/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.EventDataProvider;
import org.opengts.db.EventUtil;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.I18N;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.opengts.war.tools.CommonServlet;
import org.opengts.war.tools.MapDimension;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.PushpinIcon;
import org.opengts.war.tools.RequestProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MapProviderAdapter
implements MapProvider {
    private static final String DFT_AUTO_ENABLED = "false";
    private static final String DFT_AUTO_ONLOAD = "false";
    private static final long DFT_AUTO_DURATION = DateTime.MinuteSeconds((long)20L);
    private static final long DFT_AUTO_INTERVAL = DateTime.MinuteSeconds((long)1L);
    private static final long DFT_AUTO_MAXCOUNT = DFT_AUTO_DURATION / DFT_AUTO_INTERVAL;
    private static final boolean DFT_REPLAY_ENABLED = false;
    private static final long DFT_REPLAY_INTERVAL = 1000L;
    private String mapProviderName = null;
    private String mapAuthorization = null;
    private RTProperties mapProperties = null;
    private MapDimension mapDimension = null;
    private MapDimension mapZoneDimension = null;
    private long mapFeatures = 0L;
    private OrderedMap<String, PushpinIcon> pushpinIconMap = null;
    private static final String TAG_Legend = "Legend";
    private static final String TAG_Title = "Title";
    private static final String TAG_Icon = "Icon";
    private static final String ATTR_name = "name";
    private static final String ATTR_url = "url";
    private static final String ATTR_scale = "scale";
    private static final String CSS_legend = "mapProviderLegend";

    public static String ID_ZONE_LATITUDE(int ndx) {
        return "trackMapZoneLatitude_" + ndx;
    }

    public static String ID_ZONE_LONGITUDE(int ndx) {
        return "trackMapZoneLongitude_" + ndx;
    }

    public MapProviderAdapter(String name, String key) {
        this(name, key, 0L);
    }

    public MapProviderAdapter(String name, String key, long featureMask) {
        this.mapProviderName = name != null ? name : "";
        this.mapAuthorization = key != null ? key : "";
        this.mapFeatures = featureMask;
    }

    public void postInit() {
    }

    public void setSupportedFeatures(long featureMask) {
        this.mapFeatures = featureMask;
    }

    public void addSupportedFeature(long feature) {
        this.mapFeatures |= feature;
    }

    @Override
    public boolean isFeatureSupported(long feature) {
        return (feature & this.mapFeatures) != 0L;
    }

    public boolean validate() {
        return true;
    }

    @Override
    public String getName() {
        return this.mapProviderName != null ? this.mapProviderName : "";
    }

    @Override
    public String getAuthorization() {
        return this.mapAuthorization != null ? this.mapAuthorization : "";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        String auth = this.getAuthorization();
        if (!StringTools.isBlank((String)auth)) {
            sb.append(" [");
            sb.append(auth);
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public void setProperties(String props) {
        RTProperties rtp = this.getProperties();
        rtp.setProperties(props);
        this.mapDimension = null;
    }

    public void setProperty(String key, String val) {
        if (key != null && !key.equals("")) {
            RTProperties rtp = this.getProperties();
            rtp.setProperty((Object)key, (Object)(val != null ? val : ""));
            this.mapDimension = null;
        }
    }

    @Override
    public RTProperties getProperties() {
        if (this.mapProperties == null) {
            this.mapProperties = new RTProperties();
            this.mapProperties.setPropertySeparatorChar(';');
        }
        return this.mapProperties;
    }

    public void setIconSelector(boolean isFleet, String iconSel) {
        String key = isFleet ? MapProvider.PROP_iconSel_fleet[0] : MapProvider.PROP_iconSelector[0];
        this.getProperties().setProperty((Object)key, (Object)iconSel);
    }

    public String getIconSelector(boolean isFleet) {
        String sel;
        RTProperties rtp = this.getProperties();
        if (isFleet && !StringTools.isBlank((String)(sel = rtp.getString(MapProvider.PROP_iconSel_fleet, null)))) {
            return sel;
        }
        return rtp.getString(MapProvider.PROP_iconSelector, null);
    }

    @Override
    public String getIconSelector(RequestProperties reqState) {
        boolean isFleet = reqState != null && reqState.isFleet();
        return this.getIconSelector(isFleet);
    }

    public String _getIconLegendHtml(String legendXml, RequestProperties reqState, boolean outputHtml) {
        String xml = legendXml.trim();
        if (StringTools.isBlank((String)xml)) {
            return "";
        }
        if (!xml.startsWith("<Legend>")) {
            Print.logError((String)("IconLegend [<xml>:" + this.getName() + "]: Legend XML does not start with <" + TAG_Legend + ">: \n" + xml), (Object[])new Object[0]);
            return "";
        }
        Document xmlDoc = XMLTools.getDocument((String)xml);
        if (xmlDoc == null) {
            Print.logError((String)("IconLegend [?:" + this.getName() + "]: Invalid Legend XML: \n" + xml), (Object[])new Object[0]);
            Print.logStackTrace((String)"Invalid Legend XML");
            return "";
        }
        Element legend = xmlDoc.getDocumentElement();
        String refName = "?:" + this.getName();
        Locale locale = reqState != null ? reqState.getLocale() : null;
        OrderedMap<String, PushpinIcon> pushpinMap = this.getPushpinIconMap(reqState);
        String legendHtml = MapProviderAdapter.GetIconLegendHtml(refName, locale, pushpinMap, null, legend, outputHtml);
        return legendHtml;
    }

    public static String GetIconLegendHtml(String refName, Locale locale, OrderedMap<String, PushpinIcon> pushpinMap, String legendType, Element legendElem, boolean outputHtml) {
        NodeList iconList = null;
        if (legendElem != null && (iconList = XMLTools.getChildElements((Node)legendElem, (String)TAG_Icon)).getLength() <= 0) {
            return "";
        }
        String legendTitle = null;
        if (legendElem != null) {
            NodeList titleList = XMLTools.getChildElements((Node)legendElem, (String)TAG_Title);
            if (titleList.getLength() > 0) {
                Element titleElem = (Element)titleList.item(0);
                legendTitle = XMLTools.getNodeText((Node)titleElem, (String)" ", (boolean)false).trim();
            } else if (outputHtml) {
                I18N i18n = I18N.getI18N(MapProviderAdapter.class, (Locale)locale);
                legendTitle = i18n.getString("MapProviderAdapter.legendTitle", "Pushpin Legend");
            }
        } else {
            String titleKey = "legend." + legendType + ".title";
            legendTitle = RTConfig.getString((String)titleKey, null);
        }
        StringBuffer sb = new StringBuffer();
        if (!outputHtml) {
            sb.append("<Legend>\n");
        }
        if (!StringTools.isBlank((String)legendTitle)) {
            if (outputHtml) {
                sb.append("<span class=\"mapProviderLegend\">" + legendTitle + "</span>\n");
            } else {
                sb.append("<Title><![CDATA[" + legendTitle + "]]></" + TAG_Title + ">\n");
            }
        }
        if (outputHtml) {
            sb.append("<table class=\"mapProviderLegend\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n");
        }
        int iconCount = 0;
        int iconListLen = iconList != null ? iconList.getLength() : 10;
        for (int i = 0; i < iconListLen; ++i) {
            String imgUrl;
            Element iconElem;
            String name = null;
            String url = null;
            double scale = 1.0;
            String desc = null;
            Element element = iconElem = iconList != null ? (Element)iconList.item(i) : null;
            if (iconElem != null) {
                name = XMLTools.getAttribute((Element)iconElem, (String)ATTR_name, null, (boolean)false);
                url = XMLTools.getAttribute((Element)iconElem, (String)ATTR_url, null, (boolean)false);
                scale = StringTools.parseDouble((String)XMLTools.getAttribute((Element)iconElem, (String)ATTR_scale, null, (boolean)false), (double)0.0);
                desc = XMLTools.getNodeText((Node)iconElem, (String)"", (boolean)false).trim();
            } else {
                String iconKey = "legend." + legendType + ".icon." + (i + 1);
                String iconItem = RTConfig.getString((String)iconKey, null);
                if (StringTools.isBlank((String)iconItem)) break;
                String[] p = StringTools.split((String)iconItem, (char)'|');
                if (p.length < 3) continue;
                name = StringTools.trim((String)p[0]);
                url = null;
                scale = StringTools.parseDouble((String)p[1], (double)0.0);
                desc = StringTools.trim((String)p[2]);
            }
            PushpinIcon pp = (PushpinIcon)pushpinMap.get((Object)name);
            if (pp == null) {
                Print.logWarn((String)("IconLegend [" + refName + "]: PushpinIcon not found: " + name), (Object[])new Object[0]);
                continue;
            }
            String string = imgUrl = !StringTools.isBlank((String)url) ? url : pp.getImageURL();
            if (StringTools.isBlank((String)imgUrl)) {
                Print.logWarn((String)("IconLegend [" + refName + "]: Invalid PushpinIcon URL: " + imgUrl), (Object[])new Object[0]);
                continue;
            }
            if (outputHtml) {
                sb.append("<tr class=\"mapProviderLegend\">");
                sb.append("<td class=\"mapProviderLegend\">");
                if (pp != null) {
                    double S = scale > 0.0 ? scale : 1.0;
                    int W = (int)Math.round(S * (double)pp.getIconWidth());
                    int H = (int)Math.round(S * (double)pp.getIconHeight());
                    sb.append("<img class=\"mapProviderLegend\" src=\"" + imgUrl + "\" width=\"" + W + "\" height=\"" + H + "\">");
                } else {
                    sb.append("<img class=\"mapProviderLegend\" src=\"" + imgUrl + "\">");
                }
                sb.append("</td>");
                sb.append("<td class=\"mapProviderLegend\">");
                sb.append(desc);
                sb.append("</td>");
                sb.append("</tr>\n");
            } else {
                sb.append("<Icon name=\"" + name + "\"");
                if (scale > 0.0) {
                    sb.append(" scale=\"" + StringTools.format((double)scale, (String)"0.0") + "\"");
                }
                if (!StringTools.isBlank((String)url)) {
                    sb.append(" url=\"" + url + "\"");
                }
                sb.append(">");
                sb.append("<![CDATA[" + desc + "]]>");
                sb.append("</Icon>\n");
            }
            ++iconCount;
        }
        if (outputHtml) {
            sb.append("</table>\n");
        } else {
            sb.append("</Legend>");
        }
        return iconCount > 0 ? sb.toString() : "";
    }

    public void setIconSelectorLegend(boolean isFleet, String legend) {
        String key = isFleet ? MapProvider.PROP_iconSel_fleet_legend[0] : MapProvider.PROP_iconSelector_legend[0];
        this.getProperties().setProperty((Object)key, (Object)legend);
    }

    public String getIconSelectorLegend(boolean isFleet) {
        String legend;
        RTProperties rtp = this.getProperties();
        String string = legend = isFleet ? rtp.getString(MapProvider.PROP_iconSel_fleet_legend, null) : rtp.getString(MapProvider.PROP_iconSelector_legend, null);
        if (legend == null) {
            Print.logWarn((String)"Legend is null", (Object[])new Object[0]);
            return null;
        }
        if (legend.startsWith("<Legend")) {
            String legendHtml = this._getIconLegendHtml(legend, null, true);
            legendHtml = RTConfig.insertKeyValues((String)legendHtml);
            return legendHtml;
        }
        String legendHtml = RTConfig.insertKeyValues((String)legend);
        return legendHtml;
    }

    @Override
    public String getIconSelectorLegend(RequestProperties reqState) {
        if (reqState != null) {
            Device device;
            String legendHtml;
            DeviceGroup group;
            boolean isFleet = reqState.isFleet();
            if (isFleet ? (group = reqState.getSelectedDeviceGroup()) != null && !StringTools.isBlank((String)(legendHtml = this._getIconLegendHtml(group.getMapLegend(), reqState, true))) : (device = reqState.getSelectedDevice()) != null && !StringTools.isBlank((String)(legendHtml = this._getIconLegendHtml(device.getMapLegend(), reqState, true)))) {
                return legendHtml;
            }
            Account account = reqState.getCurrentAccount();
            if (account != null && !StringTools.isBlank((String)(legendHtml = this._getIconLegendHtml(account.getMapLegend(isFleet), reqState, true)))) {
                return legendHtml;
            }
            return this.getIconSelectorLegend(isFleet);
        }
        return this.getIconSelectorLegend(false);
    }

    @Override
    public MapDimension getZoneDimension() {
        if (this.mapZoneDimension == null) {
            RTProperties rtp = this.getProperties();
            int w = rtp.getInt(MapProvider.PROP_zone_map_width, 630);
            int h = rtp.getInt(MapProvider.PROP_zone_map_height, 630);
            this.mapZoneDimension = w > 0 && h > 0 ? new MapDimension(w, h) : new MapDimension(630, 630);
        }
        return this.mapZoneDimension;
    }

    @Override
    public int getZoneWidth() {
        return this.getZoneDimension().getWidth();
    }

    @Override
    public int getZoneHeight() {
        return this.getZoneDimension().getHeight();
    }

    @Override
    public MapDimension getDimension() {
        if (this.mapDimension == null) {
            RTProperties rtp = this.getProperties();
            if (rtp.getBoolean(MapProvider.PROP_map_fillFrame, false)) {
                this.mapDimension = new MapDimension(-1, -1);
            } else {
                int w = rtp.getInt(MapProvider.PROP_map_width, 0);
                int h = rtp.getInt(MapProvider.PROP_map_height, 0);
                this.mapDimension = w != 0 && h != 0 ? new MapDimension(w, h) : new MapDimension(680, 470);
            }
        }
        return this.mapDimension;
    }

    @Override
    public int getWidth() {
        return this.getDimension().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getDimension().getHeight();
    }

    @Override
    public long getMaxPushpins(RequestProperties reqState) {
        RTProperties rtp = this.getProperties();
        if (reqState.isReport()) {
            String[] propName = MapProvider.PROP_maxPushpins_report;
            long mpp = rtp.getLong(propName, 1000L);
            return mpp > 0L ? mpp : 1000L;
        }
        String[] propName = reqState.isFleet() ? MapProvider.PROP_maxPushpins_fleet : MapProvider.PROP_maxPushpins_device;
        long mpp = rtp.getLong(propName, 1000L);
        return mpp > 0L ? mpp : 1000L;
    }

    @Override
    public GeoPoint getDefaultCenter(GeoPoint dft) {
        RTProperties rtp = this.getProperties();
        double lat = rtp.getDouble(MapProvider.PROP_default_latitude, dft != null ? dft.getLatitude() : 39.0);
        double lon = rtp.getDouble(MapProvider.PROP_default_longitude, dft != null ? dft.getLongitude() : -96.5);
        return new GeoPoint(lat, lon);
    }

    @Override
    public double getDefaultZoom(double dft, boolean withPushpins) {
        return withPushpins ? this.getProperties().getDouble(MapProvider.PROP_pushpin_zoom, dft) : this.getProperties().getDouble(MapProvider.PROP_default_zoom, dft);
    }

    public int getDefaultZoom(int dft, boolean withPushpins) {
        return withPushpins ? this.getProperties().getInt(MapProvider.PROP_pushpin_zoom, dft) : this.getProperties().getInt(MapProvider.PROP_default_zoom, dft);
    }

    @Override
    public boolean getAutoUpdateEnabled(boolean isFleet) {
        String autoUpdate;
        String string = autoUpdate = isFleet ? this.getProperties().getString(MapProvider.PROP_auto_enable_fleet, "false") : this.getProperties().getString(MapProvider.PROP_auto_enable_device, "false");
        if (autoUpdate.equalsIgnoreCase("false") || autoUpdate.equalsIgnoreCase("no")) {
            return false;
        }
        return this.getAutoUpdateInterval(isFleet) > 0L;
    }

    @Override
    public boolean getAutoUpdateOnLoad(boolean isFleet) {
        String autoOnload;
        RTProperties rtp = this.getProperties();
        String string = autoOnload = isFleet ? rtp.getString(MapProvider.PROP_auto_onload_fleet, "") : rtp.getString(MapProvider.PROP_auto_onload_device, "");
        if (!StringTools.isBlank((String)autoOnload)) {
            return StringTools.parseBoolean((String)autoOnload, (boolean)false);
        }
        String autoEnable = isFleet ? rtp.getString(MapProvider.PROP_auto_enable_fleet, "") : rtp.getString(MapProvider.PROP_auto_enable_device, "");
        return autoEnable.equalsIgnoreCase("onload");
    }

    @Override
    public long getAutoUpdateInterval(boolean isFleet) {
        return isFleet ? this.getProperties().getLong(MapProvider.PROP_auto_interval_fleet, DFT_AUTO_INTERVAL) : this.getProperties().getLong(MapProvider.PROP_auto_interval_device, DFT_AUTO_INTERVAL);
    }

    @Override
    public long getAutoUpdateCount(boolean isFleet) {
        return isFleet ? this.getProperties().getLong(MapProvider.PROP_auto_count_fleet, DFT_AUTO_MAXCOUNT) : this.getProperties().getLong(MapProvider.PROP_auto_count_device, DFT_AUTO_MAXCOUNT);
    }

    @Override
    public boolean getReplayEnabled() {
        if (!this.isFeatureSupported(32L)) {
            return false;
        }
        if (!this.getProperties().getBoolean(MapProvider.PROP_replay_enable, false)) {
            return false;
        }
        return this.getReplayInterval() > 0L;
    }

    @Override
    public long getReplayInterval() {
        long interval = this.getProperties().getLong(MapProvider.PROP_replay_interval, 1000L);
        return interval < 30L ? interval * 1000L : interval;
    }

    @Override
    public boolean getReplaySinglePushpin() {
        return this.getProperties().getBoolean(MapProvider.PROP_replay_singlePushpin, false);
    }

    public abstract String getMapID();

    @Override
    public void writeStyle(PrintWriter out, RequestProperties reqState) throws IOException {
    }

    @Override
    public abstract void writeJavaScript(PrintWriter var1, RequestProperties var2) throws IOException;

    protected String getMapCellStyle(RequestProperties reqState, MapDimension mapDim) {
        MapDimension md = mapDim != null ? mapDim : this.getDimension();
        int mapW = md != null ? md.getWidth() : -1;
        int mapH = md != null ? md.getHeight() : -1;
        String styleW = mapW > 0 ? "" + mapW + "px" : "100%";
        String styleH = mapH > 0 ? "" + mapH + "px" : "100%";
        return "padding:0px; margin:0px; width:" + styleW + "; height:" + styleH + ";";
    }

    @Override
    public void writeMapCell(PrintWriter out, RequestProperties reqState, MapDimension mapDim) throws IOException {
        MapDimension md = mapDim != null ? mapDim : this.getDimension();
        int mapW = md != null ? md.getWidth() : -1;
        int mapH = md != null ? md.getHeight() : -1;
        String tableStyle = "width:100%;" + (mapH < 0 ? " height:100%;" : "");
        String cellClass = "mapProviderCell";
        String cellStyle = "" + (mapH < 0 ? " height:100%;" : "");
        String divStyle = this.getMapCellStyle(reqState, mapDim);
        String mapID = this.getMapID();
        out.println("<table valign='center' align='center' cellspacing='0' cellpadding='0' border='0' style='" + tableStyle + "'>");
        out.println("<tr><td class='" + cellClass + "' align='center' style='" + cellStyle + "'>");
        out.println("<div id='" + mapID + "' style='" + divStyle + "'></div>");
        out.println("</td></tr>");
        out.println("</table>");
    }

    protected void writeMapUpdate_precheck(RequestProperties reqState) {
    }

    @Override
    public void writeMapUpdate(int mapDataFormat, RequestProperties reqState, int[] statusCodes) throws IOException {
        HttpServletResponse response = reqState.getHttpServletResponse();
        PrintWriter out = response.getWriter();
        String mimeType = EventUtil.IsXMLMapDataFormat((int)mapDataFormat) ? HTMLTools.MIME_XML() : HTMLTools.MIME_JSON();
        CommonServlet.setResponseContentType(response, mimeType, "UTF-8");
        response.setHeader("CACHE-CONTROL", "NO-CACHE");
        response.setHeader("PRAGMA", "NO-CACHE");
        response.setDateHeader("EXPIRES", 0L);
        this.writeMapUpdate(out, 0, mapDataFormat, true, reqState, statusCodes);
    }

    @Override
    public void writeMapUpdate(PrintWriter out, int indentLevel, int mapDataFormat, boolean isTopLevelTag, RequestProperties reqState, int[] statusCodes) throws IOException {
        double lastBatt;
        DateTime latest;
        this.writeMapUpdate_precheck(reqState);
        EventData[] evdata = null;
        try {
            evdata = reqState.getMapEvents(statusCodes, -1L);
        }
        catch (DBException dbe) {
            Print.logException((String)"Error reading Events", (Throwable)dbe);
            out.println("\nError reading Events");
            return;
        }
        PrivateLabel privLabel = reqState.getPrivateLabel();
        boolean isFleet = reqState.isFleet();
        Account acct = reqState.getCurrentAccount();
        User user = reqState.getCurrentUser();
        TimeZone tmz = reqState.getTimeZone();
        Device selDev = isFleet ? null : reqState.getSelectedDevice();
        String selID = isFleet ? reqState.getSelectedDeviceGroupID() : reqState.getSelectedDeviceID();
        DateTime dateTime = latest = isFleet ? null : reqState.getLastEventTime();
        double d = isFleet ? 0.0 : (lastBatt = selDev == null ? 0.0 : selDev.getLastBatteryLevel());
        double lastSig = isFleet ? 0.0 : (selDev == null ? 0.0 : 0.0);
        double proximityM = this.getProperties().getDouble(MapProvider.PROP_map_minProximity, 0.0);
        String iconSel = this.getIconSelector(reqState);
        boolean fleetRoute = reqState.getFleetDeviceEventCount() > 1L;
        boolean inclZones = this.getProperties().getBoolean(MapProvider.PROP_map_includeGeozones, false);
        OrderedSet iconKeys = (OrderedSet)this.getPushpinIconMap(reqState).keySet();
        try {
            EventUtil evUtil = EventUtil.getInstance();
            int mdf = mapDataFormat <= 0 ? EventUtil.GetDefaultMapDataFormat() : mapDataFormat;
            evUtil.writeMapEvents(mdf, indentLevel, out, reqState.isSoapRequest(), isTopLevelTag, (BasicPrivateLabel)privLabel, (EventDataProvider[])evdata, inclZones, iconSel, iconKeys, isFleet, fleetRoute, selID, tmz, acct, user, latest, lastBatt, lastSig, proximityM);
        }
        catch (IOException ioe) {
            Print.logException((String)"Error writing events", (Throwable)ioe);
            out.println("\nError writing Events");
        }
    }

    @Override
    public OrderedMap<String, PushpinIcon> getPushpinIconMap(RequestProperties reqState) {
        if (this.pushpinIconMap == null) {
            this.pushpinIconMap = PushpinIcon.newDefaultPushpinIconMap();
        }
        return this.pushpinIconMap;
    }

    @Override
    public int getGeozoneSupportedPointCount(int type) {
        if (!this.isFeatureSupported(1L)) {
            return 0;
        }
        if (type == Geozone.GeozoneType.POINT_RADIUS.getIntValue()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String[] getGeozoneInstructions(int type, Locale loc) {
        return null;
    }

    @Override
    public String[] getCorridorInstructions(Locale loc) {
        return null;
    }
}

