/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.opengts.util.GeoPoint;
import org.opengts.util.OrderedMap;
import org.opengts.util.RTProperties;
import org.opengts.war.tools.MapDimension;
import org.opengts.war.tools.PushpinIcon;
import org.opengts.war.tools.RequestProperties;

public interface MapProvider {
    public static final long FEATURE_GEOZONES = 1L;
    public static final long FEATURE_LATLON_DISPLAY = 2L;
    public static final long FEATURE_DISTANCE_RULER = 4L;
    public static final long FEATURE_DETAIL_REPORT = 8L;
    public static final long FEATURE_DETAIL_INFO_BOX = 16L;
    public static final long FEATURE_REPLAY_POINTS = 32L;
    public static final long FEATURE_CENTER_ON_LAST = 64L;
    public static final long FEATURE_CORRIDORS = 128L;
    public static final String ID_DETAIL_TABLE = "trackMapDataTable";
    public static final String ID_DETAIL_CONTROL = "trackMapDataControl";
    public static final String ID_LAT_LON_DISPLAY = "trackMapLatLonDisplay";
    public static final String ID_DISTANCE_DISPLAY = "trackMapDistanceDisplay";
    public static final String ID_LATEST_EVENT_DATE = "lastEventDate";
    public static final String ID_LATEST_EVENT_TIME = "lastEventTime";
    public static final String ID_LATEST_EVENT_TMZ = "lastEventTmz";
    public static final String ID_LATEST_BATTERY = "lastBatteryLevel";
    public static final String ID_MESSAGE_TEXT = "contentMessage";
    public static final String ID_ZONE_RADIUS_M = "trackMapZoneRadiusM";
    public static final String ID_ZONE_LATITUDE_ = "trackMapZoneLatitude_";
    public static final String ID_ZONE_LONGITUDE_ = "trackMapZoneLongitude_";
    public static final int MAP_WIDTH = 680;
    public static final int MAP_HEIGHT = 470;
    public static final int ZONE_WIDTH = 630;
    public static final int ZONE_HEIGHT = 630;
    public static final String[] PROP_zone_map_width = new String[]{"zone.map.width"};
    public static final String[] PROP_zone_map_height = new String[]{"zone.map.height"};
    public static final String[] PROP_zone_map_multipoint = new String[]{"zone.map.multipoint", "geozone.multipoint"};
    public static final String[] PROP_zone_map_polygon = new String[]{"zone.map.polygon"};
    public static final String[] PROP_zone_map_corridor = new String[]{"zone.map.corridor"};
    public static final String[] PROP_map_width = new String[]{"map.width"};
    public static final String[] PROP_map_height = new String[]{"map.height"};
    public static final String[] PROP_map_fillFrame = new String[]{"map.fillFrame"};
    public static final String[] PROP_maxPushpins_device = new String[]{"map.maxPushpins.device", "map.maxPushpins"};
    public static final String[] PROP_maxPushpins_fleet = new String[]{"map.maxPushpins.fleet", "map.maxPushpins"};
    public static final String[] PROP_maxPushpins_report = new String[]{"map.maxPushpins.report", "map.maxPushpins"};
    public static final String[] PROP_map_pushpins = new String[]{"map.showPushpins", "map.pushpins"};
    public static final String[] PROP_map_maxCreationAge = new String[]{"map.maxCreationAge", "maxCreationAge"};
    public static final String[] PROP_map_routeLine = new String[]{"map.routeLine"};
    public static final String[] PROP_map_routeLine_color = new String[]{"map.routeLine.color"};
    public static final String[] PROP_map_routeLine_arrows = new String[]{"map.routeLine.arrows"};
    public static final String[] PROP_map_routeLine_snapToRoad = new String[]{"map.routeLine.snapToRoad"};
    public static final String[] PROP_map_view = new String[]{"map.view"};
    public static final String[] PROP_map_minProximity = new String[]{"map.minProximity"};
    public static final String[] PROP_map_includeGeozones = new String[]{"map.includeGeozones", "includeGeozones"};
    public static final String[] PROP_pushpin_zoom = new String[]{"pushpin.zoom"};
    public static final String[] PROP_default_zoom = new String[]{"default.zoom"};
    public static final String[] PROP_default_latitude = new String[]{"default.lat", "default.latitude"};
    public static final String[] PROP_default_longitude = new String[]{"default.lon", "default.longitude"};
    public static final String[] PROP_info_showSpeed = new String[]{"info.showSpeed"};
    public static final String[] PROP_info_showAltitude = new String[]{"info.showAltitude"};
    public static final String[] PROP_info_inclBlankAddress = new String[]{"info.inclBlankAddress"};
    public static final String[] PROP_info_showOptionalFields = new String[]{"info.showOptionalFields"};
    public static final String[] PROP_info_inclBlankOptFields = new String[]{"info.inclBlankOptFields"};
    public static final String[] PROP_detail_showSatCount = new String[]{"detail.showSatCount"};
    public static final String[] PROP_auto_enable_device = new String[]{"auto.enable", "auto.enable.device"};
    public static final String[] PROP_auto_onload_device = new String[]{"auto.onload", "auto.onload.device"};
    public static final String[] PROP_auto_interval_device = new String[]{"auto.interval", "auto.interval.device"};
    public static final String[] PROP_auto_count_device = new String[]{"auto.count", "auto.count.device"};
    public static final String[] PROP_auto_enable_fleet = new String[]{"auto.enable", "auto.enable.fleet"};
    public static final String[] PROP_auto_onload_fleet = new String[]{"auto.onload", "auto.onload.fleet"};
    public static final String[] PROP_auto_interval_fleet = new String[]{"auto.interval", "auto.interval.fleet"};
    public static final String[] PROP_auto_count_fleet = new String[]{"auto.count", "auto.count.fleet"};
    public static final String[] PROP_replay_enable = new String[]{"replay.enable"};
    public static final String[] PROP_replay_interval = new String[]{"replay.interval"};
    public static final String[] PROP_replay_singlePushpin = new String[]{"replay.singlePushpin"};
    public static final String[] PROP_combineSpeedHeading = new String[]{"details.combineSpeedHeading"};
    public static final String[] PROP_iconSelector = new String[]{"iconSelector", "iconselector.device"};
    public static final String[] PROP_iconSelector_legend = new String[]{"iconSelector.legend", "iconSelector.device.legend"};
    public static final String[] PROP_iconSel_fleet = new String[]{"iconSelector.fleet"};
    public static final String[] PROP_iconSel_fleet_legend = new String[]{"iconSelector.fleet.legend"};
    public static final String[] PROP_javascript_src = new String[]{"javascript.src", "javascript.include"};
    public static final String[] PROP_javascript_inline = new String[]{"javascript.inline"};
    public static final String[] PROP_scrollWheelZoom = new String[]{"scrollWheelZoom"};
    public static final double DEFAULT_LATITUDE = 39.0;
    public static final double DEFAULT_LONGITUDE = -96.5;

    public String getName();

    public String getAuthorization();

    public void setProperties(String var1);

    public RTProperties getProperties();

    public long getMaxPushpins(RequestProperties var1);

    public OrderedMap<String, PushpinIcon> getPushpinIconMap(RequestProperties var1);

    public String getIconSelector(RequestProperties var1);

    public String getIconSelectorLegend(RequestProperties var1);

    public MapDimension getDimension();

    public int getWidth();

    public int getHeight();

    public MapDimension getZoneDimension();

    public int getZoneWidth();

    public int getZoneHeight();

    public GeoPoint getDefaultCenter(GeoPoint var1);

    public double getDefaultZoom(double var1, boolean var3);

    public boolean getAutoUpdateEnabled(boolean var1);

    public boolean getAutoUpdateOnLoad(boolean var1);

    public long getAutoUpdateInterval(boolean var1);

    public long getAutoUpdateCount(boolean var1);

    public boolean getReplayEnabled();

    public long getReplayInterval();

    public boolean getReplaySinglePushpin();

    public void writeStyle(PrintWriter var1, RequestProperties var2) throws IOException;

    public void writeJavaScript(PrintWriter var1, RequestProperties var2) throws IOException;

    public void writeMapCell(PrintWriter var1, RequestProperties var2, MapDimension var3) throws IOException;

    public void writeMapUpdate(int var1, RequestProperties var2, int[] var3) throws IOException;

    public void writeMapUpdate(PrintWriter var1, int var2, int var3, boolean var4, RequestProperties var5, int[] var6) throws IOException;

    public int getGeozoneSupportedPointCount(int var1);

    public String[] getGeozoneInstructions(int var1, Locale var2);

    public String[] getCorridorInstructions(Locale var1);

    public boolean isFeatureSupported(long var1);
}

