/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.war.tools.AttributeTools;

public class JavaScriptTools {
    public static String qualifyJSFileRef(String jsFileRef) {
        if (jsFileRef == null) {
            return null;
        }
        if (jsFileRef.startsWith("http:") || jsFileRef.startsWith("https:")) {
            return jsFileRef;
        }
        if (jsFileRef.startsWith("file:")) {
            return jsFileRef;
        }
        if (jsFileRef.startsWith("/") || jsFileRef.startsWith(".")) {
            return jsFileRef;
        }
        String js_dir = RTConfig.getString((String)"track.js.directory", (String)"./js");
        return js_dir + "/" + jsFileRef;
    }

    public static void writeJSVar(PrintWriter out, String varName, Object value) throws IOException {
        JavaScriptTools.writeJSVar(out, varName, value, true);
    }

    public static void writeJSVar(PrintWriter out, String varName, Object value, boolean quoteString) throws IOException {
        String var = varName;
        out.write("var " + var + " = ");
        if (value == null) {
            out.write("null");
        } else if (value instanceof Number || value instanceof Boolean) {
            out.write(value.toString());
        } else if (value instanceof Object[]) {
            Object[] obj = (Object[])value;
            out.write("[");
            for (int i = 0; i < obj.length; ++i) {
                Object v = obj[i];
                out.write(" ");
                if (v instanceof Number || v instanceof Boolean) {
                    out.write(v.toString());
                } else {
                    String val = StringTools.replace((String)v.toString(), (String)"\"", (String)"\\\"");
                    val = StringTools.replace((String)val, (String)"\n", (String)"\\n");
                    out.write("\"" + val + "\"");
                }
                if (i + 1 >= obj.length) continue;
                out.write(",");
            }
            out.write("]");
        } else if (!quoteString) {
            String s = value.toString().trim();
            if (StringTools.isBlank((String)s)) {
                out.write("null");
            } else {
                out.write(s);
            }
        } else {
            String val = StringTools.replace((String)value.toString(), (String)"\"", (String)"\\\"");
            val = StringTools.replace((String)val, (String)"\n", (String)"\\n");
            out.write("\"" + val + "\"");
        }
        out.write(";\n");
    }

    public static void writeJSInclude(PrintWriter out, String jsFileRef, HttpServletRequest request) throws IOException {
        JavaScriptTools._writeJSInclude(out, jsFileRef, AttributeTools.GetSessionSequence(request));
    }

    public static void writeJSInclude(PrintWriter out, String jsFileRef, int seq) throws IOException {
        JavaScriptTools._writeJSInclude(out, jsFileRef, seq);
    }

    public static void writeJSIncludes(PrintWriter out, String[] jsFileRefs, HttpServletRequest request) throws IOException {
        JavaScriptTools._writeJSIncludes(out, jsFileRefs, AttributeTools.GetSessionSequence(request));
    }

    public static void writeJSIncludes(PrintWriter out, String[] jsFileRefs, int seq) throws IOException {
        JavaScriptTools._writeJSIncludes(out, jsFileRefs, seq);
    }

    private static void _writeJSIncludes(PrintWriter out, String[] jsFileRefs, int seq) throws IOException {
        if (jsFileRefs != null) {
            for (int i = 0; i < jsFileRefs.length; ++i) {
                String jsIncl = StringTools.trim((String)jsFileRefs[i]);
                if (StringTools.isBlank((String)jsIncl)) continue;
                JavaScriptTools._writeJSInclude(out, jsIncl, seq);
            }
        }
    }

    private static void _writeJSInclude(PrintWriter out, String jsFileRef, int seq) throws IOException {
        if (!StringTools.isBlank((String)jsFileRef)) {
            String src = jsFileRef;
            if (seq > 0 && jsFileRef.endsWith(".js")) {
                src = src + "?seq=" + seq;
            }
            String script = "<script src=\"" + src + "\" type=\"text/javascript\"></script>\n";
            out.write(script);
        }
    }

    public static void writeJSInclude(JspWriter out, String jsFileRef, HttpServletRequest request) throws IOException {
        JavaScriptTools._writeJSInclude(out, jsFileRef, AttributeTools.GetSessionSequence(request));
    }

    public static void writeJSInclude(JspWriter out, String jsFileRef, int seq) throws IOException {
        JavaScriptTools._writeJSInclude(out, jsFileRef, seq);
    }

    public static void writeJSIncludes(JspWriter out, String[] jsFileRefs, HttpServletRequest request) throws IOException {
        JavaScriptTools._writeJSIncludes(out, jsFileRefs, AttributeTools.GetSessionSequence(request));
    }

    public static void writeJSIncludes(JspWriter out, String[] jsFileRefs, int seq) throws IOException {
        JavaScriptTools._writeJSIncludes(out, jsFileRefs, seq);
    }

    private static void _writeJSIncludes(JspWriter out, String[] jsFileRefs, int seq) throws IOException {
        if (jsFileRefs != null) {
            for (int i = 0; i < jsFileRefs.length; ++i) {
                String jsIncl = StringTools.trim((String)jsFileRefs[i]);
                if (StringTools.isBlank((String)jsIncl)) continue;
                JavaScriptTools._writeJSInclude(out, jsIncl, seq);
            }
        }
    }

    private static void _writeJSInclude(JspWriter out, String jsFileRef, int seq) throws IOException {
        if (!StringTools.isBlank((String)jsFileRef)) {
            String src = jsFileRef;
            if (seq > 0 && jsFileRef.endsWith(".js")) {
                src = src + "?seq=" + seq;
            }
            String script = "<script src=\"" + src + "\" type=\"text/javascript\"></script>\n";
            out.write(script);
        }
    }

    public static void writeUtilsJS(PrintWriter out, HttpServletRequest request) throws IOException {
        JavaScriptTools.writeUtilsJS(out, AttributeTools.GetSessionSequence(request));
    }

    public static void writeUtilsJS(PrintWriter out, int seq) throws IOException {
        JavaScriptTools.writeJSInclude(out, JavaScriptTools.qualifyJSFileRef("utils.js"), seq);
    }

    public static void writeUtilsJS(JspWriter out, HttpServletRequest request) throws IOException {
        JavaScriptTools.writeUtilsJS(out, AttributeTools.GetSessionSequence(request));
    }

    public static void writeUtilsJS(JspWriter out, int seq) throws IOException {
        JavaScriptTools.writeJSInclude(out, JavaScriptTools.qualifyJSFileRef("utils.js"), seq);
    }

    public static void writeStartJavaScript(PrintWriter out) {
        out.println("<script type=\"text/javascript\">");
        out.println("<!--");
    }

    public static void writeEndJavaScript(PrintWriter out) {
        out.println("//-->");
        out.println("</script>");
    }

    public static void writeJS(PrintWriter out, String[] js) throws IOException {
        for (int i = 0; i < js.length; ++i) {
            if (js[i] == null) continue;
            out.println(js[i]);
        }
    }

    public static void writeJS(PrintWriter out, String js) throws IOException {
        if (js != null) {
            out.println(js);
        }
    }
}

