/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.util.Comparator;
import java.util.List;
import org.opengts.util.EnumTools;
import org.opengts.util.ListTools;
import org.opengts.util.StringTools;

public class IDDescription {
    private String id = null;
    private String description = null;
    private String name = null;

    public static SortBy GetSortBy(String sortBy) {
        if (StringTools.isBlank((String)sortBy) || sortBy.equalsIgnoreCase("id")) {
            return SortBy.ID;
        }
        if (sortBy.equalsIgnoreCase("name")) {
            return SortBy.NAME;
        }
        if (StringTools.startsWithIgnoreCase((String)sortBy, (String)"desc")) {
            return SortBy.DESCRIPTION;
        }
        return SortBy.ID;
    }

    public static SortBy GetSortBy(SortBy sortBy) {
        return sortBy != null ? sortBy : SortBy.DESCRIPTION;
    }

    public static List<IDDescription> SortList(List<IDDescription> idList, String sortBy) {
        return IDDescription.SortList(idList, IDDescription.GetSortBy(sortBy));
    }

    public static List<IDDescription> SortList(List<IDDescription> idList, SortBy sortBy) {
        return ListTools.sort(idList, (Comparator)new SortComparator(sortBy));
    }

    public IDDescription(String id, String desc) {
        this(id, desc, null);
    }

    public IDDescription(String id, String desc, String name) {
        this.id = id;
        this.description = desc;
        this.name = name;
    }

    public String getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getSortByString(SortBy sortBy) {
        String val = this.getID();
        if (sortBy != null) {
            switch (sortBy) {
                case ID: {
                    val = this.getID();
                    break;
                }
                case DESCRIPTION: {
                    val = this.getDescription();
                    break;
                }
                case NAME: {
                    val = this.getName();
                }
            }
        }
        return val != null ? val.toLowerCase() : "";
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        if (this.name != null) {
            return this.name;
        }
        return this.id;
    }

    private static class SortComparator
    implements Comparator<IDDescription> {
        private SortBy sortBy = SortBy.ID;

        public SortComparator(SortBy sortBy) {
            this.sortBy = sortBy != null ? sortBy : SortBy.ID;
        }

        @Override
        public int compare(IDDescription id1, IDDescription id2) {
            String s1 = id1 != null ? id1.getSortByString(this.sortBy) : "";
            String s2 = id1 != null ? id2.getSortByString(this.sortBy) : "";
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof SortComparator) {
                SortComparator sc = (SortComparator)other;
                return this.sortBy.equals((Object)sc.sortBy);
            }
            return false;
        }
    }

    public static enum SortBy implements EnumTools.IntValue
    {
        ID(0),
        DESCRIPTION(1),
        NAME(2);

        private int vv = 0;

        private SortBy(int v) {
            this.vv = v;
        }

        public int getIntValue() {
            return this.vv;
        }
    }
}

