/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.util.Locale;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.StringTools;

public class ComboOption {
    public static final String BOOLEAN_NAME_FALSE = "false";
    public static final String BOOLEAN_NAME_TRUE = "true";
    private String key = "";
    private String desc = "";

    public static String getOnOffText(Locale locale, boolean state) {
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        return state ? i18n.getString("ComboOption.on", "On") : i18n.getString("ComboOption.off", "Off");
    }

    public static boolean parseOnOffText(Locale locale, String state) {
        return ComboOption.parseOnOffText(locale, state, false);
    }

    public static boolean parseOnOffText(Locale locale, String state, boolean dft) {
        if (StringTools.isBlank((String)state)) {
            return dft;
        }
        if (state.equalsIgnoreCase(BOOLEAN_NAME_FALSE)) {
            return false;
        }
        if (state.equalsIgnoreCase(BOOLEAN_NAME_TRUE)) {
            return true;
        }
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        if (state.equalsIgnoreCase(i18n.getString("ComboOption.off", "Off"))) {
            return false;
        }
        if (state.equalsIgnoreCase(i18n.getString("ComboOption.on", "On"))) {
            return true;
        }
        return StringTools.parseBoolean((String)state, (boolean)dft);
    }

    public static ComboOption getOnOffOption(Locale locale, boolean state) {
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        return state ? new ComboOption(BOOLEAN_NAME_TRUE, i18n.getString("ComboOption.on", "On")) : new ComboOption(BOOLEAN_NAME_FALSE, i18n.getString("ComboOption.off", "Off"));
    }

    public static String getYesNoText(Locale locale, boolean state) {
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        return state ? i18n.getString("ComboOption.yes", "Yes") : i18n.getString("ComboOption.no", "No");
    }

    public static boolean parseYesNoText(Locale locale, String state) {
        return ComboOption.parseYesNoText(locale, state, false);
    }

    public static boolean parseYesNoText(Locale locale, String state, boolean dft) {
        if (StringTools.isBlank((String)state)) {
            return dft;
        }
        if (state.equalsIgnoreCase(BOOLEAN_NAME_FALSE)) {
            return false;
        }
        if (state.equalsIgnoreCase(BOOLEAN_NAME_TRUE)) {
            return true;
        }
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        if (state.equalsIgnoreCase(i18n.getString("ComboOption.no", "No"))) {
            return false;
        }
        if (state.equalsIgnoreCase(i18n.getString("ComboOption.yes", "Yes"))) {
            return true;
        }
        return StringTools.parseBoolean((String)state, (boolean)dft);
    }

    public static ComboOption getYesNoOption(Locale locale, boolean state) {
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        return state ? new ComboOption(BOOLEAN_NAME_TRUE, i18n.getString("ComboOption.yes", "Yes")) : new ComboOption(BOOLEAN_NAME_FALSE, i18n.getString("ComboOption.no", "No"));
    }

    public static String getTrueFalseText(Locale locale, boolean state) {
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        return state ? i18n.getString("ComboOption.true", "True") : i18n.getString("ComboOption.false", "False");
    }

    public static boolean parseTrueFalseText(Locale locale, String state) {
        return ComboOption.parseTrueFalseText(locale, state, false);
    }

    public static boolean parseTrueFalseText(Locale locale, String state, boolean dft) {
        if (StringTools.isBlank((String)state)) {
            return dft;
        }
        if (state.equalsIgnoreCase(BOOLEAN_NAME_FALSE)) {
            return false;
        }
        if (state.equalsIgnoreCase(BOOLEAN_NAME_TRUE)) {
            return true;
        }
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        if (state.equalsIgnoreCase(i18n.getString("ComboOption.false", "False"))) {
            return false;
        }
        if (state.equalsIgnoreCase(i18n.getString("ComboOption.true", "True"))) {
            return true;
        }
        return StringTools.parseBoolean((String)state, (boolean)dft);
    }

    public static ComboOption getTrueFalseOption(Locale locale, boolean state) {
        I18N i18n = I18N.getI18N(ComboOption.class, (Locale)locale);
        return state ? new ComboOption(BOOLEAN_NAME_TRUE, i18n.getString("ComboOption.true", "True")) : new ComboOption(BOOLEAN_NAME_FALSE, i18n.getString("ComboOption.false", "False"));
    }

    public ComboOption(String key, String desc) {
        this.key = StringTools.trim((String)key);
        this.desc = StringTools.isBlank((String)desc) ? this.key : StringTools.trim((String)desc);
    }

    public ComboOption(String key) {
        this(key, null);
    }

    public ComboOption(EnumTools.StringLocale enumType, Locale locale) {
        if (enumType != null) {
            this.key = ((Enum)enumType).name();
            this.desc = enumType.toString(locale);
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.desc;
    }

    public boolean isKey(String k) {
        return this.key.equalsIgnoreCase(StringTools.trim((String)k));
    }

    public boolean isMatch(String n) {
        String k = StringTools.trim((String)n);
        return this.key.equalsIgnoreCase(k) || this.desc.equalsIgnoreCase(k);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getKey());
        sb.append("|");
        sb.append(this.getDescription());
        return sb.toString();
    }
}

