/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.opengts.util.I18N;
import org.opengts.util.OrderedMap;
import org.opengts.util.StringTools;
import org.opengts.war.tools.ComboOption;

public class ComboMap
extends OrderedMap<String, String> {
    private ComboOption defaultSelection = null;

    public static ComboMap getYesNoMap(Locale locale) {
        I18N i18n = I18N.getI18N(ComboMap.class, (Locale)locale);
        ComboMap yesNo = new ComboMap();
        yesNo.add("false", ComboOption.getYesNoText(locale, false));
        yesNo.add("true", ComboOption.getYesNoText(locale, true));
        return yesNo;
    }

    public static ComboMap getTrueFalseMap(Locale locale) {
        I18N i18n = I18N.getI18N(ComboMap.class, (Locale)locale);
        ComboMap trueFalse = new ComboMap();
        trueFalse.add("false", ComboOption.getTrueFalseText(locale, false));
        trueFalse.add("true", ComboOption.getTrueFalseText(locale, true));
        return trueFalse;
    }

    public ComboMap() {
    }

    public ComboMap(Map<String, String> map) {
        super(map);
    }

    public ComboMap(Collection<String> list) {
        if (list != null) {
            for (String k : list) {
                this.put(k, k);
            }
        }
    }

    public ComboMap(String[] list) {
        if (list != null) {
            for (String k : list) {
                this.put(k, k);
            }
        }
    }

    public ComboMap(String key) {
        String k = StringTools.trim((String)key);
        this.put(k, k);
    }

    public ComboMap(String key, String desc) {
        String k = StringTools.trim((String)key);
        String d = StringTools.trim((String)desc);
        this.put(k, d);
    }

    public void setDefaultSelection(ComboOption option) {
        this.defaultSelection = option;
    }

    public ComboOption getDefaultSelection() {
        return this.defaultSelection;
    }

    public void insert(String key, String desc) {
        String k = StringTools.trim((String)key);
        String d = StringTools.isBlank((String)desc) ? k : StringTools.trim((String)desc);
        this.put(0, k, d);
    }

    public void insert(String key) {
        this.insert(key, key);
    }

    public void insert(ComboOption option) {
        if (option != null) {
            this.insert(option.getKey(), option.getDescription());
        }
    }

    public void add(String key, String desc) {
        String k = StringTools.trim((String)key);
        String d = StringTools.isBlank((String)desc) ? k : StringTools.trim((String)desc);
        this.put(k, d);
    }

    public void add(String key) {
        this.add(key, key);
    }

    public void add(ComboOption option) {
        if (option != null) {
            this.add(option.getKey(), option.getDescription());
        }
    }

    public ComboOption getFirstComboOption() {
        String key = (String)this.getFirstKey();
        String desc = (String)this.getFirstValue();
        return new ComboOption(key, desc);
    }

    public ComboOption getComboOption(String key) {
        String desc = (String)this.get(key);
        return new ComboOption(key, desc);
    }

    public static ComboOption getComboOption(ComboMap map, String key) {
        return map != null ? map.getComboOption(key) : new ComboOption(key);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String k : this.keySet()) {
            String d = (String)this.get(k);
            sb.append(k);
            sb.append("|");
            sb.append(d);
            sb.append("\n");
        }
        return sb.toString();
    }
}

