/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.tools;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class AttributeTools {
    private static final boolean IGNORE_CASE = true;
    public static final String ATTR_RTP = "rtp_";
    public static final String ATTR_MULTIPART = "multi_";
    private static final String SessionSequenceKey = "SequenceID";
    private static final Object SessionSequenceLock = new Object();
    private static int SessionSequenceValue = 0;
    public static final int MAX_BINARY_SIZE = 0x200000;
    public static final String MIMEPART_NAME = "mimepart.name";
    public static final String MIMEPART_FILENAME = "mimepart.filename";
    public static final String MIMEPART_FILE = "mimepart.file";
    public static final String MIMEPART_STRING = "mimepart.string";
    public static final String MIMEPART_BYTES = "mimepart.bytes";
    public static final String MIMEPART_INCOMPLETE = "mimepart.incomplete";
    private static final String[] ARG_DECODE = new String[]{"decode", "d"};
    private static final String[] ARG_ENCODE = new String[]{"encode", "e"};
    private static final String[] ARG_URL = new String[]{"url", "u"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _SaveSessionSequence(HttpServletRequest request) {
        int seq;
        Object object = SessionSequenceLock;
        synchronized (object) {
            seq = SessionSequenceValue = SessionSequenceValue + 1 & Integer.MAX_VALUE;
        }
        AttributeTools.setSessionInt((ServletRequest)request, SessionSequenceKey, seq);
        return seq;
    }

    public static int GetSessionSequence(HttpServletRequest request) {
        int seq = AttributeTools.getSessionInt((ServletRequest)request, SessionSequenceKey, 0);
        if (seq <= 0) {
            seq = AttributeTools._SaveSessionSequence(request);
        }
        return seq;
    }

    public static void printHeaders(HttpServletRequest req, String title) {
        if (req != null) {
            Print.logInfo((String)("Headers: " + title), (Object[])new Object[0]);
            Enumeration h = req.getHeaderNames();
            while (h.hasMoreElements()) {
                String key = (String)h.nextElement();
                Enumeration v = req.getHeaders(key);
                while (v.hasMoreElements()) {
                    String val = (String)v.nextElement();
                    Print.logInfo((String)(" " + key + " ==> " + val), (Object[])new Object[0]);
                }
            }
        }
    }

    public static void printParameters(HttpServletRequest req, String title) {
        RTProperties multi;
        if (req == null) {
            return;
        }
        if (title == null) {
            Print.logInfo((String)"Parameters:", (Object[])new Object[0]);
        } else {
            Print.logInfo((String)title, (Object[])new Object[0]);
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = req.getParameter(key);
            Print.logInfo((String)("[standard] " + key + "=" + val), (Object[])new Object[0]);
        }
        RTProperties rtp = (RTProperties)req.getAttribute(ATTR_RTP);
        if (rtp != null) {
            for (Object key : rtp.getPropertyKeys()) {
                Object val = rtp.getProperty(key, null);
                Print.logInfo((String)("[rtp] " + key + "=" + val), (Object[])new Object[0]);
            }
        }
        if ((multi = (RTProperties)req.getAttribute(ATTR_MULTIPART)) != null) {
            for (Object key : multi.getPropertyKeys()) {
                Object val = multi.getProperty(key, null);
                if (val instanceof MimePart) {
                    MimePart mp = (MimePart)val;
                    Print.logInfo((String)("[multi] MimePart: " + key), (Object[])new Object[0]);
                    for (String mpKey : mp.keySet()) {
                        Object mpVal = mp.get(mpKey);
                        if (mpVal instanceof byte[]) {
                            byte[] b = (byte[])mpVal;
                            int maxLen = 20;
                            if (b.length > maxLen) {
                                StringBuffer sb = StringTools.toHexString((byte[])b, (int)0, (int)maxLen, null);
                                Print.logInfo((String)("    ==> " + mpKey + "=0x" + sb + "..."), (Object[])new Object[0]);
                                continue;
                            }
                            String s = StringTools.toHexString((byte[])b);
                            Print.logInfo((String)("    ==> " + mpKey + "=0x" + s), (Object[])new Object[0]);
                            continue;
                        }
                        Print.logInfo((String)("    ==> " + mpKey + "=" + mpVal), (Object[])new Object[0]);
                    }
                    continue;
                }
                Print.logInfo((String)("[multi] " + key + "=" + val), (Object[])new Object[0]);
            }
        }
    }

    public static boolean parseMultipartFormData(HttpServletRequest request) {
        try {
            AttributeTools._parseMultipartFormData(request, 0x200000, null);
            return true;
        }
        catch (IOException ioe) {
            Print.logError((String)("Unexpected IOException: " + ioe), (Object[])new Object[0]);
            return false;
        }
    }

    public static RTProperties getMultipartProperties(HttpServletRequest request) {
        return (RTProperties)request.getAttribute(ATTR_MULTIPART);
    }

    public static boolean hasMultipartFormData(HttpServletRequest request) {
        String contentType = AttributeTools.getContentType(request);
        String multiBoundary = HTMLTools.getContentMultipartBoundary((String)contentType);
        return !StringTools.isBlank((String)multiBoundary);
    }

    public static boolean parseMultipartFormData(HttpServletRequest request, int maxLen, File fileSaveDir) {
        try {
            AttributeTools._parseMultipartFormData(request, maxLen, fileSaveDir);
            return true;
        }
        catch (IOException ioe) {
            Print.logError((String)("Unexpected IOException: " + ioe), (Object[])new Object[0]);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    protected static void _parseMultipartFormData(HttpServletRequest request, int maxLen, File fileSaveDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[DOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HttpSession getSession(ServletRequest req) {
        try {
            return req instanceof HttpServletRequest ? ((HttpServletRequest)req).getSession(true) : null;
        }
        catch (IllegalStateException ise) {
            Print.logException((String)"'HttpServletRequest.getSession(true)' Error", (Throwable)ise);
            return null;
        }
    }

    public static String getContentType(HttpServletRequest req) {
        if (req == null) {
            return "";
        }
        String ct1 = StringTools.trim((String)req.getContentType());
        String ct2 = StringTools.trim((String)req.getHeader("content-type"));
        return ct1.length() >= ct2.length() ? ct1 : ct2;
    }

    public static int getContentLength(HttpServletRequest req) {
        return req != null ? req.getContentLength() : 0;
    }

    public static RTProperties parseRTP(ServletRequest req) {
        RTProperties rtp;
        String args;
        if (req != null && !StringTools.isBlank((String)(args = req.getParameter(ATTR_RTP))) && (rtp = URIArg.parseRTP((String)args)) != null) {
            rtp.setIgnoreKeyCase(true);
            req.setAttribute(ATTR_RTP, (Object)rtp);
            return rtp;
        }
        return null;
    }

    public static String[] getMatchingKeys(ServletRequest req, String key_) {
        if (req == null) {
            return null;
        }
        boolean allKeys = key_ == null || key_.equals("");
        Vector<String> keyList = new Vector<String>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            if (allKeys) {
                keyList.add(k);
                continue;
            }
            if (!StringTools.startsWithIgnoreCase((String)k, (String)key_)) continue;
            keyList.add(k);
        }
        if (keyList.size() > 0) {
            return keyList.toArray(new String[keyList.size()]);
        }
        return null;
    }

    public static boolean hasRequestAttribute(ServletRequest req, String key) {
        String v = AttributeTools.getRequestString(req, key, null);
        return v != null;
    }

    public static boolean hasRequestAttribute(ServletRequest req, String[] key) {
        String v = AttributeTools.getRequestString(req, key, null);
        return v != null;
    }

    public static String getRequestString(ServletRequest req, String key, String dft) {
        String val;
        Object val2;
        if (req == null || StringTools.isBlank((String)key)) {
            return dft;
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (!n.equalsIgnoreCase(key) || (val2 = req.getParameter(n)) == null) continue;
            return val2;
        }
        RTProperties rtp = (RTProperties)req.getAttribute(ATTR_RTP);
        if (rtp != null && (val = rtp.getString(key, null)) != null) {
            return val;
        }
        RTProperties multi = (RTProperties)req.getAttribute(ATTR_MULTIPART);
        if (multi != null && (val2 = multi.getProperty((Object)key, null)) != null) {
            if (val2 instanceof String) {
                return (String)val2;
            }
            return dft == null ? null : "";
        }
        return dft;
    }

    public static String getRequestString(ServletRequest req, String[] keyList, String dft) {
        String val;
        Object val2;
        if (req == null || ListTools.isEmpty((Object[])keyList)) {
            return dft;
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            for (String key : keyList) {
                if (!n.equalsIgnoreCase(key) || (val2 = req.getParameter(n)) == null) continue;
                return val2;
            }
        }
        RTProperties rtp = (RTProperties)req.getAttribute(ATTR_RTP);
        if (rtp != null && (val = rtp.getString(keyList, null)) != null) {
            return val;
        }
        RTProperties multi = (RTProperties)req.getAttribute(ATTR_MULTIPART);
        if (multi != null) {
            for (String key : keyList) {
                val2 = multi.getProperty((Object)key, null);
                if (val2 == null) continue;
                if (val2 instanceof String) {
                    return (String)val2;
                }
                return dft == null ? null : "";
            }
        }
        return dft;
    }

    public static double getRequestDouble(ServletRequest req, String key, double dft) {
        return StringTools.parseDouble((String)AttributeTools.getRequestString(req, key, null), (double)dft);
    }

    public static double getRequestDouble(ServletRequest req, String[] key, double dft) {
        return StringTools.parseDouble((String)AttributeTools.getRequestString(req, key, null), (double)dft);
    }

    public static long getRequestLong(ServletRequest req, String key, long dft) {
        return StringTools.parseLong((String)AttributeTools.getRequestString(req, key, null), (long)dft);
    }

    public static long getRequestLong(ServletRequest req, String[] key, long dft) {
        return StringTools.parseLong((String)AttributeTools.getRequestString(req, key, null), (long)dft);
    }

    public static int getRequestInt(ServletRequest req, String key, int dft) {
        return StringTools.parseInt((String)AttributeTools.getRequestString(req, key, null), (int)dft);
    }

    public static int getRequestInt(ServletRequest req, String[] key, int dft) {
        return StringTools.parseInt((String)AttributeTools.getRequestString(req, key, null), (int)dft);
    }

    public static boolean getRequestBoolean(ServletRequest req, String key, boolean dft) {
        String s = AttributeTools.getRequestString(req, key, null);
        return StringTools.parseBoolean((String)s, (boolean)dft);
    }

    public static boolean getRequestBoolean(ServletRequest req, String[] key, boolean dft) {
        String s = AttributeTools.getRequestString(req, key, null);
        return StringTools.parseBoolean((String)s, (boolean)dft);
    }

    public static boolean getRequestCheckbox(ServletRequest req, String key) {
        String s = AttributeTools.getRequestString(req, key, null);
        if (s == null) {
            s = "false";
        }
        return StringTools.parseBoolean((String)s, (boolean)false);
    }

    public static boolean getRequestCheckbox(ServletRequest req, String[] key) {
        String s = AttributeTools.getRequestString(req, key, null);
        if (s == null) {
            s = "false";
        }
        return StringTools.parseBoolean((String)s, (boolean)false);
    }

    public static boolean hasSessionAttribute(HttpSession sess, String key) {
        Object val = AttributeTools.getSessionAttribute(sess, key, null);
        return val != null;
    }

    public static boolean hasSessionAttribute(HttpSession sess, String[] key) {
        Object val = AttributeTools.getSessionAttribute(sess, key, null);
        return val != null;
    }

    public static boolean hasSessionAttribute(ServletRequest req, String key) {
        return AttributeTools.hasSessionAttribute(AttributeTools.getSession(req), key);
    }

    public static boolean hasSessionAttribute(ServletRequest req, String[] key) {
        return AttributeTools.hasSessionAttribute(AttributeTools.getSession(req), key);
    }

    public static Object getSessionAttribute(HttpSession sess, String key, Object dft) {
        try {
            Object val = sess != null ? sess.getAttribute(key) : null;
            return val != null ? val : dft;
        }
        catch (IllegalStateException ise) {
            return dft;
        }
    }

    public static Object getSessionAttribute(HttpSession sess, String[] key, Object dft) {
        if (sess == null || ListTools.isEmpty((Object[])key)) {
            return dft;
        }
        for (int i = 0; i < key.length; ++i) {
            Object val = AttributeTools.getSessionAttribute(sess, key[i], null);
            if (val == null) continue;
            return val;
        }
        return dft;
    }

    public static Object getSessionAttribute(ServletRequest req, String key, Object dft) {
        Object val = AttributeTools.getSessionAttribute(AttributeTools.getSession(req), key, null);
        return val != null ? val : dft;
    }

    public static Object getSessionAttribute(ServletRequest req, String[] key, Object dft) {
        if (req == null || ListTools.isEmpty((Object[])key)) {
            return dft;
        }
        for (int i = 0; i < key.length; ++i) {
            Object val = AttributeTools.getSessionAttribute(req, key[i], null);
            if (val == null) continue;
            return val;
        }
        return dft;
    }

    public static String getSessionString(ServletRequest req, String key, String dft) {
        Object val = AttributeTools.getSessionAttribute(AttributeTools.getSession(req), key, null);
        return val != null ? val.toString() : dft;
    }

    public static String getSessionString(ServletRequest req, String[] key, String dft) {
        if (req == null || ListTools.isEmpty((Object[])key)) {
            return dft;
        }
        for (int i = 0; i < key.length; ++i) {
            String val = AttributeTools.getSessionString(req, key[i], null);
            if (val == null) continue;
            return val;
        }
        return dft;
    }

    public static double getSessionDouble(ServletRequest req, String key, double dft) {
        Object val = AttributeTools.getSessionAttribute(AttributeTools.getSession(req), key, null);
        return StringTools.parseDouble((Object)val, (double)dft);
    }

    public static double getSessionDouble(ServletRequest req, String[] key, double dft) {
        if (req == null || ListTools.isEmpty((Object[])key)) {
            return dft;
        }
        for (int i = 0; i < key.length; ++i) {
            Object val = AttributeTools.getSessionAttribute(req, key[i], null);
            if (val == null) continue;
            return StringTools.parseDouble((Object)val, (double)dft);
        }
        return dft;
    }

    public static long getSessionLong(ServletRequest req, String key, long dft) {
        Object val = AttributeTools.getSessionAttribute(AttributeTools.getSession(req), key, null);
        return StringTools.parseLong((Object)val, (long)dft);
    }

    public static long getSessionLong(ServletRequest req, String[] key, long dft) {
        if (req == null || ListTools.isEmpty((Object[])key)) {
            return dft;
        }
        for (int i = 0; i < key.length; ++i) {
            Object val = AttributeTools.getSessionAttribute(req, key[i], null);
            if (val == null) continue;
            return StringTools.parseLong((Object)val, (long)dft);
        }
        return dft;
    }

    public static int getSessionInt(ServletRequest req, String key, int dft) {
        Object val = AttributeTools.getSessionAttribute(AttributeTools.getSession(req), key, null);
        return StringTools.parseInt((Object)val, (int)dft);
    }

    public static int getSessionInt(ServletRequest req, String[] key, int dft) {
        if (req == null || ListTools.isEmpty((Object[])key)) {
            return dft;
        }
        for (int i = 0; i < key.length; ++i) {
            Object val = AttributeTools.getSessionAttribute(req, key[i], null);
            if (val == null) continue;
            return StringTools.parseInt((Object)val, (int)dft);
        }
        return dft;
    }

    public static boolean getSessionBoolean(ServletRequest req, String key, boolean dft) {
        Object val = AttributeTools.getSessionAttribute(AttributeTools.getSession(req), key, null);
        return StringTools.parseBoolean((Object)val, (boolean)dft);
    }

    public static boolean getSessionBoolean(ServletRequest req, String[] key, boolean dft) {
        if (req == null || ListTools.isEmpty((Object[])key)) {
            return dft;
        }
        for (int i = 0; i < key.length; ++i) {
            Object val = AttributeTools.getSessionAttribute(req, key[i], null);
            if (val == null) continue;
            return StringTools.parseBoolean((Object)val, (boolean)dft);
        }
        return dft;
    }

    public static Object getRequestAttribute(ServletRequest req, String key, Object dft) {
        Object val = AttributeTools.getRequestString(req, key, null);
        if (val == null) {
            val = AttributeTools.getSessionAttribute(req, key, null);
        }
        return val != null ? val : dft;
    }

    public static Object getRequestAttribute(ServletRequest req, String[] key, Object dft) {
        if (req == null || ListTools.isEmpty((Object[])key)) {
            return dft;
        }
        Object val = AttributeTools.getRequestString(req, key, null);
        if (val == null) {
            val = AttributeTools.getSessionAttribute(req, key, null);
        }
        return val != null ? val : dft;
    }

    public static void setSessionAttribute(HttpSession sess, String key, Object val) {
        if (sess != null) {
            try {
                if (val != null) {
                    sess.setAttribute(key, val);
                } else {
                    sess.removeAttribute(key);
                }
            }
            catch (Throwable th) {
                Print.logError((String)("Error setting HttpSession attribute: " + th), (Object[])new Object[0]);
            }
        }
    }

    public static void setSessionAttribute(ServletRequest req, String key, Object val) {
        AttributeTools.setSessionAttribute(AttributeTools.getSession(req), key, val);
    }

    public static void setSessionDouble(ServletRequest req, String key, double val) {
        AttributeTools.setSessionAttribute(AttributeTools.getSession(req), key, (Object)new Double(val));
    }

    public static void setSessionLong(ServletRequest req, String key, long val) {
        AttributeTools.setSessionAttribute(AttributeTools.getSession(req), key, (Object)new Long(val));
    }

    public static void setSessionInt(ServletRequest req, String key, int val) {
        AttributeTools.setSessionAttribute(AttributeTools.getSession(req), key, (Object)new Integer(val));
    }

    public static void setSessionBoolean(ServletRequest req, String key, boolean val) {
        AttributeTools.setSessionAttribute(AttributeTools.getSession(req), key, (Object)new Boolean(val));
    }

    public static void clearSessionAttributes(HttpSession sess) {
        if (sess != null) {
            sess.invalidate();
        }
    }

    public static void clearSessionAttributes(ServletRequest req) {
        AttributeTools.clearSessionAttributes(AttributeTools.getSession(req));
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + AttributeTools.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -encode=<ASCII>    Encode ASCII string to URL argument string", (Object[])new Object[0]);
        Print.logInfo((String)"  -decode=<args>     Decode URL argument string to ASCII", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        if (RTConfig.hasProperty((String[])ARG_URL)) {
            URIArg u = new URIArg(RTConfig.getString((String[])ARG_URL, (String)""));
            String r = URIArg.encodeRTP((RTProperties)u.getArgProperties());
            Print.sysPrintln((String)("==> " + u.getURI() + "?" + ATTR_RTP + "=" + r), (Object[])new Object[0]);
            System.exit(0);
        }
        AttributeTools.usage();
    }

    public static class MimePart
    extends HashMap<String, Object> {
        public String getString(String key, String dft) {
            Object obj = super.get(key);
            return obj != null ? obj.toString() : dft;
        }

        public byte[] getByteArray(String key, byte[] dft) {
            Object obj = super.get(key);
            return obj instanceof byte[] ? (byte[])obj : dft;
        }
    }
}

