/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.presentation;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opengts.db.ReportURL;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.User;
import org.opengts.util.Base64;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.HTMLTools;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.util.XMLTools;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.ReportCallback;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.ReportPresentation;
import org.opengts.war.report.ReportSpreadsheet;
import org.opengts.war.report.presentation.BodyColumnTemplate;
import org.opengts.war.report.presentation.HeaderColumnTemplate;
import org.opengts.war.report.presentation.ReportBody;
import org.opengts.war.report.presentation.ReportHeader;
import org.opengts.war.tools.BufferedHttpServletResponse;
import org.opengts.war.tools.CommonServlet;
import org.opengts.war.tools.HTMLOutput;
import org.opengts.war.tools.MapDimension;
import org.opengts.war.tools.OutputProvider;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPageAdaptor;

public class ReportTable
implements ReportPresentation {
    public static final String CSS_CLASS_TABLE = "rptTbl";
    public static final String CSS_CLASS_TABLE_SORT = "rptTbl_sortable";
    public static final int INDENT = 3;
    public static final String TAG_Account = "Account";
    public static final String TAG_TimeFrom = "TimeFrom";
    public static final String TAG_TimeTo = "TimeTo";
    public static final String TAG_ValidGPSRequired = "ValidGPSRequired";
    public static final String TAG_SelectionLimit = "SelectionLimit";
    public static final String TAG_Ascending = "Ascending";
    public static final String TAG_ReportLimit = "ReportLimit";
    public static final String TAG_Where = "Where";
    public static final String TAG_RuleSelector = "RuleSelector";
    public static final String TAG_Title = "Title";
    public static final String TAG_Subtitle = "Subtitle";
    public static final String TAG_Partial = "Partial";
    public static final String TAG_Report = "Report";
    public static final String TAG_ReportUrl = "ReportUrl";
    public static final String TAG_ReportHtml = "ReportHtml";
    public static final String TAG_ReportEmail = "ReportEmail";
    public static final String TAG_Message = "Message";
    public static final String ATTR_timestamp = "timestamp";
    public static final String ATTR_timezone = "timezone";
    public static final String ATTR_name = "name";
    public static final String ATTR_type = "type";
    public static final String ATTR_format = "format";
    public static final String ATTR_encoding = "encoding";
    public static final String ATTR_sent = "sent";
    private ReportHeader rptHeader = null;
    private ReportBody rptBody = null;
    private Map<String, HeaderColumnTemplate> headerColumnMap = null;
    private Map<String, BodyColumnTemplate> bodyColumnMap = null;
    private static final char[] XML_CHARS = new char[]{'_', '-', '.', ',', '/', '+', ':', '|', '=', ' '};

    public ReportTable() {
        this(null, null);
    }

    protected ReportTable(ReportHeader rh, ReportBody rb) {
        this.rptHeader = rh != null ? rh : new ReportHeader(this);
        this.rptBody = rb != null ? rb : new ReportBody(this);
        this.headerColumnMap = new HashMap<String, HeaderColumnTemplate>();
        this.bodyColumnMap = new HashMap<String, BodyColumnTemplate>();
    }

    @Override
    public int writeReport(String format, ReportData rd, OutputProvider out, int indentLevel) throws ReportException {
        ReportURL.Format rptFormat = (ReportURL.Format)EnumTools.getValueOf(ReportURL.Format.class, (String)format);
        return this.writeReport(rptFormat, rd, out, indentLevel);
    }

    @Override
    public int writeReport(ReportURL.Format rptFormat, ReportData rd, OutputProvider out, int indentLevel) throws ReportException {
        if (rptFormat == null) {
            rptFormat = ReportURL.Format.HTML;
        }
        switch (rptFormat) {
            case XML: 
            case SOAP: 
            case URL: 
            case EMAIL: 
            case EHTML: {
                return this.writeXML(out, indentLevel, rd, rptFormat);
            }
            case CSV: {
                return this.writeCSV(out, indentLevel, rd, true);
            }
            case XLS: {
                return this.writeXLS(out, indentLevel, rd, false);
            }
            case XLSX: {
                return this.writeXLS(out, indentLevel, rd, true);
            }
            case TXT: {
                return this.writeCSV(out, indentLevel, rd, false);
            }
            case CALLBACK: {
                return this.writeCallback(out, indentLevel, rd);
            }
            case PDF: {
                return this.writePDF(out, indentLevel, rd);
            }
        }
        return this.writeHTML(out, indentLevel, rd);
    }

    private int writeHTML(OutputProvider out, int level, ReportData rd) throws ReportException {
        PrintWriter pw = null;
        try {
            pw = out.getWriter();
        }
        catch (IOException ioe) {
            throw new ReportException("PrintWriter error", ioe);
        }
        if (rd == null) {
            return 0;
        }
        if (!rd.isSingleDeviceOnly() || rd.getDeviceCount() <= 1) {
            return this._writeHTML(pw, level, rd, -1);
        }
        ReportDeviceList rdl = rd.getReportDeviceList();
        List<ReportDeviceList.DeviceHolder> dhList = rdl.getDeviceHolderList(true);
        rdl.clear();
        int rcdCount = 0;
        int devCount = dhList.size();
        for (int i = 0; i < devCount; ++i) {
            if (i > 0) {
                pw.print("<br>\n");
            }
            rdl.setDevice(null, dhList.get(i));
            rcdCount += this._writeHTML(pw, level, rd, i);
        }
        return rcdCount;
    }

    private int _writeHTML(PrintWriter out, int level, ReportData rd, int ndx) throws ReportException {
        String t;
        String kmlURL;
        String desc;
        String mapURL;
        String graphURL;
        String refreshURL;
        if (out == null) {
            throw new ReportException("Invalid PrintWriter (null)");
        }
        RequestProperties reqState = rd.getRequestProperties();
        boolean isEMail = reqState.getEncodeEMailHTML();
        PrivateLabel privLabel = rd.getPrivateLabel();
        I18N i18n = privLabel.getI18N(ReportTable.class);
        out.print("<center>\n");
        out.print("<table cellspacing='0' cellpadding='0' border='0'>\n");
        String rptTitle = rd.getReportTitle();
        out.print("<tr><td colSpan='3'><H1 class=\"rptTitle\">" + ReportTable.FilterText(rptTitle) + "</H1></td></tr>\n");
        out.print("<tr>\n");
        out.print("<td>");
        StringBuffer linkSB_L = new StringBuffer();
        String string = refreshURL = !isEMail && ndx <= 0 ? ReportTable.EncodeURL(reqState, rd.getRefreshURL()) : null;
        if (!StringTools.isBlank(refreshURL)) {
            String refreshDesc = i18n.getString("ReportTable.refreshReport", "Refresh");
            if (linkSB_L.length() > 0) {
                linkSB_L.append("&nbsp;&nbsp;");
            }
            linkSB_L.append("<a href='" + refreshURL + "' target='_self'>" + refreshDesc + "</a>");
        }
        if (linkSB_L.length() > 0) {
            out.print(linkSB_L.toString());
        } else {
            out.print("&nbsp;");
        }
        out.print("</td>\n");
        out.print("<td width='100%'>");
        String rptSubtt = rd.getReportSubtitle();
        if (!StringTools.isBlank((String)rptSubtt)) {
            out.print("<H2 class=\"rptSubtitle\">" + ReportTable.FilterText(rptSubtt) + "</H2>");
        } else {
            out.print("&nbsp;");
        }
        out.print("</td>\n");
        out.print("<td>");
        StringBuffer linkSB_R = new StringBuffer();
        String string2 = graphURL = !isEMail && ndx < 0 && rd.getSupportsGraphDisplay() ? ReportTable.EncodeURL(reqState, rd.getGraphURL()) : null;
        if (!StringTools.isBlank(graphURL)) {
            MapDimension sz = rd.getGraphWindowSize();
            String desc2 = rd.getGraphLinkDescription();
            if (StringTools.isBlank((String)desc2)) {
                desc2 = i18n.getString("ReportTable.displayGraph", "Graph");
            }
            if (linkSB_R.length() > 0) {
                linkSB_R.append("&nbsp;&nbsp;");
            }
            linkSB_R.append("<span class='spanLink' onclick=\"javascript:openResizableWindow('" + graphURL + "','ReportGraph'," + sz.getWidth() + "," + sz.getHeight() + ");\">" + desc2 + "</span>");
        }
        String string3 = mapURL = !isEMail && ndx < 0 && rd.getSupportsMapDisplay() ? ReportTable.EncodeURL(reqState, rd.getMapURL()) : null;
        if (!StringTools.isBlank(mapURL)) {
            MapDimension sz = rd.getMapWindowSize();
            desc = rd.getMapLinkDescription();
            if (StringTools.isBlank((String)desc)) {
                desc = i18n.getString("ReportTable.displayMap", "Map");
            }
            if (linkSB_R.length() > 0) {
                linkSB_R.append("&nbsp;&nbsp;");
            }
            linkSB_R.append("<span class='spanLink' onclick=\"javascript:openResizableWindow('" + mapURL + "','ReportMap'," + sz.getWidth() + "," + sz.getHeight() + ");\">" + desc + "</span>");
        }
        String string4 = kmlURL = !isEMail && ndx < 0 && rd.getSupportsKmlDisplay() && privLabel.getBooleanProperty("reportDisplay.showGoogleKML", false) ? ReportTable.EncodeURL(reqState, rd.getKmlURL()) : null;
        if (!StringTools.isBlank(kmlURL)) {
            desc = rd.getKmlLinkDescription();
            if (StringTools.isBlank((String)desc)) {
                desc = i18n.getString("ReportTable.displayKML", "KML");
            }
            if (linkSB_R.length() > 0) {
                linkSB_R.append("&nbsp;&nbsp;");
            }
            linkSB_R.append("<a href='" + kmlURL + "' target='_blank'>" + desc + "</a>");
        }
        if (linkSB_R.length() > 0) {
            out.print(linkSB_R.toString());
        } else {
            out.print("&nbsp;");
        }
        out.print("</td>\n");
        out.print("</tr>\n");
        out.print("<tr>\n");
        out.print("<td colSpan='3'>\n");
        String tableClass = rd.getReportFactory().isTableSortable() ? CSS_CLASS_TABLE_SORT : CSS_CLASS_TABLE;
        out.print("<table class='" + tableClass + "' width='100%' cellspacing='0' cellpadding='0' border='0'>\n");
        out.print("<!-- Report Header -->\n");
        this.rptHeader.writeHTML(out, level + 1, rd);
        out.print("<!-- Report Data -->\n");
        this.rptBody.writeHTML(out, level + 1, rd);
        out.print("</table>\n");
        out.print("</td>\n");
        out.print("</tr>\n");
        if (this.rptBody.getRecordCount(rd) <= 0) {
            out.print("<tr>\n");
            out.print("<td colSpan='3'><H2 class=\"rptNoData\">");
            t = i18n.getString("ReportTable.noData", "This report contains no data");
            out.print(ReportTable.FilterText(t));
            out.print("</H2></td>\n");
            out.print("</tr>\n");
        } else if (this.rptBody.isPartial(rd)) {
            out.print("<tr>\n");
            out.print("<td colSpan='3'><H2 class=\"rptPartial\">");
            t = i18n.getString("ReportTable.partialData", "This report has reached it's record display limit and may only contain a portion of the possible data");
            out.print(ReportTable.FilterText(t));
            out.print("</H2></td>\n");
            out.print("</tr>\n");
        }
        out.print("</table>\n");
        out.print("</center>\n");
        return this.rptBody.getRecordCount(rd);
    }

    public static String EncodeURL(RequestProperties reqState, URIArg url) {
        return WebPageAdaptor.EncodeURL(reqState, url);
    }

    public static String FilterText(String s) {
        return WebPageAdaptor.FilterText(s);
    }

    private int writeXML(OutputProvider out, int level, ReportData rd, ReportURL.Format rptFormat) throws ReportException {
        int rcdCount = 0;
        return rcdCount += this._writeXML(out, level, rd, rptFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _writeXML(OutputProvider out, int level, ReportData rd, ReportURL.Format rptFormat) throws ReportException {
        PrintWriter pw = null;
        try {
            pw = out.getWriter();
        }
        catch (IOException ioe) {
            throw new ReportException("PrintWriter error", ioe);
        }
        boolean isSoapRequest = rd.isSoapRequest();
        RequestProperties reqState = rd.getRequestProperties();
        PrivateLabel privLabel = rd.getPrivateLabel();
        I18N i18n = privLabel.getI18N(ReportTable.class);
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)(level * 3));
        String PFX2 = XMLTools.PREFIX((boolean)isSoapRequest, (int)((level + 1) * 3));
        pw.print(PFX1);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Report, (String)(XMLTools.ATTR((String)ATTR_name, (String)rd.getReportName()) + XMLTools.ATTR((String)ATTR_type, (String)rd.getReportType()) + XMLTools.ATTR((String)ATTR_format, (String)rptFormat.toString())), (boolean)false, (boolean)true));
        ReportConstraints rc = rd.getReportConstraints();
        String dtFmt = "yyyy/MM/dd,HH:mm:ss";
        TimeZone tzone = rd.getTimeZone();
        String tzStr = rd.getTimeZoneString();
        long tmBeg = rc.getTimeStart();
        long tmEnd = rc.getTimeEnd();
        DateTime dtStr = new DateTime(tmBeg, tzone);
        DateTime dtEnd = new DateTime(tmEnd, tzone);
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Account, (String)"", (boolean)false, (boolean)false));
        pw.print(ReportTable.XmlFilter(isSoapRequest, rd.getAccountID()));
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Account, (boolean)true));
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_TimeFrom, (String)(XMLTools.ATTR((String)ATTR_timestamp, (String)String.valueOf(tmBeg)) + XMLTools.ATTR((String)ATTR_timezone, (String)tzStr)), (boolean)false, (boolean)false));
        pw.print(tmBeg > 0L ? ReportTable.XmlFilter(isSoapRequest, dtStr.format(dtFmt)) : "");
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_TimeFrom, (boolean)true));
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_TimeTo, (String)(XMLTools.ATTR((String)ATTR_timestamp, (String)String.valueOf(tmEnd)) + XMLTools.ATTR((String)ATTR_timezone, (String)tzStr)), (boolean)false, (boolean)false));
        pw.print(tmEnd > 0L ? ReportTable.XmlFilter(isSoapRequest, dtEnd.format(dtFmt)) : "");
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_TimeTo, (boolean)true));
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_ValidGPSRequired, (String)"", (boolean)false, (boolean)false));
        pw.print(ReportTable.XmlFilter(isSoapRequest, rc.getValidGPSRequired()));
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_ValidGPSRequired, (boolean)true));
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_SelectionLimit, (String)XMLTools.ATTR((String)ATTR_type, (Object)rc.getSelectionLimitType()), (boolean)false, (boolean)false));
        pw.print(ReportTable.XmlFilter(isSoapRequest, rc.getSelectionLimit()));
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_SelectionLimit, (boolean)true));
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Ascending, (String)"", (boolean)false, (boolean)false));
        pw.print(ReportTable.XmlFilter(isSoapRequest, rc.getOrderAscending()));
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Ascending, (boolean)true));
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_ReportLimit, (String)"", (boolean)false, (boolean)false));
        pw.print(ReportTable.XmlFilter(isSoapRequest, rc.getReportLimit()));
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_ReportLimit, (boolean)true));
        if (rc.hasWhere()) {
            pw.print(PFX2);
            pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Where, (String)"", (boolean)false, (boolean)false));
            pw.print(ReportTable.XmlFilter(isSoapRequest, rc.getWhere()));
            pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Where, (boolean)true));
        }
        if (rc.hasRuleSelector()) {
            pw.print(PFX2);
            pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_RuleSelector, (String)"", (boolean)false, (boolean)false));
            pw.print(ReportTable.XmlFilter(isSoapRequest, rc.getRuleSelector()));
            pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_RuleSelector, (boolean)true));
        }
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Title, (String)"", (boolean)false, (boolean)false));
        pw.print(ReportTable.XmlFilter(isSoapRequest, rd.getReportTitle()));
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Title, (boolean)true));
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Subtitle, (String)"", (boolean)false, (boolean)false));
        pw.print(ReportTable.XmlFilter(isSoapRequest, rd.getReportSubtitle()));
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Subtitle, (boolean)true));
        if (rptFormat.equals((Object)ReportURL.Format.URL)) {
            String groupID;
            HttpServletRequest request = reqState.getHttpServletRequest();
            ReportDeviceList devList = rd.getReportDeviceList();
            String deviceID = devList.isDeviceGroup() ? null : devList.getFirstDeviceID();
            String string = groupID = devList.isDeviceGroup() ? devList.getDeviceGroupID() : null;
            String baseURL = privLabel.hasDefaultBaseURL() ? privLabel.getDefaultBaseURL() : (request != null ? request.getRequestURL().toString() : "");
            URIArg rptURL = ReportURL.createReportURL((String)baseURL, (boolean)false, (String)rd.getAccountID(), (String)rd.getUserID(), (String)"", (String)deviceID, (String)groupID, (String)String.valueOf(rc.getTimeStart()), (String)String.valueOf(rc.getTimeEnd()), (String)rd.getTimeZoneString(), (String)rd.getReportName(), (String)String.valueOf(rc.getReportLimit()), (String)rc.getSelectionLimitType().toString(), (String)"ehtml");
            pw.print(PFX2);
            pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_ReportUrl, (String)"", (boolean)false, (boolean)false));
            pw.print(ReportTable.XmlFilter(isSoapRequest, rptURL.toString()));
            pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_ReportUrl, (boolean)true));
        } else if (rptFormat.equals((Object)ReportURL.Format.EMAIL)) {
            String rptMsg = "";
            boolean sent = false;
            Print.logInfo((String)"Generate and email HTML report ...", (Object[])new Object[0]);
            String htmlStr = ReportTable._writeHTMLReport(reqState, rd, false);
            int logLevel = Print.getLogLevel();
            Print.setLogLevel((int)6);
            try {
                String toEmail;
                Account account = rd.getAccount();
                User user = rd.getUser();
                String frEmail = privLabel.getEventNotificationFrom();
                String string = toEmail = rc.hasEmailAddresses() ? rc.getEmailAddresses() : Account.getReportEmailAddress((Account)account, (User)user);
                if (StringTools.isBlank((String)frEmail)) {
                    Print.logWarn((String)"'From' email address has not been configured", (Object[])new Object[0]);
                    rptMsg = "'From' email address not specified";
                    sent = false;
                } else if (StringTools.isBlank((String)toEmail)) {
                    Print.logWarn((String)"No email recipients have been specified", (Object[])new Object[0]);
                    rptMsg = "No email recipients specified";
                    sent = false;
                } else {
                    String reportID = rd.getReportName();
                    String subj = i18n.getString("ReportDisplay.reportTitle", TAG_Report) + ": " + rd.getReportTitle();
                    StringBuffer body = new StringBuffer();
                    body.append(i18n.getString("ReportDisplay.account", TAG_Account)).append(": ");
                    body.append("[").append(rd.getAccountID()).append("] ");
                    body.append(account.getDescription());
                    body.append("\n");
                    body.append(subj);
                    body.append("\n");
                    byte[] rptAttach = StringTools.getBytes((String)htmlStr);
                    SendMail.Attachment attach = new SendMail.Attachment(rptAttach, reportID + ".html", HTMLTools.MIME_HTML());
                    SendMail.SmtpProperties smtpProps = privLabel.getSmtpProperties();
                    SendMail.send((String)frEmail, (String)toEmail, (String)subj, (String)body.toString(), (SendMail.Attachment)attach, (SendMail.SmtpProperties)smtpProps);
                    Print.logInfo((String)("Email sent to: " + toEmail), (Object[])new Object[0]);
                    rptMsg = "EMail sent: " + toEmail;
                    sent = true;
                }
            }
            catch (Throwable t) {
                Print.logException((String)"SendMail error", (Throwable)t);
                rptMsg = "Internal SendMail error";
                sent = false;
            }
            finally {
                Print.setLogLevel((int)logLevel);
            }
            pw.print(PFX2);
            pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_ReportEmail, (String)XMLTools.ATTR((String)ATTR_sent, (String)(sent ? "true" : "false")), (boolean)false, (boolean)false));
            pw.print(ReportTable.XmlFilter(isSoapRequest, rptMsg));
            pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_ReportEmail, (boolean)true));
        } else if (rptFormat.equals((Object)ReportURL.Format.EHTML) || rptFormat.equals((Object)ReportURL.Format.HTML)) {
            String htmlB64 = ReportTable._writeHTMLReport(reqState, rd, true);
            pw.print(PFX2);
            pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_ReportHtml, (String)XMLTools.ATTR((String)ATTR_encoding, (String)"base64"), (boolean)false, (boolean)false));
            pw.print(XMLTools.CDATA((boolean)isSoapRequest, (String)htmlB64));
            pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_ReportHtml, (boolean)true));
        } else {
            this.rptHeader.writeXML(pw, level + 1, rd);
            this.rptBody.writeXML(pw, level + 1, rd);
        }
        pw.print(PFX2);
        pw.print(XMLTools.startTAG((boolean)isSoapRequest, (String)TAG_Partial, (String)"", (boolean)false, (boolean)false));
        pw.print(ReportTable.XmlFilter(isSoapRequest, this.rptBody.isPartial(rd)));
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Partial, (boolean)true));
        pw.print(PFX1);
        pw.print(XMLTools.endTAG((boolean)isSoapRequest, (String)TAG_Report, (boolean)true));
        return this.rptBody.getRecordCount(rd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String _writeHTMLReport(final RequestProperties reqState, final ReportData report, boolean base64Encode) {
        final PrivateLabel privLabel = reqState.getPrivateLabel();
        HTMLOutput HTML_CSS = new HTMLOutput(){

            @Override
            public void write(PrintWriter _pw) throws IOException {
                PrintWriter pw = _pw;
                try {
                    pw.write("\n");
                    pw.write("<!-- Begin Report Style -->\n");
                    String cssDir = privLabel.getCssDirectory();
                    WebPageAdaptor.writeCssLink(pw, reqState, "ReportDisplay.css", cssDir);
                    ReportLayout reportLayout = report.getReportLayout();
                    if (reportLayout.hasCSSFiles()) {
                        for (String file : reportLayout.getCSSFiles(true)) {
                            WebPageAdaptor.writeCssLink(pw, reqState, file, cssDir);
                        }
                    }
                    report.writeReportStyle("html", new OutputProvider(pw));
                    pw.write("<!-- End Report Style -->\n");
                    pw.write("\n");
                }
                catch (ReportException re) {
                    throw new IOException(re.getMessage());
                }
            }
        };
        String[] CSS_REPORT_DISPLAY = new String[]{"reportDisplayTable", "reportDisplayCell"};
        HTMLOutput HTML_CONTENT = new HTMLOutput(CSS_REPORT_DISPLAY, ""){

            @Override
            public void write(PrintWriter _pw) throws IOException {
                PrintWriter pw = _pw;
                try {
                    report.writeReport("html", new OutputProvider(pw));
                }
                catch (ReportException re) {
                    throw new IOException(re.getMessage());
                }
            }
        };
        String uri = privLabel.getJSPFile("emailReport", false);
        reqState.setWebPageURI(uri);
        Print.logInfo((String)("Embedded Report JSP: " + uri), (Object[])new Object[0]);
        Print.logInfo((String)("Report JSP: " + reqState.getJspURI()), (Object[])new Object[0]);
        RTProperties emailLinkProps = null;
        reqState.setEncodeEMailHTML(true);
        URIArg emailURL = reqState.getHttpServletRequestURIArg(true);
        if (emailURL != null) {
            emailURL.removeArg(ReportURL.RPTARG_FORMAT);
            emailURL.addArg(ReportURL.RPTARG_FORMAT[1], "html");
            if (privLabel.hasDefaultBaseURL()) {
                emailURL.setURI(privLabel.getDefaultBaseURL());
            }
            Print.logInfo((String)("EMail URL(1): " + emailURL), (Object[])new Object[0]);
            String rtpVal = URIArg.encodeRTP((RTProperties)emailURL.getArgProperties());
            emailURL = new URIArg(emailURL.getURI(), true);
            emailURL.addArg("rtp_", rtpVal);
            emailLinkProps = new RTProperties();
            emailLinkProps.setString("EMailReport.url", emailURL.toString());
            emailLinkProps.setString("EMailReport.desc", "Web Link");
        }
        HttpServletResponse httpResp = reqState.getHttpServletResponse();
        BufferedHttpServletResponse bhsp = new BufferedHttpServletResponse(httpResp);
        reqState.setHttpServletResponse((HttpServletResponse)bhsp);
        boolean success = true;
        try {
            if (emailLinkProps != null) {
                RTConfig.pushTemporaryProperties(emailLinkProps);
            }
            CommonServlet.writePageFrame(reqState, null, null, HTML_CSS, null, null, HTML_CONTENT);
            success = true;
        }
        catch (IOException ioe) {
            success = false;
        }
        finally {
            if (emailLinkProps != null) {
                RTConfig.popTemporaryProperties(emailLinkProps);
            }
        }
        reqState.setHttpServletResponse(httpResp);
        reqState.setWebPageURI(null);
        reqState.setEncodeEMailHTML(false);
        if (success) {
            String htmlStr = bhsp.toString();
            if (base64Encode) {
                String htmlB64 = Base64.encode((String)htmlStr);
                StringBuffer htmlSB = new StringBuffer("\n");
                int lineLen = 100;
                while (htmlB64.length() > lineLen) {
                    htmlSB.append(htmlB64.substring(0, lineLen)).append("\n");
                    htmlB64 = htmlB64.substring(lineLen);
                }
                htmlSB.append(htmlB64).append("\n");
                return htmlSB.toString();
            }
            return htmlStr;
        }
        return "";
    }

    public static String XmlFilter(boolean isSoapReq, String value) {
        if (value == null || value.equals("")) {
            return "";
        }
        if (StringTools.isAlphaNumeric((String)value, (char[])XML_CHARS)) {
            return value;
        }
        String v = StringTools.replace((String)value, (String)"\n", (String)"\\n");
        return XMLTools.CDATA((boolean)isSoapReq, (String)v);
    }

    public static String XmlFilter(boolean isSoapReq, long value) {
        return String.valueOf(value);
    }

    public static String XmlFilter(boolean isSoapReq, int value) {
        return String.valueOf(value);
    }

    public static String XmlFilter(boolean isSoapReq, boolean value) {
        return String.valueOf(value);
    }

    private int writeCSV(OutputProvider out, int level, ReportData rd, boolean mimeCSV) throws ReportException {
        PrintWriter pw = null;
        try {
            pw = out.getWriter();
        }
        catch (IOException ioe) {
            throw new ReportException("PrintWriter error", ioe);
        }
        HttpServletResponse response = rd.getRequestProperties().getHttpServletResponse();
        if (mimeCSV) {
            CommonServlet.setResponseContentType(response, HTMLTools.MIME_CSV());
        } else {
            CommonServlet.setResponseContentType(response, HTMLTools.MIME_PLAIN());
        }
        if (rd == null) {
            Print.logInfo((String)"No ReportData", (Object[])new Object[0]);
            return 0;
        }
        int rcdCount = 0;
        if (!rd.isSingleDeviceOnly() || rd.getDeviceCount() <= 1) {
            rcdCount = this._writeCSV(pw, level, rd, -1);
        } else {
            ReportDeviceList rdl = rd.getReportDeviceList();
            List<ReportDeviceList.DeviceHolder> dhList = rdl.getDeviceHolderList(true);
            rdl.clear();
            int devCount = dhList.size();
            for (int i = 0; i < devCount; ++i) {
                rdl.setDevice(null, dhList.get(i));
                rcdCount += this._writeCSV(pw, level, rd, devCount);
            }
        }
        return rcdCount;
    }

    private int _writeCSV(PrintWriter pw, int level, ReportData rd, int devCnt) throws ReportException {
        this.rptHeader.writeCSV(pw, level + 1, rd);
        this.rptBody.writeCSV(pw, level + 1, rd);
        return this.rptBody.getRecordCount(rd);
    }

    public static String csvFilter(String value) {
        return StringTools.quoteCSVString((String)value);
    }

    private int writeXLS(OutputProvider out, int level, ReportData rd, boolean xlsx) throws ReportException {
        Print.logInfo((String)("Excel spreadsheet report output (xlsx=" + xlsx + ") ..."), (Object[])new Object[0]);
        HttpServletResponse response = rd.getRequestProperties().getHttpServletResponse();
        if (xlsx) {
            CommonServlet.setResponseContentType(response, HTMLTools.MIME_XLSX());
        } else {
            CommonServlet.setResponseContentType(response, HTMLTools.MIME_XLS());
        }
        if (rd == null) {
            Print.logInfo((String)"No ReportData (Skipping Excel spreadsheet output)", (Object[])new Object[0]);
            return 0;
        }
        ReportSpreadsheet rptSS = new ReportSpreadsheet(xlsx, rd);
        int rcdCount = 0;
        if (!rd.isSingleDeviceOnly() || rd.getDeviceCount() <= 1) {
            rcdCount = this._writeXLS(rptSS, level, rd, xlsx, -1);
        } else {
            ReportDeviceList rdl = rd.getReportDeviceList();
            List<ReportDeviceList.DeviceHolder> dhList = rdl.getDeviceHolderList(true);
            rdl.clear();
            int devCount = dhList.size();
            for (int i = 0; i < devCount; ++i) {
                if (i > 0) {
                    rptSS.setBlankRow();
                }
                rdl.setDevice(null, dhList.get(i));
                rcdCount += this._writeXLS(rptSS, level, rd, xlsx, devCount);
            }
        }
        OutputStream os = null;
        try {
            os = out.getOutputStream();
        }
        catch (IOException ioe) {
            throw new ReportException("'OutputStream' error", ioe);
        }
        boolean ok = rptSS.write(os);
        return rcdCount;
    }

    private int _writeXLS(ReportSpreadsheet rptSS, int level, ReportData rd, boolean xlsx, int devCount) throws ReportException {
        if (rptSS == null) {
            throw new ReportException("Invalid ReportSpreadsheet (null)");
        }
        rptSS.setHeaderTitle(rd.getReportTitle());
        rptSS.setHeaderSubtitle(rd.getReportSubtitle());
        this.rptHeader.writeXLS(rptSS, level + 1, rd);
        this.rptBody.writeXLS(rptSS, level + 1, rd);
        return this.rptBody.getRecordCount(rd);
    }

    private int writePDF(OutputProvider out, int level, ReportData rd) throws ReportException {
        Print.logInfo((String)"PDF report output ...", (Object[])new Object[0]);
        throw new ReportException("PDF not yet supported");
    }

    private int writeCallback(OutputProvider out, int level, ReportData rd) throws ReportException {
        ReportCallback rptCB = rd.getReportCallback();
        if (rptCB == null) {
            return 0;
        }
        rptCB.reportStart(out, level);
        this.rptHeader.writeCallback(out, level + 1, rd);
        this.rptBody.writeCallback(out, level + 1, rd);
        rptCB.reportEnd(out, level);
        return this.rptBody.getRecordCount(rd);
    }

    protected HeaderColumnTemplate _createHeaderColumnTemplate(DataColumnTemplate dct) {
        return new HeaderColumnTemplate(dct);
    }

    public HeaderColumnTemplate getHeaderColumnTemplate(DataColumnTemplate dct) {
        if (dct != null) {
            String keyName = dct.getKeyName();
            if (this.headerColumnMap.containsKey(keyName)) {
                return this.headerColumnMap.get(keyName);
            }
            HeaderColumnTemplate hct = this._createHeaderColumnTemplate(dct);
            this.headerColumnMap.put(keyName, hct);
            return hct;
        }
        Print.logStackTrace((String)"DataColumnTemplate is null!");
        return null;
    }

    protected BodyColumnTemplate _createBodyColumnTemplate(DataColumnTemplate dct) {
        return new BodyColumnTemplate(dct.getKeyName());
    }

    public BodyColumnTemplate getBodyColumnTemplate(DataColumnTemplate dct) {
        if (dct != null) {
            String keyName = dct.getKeyName();
            if (this.bodyColumnMap.containsKey(keyName)) {
                return this.bodyColumnMap.get(keyName);
            }
            BodyColumnTemplate bct = this._createBodyColumnTemplate(dct);
            this.bodyColumnMap.put(keyName, bct);
            return bct;
        }
        Print.logStackTrace((String)"DataColumnTemplate is null!");
        return null;
    }
}

