/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.presentation;

import java.io.PrintWriter;
import org.opengts.util.ListTools;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportCallback;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportSpreadsheet;
import org.opengts.war.report.presentation.BodyColumnTemplate;
import org.opengts.war.report.presentation.HeaderColumnTemplate;
import org.opengts.war.report.presentation.HeaderRowTemplate;
import org.opengts.war.report.presentation.ReportTable;
import org.opengts.war.tools.OutputProvider;

public class ReportHeader {
    private static final boolean USE_CSV_COLUMN_HEADER_DESCRIPTIONS = false;
    private static final String PROP_csvColumnHeaderDescriptions = "csvColumnHeaderDescriptions";
    private static final boolean USE_XLS_COLUMN_HEADER_DESCRIPTIONS = true;
    private static final String PROP_xlsColumnHeaderDescriptions = "xlsColumnHeaderDescriptions";
    private static final boolean USE_CALLBACK_COLUMN_HEADER_DESCRIPTIONS = true;
    private static final String PROP_callbackColumnHeaderDescriptions = "callbackColumnHeaderDescriptions";
    private ReportTable reportTable = null;
    private HeaderRowTemplate[] headerRow = null;

    public ReportHeader(ReportTable rptTable) {
        this(rptTable, new HeaderRowTemplate(rptTable));
    }

    protected ReportHeader(ReportTable rptTable, HeaderRowTemplate ... hr) {
        this.reportTable = rptTable;
        this.headerRow = hr != null ? hr : new HeaderRowTemplate[]{};
    }

    public void writeHTML(PrintWriter out, int level, ReportData rptData) throws ReportException {
        out.print("<thead>\n");
        for (int i = 0; i < this.headerRow.length; ++i) {
            this.headerRow[i].writeHTML(out, level + 1, rptData);
        }
        out.print("</thead>\n");
    }

    public void writeXML(PrintWriter out, int level, ReportData rptData) throws ReportException {
        boolean isSoapRequest = rptData.isSoapRequest();
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)(level * 3));
        out.print(PFX1);
        out.print(XMLTools.startTAG((boolean)isSoapRequest, (String)"ReportHeader", (String)"", (boolean)false, (boolean)true));
        for (int i = 0; i < this.headerRow.length; ++i) {
            this.headerRow[i].writeXML(out, level + 1, rptData);
        }
        out.print(PFX1);
        out.print(XMLTools.endTAG((boolean)isSoapRequest, (String)"ReportHeader", (boolean)true));
    }

    public void writeCSV(PrintWriter out, int level, ReportData rptData) throws ReportException {
        Object[] rptCols = rptData.getReportColumns();
        if (ListTools.isEmpty((Object[])rptCols)) {
            throw new ReportException("No report columns defined");
        }
        boolean useColDesc = rptData.getProperties().getBoolean(PROP_csvColumnHeaderDescriptions, false);
        DataRowTemplate rdp = rptData.getDataRowTemplate();
        for (int i = 0; i < rptCols.length; ++i) {
            String colName = ((ReportColumn)rptCols[i]).getKey();
            DataColumnTemplate dct = rdp.getColumnTemplate(colName);
            if (dct == null) continue;
            if (i > 0) {
                out.print(",");
            }
            BodyColumnTemplate bct = this.reportTable.getBodyColumnTemplate(dct);
            String colTitle = null;
            if (useColDesc) {
                HeaderColumnTemplate hct = this.reportTable.getHeaderColumnTemplate(dct);
                colTitle = StringTools.replace((String)hct.getTitle(rptData, (ReportColumn)rptCols[i]), (String)"\n", (String)" ");
            } else {
                colTitle = bct.getFieldName();
            }
            bct.writeCSV(out, level + 1, colTitle);
        }
        out.print("\n");
    }

    public void writeXLS(ReportSpreadsheet rptSS, int level, ReportData rptData) throws ReportException {
        for (int i = 0; i < this.headerRow.length; ++i) {
            this.headerRow[i].writeXLS(rptSS, level + 1, rptData);
        }
    }

    public void writeCallback(OutputProvider out, int level, ReportData rd) throws ReportException {
        ReportCallback rptCB = rd.getReportCallback();
        if (rptCB == null) {
            return;
        }
        boolean useColDesc = rd.getProperties().getBoolean(PROP_callbackColumnHeaderDescriptions, true);
        Object[] rptCols = rd.getReportColumns();
        if (ListTools.isEmpty((Object[])rptCols)) {
            throw new ReportException("No report columns defined");
        }
        Object[] colHeader = new Object[rptCols.length];
        DataRowTemplate rdp = rd.getDataRowTemplate();
        for (int i = 0; i < rptCols.length; ++i) {
            String colName = ((ReportColumn)rptCols[i]).getKey();
            DataColumnTemplate dct = rdp.getColumnTemplate(colName);
            if (dct != null) {
                BodyColumnTemplate bct = this.reportTable.getBodyColumnTemplate(dct);
                if (useColDesc) {
                    colHeader[i] = this.reportTable.getHeaderColumnTemplate(dct);
                    continue;
                }
                colHeader[i] = bct.getFieldName();
                continue;
            }
            colHeader[i] = colName;
        }
        rptCB.reportHeader(out, level, colHeader);
    }
}

