/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.presentation;

import java.io.PrintWriter;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.XMLTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.ReportCallback;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportSpreadsheet;
import org.opengts.war.report.presentation.BodyRowTemplate;
import org.opengts.war.report.presentation.ReportTable;
import org.opengts.war.tools.OutputProvider;

public class ReportBody {
    public static final String PROP_ReportBody_debugXLS = "ReportBody.debugXLS";
    private ReportTable reportTable = null;
    private BodyRowTemplate bodyRow = null;
    private boolean debugXLS = false;
    private int rcdCount = 0;
    private boolean isPartial = false;
    private static final boolean INCLUDE_CSV_TOTALS = false;

    public ReportBody(ReportTable rptTable) {
        this(rptTable, null);
    }

    protected ReportBody(ReportTable rptTable, BodyRowTemplate br) {
        this.reportTable = rptTable;
        this.bodyRow = br != null ? br : new BodyRowTemplate(this.reportTable);
        this.debugXLS = RTConfig.getBoolean((String)PROP_ReportBody_debugXLS, (boolean)false);
    }

    public int getRecordCount(ReportData rd) {
        if (rd != null) {
            return rd.getReportRecordCount();
        }
        return this.rcdCount;
    }

    public boolean isPartial(ReportData rd) {
        if (rd != null) {
            return rd.getReportIsPartial();
        }
        return this.isPartial;
    }

    private void _setRecordCount(ReportData rd, int count) {
        boolean partial;
        boolean bl = partial = count > 0 ? this._overLimit(rd, count) : false;
        if (rd != null) {
            rd.setReportRecordCount(count, partial);
        }
        this.rcdCount = count;
        this.isPartial = partial;
    }

    private boolean _overLimit(ReportData rd, long rptCount) {
        long rptLimit = rd.getReportLimit();
        if (rptLimit > 0L && rptCount >= rptLimit) {
            Print.logInfo((String)("Partial report data (RecordCount): " + rptCount + " >= " + rptLimit), (Object[])new Object[0]);
            return true;
        }
        long selLimit = rd.getSelectionLimit();
        if (selLimit > 10L) {
            long selCount = rd.getMaximumEventDataCount();
            if (selLimit > 0L && selCount >= selLimit) {
                Print.logInfo((String)("Partial report data (maxSelectionCount): " + selCount + " >= " + selLimit), (Object[])new Object[0]);
                return true;
            }
        }
        return false;
    }

    public void writeHTML(PrintWriter out, int level, ReportData report) throws ReportException {
        DBDataIterator totals;
        this._setRecordCount(report, 0);
        out.print("<tbody>\n");
        DBDataIterator data = report.getBodyDataIterator();
        if (data != null && data.hasNext()) {
            int RC = 0;
            RC = 0;
            while (data.hasNext()) {
                DBDataRow dr = data.next();
                if (dr != null) {
                    this.bodyRow.writeHTML(out, level + 1, RC, false, dr);
                }
                ++RC;
            }
            this._setRecordCount(report, RC);
        }
        if ((totals = report.getTotalsDataIterator()) != null && totals.hasNext()) {
            int r = 0;
            while (totals.hasNext()) {
                DBDataRow dr = totals.next();
                if (dr != null) {
                    this.bodyRow.writeHTML(out, level + 1, r, true, dr);
                }
                ++r;
            }
        }
        out.print("</tbody>\n");
    }

    public void writeXML(PrintWriter out, int level, ReportData report) throws ReportException {
        DBDataIterator totals;
        boolean isSoapRequest = report.isSoapRequest();
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)(level * 3));
        this._setRecordCount(report, 0);
        out.print(PFX1);
        out.print(XMLTools.startTAG((boolean)isSoapRequest, (String)"ReportBody", (String)"", (boolean)false, (boolean)true));
        DBDataIterator data = report.getBodyDataIterator();
        if (data != null && data.hasNext()) {
            int RC = 0;
            RC = 0;
            while (data.hasNext()) {
                DBDataRow dr = data.next();
                if (dr != null) {
                    this.bodyRow.writeXML(out, level + 1, RC, false, dr);
                }
                ++RC;
            }
            this._setRecordCount(report, RC);
        }
        if ((totals = report.getTotalsDataIterator()) != null && totals.hasNext()) {
            int r = 0;
            while (totals.hasNext()) {
                DBDataRow dr = totals.next();
                if (dr != null) {
                    this.bodyRow.writeXML(out, level + 1, r, true, dr);
                }
                ++r;
            }
        }
        out.print(PFX1);
        out.print(XMLTools.endTAG((boolean)isSoapRequest, (String)"ReportBody", (boolean)true));
    }

    public void writeCSV(PrintWriter out, int level, ReportData report) throws ReportException {
        this._setRecordCount(report, 0);
        DBDataIterator data = report.getBodyDataIterator();
        if (data != null && data.hasNext()) {
            int RC = 0;
            RC = 0;
            while (data.hasNext()) {
                DBDataRow dr = data.next();
                if (dr != null) {
                    this.bodyRow.writeCSV(out, level + 1, RC, false, dr);
                }
                ++RC;
            }
            this._setRecordCount(report, RC);
        }
    }

    public void writeXLS(ReportSpreadsheet rptSS, int level, ReportData report) throws ReportException {
        DBDataIterator totals;
        this._setRecordCount(report, 0);
        DBDataIterator data = report.getBodyDataIterator();
        if (data != null && data.hasNext()) {
            int RC = 0;
            RC = 0;
            while (data.hasNext()) {
                DBDataRow dr = data.next();
                if (dr != null) {
                    if (this.debugXLS) {
                        Print.logInfo((String)("XLS: Writing Report Body Row #" + RC), (Object[])new Object[0]);
                    }
                    this.bodyRow.writeXLS(rptSS, level + 1, RC, dr);
                }
                ++RC;
            }
            this._setRecordCount(report, RC);
        }
        if ((totals = report.getTotalsDataIterator()) != null && totals.hasNext()) {
            int r = 0;
            while (totals.hasNext()) {
                DBDataRow dr = totals.next();
                if (dr != null) {
                    if (this.debugXLS) {
                        Print.logInfo((String)("XLS: Writing Report Total Row #" + r), (Object[])new Object[0]);
                    }
                    this.bodyRow.writeXLS(rptSS, level + 1, r, dr);
                }
                ++r;
            }
        }
    }

    public void writeCallback(OutputProvider out, int level, ReportData rd) throws ReportException {
        DBDataIterator totals;
        this._setRecordCount(rd, 0);
        ReportCallback rptCB = rd.getReportCallback();
        if (rptCB == null) {
            return;
        }
        DBDataIterator data = rd.getBodyDataIterator();
        if (data != null && data.hasNext()) {
            int RC = rptCB.reportBody(out, level + 1, data);
            this._setRecordCount(rd, RC);
        }
        if ((totals = rd.getTotalsDataIterator()) != null && totals.hasNext()) {
            rptCB.reportTotals(out, level + 1, totals);
        }
    }
}

