/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.presentation;

import java.io.PrintWriter;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportHeaderGroup;
import org.opengts.war.report.ReportSpreadsheet;
import org.opengts.war.report.presentation.HeaderColumnTemplate;
import org.opengts.war.report.presentation.ReportTable;

public class HeaderRowTemplate {
    public static final String STYLE_CLASS = "rptHdrRow";
    public static final String GROUP_ROW_CLASS = "rptGrpRow";
    public static final String GROUP_COL_CLASS = "rptGrpCol";
    private ReportTable reportTable = null;

    public HeaderRowTemplate(ReportTable rptTable) {
        this.reportTable = rptTable;
    }

    public void writeHTML(PrintWriter out, int level, ReportData report) throws ReportException {
        Object[] rptCols = report.getReportColumns();
        if (ListTools.isEmpty((Object[])rptCols)) {
            String rptName = report.getReportFactory().getReportName();
            throw new ReportException("No report columns defined: " + rptName);
        }
        DataRowTemplate rdp = report.getDataRowTemplate();
        Object[] rptHdrGrp = report.getReportHeaderGroups();
        if (!ListTools.isEmpty((Object[])rptHdrGrp)) {
            String pfx1 = StringTools.replicateString((String)" ", (int)(level * 3));
            out.print("<tr");
            out.print(" class=\"rptGrpRow\"");
            out.print(">\n");
            for (Object rhg : rptHdrGrp) {
                String title = report.expandHeaderText(((ReportHeaderGroup)rhg).getTitle(report.getLocale()));
                out.print(pfx1);
                out.print("<th");
                out.print(" class=\"rptGrpCol\"");
                out.print(" nowrap");
                out.print(" colSpan=\"" + ((ReportHeaderGroup)rhg).getColSpan() + "\"");
                out.print(">");
                out.print(ReportTable.FilterText(title));
                out.print("</th>\n");
            }
            out.print("</tr>\n");
        }
        out.print("<tr");
        out.print(" class=\"rptHdrRow\"");
        out.print(">\n");
        for (int i = 0; i < rptCols.length; ++i) {
            String colName = ((ReportColumn)rptCols[i]).getKey();
            DataColumnTemplate dct = rdp.getColumnTemplate(colName);
            if (dct != null) {
                HeaderColumnTemplate hct = this.reportTable.getHeaderColumnTemplate(dct);
                hct.writeHTML(out, level + 1, report, (ReportColumn)rptCols[i]);
                continue;
            }
            String rptName = report.getReportFactory().getReportName();
            if (StringTools.isBlank((String)colName)) {
                Print.logError((String)("Column name not found: " + rptName + ".#" + i), (Object[])new Object[0]);
                continue;
            }
            Print.logError((String)("Column name not found: " + rptName + "." + colName + " [#" + i + "]"), (Object[])new Object[0]);
        }
        out.print("</tr>\n");
    }

    public void writeXML(PrintWriter out, int level, ReportData report) throws ReportException {
        boolean isSoapRequest = report.isSoapRequest();
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)(level * 3));
        Object[] rptCols = report.getReportColumns();
        if (ListTools.isEmpty((Object[])rptCols)) {
            throw new ReportException("No report columns defined");
        }
        DataRowTemplate rdp = report.getDataRowTemplate();
        out.print(PFX1);
        out.print(XMLTools.startTAG((boolean)isSoapRequest, (String)"HeaderRow", (String)XMLTools.ATTR((String)"class", (String)STYLE_CLASS), (boolean)false, (boolean)true));
        for (int i = 0; i < rptCols.length; ++i) {
            String colName = ((ReportColumn)rptCols[i]).getKey();
            DataColumnTemplate dct = rdp.getColumnTemplate(colName);
            if (dct != null) {
                HeaderColumnTemplate hct = this.reportTable.getHeaderColumnTemplate(dct);
                hct.writeXML(out, level + 1, report, (ReportColumn)rptCols[i]);
                continue;
            }
            Print.logStackTrace((String)("Column name not found: " + ((ReportColumn)rptCols[i]).getKey()));
        }
        out.print(PFX1);
        out.print(XMLTools.endTAG((boolean)isSoapRequest, (String)"HeaderRow", (boolean)true));
    }

    public void writeXLS(ReportSpreadsheet rptSS, int level, ReportData report) throws ReportException {
        ReportColumn[] rptCols = report.getReportColumns();
        if (rptCols == null || rptCols.length == 0) {
            throw new ReportException("No report columns defined");
        }
        DataRowTemplate rdp = report.getDataRowTemplate();
        Object[] rptHdrGrp = report.getReportHeaderGroups();
        if (!ListTools.isEmpty((Object[])rptHdrGrp)) {
            for (Object rhg : rptHdrGrp) {
                String title = report.expandHeaderText(((ReportHeaderGroup)rhg).getTitle(report.getLocale()));
                rptSS.addHeaderColumn(((ReportHeaderGroup)rhg).getColSpan(), title, 25);
            }
            rptSS.incrementRowIndex();
        }
        for (int i = 0; i < rptCols.length; ++i) {
            String colName = rptCols[i].getKey();
            DataColumnTemplate dct = rdp.getColumnTemplate(colName);
            if (dct != null) {
                HeaderColumnTemplate hct = this.reportTable.getHeaderColumnTemplate(dct);
                hct.writeXLS(rptSS, level + 1, report, rptCols[i]);
                continue;
            }
            Print.logStackTrace((String)("Column name not found: " + rptCols[i].getKey()));
        }
        rptSS.incrementRowIndex();
    }
}

