/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.presentation;

import java.io.PrintWriter;
import java.util.Locale;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportSpreadsheet;
import org.opengts.war.report.presentation.ReportTable;

public class HeaderColumnTemplate {
    public static final String STYLE_CLASS_SORT = "rptHdrCol_sort";
    public static final String STYLE_CLASS_NOSORT = "rptHdrCol_nosort";
    private DataColumnTemplate dataColumn = null;
    private int rowSpan = 1;
    private int colSpan = 1;

    public HeaderColumnTemplate(DataColumnTemplate dtaCol) {
        this(dtaCol, 1, 1);
    }

    public HeaderColumnTemplate(DataColumnTemplate dtaCol, int rowSpan, int colSpan) {
        this.dataColumn = dtaCol;
        this.setRowSpan(rowSpan);
        this.setColSpan(colSpan);
    }

    public String getFieldName() {
        return this.dataColumn.getKeyName();
    }

    public String getTitle(ReportData report, ReportColumn column) {
        Locale locale = report.getLocale();
        String dftTitle = this.dataColumn.getTitle(report, column);
        String rptTitle = column != null ? column.getTitle(locale, dftTitle) : dftTitle;
        return report.expandHeaderText(rptTitle);
    }

    public HeaderColumnTemplate setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public boolean hasRowSpan() {
        return this.rowSpan > 1;
    }

    public HeaderColumnTemplate setColSpan(int colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public boolean hasColSpan() {
        return this.colSpan > 1;
    }

    public void writeHTML(PrintWriter out, int level, ReportData report, ReportColumn column) {
        String pfx1 = StringTools.replicateString((String)" ", (int)(level * 3));
        boolean colSortable = column != null && column.isSortable();
        out.print(pfx1);
        out.print("<th");
        out.print(" id=\"" + this.getFieldName() + "\"");
        out.print(" class=\"" + (colSortable ? STYLE_CLASS_SORT : STYLE_CLASS_NOSORT) + "\"");
        out.print(" nowrap");
        if (this.hasRowSpan()) {
            out.print(" rowSpan=\"" + this.getRowSpan() + "\"");
        }
        if (this.hasColSpan()) {
            out.print(" colSpan=\"" + this.getColSpan() + "\"");
        }
        out.print(">");
        String htmlTitle = ReportTable.FilterText(this.getTitle(report, column));
        out.print(htmlTitle);
        out.print("</th>\n");
    }

    public void writeXML(PrintWriter out, int level, ReportData report, ReportColumn column) {
        boolean isSoapRequest = report.isSoapRequest();
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)(level * 3));
        boolean colSortable = column != null && column.isSortable();
        out.print(PFX1);
        out.print(XMLTools.startTAG((boolean)isSoapRequest, (String)"HeaderColumn", (String)(XMLTools.ATTR((String)"id", (String)this.getFieldName()) + XMLTools.ATTR((String)"class", (String)(colSortable ? STYLE_CLASS_SORT : STYLE_CLASS_NOSORT)) + (this.hasRowSpan() ? XMLTools.ATTR((String)"rowspan", (int)this.getRowSpan()) : "") + (this.hasColSpan() ? XMLTools.ATTR((String)"colspan", (int)this.getColSpan()) : "")), (boolean)false, (boolean)false));
        out.print(ReportTable.XmlFilter(isSoapRequest, this.getTitle(report, column)));
        out.print(XMLTools.endTAG((boolean)isSoapRequest, (String)"HeaderColumn", (boolean)true));
    }

    public void writeXLS(ReportSpreadsheet rptSS, int level, ReportData report, ReportColumn column) {
        String colTitle = this.getTitle(report, column);
        rptSS.addHeaderColumn(colTitle, 20);
    }
}

