/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.presentation;

import java.io.PrintWriter;
import org.opengts.util.ListTools;
import org.opengts.util.XMLTools;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportSpreadsheet;
import org.opengts.war.report.presentation.BodyColumnTemplate;
import org.opengts.war.report.presentation.ReportTable;

public class BodyRowTemplate {
    private ReportTable reportTable = null;

    public BodyRowTemplate(ReportTable rptTable) {
        this.reportTable = rptTable;
    }

    public void writeHTML(PrintWriter out, int level, int rowIndex, boolean isTotal, DBDataRow dr) throws ReportException {
        String trCssClass;
        String tdCssClass = null;
        if (dr.hasCssClass()) {
            trCssClass = dr.getCssClass();
            tdCssClass = dr.getCssClass();
        } else {
            trCssClass = isTotal ? (rowIndex <= 0 ? "rptTotalRow" : "rptTotalRow2") : ((rowIndex & 1) == 0 ? "rptBodyRowOdd" : "rptBodyRowEven");
        }
        Object[] rptCols = dr.getReportColumns();
        if (ListTools.isEmpty((Object[])rptCols)) {
            throw new ReportException("No report columns defined");
        }
        out.print("<tr class=\"" + trCssClass + "\">\n");
        DataRowTemplate drt = dr.getDataRowTemplate();
        for (int i = 0; i < rptCols.length; ++i) {
            String colName = ((ReportColumn)rptCols[i]).getKey();
            int colSpan = ((ReportColumn)rptCols[i]).getColSpan();
            DataColumnTemplate dct = drt.getColumnTemplate(colName);
            if (dct == null) continue;
            BodyColumnTemplate bct = this.reportTable.getBodyColumnTemplate(dct);
            String fldName = bct.getFieldName();
            Object fldVal = dr.getDBValue(fldName, rowIndex, (ReportColumn)rptCols[i]);
            bct.writeHTML(out, level + 1, rowIndex, isTotal, tdCssClass, colSpan, fldVal);
        }
        out.print("</tr>\n");
    }

    public void writeXML(PrintWriter out, int level, int rowIndex, boolean isTotal, DBDataRow dr) throws ReportException {
        String trCssClass;
        ReportData rd = dr.getReportData();
        boolean isSoapRequest = rd != null ? rd.isSoapRequest() : false;
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)(level * 3));
        String tdCssClass = null;
        if (dr.hasCssClass()) {
            trCssClass = dr.getCssClass();
            tdCssClass = dr.getCssClass();
        } else {
            trCssClass = isTotal ? (rowIndex <= 0 ? "rptTotalRow" : "rptTotalRow2") : ((rowIndex & 1) == 0 ? "rptBodyRowOdd" : "rptBodyRowEven");
        }
        Object[] rptCols = dr.getReportColumns();
        if (ListTools.isEmpty((Object[])rptCols)) {
            throw new ReportException("No report columns defined");
        }
        out.print(PFX1);
        out.print(XMLTools.startTAG((boolean)isSoapRequest, (String)"BodyRow", (String)XMLTools.ATTR((String)"class", (String)trCssClass), (boolean)false, (boolean)true));
        DataRowTemplate drt = dr.getDataRowTemplate();
        for (int i = 0; i < rptCols.length; ++i) {
            String colName = ((ReportColumn)rptCols[i]).getKey();
            int colSpan = ((ReportColumn)rptCols[i]).getColSpan();
            DataColumnTemplate dct = drt.getColumnTemplate(colName);
            if (dct == null) continue;
            BodyColumnTemplate bct = this.reportTable.getBodyColumnTemplate(dct);
            String fldName = bct.getFieldName();
            Object fldVal = dr.getDBValue(fldName, rowIndex, (ReportColumn)rptCols[i]);
            bct.writeXML(out, level + 1, rowIndex, isTotal, tdCssClass, colSpan, fldVal, isSoapRequest);
        }
        out.print(PFX1);
        out.print(XMLTools.endTAG((boolean)isSoapRequest, (String)"BodyRow", (boolean)true));
    }

    public void writeCSV(PrintWriter out, int level, int rowIndex, boolean isTotal, DBDataRow dr) throws ReportException {
        DataRowTemplate drt = dr.getDataRowTemplate();
        ReportColumn[] rptCols = dr.getReportColumns();
        for (int i = 0; i < rptCols.length; ++i) {
            BodyColumnTemplate bct;
            String fldName;
            Object fldVal;
            String colName = rptCols[i].getKey();
            DataColumnTemplate dct = drt.getColumnTemplate(colName);
            if (dct == null) continue;
            if (i > 0) {
                out.print(",");
            }
            String valStr = (fldVal = dr.getDBValue(fldName = (bct = this.reportTable.getBodyColumnTemplate(dct)).getFieldName(), rowIndex, rptCols[i])) != null ? fldVal.toString() : "";
            bct.writeCSV(out, level + 1, valStr);
        }
        out.print("\n");
    }

    public void writeXLS(ReportSpreadsheet rptRSS, int level, int rowIndex, DBDataRow dr) throws ReportException {
        Object[] rptCols = dr.getReportColumns();
        if (ListTools.isEmpty((Object[])rptCols)) {
            throw new ReportException("No report columns defined");
        }
        DBDataRow.RowType rowType = dr.getRowType();
        DataRowTemplate drt = dr.getDataRowTemplate();
        for (int i = 0; i < rptCols.length; ++i) {
            String colName = ((ReportColumn)rptCols[i]).getKey();
            int colSpan = ((ReportColumn)rptCols[i]).getColSpan();
            DataColumnTemplate dct = drt.getColumnTemplate(colName);
            if (dct == null) continue;
            BodyColumnTemplate bct = this.reportTable.getBodyColumnTemplate(dct);
            String fldName = bct.getFieldName();
            Object fldVal = dr.getDBValue(fldName, rowIndex, (ReportColumn)rptCols[i]);
            bct.writeXLS(rptRSS, level + 1, rowType, fldVal);
        }
        rptRSS.incrementRowIndex();
    }
}

