/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.presentation;

import java.io.PrintWriter;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.opengts.war.report.ColumnValue;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.ReportSpreadsheet;
import org.opengts.war.report.presentation.ReportTable;

public class BodyColumnTemplate {
    public static final String BODY_COLUMN = "rptBodyCol";
    public static final String TOTAL_COLUMN = "rptTotalCol";
    public static final String TOTAL_COLUMN_2 = "rptTotalCol2";
    private String fieldName = "";

    public BodyColumnTemplate(String fieldName) {
        this.fieldName = fieldName != null ? fieldName : "";
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void writeHTML(PrintWriter out, int level, int rowIndex, boolean isTotal, String custCssClass, int colSpan, Object valObj) {
        ColumnValue cv = valObj instanceof ColumnValue ? (ColumnValue)valObj : null;
        String cssClass = null;
        cssClass = cv != null && cv.hasCssClass() ? cv.getCssClass() : (!StringTools.isBlank((String)custCssClass) ? custCssClass : (isTotal ? (rowIndex <= 0 ? TOTAL_COLUMN : TOTAL_COLUMN_2) : BODY_COLUMN));
        out.print(StringTools.replicateString((String)" ", (int)(level * 3)));
        out.print("<td");
        out.print(" id=\"" + this.getFieldName() + "\"");
        out.print(" class=\"" + cssClass + "\"");
        out.print(" nowrap");
        if (cv != null && cv.hasStyle()) {
            out.print(" style=\"");
            out.print(cv.getStyleString());
            out.print("\"");
        }
        if (cv != null && cv.hasSortKey()) {
            out.print(" sorttable_customkey=\"" + cv.getSortKey() + "\"");
        }
        if (colSpan > 1) {
            out.print(" colspan=\"" + colSpan + "\"");
        }
        out.print(">");
        String cellValue = null;
        if (cv != null && cv.hasImageURL()) {
            String imageURL = cv.getImageURL();
            cellValue = "<img src='" + imageURL + "'/>";
        } else {
            String strValue = valObj != null ? valObj.toString() : "";
            cellValue = ReportTable.FilterText(strValue != null ? strValue : "");
        }
        if (cv != null && cv.hasLinkURL()) {
            String linkURL = cv.getLinkURL();
            if (linkURL.startsWith("javascript:")) {
                out.print("<span class='spanLink' onclick=\"" + linkURL + "\">");
                out.print(cellValue);
                out.print("</span>");
            } else {
                out.print("<a href=\"" + linkURL + "\"");
                if (cv.hasLinkTarget()) {
                    out.print(" target=\"" + cv.getLinkTarget() + "\"");
                }
                out.print(" style=\"text-decoration: none;\">");
                out.print(cellValue);
                out.print("</a>");
            }
        } else {
            out.print(cellValue);
        }
        out.print("</td>\n");
    }

    public void writeXML(PrintWriter out, int level, int rowIndex, boolean isTotal, String custCssClass, int colSpan, Object valObj, boolean isSoapRequest) {
        String cellValue;
        ColumnValue cv = valObj instanceof ColumnValue ? (ColumnValue)valObj : null;
        String PFX1 = XMLTools.PREFIX((boolean)isSoapRequest, (int)(level * 3));
        String cssClass = null;
        cssClass = cv != null && cv.hasCssClass() ? cv.getCssClass() : (!StringTools.isBlank((String)custCssClass) ? custCssClass : (isTotal ? (rowIndex <= 0 ? TOTAL_COLUMN : TOTAL_COLUMN_2) : BODY_COLUMN));
        StringBuffer style = null;
        if (cv != null && cv.hasStyle()) {
            style = new StringBuffer();
            if (cv.hasForegroundColor()) {
                style.append("color:" + cv.getForegroundColor() + ";");
            }
            if (cv.hasBackgroundColor()) {
                style.append("background-color:" + cv.getBackgroundColor() + ";");
            }
            if (cv.hasTextDecoration()) {
                style.append("text-decoration:" + cv.getTextDecoration() + ";");
            }
            if (cv.hasFontStyle()) {
                style.append("font-style:" + cv.getFontStyle() + ";");
            }
            if (cv.hasFontWeight()) {
                style.append("font-weight:" + cv.getFontWeight() + ";");
            }
        }
        out.print(PFX1);
        out.print(XMLTools.startTAG((boolean)isSoapRequest, (String)"BodyColumn", (String)(XMLTools.ATTR((String)"id", (String)this.getFieldName()) + XMLTools.ATTR((String)"class", (String)cssClass) + (style != null && style.length() > 0 ? XMLTools.ATTR((String)"style", (Object)style) : "") + (colSpan > 1 ? XMLTools.ATTR((String)"colspan", (int)colSpan) : "")), (boolean)false, (boolean)false));
        String string = cellValue = valObj != null ? valObj.toString() : "";
        if (!StringTools.isBlank((String)cellValue)) {
            if (valObj instanceof Number || valObj instanceof Boolean) {
                out.print(cellValue);
            } else {
                out.print(ReportTable.XmlFilter(isSoapRequest, cellValue));
            }
        }
        out.print(XMLTools.endTAG((boolean)isSoapRequest, (String)"BodyColumn", (boolean)true));
    }

    public void writeCSV(PrintWriter out, int level, String value) {
        String csvValue = ReportTable.csvFilter(StringTools.trim((String)value));
        out.print(csvValue);
    }

    public void writeXLS(ReportSpreadsheet rptSS, int level, DBDataRow.RowType rowType, Object fldVal) {
        switch (rowType) {
            case DETAIL: {
                rptSS.addBodyColumn(fldVal);
                break;
            }
            case SUBTOTAL: {
                rptSS.addSubtotalColumn(fldVal);
                break;
            }
            case TOTAL: {
                rptSS.addTotalColumn(fldVal);
            }
        }
    }
}

