/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.field;

import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.EventDataProvider;
import org.opengts.db.StatusCodeProvider;
import org.opengts.db.StatusCodes;
import org.opengts.db.WorkHours;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.StatusCode;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class MotionReport
extends ReportData
implements DBRecordHandler<EventData> {
    private static final String PROP_alwaysReadAllEvents = "alwaysReadAllEvents";
    private static final String PROP_isFleetSummaryReport = "isFleetSummaryReport";
    private static final String PROP_showMapLink = "showMapLink";
    private static final String PROP_tripStartType = "tripStartType";
    private static final String PROP_minimumStoppedTime = "minimumStoppedTime";
    private static final String PROP_minimumSpeedKPH = "minimumSpeedKPH";
    private static final String PROP_stopOnIgnitionOff = "stopOnIgnitionOff";
    private static final String PROP_tabulateByWorkHours = "tabulateByWorkHours";
    private static final String PROP_WorkHours_ = "WorkHours.";
    private static final String[] MOTION_DEFAULT = new String[]{"default"};
    private static final String[] MOTION_SPEED = new String[]{"speed", "motion"};
    private static final String[] MOTION_IGNITION = new String[]{"ignition"};
    private static final String[] MOTION_ENGINE = new String[]{"engine"};
    private static final String[] MOTION_STARTSTOP = new String[]{"start", "startstop"};
    private static final int TRIP_ON_SPEED = 0;
    private static final int TRIP_ON_IGNITION = 1;
    private static final int TRIP_ON_ENGINE = 2;
    private static final int TRIP_ON_START = 3;
    private static final boolean SHOW_MAP_LINK = true;
    private static final double MIN_SPEED_KPH = 5.0;
    private static final long MIN_STOPPED_TIME_SEC = DateTime.MinuteSeconds((long)5L);
    private static final boolean STOP_ON_IGNITION_OFF = false;
    private static final boolean TABULATE_BY_WORK_HOURS = false;
    private static final boolean SPEED_RESET_STOP_TIME = false;
    private static final int STATE_UNKNOWN = 0;
    private static final int STATE_START = 1;
    private static final int STATE_STOP = 2;
    private int deviceCount = 0;
    private long deviceEventIndex = 0L;
    private boolean isFleetReport = false;
    private boolean alwaysReadAllEvents = false;
    private boolean showMapLink = true;
    private int tripStartType = 0;
    private boolean tripTypeDefault = true;
    private int[] ignitionCodes = null;
    private boolean isIgnitionOn = false;
    private EventData lastIgnitionEvent = null;
    private EventData idleStartEvent = null;
    private EventData idleStopEvent = null;
    private long idleAccumulator = 0L;
    private boolean isInMotion = false;
    private EventData lastMotionEvent = null;
    private EventData pendingStopEvent = null;
    private double minSpeedKPH = 5.0;
    private long minStoppedTimeSec = MIN_STOPPED_TIME_SEC;
    private boolean stopOnIgnitionOff = false;
    private boolean tabulateByWorkHours = false;
    private TimeZone timeZone = null;
    private WorkHours workHours = null;
    private double lastValidOdometerKM = 0.0;
    private int lastStateChange = 0;
    private long lastStartTime = 0L;
    private GeoPoint lastStartPoint = null;
    private String lastStartAddress = "";
    private double lastStartOdometer = 0.0;
    private double lastStartFuelUsed = 0.0;
    private double lastStartFuelLevel = 0.0;
    private double lastStartFuelRemain = 0.0;
    private long lastStopTime = 0L;
    private GeoPoint lastStopPoint = null;
    private String lastStopAddress = "";
    private double lastStopOdometer = 0.0;
    private double lastStopFuelUsed = 0.0;
    private double lastStopFuelLevel = 0.0;
    private double lastStopFuelRemain = 0.0;
    private List<FieldData> deviceDetailData = null;
    private List<FieldData> deviceTotalData = null;
    private List<FieldData> fleetTotalData = null;
    private double totalOdomKM = 0.0;
    private long totalDriveSec = 0L;
    private double totalDriveFuel = 0.0;
    private int totalStopCount = 0;
    private long totalStopSec = 0L;
    private long totalIdleSec = 0L;
    private double totalIdleFuel = 0.0;
    private double tworkOdomKM = 0.0;
    private long tworkDriveSec = 0L;
    private double tworkDriveFuel = 0.0;
    private int tworkStopCount = 0;
    private double tworkIdleFuel = 0.0;

    private static String TripTypeName(int type) {
        switch (type) {
            case 0: {
                return "Speed";
            }
            case 1: {
                return "Ignition";
            }
            case 2: {
                return "Engine";
            }
            case 3: {
                return "Start/Stop";
            }
        }
        return "Unknown";
    }

    public MotionReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        this.deviceCount = this.getDeviceCount();
        if (this.deviceCount < 1) {
            throw new ReportException("At least 1 Device must be specified");
        }
        this.timeZone = reqState.getTimeZone();
    }

    @Override
    public void postInitialize() {
        RTProperties rtp = this.getProperties();
        this.alwaysReadAllEvents = rtp.getBoolean(PROP_alwaysReadAllEvents, false);
        this.isFleetReport = this.deviceCount > 1 ? true : rtp.getBoolean(PROP_isFleetSummaryReport, false);
        this.showMapLink = rtp.getBoolean(PROP_showMapLink, true);
        this.minSpeedKPH = rtp.getDouble(PROP_minimumSpeedKPH, 5.0);
        this.minStoppedTimeSec = rtp.getLong(PROP_minimumStoppedTime, MIN_STOPPED_TIME_SEC);
        this.stopOnIgnitionOff = rtp.getBoolean(PROP_stopOnIgnitionOff, false);
        this.tabulateByWorkHours = rtp.getBoolean(PROP_tabulateByWorkHours, false);
        if (this.tabulateByWorkHours) {
            this.workHours = new WorkHours((RTConfig.PropertyGetter)this.getProperties(), PROP_WorkHours_);
        }
    }

    @Override
    protected EventData[] getEventData(Device device, DBRecordHandler<EventData> rcdHandler) {
        if (device == null) {
            return EventData.EMPTY_ARRAY;
        }
        ReportConstraints rc = this.getReportConstraints();
        if (this.alwaysReadAllEvents) {
            rc.setStatusCodes(null);
            rc.setValidGPSRequired(false);
        } else if (this.tripStartType == 3) {
            if (this.ignitionCodes != null) {
                rc.setStatusCodes(new int[]{61713, 61715, this.ignitionCodes[0], this.ignitionCodes[1]});
            } else {
                rc.setStatusCodes(new int[]{61713, 61715});
            }
            rc.setValidGPSRequired(false);
        } else if (this.tripStartType == 1) {
            rc.setStatusCodes(new int[]{this.ignitionCodes[0], this.ignitionCodes[1]});
            rc.setValidGPSRequired(false);
        } else if (this.tripStartType == 2) {
            if (this.ignitionCodes != null) {
                rc.setStatusCodes(new int[]{62477, 62476, this.ignitionCodes[0], this.ignitionCodes[1]});
            } else {
                rc.setStatusCodes(new int[]{62477, 62476});
            }
            rc.setValidGPSRequired(false);
        } else {
            rc.setStatusCodes(null);
            rc.setValidGPSRequired(this.ignitionCodes == null);
        }
        long rptLimit = rc.getReportLimit();
        if (rptLimit > 0L) {
            rc.setSelectionLimit(Math.max(rc.getSelectionLimit(), rptLimit * 4L));
        }
        return super.getEventData(device, rcdHandler);
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return this.showMapLink;
    }

    @Override
    public boolean getSupportsKmlDisplay() {
        return this.hasReportColumn("stopGeoPoint");
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return MotionReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        double grandTotalOdomKM = 0.0;
        long grandTotalDriveSec = 0L;
        double grandTotalDriveFuel = 0.0;
        int grandTotalStopCount = 0;
        long grandTotalStopSec = 0L;
        long grandTotalIdleSec = 0L;
        double grandTotalIdleFuel = 0.0;
        double gworkTotalOdomKM = 0.0;
        long gworkTotalDriveSec = 0L;
        double gafterTotalOdomKM = 0.0;
        long gafterTotalDriveSec = 0L;
        this.deviceTotalData = new Vector<FieldData>();
        Account account = this.getAccount();
        String accountID = account.getAccountID();
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            String devID = i.next();
            this.deviceDetailData = new Vector<FieldData>();
            this.totalOdomKM = 0.0;
            this.totalDriveSec = 0L;
            this.totalDriveFuel = 0.0;
            this.totalStopCount = 0;
            this.totalStopSec = 0L;
            this.totalIdleSec = 0L;
            this.totalIdleFuel = 0.0;
            this.tworkOdomKM = 0.0;
            this.tworkDriveSec = 0L;
            this.tworkDriveFuel = 0.0;
            this.tworkStopCount = 0;
            this.tworkIdleFuel = 0.0;
            this.isIgnitionOn = false;
            this.lastIgnitionEvent = null;
            this.ignitionCodes = null;
            this.idleStartEvent = null;
            this.idleStopEvent = null;
            this.idleAccumulator = 0L;
            this.isInMotion = false;
            this.lastMotionEvent = null;
            this.lastStartTime = 0L;
            this.lastStartPoint = null;
            this.lastStartAddress = "";
            this.lastStartOdometer = 0.0;
            this.lastStartFuelUsed = 0.0;
            this.lastStartFuelLevel = 0.0;
            this.lastStartFuelRemain = 0.0;
            this.lastStopTime = 0L;
            this.lastStopPoint = null;
            this.lastStopAddress = "";
            this.lastStopOdometer = 0.0;
            this.lastStopFuelUsed = 0.0;
            this.lastStopFuelLevel = 0.0;
            this.lastStopFuelRemain = 0.0;
            this.lastStateChange = 0;
            this.lastValidOdometerKM = 0.0;
            try {
                double fuelIdle;
                long idleElaps;
                long stopElaps;
                Device.FuelEconomyType driveEconType;
                double driveEcon;
                Device device = devList.getDevice(devID);
                if (device == null) continue;
                this.ignitionCodes = device.getIgnitionStatusCodes();
                boolean hasIgnition = this.ignitionCodes != null;
                RTProperties rtp = this.getProperties();
                String tt = rtp.getString(PROP_tripStartType, MOTION_SPEED[0]).toLowerCase();
                if (ListTools.contains((Object[])MOTION_DEFAULT, (Object)tt)) {
                    String devCode = device.getDeviceCode();
                    DCServerConfig dcs = DCServerFactory.getServerConfig((String)devCode);
                    if (dcs == null && StringTools.isBlank((String)devCode) && Account.IsDemoAccount((String)accountID) && (dcs = DCServerFactory.getServerConfig((String)"gtsdmtp")) == null) {
                        Print.logWarn((String)"Account 'demo' DCServerConfig not found: gtsdmtp", (Object[])new Object[0]);
                    }
                    this.tripStartType = dcs != null ? (dcs.getStartStopSupported(false) ? 3 : (hasIgnition ? 1 : 0)) : (hasIgnition ? 1 : 0);
                    this.tripTypeDefault = true;
                } else if (ListTools.contains((Object[])MOTION_STARTSTOP, (Object)tt)) {
                    this.tripStartType = 3;
                    this.tripTypeDefault = false;
                } else if (ListTools.contains((Object[])MOTION_IGNITION, (Object)tt)) {
                    this.tripStartType = 1;
                    this.tripTypeDefault = false;
                    if (!hasIgnition) {
                        this.ignitionCodes = new int[]{62467, 62465};
                        hasIgnition = true;
                    }
                } else if (ListTools.contains((Object[])MOTION_ENGINE, (Object)tt)) {
                    this.tripStartType = 2;
                    this.tripTypeDefault = false;
                } else {
                    this.tripStartType = 0;
                    this.tripTypeDefault = true;
                }
                if (RTConfig.isDebugMode()) {
                    Print.logDebug((String)("Trip Start Type: [" + this.tripStartType + "] " + MotionReport.TripTypeName(this.tripStartType)), (Object[])new Object[0]);
                    if (hasIgnition) {
                        String ignOff = StatusCodes.GetHex((int)this.ignitionCodes[0]);
                        String ignOn = StatusCodes.GetHex((int)this.ignitionCodes[1]);
                        Print.logDebug((String)("Device Ignition Codes " + ignOff + ":" + ignOn + " [" + accountID + "/" + devID + "]"), (Object[])new Object[0]);
                    } else {
                        Print.logDebug((String)("No defined Device ignition codes [" + accountID + "/" + devID + "]"), (Object[])new Object[0]);
                    }
                }
                this.deviceEventIndex = 0L;
                this.getEventData(device, this);
                if (this.lastStopTime > 0L) {
                    long driveTime = this.lastStartTime > 0L ? this.lastStopTime - this.lastStartTime : -1L;
                    double driveDist = this.lastStartTime > 0L ? this.lastStopOdometer - this.lastStartOdometer : -1.0;
                    double fuelTrip = this.lastStartTime > 0L ? this.lastStopFuelUsed - this.lastStartFuelUsed : -1.0;
                    driveEcon = fuelTrip > 0.0 ? driveDist / fuelTrip : 0.0;
                    driveEconType = Device.FuelEconomyType.FUEL_CONSUMED;
                    stopElaps = -1L;
                    idleElaps = this.idleAccumulator > 0L ? this.idleAccumulator : -1L;
                    fuelIdle = -1.0;
                    this._addRecord(accountID, devID, device, this.lastStartTime, this.lastStartPoint, this.lastStartAddress, this.lastStartOdometer, this.lastStartFuelUsed, this.lastStopTime, this.lastStopPoint, this.lastStopAddress, this.lastStopOdometer, this.lastStopFuelUsed, driveTime, driveDist, fuelTrip, driveEcon, driveEconType, stopElaps, idleElaps, fuelIdle);
                } else if (this.lastStartTime > 0L) {
                    long driveTime = -1L;
                    double driveDist = -1.0;
                    double fuelTrip = -1.0;
                    driveEcon = -1.0;
                    driveEconType = Device.FuelEconomyType.UNKNOWN;
                    stopElaps = -1L;
                    idleElaps = -1L;
                    fuelIdle = -1.0;
                    this._addRecord(accountID, devID, device, this.lastStartTime, this.lastStartPoint, this.lastStartAddress, this.lastStartOdometer, this.lastStartFuelUsed, -1L, null, "", -1.0, -1.0, driveTime, driveDist, fuelTrip, driveEcon, driveEconType, stopElaps, idleElaps, fuelIdle);
                }
                double driveEcon2 = this.totalDriveFuel > 0.0 ? this.totalOdomKM / this.totalDriveFuel : 0.0;
                Device.FuelEconomyType driveEconType2 = Device.FuelEconomyType.FUEL_CONSUMED;
                FieldData fd = new FieldData();
                fd.setRowType(DBDataRow.RowType.TOTAL);
                long idleElaps2 = this.totalIdleSec > 0L ? this.totalIdleSec : -1L;
                fd.setAccount(account);
                fd.setDevice(device);
                fd.setString("accountId", this.getAccountID());
                fd.setString("deviceId", devID);
                fd.setDouble("odomDelta", this.totalOdomKM);
                fd.setLong("drivingElapse", this.totalDriveSec);
                fd.setDouble("fuelTrip", this.totalDriveFuel);
                fd.setDouble("fuelEconomy", driveEcon2);
                fd.setValue("fuelEconomyType", driveEconType2);
                fd.setLong("stopCount", this.totalStopCount);
                fd.setLong("stopElapse", this.totalStopSec);
                fd.setLong("idleElapse", idleElaps2);
                fd.setDouble("fuelIdle", this.totalIdleFuel);
                fd.setLong("drivingElapseWH", this.tworkDriveSec);
                fd.setDouble("odomDeltaWH", this.tworkOdomKM);
                fd.setDouble("fuelTripWH", this.tworkDriveFuel);
                fd.setDouble("fuelIdleWH", this.tworkIdleFuel);
                fd.setLong("stopCountWH", this.tworkStopCount);
                fd.setLong("drivingElapseAH", this.totalDriveSec - this.tworkDriveSec);
                fd.setDouble("odomDeltaAH", this.totalOdomKM - this.tworkOdomKM);
                this.deviceTotalData.add(fd);
                grandTotalOdomKM += this.totalOdomKM;
                grandTotalDriveSec += this.totalDriveSec;
                grandTotalDriveFuel += this.totalDriveFuel;
                grandTotalStopCount += this.totalStopCount;
                grandTotalStopSec += this.totalStopSec;
                grandTotalIdleSec += this.totalIdleSec;
                grandTotalIdleFuel += this.totalIdleFuel;
                gworkTotalOdomKM += this.tworkOdomKM;
                gworkTotalDriveSec += this.tworkDriveSec;
                gafterTotalOdomKM += this.totalOdomKM - this.tworkOdomKM;
                gafterTotalDriveSec += this.totalDriveSec - this.tworkDriveSec;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData for Device: " + devID), (Object[])new Object[0]);
            }
        }
        if (this.isFleetReport) {
            double avgEcon = grandTotalDriveFuel > 0.0 ? grandTotalOdomKM / grandTotalDriveFuel : 0.0;
            FieldData fd = new FieldData();
            fd.setRowType(DBDataRow.RowType.TOTAL);
            fd.setAccount(account);
            fd.setString("accountId", this.getAccountID());
            fd.setDouble("odomDelta", grandTotalOdomKM);
            fd.setLong("drivingElapse", grandTotalDriveSec);
            fd.setDouble("fuelTrip", grandTotalDriveFuel);
            fd.setLong("stopCount", grandTotalStopCount);
            fd.setLong("stopElapse", grandTotalStopSec);
            fd.setLong("idleElapse", grandTotalIdleSec);
            fd.setDouble("fuelIdle", grandTotalIdleFuel);
            fd.setDouble("odomDeltaWH", gworkTotalOdomKM);
            fd.setLong("drivingElapseWH", gworkTotalDriveSec);
            fd.setDouble("odomDeltaAH", gafterTotalOdomKM);
            fd.setLong("drivingElapseAH", gafterTotalDriveSec);
            this.fleetTotalData = new Vector<FieldData>();
            this.fleetTotalData.add(fd);
            return new ReportData.ListDataIterator(this.deviceTotalData);
        }
        return new ReportData.ListDataIterator(this.deviceDetailData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        if (this.isFleetReport) {
            if (this.fleetTotalData != null) {
                return new ReportData.ListDataIterator(this.fleetTotalData);
            }
            return null;
        }
        return new ReportData.ListDataIterator(this.deviceTotalData);
    }

    private void _addRecord(String acctID, String devID, Device device, long startTime, GeoPoint startGP, String startAddress, double startOdom, double startFuel, long stopTime, GeoPoint stopGP, String stopAddress, double stopOdom, double stopFuel, long driveTime, double driveDist, double fuelTrip, double driveEcon, Device.FuelEconomyType driveEconType, long stopElapse, long idleElapse, double fuelIdle) {
        MotionFieldData fd = new MotionFieldData();
        fd.setString("accountId", acctID);
        fd.setString("deviceId", devID);
        fd.setGeoPoint("geoPoint", startGP);
        fd.setString("address", startAddress);
        fd.setLong("startTimestamp", startTime);
        fd.setLong("drivingElapse", driveTime);
        fd.setDouble("odometer", startOdom);
        fd.setDouble("odomDelta", driveDist);
        fd.setLong("stopTimestamp", stopTime);
        fd.setGeoPoint("stopGeoPoint", stopGP);
        fd.setString("stopAddress", stopAddress);
        fd.setDouble("stopOdometer", stopOdom);
        fd.setDouble("fuelTotal", startFuel);
        fd.setDouble("fuelTrip", fuelTrip);
        fd.setDouble("fuelEconomy", driveEcon);
        fd.setValue("fuelEconomyType", driveEconType);
        fd.setLong("stopElapse", stopElapse);
        fd.setLong("idleElapse", idleElapse);
        fd.setDouble("fuelIdle", fuelIdle);
        boolean whStart = false;
        boolean whStop = false;
        long whDriveTime = 0L;
        double whDriveDist = 0.0;
        double whFuelTrip = 0.0;
        double whFuelIdle = 0.0;
        if (this.tabulateByWorkHours && this.workHours != null) {
            WorkHours WH = device != null ? device.getWorkHours(this.workHours) : this.workHours;
            whStart = startTime > 0L ? WH.isMatch(startTime, this.timeZone) : false;
            boolean bl = whStop = stopTime > 0L ? WH.isMatch(stopTime, this.timeZone) : false;
            if (startTime > 0L || stopTime > 0L) {
                if (startTime <= 0L && stopTime > 0L) {
                    boolean stopWH = WH.isMatch(stopTime, this.timeZone);
                    if (stopWH) {
                        whDriveTime = driveTime;
                        whDriveDist = driveDist;
                        whFuelTrip = fuelTrip;
                        whFuelIdle = fuelIdle;
                    }
                } else if (startTime > 0L && stopTime <= 0L) {
                    boolean startWH = WH.isMatch(startTime, this.timeZone);
                    if (startWH) {
                        whDriveTime = driveTime;
                        whDriveDist = driveDist;
                        whFuelTrip = fuelTrip;
                        whFuelIdle = fuelIdle;
                    }
                } else if (startTime < stopTime) {
                    double totalHR = (double)(stopTime - startTime) / 3600.0;
                    DateTime startDT = new DateTime(startTime, this.timeZone);
                    DateTime stopDT = new DateTime(stopTime, this.timeZone);
                    double accumHR = WH.countWorkHours(startDT, stopDT, this.timeZone);
                    if (accumHR > 0.0) {
                        double fracHR = accumHR / totalHR;
                        if (fracHR > 1.0) {
                            whDriveTime = driveTime;
                            whDriveDist = driveDist;
                            whFuelTrip = fuelTrip;
                            whFuelIdle = fuelIdle;
                        } else {
                            whDriveTime = (long)(fracHR * (double)driveTime);
                            whDriveDist = fracHR * driveDist;
                            whFuelTrip = fracHR * fuelTrip;
                            whFuelIdle = fracHR * fuelIdle;
                        }
                    }
                }
            }
        }
        fd.setLong("drivingElapseWH", whDriveTime);
        fd.setDouble("odomDeltaWH", whDriveDist);
        fd.setDouble("fuelTripWH", whFuelTrip);
        fd.setDouble("fuelIdleWH", whFuelIdle);
        fd.setLong("drivingElapseAH", driveTime - whDriveTime);
        fd.setDouble("odomDeltaAH", driveDist - whDriveDist);
        fd.setDouble("fuelTripAH", fuelTrip - whFuelTrip);
        fd.setDouble("fuelIdleAH", fuelIdle - whFuelIdle);
        this.deviceDetailData.add(fd);
        if (driveTime > 0L) {
            this.totalDriveSec += driveTime;
        }
        if (driveDist > 0.0) {
            this.totalOdomKM += driveDist;
        }
        if (fuelTrip > 0.0) {
            this.totalDriveFuel += fuelTrip;
        }
        if (stopTime > 0L) {
            ++this.totalStopCount;
        }
        if (stopElapse > 0L) {
            this.totalStopSec += stopElapse;
        }
        if (idleElapse > 0L) {
            this.totalIdleSec += idleElapse;
        }
        if (fuelIdle > 0.0) {
            this.totalIdleFuel += fuelIdle;
        }
        if (whDriveTime > 0L) {
            this.tworkDriveSec += whDriveTime;
        }
        if (whDriveDist > 0.0) {
            this.tworkOdomKM += whDriveDist;
        }
        if (whFuelTrip > 0.0) {
            this.tworkDriveFuel += whFuelTrip;
        }
        if (whStop) {
            ++this.tworkStopCount;
        }
        if (whFuelIdle > 0.0) {
            this.tworkIdleFuel += whFuelIdle;
        }
    }

    public int handleDBRecord(EventData rcd) throws DBException {
        EventData evRcd = rcd;
        Device device = evRcd.getDevice();
        int statusCode = evRcd.getStatusCode();
        ++this.deviceEventIndex;
        boolean ignitionChange = false;
        if (this.tripStartType != 1 && this.ignitionCodes != null) {
            if (this.isIgnitionOff(statusCode)) {
                if (this.lastIgnitionEvent == null || this.isIgnitionOn) {
                    ignitionChange = true;
                    this.isIgnitionOn = false;
                    this.lastIgnitionEvent = evRcd;
                }
            } else if (this.isIgnitionOn(statusCode) && (this.lastIgnitionEvent == null || !this.isIgnitionOn)) {
                ignitionChange = true;
                this.isIgnitionOn = true;
                this.lastIgnitionEvent = evRcd;
            }
        }
        boolean isMotionStart = false;
        boolean isMotionStop = false;
        boolean isIdleStart = false;
        boolean isIdleStop = false;
        if (this.tripStartType == 1) {
            if (this.isIgnitionOn(statusCode)) {
                if (this.lastIgnitionEvent == null || !this.isIgnitionOn) {
                    ignitionChange = true;
                    this.isIgnitionOn = true;
                    this.lastIgnitionEvent = evRcd;
                    isMotionStart = true;
                    this.isInMotion = true;
                    this.lastMotionEvent = evRcd;
                    this.idleStopEvent = null;
                }
            } else if (this.isIgnitionOff(statusCode) && (this.lastIgnitionEvent == null || this.isIgnitionOn)) {
                ignitionChange = true;
                this.isIgnitionOn = false;
                this.lastIgnitionEvent = evRcd;
                isMotionStop = true;
                this.isInMotion = false;
                this.lastMotionEvent = evRcd;
                this.idleStartEvent = null;
            }
        } else if (this.tripStartType == 2) {
            if (this.isEngineStart(statusCode)) {
                if (!this.isInMotion) {
                    isMotionStart = true;
                    this.isInMotion = true;
                    this.lastMotionEvent = evRcd;
                    if (!this.isIgnitionOn) {
                        this.isIgnitionOn = true;
                        this.lastIgnitionEvent = evRcd;
                    }
                    isIdleStop = true;
                    this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
                }
            } else if (this.isEngineStop(statusCode)) {
                if (this.isInMotion) {
                    isMotionStop = true;
                    this.isInMotion = false;
                    this.lastMotionEvent = evRcd;
                    if (this.isIgnitionOn && this.ignitionCodes == null) {
                        this.isIgnitionOn = false;
                        this.lastIgnitionEvent = evRcd;
                    }
                    isIdleStart = true;
                    this.idleStartEvent = this.ignitionCodes != null ? evRcd : null;
                }
            } else if (this.isIgnitionOff(statusCode) && this.stopOnIgnitionOff) {
                if (this.isInMotion) {
                    isMotionStop = true;
                    this.isInMotion = false;
                    this.lastMotionEvent = evRcd;
                }
                isIdleStop = true;
                this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
            } else if (!this.isInMotion) {
                if (this.isIgnitionOn(statusCode)) {
                    isIdleStart = true;
                    this.idleStartEvent = this.ignitionCodes != null ? evRcd : null;
                } else if (this.isIgnitionOff(statusCode)) {
                    isIdleStop = true;
                    this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
                }
            }
        } else if (this.tripStartType == 3) {
            if (this.isMotionStart(statusCode)) {
                if (!this.isInMotion) {
                    isMotionStart = true;
                    this.isInMotion = true;
                    this.lastMotionEvent = evRcd;
                    if (!this.isIgnitionOn) {
                        this.isIgnitionOn = true;
                        this.lastIgnitionEvent = evRcd;
                    }
                    isIdleStop = true;
                    this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
                }
            } else if (this.isMotionStop(statusCode)) {
                if (this.isInMotion) {
                    isMotionStop = true;
                    this.isInMotion = false;
                    this.lastMotionEvent = evRcd;
                    if (this.isIgnitionOn && this.ignitionCodes == null) {
                        this.isIgnitionOn = false;
                        this.lastIgnitionEvent = evRcd;
                    }
                    isIdleStart = true;
                    this.idleStartEvent = this.ignitionCodes != null ? evRcd : null;
                }
            } else if (this.isIgnitionOff(statusCode) && this.stopOnIgnitionOff) {
                if (this.isInMotion) {
                    isMotionStop = true;
                    this.isInMotion = false;
                    this.lastMotionEvent = evRcd;
                }
                isIdleStop = true;
                this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
            } else if (!this.isInMotion) {
                if (this.isIgnitionOn(statusCode)) {
                    isIdleStart = true;
                    this.idleStartEvent = this.ignitionCodes != null ? evRcd : null;
                } else if (this.isIgnitionOff(statusCode)) {
                    isIdleStop = true;
                    this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
                }
            }
        } else if (this.tripStartType == 0) {
            if (evRcd.getSpeedKPH() >= this.minSpeedKPH) {
                this.pendingStopEvent = null;
                if (!this.isInMotion) {
                    isMotionStart = true;
                    this.isInMotion = true;
                    this.lastMotionEvent = evRcd;
                    if (!this.isIgnitionOn) {
                        this.isIgnitionOn = true;
                        this.lastIgnitionEvent = evRcd;
                    }
                    isIdleStop = true;
                    this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
                } else if (ignitionChange) {
                    // empty if block
                }
            } else if (this.isInMotion) {
                if (this.minStoppedTimeSec <= 0L) {
                    isMotionStop = true;
                    this.isInMotion = false;
                    this.lastMotionEvent = evRcd;
                    this.pendingStopEvent = null;
                    isIdleStart = true;
                    this.idleStartEvent = this.ignitionCodes != null ? evRcd : null;
                } else if (ignitionChange && !this.isIgnitionOn && this.stopOnIgnitionOff) {
                    isMotionStop = true;
                    this.isInMotion = false;
                    this.lastMotionEvent = this.pendingStopEvent != null ? this.pendingStopEvent : evRcd;
                    this.pendingStopEvent = null;
                    isIdleStop = true;
                    this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
                } else if (this.pendingStopEvent == null) {
                    this.pendingStopEvent = evRcd;
                } else {
                    long deltaTimeSec = evRcd.getTimestamp() - this.pendingStopEvent.getTimestamp();
                    if (deltaTimeSec >= this.minStoppedTimeSec) {
                        isMotionStop = true;
                        this.isInMotion = false;
                        this.lastMotionEvent = this.pendingStopEvent;
                        this.pendingStopEvent = null;
                        isIdleStart = true;
                        this.idleStartEvent = this.ignitionCodes != null ? evRcd : null;
                    }
                }
            } else if (this.isIgnitionOn(statusCode)) {
                isIdleStart = true;
                this.idleStartEvent = this.ignitionCodes != null ? evRcd : null;
            } else if (this.isIgnitionOff(statusCode)) {
                isIdleStop = true;
                Object object = this.idleStopEvent = this.ignitionCodes != null ? evRcd : null;
            }
        }
        if (this.ignitionCodes != null && !isIdleStart && isIdleStop) {
            if (this.idleStartEvent != null) {
                long idleTime = this.idleStopEvent.getTimestamp() - this.idleStartEvent.getTimestamp();
                this.idleAccumulator += idleTime;
            }
            this.idleStartEvent = null;
            this.idleStopEvent = null;
        }
        if (isMotionStart) {
            EventData ev = this.lastMotionEvent;
            if (this.lastStateChange == 1) {
                long stopTime = ev.getTimestamp();
                GeoPoint stopPoint = ev.getGeoPoint();
                String stopAddr = ev.getAddress();
                double stopOdom = ev.getOdometerKM();
                if (!(stopOdom <= 0.0) || !((stopOdom = ev.getDistanceKM()) <= 0.0) || (stopOdom = this.lastValidOdometerKM) <= 0.0) {
                    // empty if block
                }
                double stopFuel = ev.getFieldValue("fuelTotal", 0.0);
                long driveTime = this.lastStartTime > 0L ? stopTime - this.lastStartTime : 0L;
                double driveDist = this.lastStartTime > 0L ? stopOdom - this.lastStartOdometer : 0.0;
                double fuelTrip = this.lastStartTime > 0L ? stopFuel - this.lastStartFuelUsed : 0.0;
                double driveEcon = fuelTrip > 0.0 ? driveDist / fuelTrip : -1.0;
                Device.FuelEconomyType driveEconType = Device.FuelEconomyType.FUEL_CONSUMED;
                long stopElaps = 0L;
                long idleElaps = 0L;
                double fuelIdle = -1.0;
                this._addRecord(ev.getAccountID(), ev.getDeviceID(), device, this.lastStartTime, this.lastStartPoint, this.lastStartAddress, this.lastStartOdometer, this.lastStartFuelUsed, stopTime, stopPoint, stopAddr, stopOdom, stopFuel, driveTime, driveDist, fuelTrip, driveEcon, driveEconType, stopElaps, idleElaps, fuelIdle);
            } else if (this.lastStopTime > 0L) {
                long driveTime = this.lastStartTime > 0L ? this.lastStopTime - this.lastStartTime : 0L;
                double driveDist = this.lastStartTime > 0L ? this.lastStopOdometer - this.lastStartOdometer : -1.0;
                double fuelTrip = this.lastStartTime > 0L ? this.lastStopFuelUsed - this.lastStartFuelUsed : -1.0;
                double driveEcon = fuelTrip > 0.0 ? driveDist / fuelTrip : 0.0;
                Device.FuelEconomyType driveEconType = Device.FuelEconomyType.FUEL_CONSUMED;
                long stopElaps = ev.getTimestamp() - this.lastStopTime;
                long idleElaps = this.idleAccumulator > 0L ? this.idleAccumulator : -1L;
                double fuelIdle = -1.0;
                this._addRecord(ev.getAccountID(), ev.getDeviceID(), device, this.lastStartTime, this.lastStartPoint, this.lastStartAddress, this.lastStartOdometer, this.lastStartFuelUsed, this.lastStopTime, this.lastStopPoint, this.lastStopAddress, this.lastStopOdometer, this.lastStopFuelUsed, driveTime, driveDist, fuelTrip, driveEcon, driveEconType, stopElaps, idleElaps, fuelIdle);
            }
            this.lastStartTime = ev.getTimestamp();
            this.lastStartPoint = ev.getGeoPoint();
            this.lastStartAddress = ev.getAddress();
            this.lastStartOdometer = ev.getOdometerKM();
            if (this.lastStartOdometer <= 0.0) {
                this.lastStartOdometer = ev.getDistanceKM();
                if (this.lastStartOdometer <= 0.0) {
                    this.lastStartOdometer = this.lastValidOdometerKM;
                    if (this.lastStartOdometer <= 0.0) {
                        // empty if block
                    }
                }
            }
            this.lastStartFuelUsed = ev.getFieldValue("fuelTotal", 0.0);
            this.lastStartFuelLevel = ev.getFieldValue("fuelLevel", 0.0);
            this.lastStartFuelRemain = ev.getFieldValue("fuelRemain", 0.0);
            this.lastStopTime = 0L;
            this.lastStopPoint = null;
            this.lastStopAddress = null;
            this.lastStopOdometer = 0.0;
            this.lastStopFuelUsed = 0.0;
            this.lastStopFuelLevel = 0.0;
            this.lastStopFuelRemain = 0.0;
            this.lastStateChange = 1;
            this.idleAccumulator = 0L;
        } else if (isMotionStop) {
            EventData ev = this.lastMotionEvent;
            if (this.lastStateChange == 2 && this.lastStopTime > 0L && this.lastIgnitionEvent != null && this.lastIgnitionEvent.getTimestamp() > this.lastStopTime) {
                long startTime = this.lastIgnitionEvent.getTimestamp();
                GeoPoint startPoint = this.lastIgnitionEvent.getGeoPoint();
                String startAddr = this.lastIgnitionEvent.getAddress();
                double startOdom = this.lastIgnitionEvent.getOdometerKM();
                if (!(startOdom <= 0.0) || !((startOdom = this.lastIgnitionEvent.getDistanceKM()) <= 0.0) || (startOdom = this.lastValidOdometerKM) <= 0.0) {
                    // empty if block
                }
                double startFuel = this.lastIgnitionEvent.getFieldValue("fuelTotal", 0.0);
                long driveTime = this.lastStopTime - startTime;
                double driveDist = this.lastStopOdometer - startOdom;
                double fuelTrip = this.lastStopFuelUsed - startFuel;
                double driveEcon = fuelTrip > 0.0 ? driveDist / fuelTrip : 0.0;
                Device.FuelEconomyType driveEconType = Device.FuelEconomyType.FUEL_CONSUMED;
                long stopElaps = this.lastIgnitionEvent.getTimestamp() - this.lastStopTime;
                long idleElaps = this.idleAccumulator > 0L ? this.idleAccumulator : -1L;
                double fuelIdle = -1.0;
                this._addRecord(ev.getAccountID(), ev.getDeviceID(), device, startTime, startPoint, startAddr, startOdom, startFuel, this.lastStopTime, this.lastStopPoint, this.lastStopAddress, this.lastStopOdometer, this.lastStopFuelUsed, driveTime, driveDist, fuelTrip, driveEcon, driveEconType, stopElaps, idleElaps, fuelIdle);
                this.isIgnitionOn = true;
            }
            this.lastStopTime = ev.getTimestamp();
            this.lastStopPoint = ev.getGeoPoint();
            this.lastStopAddress = ev.getAddress();
            this.lastStopOdometer = ev.getOdometerKM();
            if (this.lastStopOdometer <= 0.0) {
                this.lastStopOdometer = ev.getDistanceKM();
                if (this.lastStopOdometer <= 0.0) {
                    this.lastStopOdometer = this.lastValidOdometerKM;
                    if (this.lastStopOdometer <= 0.0) {
                        // empty if block
                    }
                }
            }
            this.lastStopFuelUsed = ev.getFieldValue("fuelTotal", 0.0);
            this.lastStopFuelLevel = ev.getFieldValue("fuelLevel", 0.0);
            this.lastStopFuelRemain = ev.getFieldValue("fuelRemain", 0.0);
            this.lastStateChange = 2;
            this.idleAccumulator = 0L;
        }
        double thisEventOdomKM = evRcd.getOdometerKM();
        if (thisEventOdomKM > 0.0) {
            this.lastValidOdometerKM = thisEventOdomKM;
        } else {
            thisEventOdomKM = evRcd.getDistanceKM();
            if (thisEventOdomKM > 0.0) {
                this.lastValidOdometerKM = thisEventOdomKM;
            }
        }
        return (long)this.deviceDetailData.size() < this.getReportLimit() ? 1 : 0;
    }

    private boolean isIgnitionOn(int statusCode) {
        if (this.ignitionCodes != null) {
            return statusCode == this.ignitionCodes[1];
        }
        return false;
    }

    private boolean isIgnitionOff(int statusCode) {
        if (this.ignitionCodes != null) {
            return statusCode == this.ignitionCodes[0];
        }
        return false;
    }

    private boolean isEngineStart(int statusCode) {
        return statusCode == 62476;
    }

    private boolean isEngineStop(int statusCode) {
        return statusCode == 62477;
    }

    private boolean isMotionStart(int statusCode) {
        return statusCode == 61713;
    }

    private boolean isMotionStop(int statusCode) {
        return statusCode == 61715;
    }

    private static class MotionFieldData
    extends FieldData
    implements EventDataProvider {
        @Override
        public String getAccountID() {
            return super.getString("accountId", "");
        }

        @Override
        public String getDeviceID() {
            return super.getDeviceID();
        }

        @Override
        public String getDeviceDescription() {
            return super.getDeviceDescription();
        }

        @Override
        public String getDeviceVIN() {
            return super.getDeviceVIN();
        }

        public long getTimestamp() {
            return super.getLong("stopTimestamp", 0L);
        }

        public int getStatusCode() {
            return 61715;
        }

        public String getStatusCodeDescription(BasicPrivateLabel bpl) {
            Device dev = null;
            int code = this.getStatusCode();
            return StatusCode.getDescription(dev, (int)code, (BasicPrivateLabel)bpl, (String)"Stop");
        }

        public StatusCodeProvider getStatusCodeProvider(BasicPrivateLabel bpl) {
            Device dev = null;
            int code = this.getStatusCode();
            return StatusCode.getStatusCodeProvider(dev, (int)code, (BasicPrivateLabel)bpl, null);
        }

        public int getPushpinIconIndex(String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, BasicPrivateLabel bpl) {
            return 2;
        }

        public boolean isValidGeoPoint() {
            return GeoPoint.isValid((double)this.getLatitude(), (double)this.getLongitude());
        }

        public double getLatitude() {
            GeoPoint gp = super.getGeoPoint("stopGeoPoint", null);
            return gp != null ? gp.getLatitude() : 0.0;
        }

        public double getLongitude() {
            GeoPoint gp = super.getGeoPoint("stopGeoPoint", null);
            return gp != null ? gp.getLongitude() : 0.0;
        }

        public GeoPoint getGeoPoint() {
            return new GeoPoint(this.getLatitude(), this.getLongitude());
        }

        public long getGpsAge() {
            return 0L;
        }

        public long getCreationAge() {
            return 0L;
        }

        public double getHorzAccuracy() {
            return -1.0;
        }

        public GeoPoint getBestGeoPoint() {
            return this.getGeoPoint();
        }

        public double getBestAccuracy() {
            return this.getHorzAccuracy();
        }

        public int getSatelliteCount() {
            return 0;
        }

        public double getBatteryLevel() {
            return 0.0;
        }

        public double getSpeedKPH() {
            return 0.0;
        }

        public double getHeading() {
            return 0.0;
        }

        public double getAltitude() {
            return 0.0;
        }

        public double getOdometerKM() {
            return 0.0;
        }

        public String getGeozoneID() {
            return "";
        }

        public String getAddress() {
            return super.getString("stopAddress", "");
        }

        public long getInputMask() {
            return 0L;
        }

        public void setEventIndex(int ndx) {
            super.setInt("eventIndex", ndx);
        }

        public int getEventIndex() {
            return super.getInt("eventIndex", -1);
        }

        public boolean getIsFirstEvent() {
            return this.getEventIndex() == 0;
        }

        public void setIsLastEvent(boolean isLast) {
            super.setBoolean("lastEvent", isLast);
        }

        public boolean getIsLastEvent() {
            return super.getBoolean("lastEvent", false);
        }
    }
}

