/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.field;

import java.util.Locale;
import java.util.TimeZone;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.EntityManager;
import org.opengts.db.StatusCodeProvider;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.StatusCode;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtypes.DTIPAddress;
import org.opengts.dbtypes.DTOBDFault;
import org.opengts.util.ColorTools;
import org.opengts.util.DateTime;
import org.opengts.util.DayNumber;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.war.report.ColumnValue;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.PushpinIcon;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPageAdaptor;

public class FieldLayout
extends ReportLayout {
    private static final long MIN_REASONABLE_TIMESTAMP = new DateTime(null, 2000, 1, 1).getTimeSec();
    public static final String DATA_INDEX = "index";
    public static final String DATA_DISPLAY_NAME = "displayName";
    public static final String DATA_ACCOUNT_ID = "accountId";
    public static final String DATA_ACCOUNT_DESC = "accountDesc";
    public static final String DATA_USER_ID = "userId";
    public static final String DATA_USER_DESC = "userDesc";
    public static final String DATA_DEVICE_ID = "deviceId";
    public static final String DATA_DEVICE_DESC = "deviceDesc";
    public static final String DATA_DEVICE_BATTERY = "deviceBattery";
    public static final String DATA_VEHICLE_ID = "vehicleId";
    public static final String DATA_LICENSE_PLATE = "licensePlate";
    public static final String DATA_EQUIPMENT_TYPE = "equipmentType";
    public static final String DATA_UNIQUE_ID = "uniqueId";
    public static final String DATA_GROUP_ID = "groupId";
    public static final String DATA_STATUS_CODE = "statusCode";
    public static final String DATA_STATUS_DESC = "statusDesc";
    public static final String DATA_STATUS_COUNT = "statusCount";
    public static final String DATA_PUSHPIN = "pushpin";
    public static final String DATA_ENTITY_ID = "entityId";
    public static final String DATA_ENTITY_TYPE = "entityType";
    public static final String DATA_ENTITY_DESC = "entityDesc";
    public static final String DATA_DRIVER_ID = "driverId";
    public static final String DATA_DRIVER_DESC = "driverDesc";
    public static final String DATA_DRIVER_NICKNAME = "driverNickname";
    public static final String DATA_DRIVER_STATUS = "driverStatus";
    public static final String DATA_DRIVER_BADGEID = "driverBadge";
    public static final String DATA_DRIVER_LICENSE = "driverLicense";
    public static final String DATA_DRIVER_LICENSE_TYPE = "driverLicenseType";
    public static final String DATA_DRIVER_LICENSE_EXP = "driverLicenseExp";
    public static final String DATA_DRIVER_BIRTHDATE = "driverBirthdate";
    public static final String DATA_DRIVER_DEVICE_ID = "driverDeviceID";
    public static final String DATA_DRIVER_DEVICE_DESC = "driverDeviceDesc";
    public static final String DATA_LATITUDE = "latitude";
    public static final String DATA_LONGITUDE = "longitude";
    public static final String DATA_GEOPOINT = "geoPoint";
    public static final String DATA_ALTITUDE = "altitude";
    public static final String DATA_SPEED_LIMIT = "speedLimit";
    public static final String DATA_SPEED = "speed";
    public static final String DATA_SPEED_HEADING = "speedH";
    public static final String DATA_SPEED_UNITS = "speedU";
    public static final String DATA_SPEED_DURATION = "speedDuration";
    public static final String DATA_HEADING = "heading";
    public static final String DATA_DISTANCE = "distance";
    public static final String DATA_PLAN_DISTANCE = "plannedDistance";
    public static final String DATA_ODOMETER = "odometer";
    public static final String DATA_ODOMETER_DELTA = "odomDelta";
    public static final String DATA_ODOMETER_DELTA_WH = "odomDeltaWH";
    public static final String DATA_ODOMETER_DELTA_AH = "odomDeltaAH";
    public static final String DATA_ODOMETER_DELTA_BIT = "odomDeltaBit";
    public static final String DATA_ODOMETER_OFFSET = "odomOffset";
    public static final String DATA_EVENT_INDEX = "eventIndex";
    public static final String DATA_LAST_EVENT = "lastEvent";
    public static final String DATA_SERVER_ID = "serverId";
    public static final String DATA_JOB_NUMBER = "jobNumber";
    public static final String DATA_BEST_LATITUDE = "bestLatitude";
    public static final String DATA_BEST_LONGITUDE = "bestLongitude";
    public static final String DATA_BEST_GEOPOINT = "bestGeoPoint";
    public static final String DATA_DATE = "date";
    public static final String DATA_TIME = "time";
    public static final String DATA_DATETIME = "dateTime";
    public static final String DATA_TIMESTAMP = "timestamp";
    public static final String DATA_CREATE_DATE = "createDate";
    public static final String DATA_CREATE_TIME = "createTime";
    public static final String DATA_CREATE_DATETIME = "createDateTime";
    public static final String DATA_CREATE_TIMESTAMP = "createTimestamp";
    public static final String DATA_PING_DATETIME = "commandDateTime";
    public static final String DATA_PING_TIMESTAMP = "commandTimestamp";
    public static final String DATA_ACK_DATETIME = "ackDateTime";
    public static final String DATA_ACK_TIMESTAMP = "ackTimestamp";
    public static final String DATA_ADDRESS = "address";
    public static final String DATA_CITY = "city";
    public static final String DATA_STATE = "state";
    public static final String DATA_COUNTRY = "country";
    public static final String DATA_SUBDIVISION = "subdivision";
    public static final String DATA_GEOZONE_ID = "geozoneId";
    public static final String DATA_GEOZONE_DESC = "geozoneDesc";
    public static final String DATA_GEOCORRIDOR_ID = "corridorID";
    public static final String DATA_PROPERTY_KEY = "propertyKey";
    public static final String DATA_PROPERTY_DESC = "propertyDesc";
    public static final String DATA_PROPERTY_VALUE = "propertyValue";
    public static final String DATA_DIAGNOSTIC_ERROR = "diagError";
    public static final String DATA_DIAGNOSTIC_KEY = "diagKey";
    public static final String DATA_DIAGNOSTIC_DESC = "diagDesc";
    public static final String DATA_DIAGNOSTIC_VALUE = "diagValue";
    public static final String DATA_UTILIZATION = "utilization";
    public static final String DATA_COUNT = "count";
    public static final String DATA_START_DATETIME = "startDateTime";
    public static final String DATA_START_TIMESTAMP = "startTimestamp";
    public static final String DATA_START_LATITUDE = "startLatitude";
    public static final String DATA_START_LONGITUDE = "startLongitude";
    public static final String DATA_START_GEOPOINT = "startGeoPoint";
    public static final String DATA_START_HOURS = "startEngineHours";
    public static final String DATA_START_ODOMETER = "startOdometer";
    public static final String DATA_START_FUEL = "startFuel";
    public static final String DATA_START_FUEL_LEVEL = "startFuelLevel";
    public static final String DATA_START_ADDRESS = "startAddress";
    public static final String DATA_STOP_DATETIME = "stopDateTime";
    public static final String DATA_STOP_TIMESTAMP = "stopTimestamp";
    public static final String DATA_STOP_LATITUDE = "stopLatitude";
    public static final String DATA_STOP_LONGITUDE = "stopLongitude";
    public static final String DATA_STOP_GEOPOINT = "stopGeoPoint";
    public static final String DATA_STOP_HOURS = "stopEngineHours";
    public static final String DATA_STOP_ODOMETER = "stopOdometer";
    public static final String DATA_STOP_FUEL = "stopFuel";
    public static final String DATA_STOP_FUEL_LEVEL = "stopFuelLevel";
    public static final String DATA_STOP_ADDRESS = "stopAddress";
    public static final String DATA_STOP_ELAPSED = "stopElapse";
    public static final String DATA_STOP_COUNT = "stopCount";
    public static final String DATA_STOP_COUNT_WH = "stopCountWH";
    public static final String DATA_FUEL_DELTA = "fuelDelta";
    public static final String DATA_DELTA_FUEL_LEVEL = "deltaFuelLevel";
    public static final String DATA_ENTER_DATETIME = "enterDateTime";
    public static final String DATA_ENTER_TIMESTAMP = "enterTimestamp";
    public static final String DATA_ENTER_GEOZONE_ID = "enterGeozoneId";
    public static final String DATA_ENTER_ADDRESS = "enterAddress";
    public static final String DATA_EXIT_DATETIME = "exitDateTime";
    public static final String DATA_EXIT_TIMESTAMP = "exitTimestamp";
    public static final String DATA_EXIT_GEOZONE_ID = "exitGeozoneId";
    public static final String DATA_EXIT_ADDRESS = "exitAddress";
    public static final String DATA_ELAPSE_SEC = "elapseSec";
    public static final String DATA_INSIDE_ELAPSED = "insideElapse";
    public static final String DATA_OUTSIDE_ELAPSED = "outsideElapse";
    public static final String DATA_DRIVING_ELAPSED = "drivingElapse";
    public static final String DATA_DRIVING_ELAPSED_WH = "drivingElapseWH";
    public static final String DATA_DRIVING_ELAPSED_AH = "drivingElapseAH";
    public static final String DATA_IDLE_ELAPSED = "idleElapse";
    public static final String DATA_AVERAGE_IDLE_HOURS = "avgIdleHours";
    public static final String DATA_ATTACHED = "attached";
    public static final String DATA_RULE_ID = "ruleId";
    public static final String DATA_MESSAGE_ID = "messageId";
    public static final String DATA_TCP_CONNECTIONS = "tcpConnections";
    public static final String DATA_UDP_CONNECTIONS = "udpConnections";
    public static final String DATA_CONNECTIONS = "connections";
    public static final String DATA_IPADDRESS = "ipAddress";
    public static final String DATA_ISDUPLEX = "isDuplex";
    public static final String DATA_BYTES_READ = "bytesRead";
    public static final String DATA_BYTES_WRITTEN = "bytesWritten";
    public static final String DATA_BYTES_OVERHEAD = "bytesOverhead";
    public static final String DATA_BYTES_TOTAL = "bytesTotal";
    public static final String DATA_BYTES_ROUNDED = "bytesRounded";
    public static final String DATA_EVENTS_RECEIVED = "eventsReceived";
    public static final String DATA_ENGINE_HOURS = "engineHours";
    public static final String DATA_IDLE_HOURS = "idleHours";
    public static final String DATA_WORK_HOURS = "workHours";
    public static final String DATA_PTO_HOURS = "ptoHours";
    public static final String DATA_FUEL_CAPACITY = "fuelCapacity";
    public static final String DATA_FUEL_LEVEL = "fuelLevel";
    public static final String DATA_FUEL_TOTAL = "fuelTotal";
    public static final String DATA_FUEL_REMAIN = "fuelRemain";
    public static final String DATA_FUEL_TRIP = "fuelTrip";
    public static final String DATA_FUEL_TRIP_WH = "fuelTripWH";
    public static final String DATA_FUEL_TRIP_AH = "fuelTripAH";
    public static final String DATA_FUEL_IDLE = "fuelIdle";
    public static final String DATA_FUEL_IDLE_WH = "fuelIdleWH";
    public static final String DATA_FUEL_IDLE_AH = "fuelIdleAH";
    public static final String DATA_FUEL_WORK = "fuelWork";
    public static final String DATA_FUEL_PTO = "fuelPTO";
    public static final String DATA_FUEL_ECONOMY = "fuelEconomy";
    public static final String DATA_FUEL_ECONOMY_TYPE = "fuelEconomyType";
    public static final String DATA_ENGINE_RPM = "engineRpm";
    public static final String DATA_CHECKIN_DATETIME = "checkinDateTime";
    public static final String DATA_CHECKIN_AGE = "checkinAge";
    public static final String DATA_LAST_IPADDRESS = "lastIPAddress";
    public static final String DATA_CODE_VERSION = "codeVersion";
    public static final String DATA_CUSTOM_FIELD = "customField";
    public static final String DATA_FAULT_CODES = "faultCodes";
    public static final String DATA_COMMAND_STATE_MASK = "commandStateMask";
    public static final String DATA_COMMAND_STATE_BIT = "commandStateBit";
    public static final String DATA_SERVICE_LAST_HR = "serviceLastHR";
    public static final String DATA_SERVICE_INTERVAL_HR = "serviceIntervalHR";
    public static final String DATA_SERVICE_NEXT_HR = "serviceNextHR";
    public static final String DATA_SERVICE_REMAINING_HR = "serviceRemainingHR";
    public static final String DATA_SERVICE_LAST = "serviceLast";
    public static final String DATA_SERVICE_INTERVAL = "serviceInterval";
    public static final String DATA_SERVICE_NEXT = "serviceNext";
    public static final String DATA_SERVICE_REMAINING = "serviceRemaining";
    public static final String DATA_SERVICE_NOTES = "serviceNotes";
    public static final String DATA_LOGIN_DATETIME = "loginDateTime";
    public static final String DATA_LOGIN_AGE = "loginAge";
    public static final String DATA_ACCOUNT_ACTIVE = "accountActive";
    public static final String DATA_DEVICE_COUNT = "deviceCount";
    public static final String DATA_PRIVATE_LABEL = "privateLabelName";
    public static final String DATA_LEFT_ALIGN_1 = "leftAlign_1";
    public static final String DATA_LEFT_ALIGN_2 = "leftAlign_2";
    public static final String DATA_RIGHT_ALIGN_1 = "rightAlign_1";
    public static final String DATA_RIGHT_ALIGN_2 = "rightAlign_2";
    public static final String DATA_BLANK_SPACE = "blankSpace";
    private static FieldLayout reportDef = null;

    public static String GetLocalStringValue(String v, I18N i18n) {
        if (StringTools.isBlank((String)v)) {
            return v;
        }
        if (v.equalsIgnoreCase("no")) {
            return i18n.getString("FieldLayout.no", "No");
        }
        if (v.equalsIgnoreCase("yes")) {
            return i18n.getString("FieldLayout.yes", "Yes");
        }
        if (v.equalsIgnoreCase("false")) {
            return i18n.getString("FieldLayout.false", "False");
        }
        if (v.equalsIgnoreCase("true")) {
            return i18n.getString("FieldLayout.true", "True");
        }
        if (v.equalsIgnoreCase("off")) {
            return i18n.getString("FieldLayout.off", "Off");
        }
        if (v.equalsIgnoreCase("on")) {
            return i18n.getString("FieldLayout.true", "True");
        }
        if (v.equalsIgnoreCase("disabled")) {
            return i18n.getString("FieldLayout.disabled", "Disabled");
        }
        if (v.equalsIgnoreCase("enabled")) {
            return i18n.getString("FieldLayout.enabled", "Enabled");
        }
        return v;
    }

    public static ReportLayout getReportLayout() {
        if (reportDef == null) {
            reportDef = new FieldLayout();
        }
        return reportDef;
    }

    private FieldLayout() {
        this.setDataRowTemplate(new FieldDataRow());
    }

    protected static String formatDouble(double value, String arg, String dftArg) {
        String fmt = dftArg;
        if (arg != null && arg.length() > 0) {
            switch (arg.charAt(0)) {
                case '0': {
                    fmt = "#0";
                    break;
                }
                case '1': {
                    fmt = "#0.0";
                    break;
                }
                case '2': {
                    fmt = "#0.00";
                    break;
                }
                case '3': {
                    fmt = "#0.000";
                    break;
                }
                case '4': {
                    fmt = "#0.0000";
                    break;
                }
                case '5': {
                    fmt = "#0.00000";
                    break;
                }
                case '6': {
                    fmt = "#0.000000";
                }
            }
        }
        return StringTools.format((double)value, (String)fmt);
    }

    protected static int getElapsedFormat(char fmt, int dft) {
        switch (fmt) {
            case '-': {
                return -1;
            }
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
        }
        return dft;
    }

    protected static int getElapsedFormat(String arg, int dft) {
        if (arg != null && arg.length() > 0) {
            return FieldLayout.getElapsedFormat(arg.charAt(0), dft);
        }
        return dft;
    }

    protected static String formatElapsedTime(long elapsedSec, int fmt) {
        return StringTools.formatElapsedSeconds((long)elapsedSec, (int)fmt);
    }

    protected static class FieldDataRow
    extends DataRowTemplate {
        @Override
        public DBDataRow.RowType getRowType(Object obj) {
            return obj instanceof FieldData ? ((FieldData)obj).getRowType() : DBDataRow.RowType.DETAIL;
        }

        public FieldDataRow() {
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_INDEX){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    if (rowNdx >= 0) {
                        String arg = rc.getArg();
                        int ofs = 1;
                        if (arg != null && arg.length() > 0 && arg.charAt(0) == '0') {
                            ofs = 0;
                        }
                        return String.valueOf(rowNdx + ofs);
                    }
                    return "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    return "#";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DISPLAY_NAME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String name = fd.getString(FieldLayout.DATA_DISPLAY_NAME, null);
                    return fd.filterReturnedValue(FieldLayout.DATA_DISPLAY_NAME, name);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.displayName", "Display Name");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ACCOUNT_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String acctID = fd.getAccountID();
                    return fd.filterReturnedValue(FieldLayout.DATA_ACCOUNT_ID, acctID);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.accountID", "Account-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ACCOUNT_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Account acct;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String desc = fd.getString(FieldLayout.DATA_ACCOUNT_DESC, null);
                    if (desc == null && (acct = fd.getAccount()) != null && StringTools.isBlank((String)(desc = acct.getDescription())) && acct.isSystemAdmin()) {
                        I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                        desc = i18n.getString("FieldLayout.accountAdmin", "Administrator");
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_ACCOUNT_DESC, desc);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.accountDescription", "Account\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_USER_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String userID = fd.getString(FieldLayout.DATA_USER_ID, "");
                    if (StringTools.isBlank((String)userID)) {
                        Device dev = fd.getDevice();
                        userID = dev != null ? dev.getAssignedUserID() : "";
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_USER_ID, userID);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.userID", "User-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_USER_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String desc;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String userID = fd.getString(FieldLayout.DATA_USER_ID, "");
                    if (StringTools.isBlank((String)userID)) {
                        Device dev = fd.getDevice();
                        String string = userID = dev != null ? dev.getAssignedUserID() : "";
                    }
                    if (StringTools.isBlank((String)(desc = fd.getString(FieldLayout.DATA_USER_DESC, ""))) && !StringTools.isBlank((String)userID)) {
                        if (User.isAdminUser((String)userID)) {
                            I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                            desc = i18n.getString("FieldLayout.userAdmin", "Account Administrator");
                        } else {
                            try {
                                User user = User.getUser((Account)fd.getAccount(), (String)userID);
                                desc = user != null ? user.getDescription() : userID;
                            }
                            catch (DBException dbe) {
                                desc = userID;
                            }
                        }
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_USER_DESC, desc);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.userDescription", "User\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DEVICE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String deviceID = fd.getDeviceID();
                    if (arg.startsWith("admin")) {
                        ColumnValue cv = new ColumnValue(deviceID);
                        RequestProperties reqState = rd.getRequestProperties();
                        URIArg devAdminURL = WebPageAdaptor.MakeURL(reqState.getBaseURI(), "dev.info");
                        devAdminURL.addArg("device", deviceID);
                        devAdminURL.addArg("page_cmd", "selectDev");
                        if (arg.equalsIgnoreCase("adminEdit")) {
                            devAdminURL.addArg("d_subedit", "edit");
                        } else {
                            devAdminURL.addArg("d_subview", "view");
                        }
                        cv.setLinkURL(devAdminURL.toString(), null);
                        return cv;
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_DEVICE_ID, deviceID);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    Locale locale = rd.getLocale();
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    RequestProperties reqState = rd.getRequestProperties();
                    Object[] devTitles = reqState != null ? reqState.getDeviceTitles() : Device.GetTitles((Locale)locale);
                    return i18n.getString("FieldLayout.deviceID", "{0} ID", devTitles);
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DEVICE_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String desc = fd.getString(FieldLayout.DATA_DEVICE_DESC, null);
                    if (desc == null && (dev = fd.getDevice()) != null) {
                        desc = dev.getDescription();
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_DEVICE_DESC, desc);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    Locale locale = rd.getLocale();
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    RequestProperties reqState = rd.getRequestProperties();
                    Object[] devTitles = reqState != null ? reqState.getDeviceTitles() : Device.GetTitles((Locale)locale);
                    return i18n.getString("FieldLayout.deviceDescription", "{0}\nDescription", devTitles);
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DEVICE_BATTERY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    if (dev != null) {
                        double level = dev.getLastBatteryLevel();
                        if (level <= 0.0) {
                            return rc.getBlankFiller();
                        }
                        if (level <= 1.0) {
                            String p = Math.round(level * 100.0) + "%";
                            return fd.filterReturnedValue(FieldLayout.DATA_DEVICE_BATTERY, p);
                        }
                        String v = FieldLayout.formatDouble(level, arg, "0.0") + "v";
                        return fd.filterReturnedValue(FieldLayout.DATA_DEVICE_BATTERY, v);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.deviceBattery", "Last\nBattery");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_VEHICLE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String vid = fd.getString(FieldLayout.DATA_VEHICLE_ID, null);
                    if (vid == null && (dev = fd.getDevice()) != null) {
                        vid = dev.getVehicleID();
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_VEHICLE_ID, vid);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.vehicleID", "Vehicle-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_LICENSE_PLATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String lic = fd.getString(FieldLayout.DATA_LICENSE_PLATE, null);
                    if (lic == null && (dev = fd.getDevice()) != null) {
                        lic = dev.getLicensePlate();
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_LICENSE_PLATE, lic);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.licensePlate", "License\nPlate");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_EQUIPMENT_TYPE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String eqType = fd.getString(FieldLayout.DATA_EQUIPMENT_TYPE, null);
                    if (eqType == null && (dev = fd.getDevice()) != null) {
                        eqType = dev.getEquipmentType();
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_EQUIPMENT_TYPE, eqType);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.equipmentType", "Equipment\nType");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_UNIQUE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String uid = fd.getString(FieldLayout.DATA_UNIQUE_ID, null);
                    if (uid == null && (dev = fd.getDevice()) != null) {
                        uid = dev.getUniqueID();
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_UNIQUE_ID, uid);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.uniqueID", "Unique-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVER_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String sid = fd.getString(FieldLayout.DATA_SERVER_ID, null);
                    if (sid == null && (dev = fd.getDevice()) != null) {
                        sid = dev.getDeviceCode();
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_SERVER_ID, sid);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.serverID", "Server-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_JOB_NUMBER){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String job = fd.getString(FieldLayout.DATA_JOB_NUMBER, "");
                    return fd.filterReturnedValue(FieldLayout.DATA_JOB_NUMBER, job);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.jobNumber", "Job#");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_GROUP_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String gid = fd.getString(FieldLayout.DATA_GROUP_ID, null);
                    if (gid == null && (dev = fd.getDevice()) != null) {
                        gid = dev.getGroupID();
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_GROUP_ID, gid);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.groupID", "Group-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_DATE)) {
                        long ds = fd.getLong(FieldLayout.DATA_DATE);
                        if (ds > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DayNumber dn = new DayNumber(ds);
                            String dnFmt = dn.format(rl.getDateFormat(rd.getPrivateLabel()));
                            ColumnValue cv = new ColumnValue(dnFmt).setSortKey(ds);
                            return fd.filterReturnedValue(FieldLayout.DATA_DATE, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    if (fd.hasValue(FieldLayout.DATA_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_TIMESTAMP);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String dtFmt = dt.format(rl.getDateFormat(rd.getPrivateLabel()), tz);
                            ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_DATE, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.date", "Date");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_TIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_TIMESTAMP);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String tmFmt = dt.format(rl.getTimeFormat(rd.getPrivateLabel()), tz);
                            return fd.filterReturnedValue(FieldLayout.DATA_TIME, tmFmt);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.time", "Time");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_TIMESTAMP);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                            ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_DATETIME, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.dateTime", "Date/Time") + "\n${timezone}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_TIMESTAMP);
                        if (ts > 0L) {
                            return fd.filterReturnedValue(FieldLayout.DATA_TIMESTAMP, String.valueOf(ts));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.timestamp", "Timestamp") + "\n(Epoch)";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CREATE_DATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_CREATE_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_CREATE_TIMESTAMP);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String dtFmt = dt.format(rl.getDateFormat(rd.getPrivateLabel()), tz);
                            ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_CREATE_DATE, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.createDate", "Insert\nDate");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CREATE_TIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_CREATE_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_CREATE_TIMESTAMP);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_CREATE_TIME, dt.format(rl.getTimeFormat(rd.getPrivateLabel()), tz));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.createTime", "Insert\nTime");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CREATE_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_CREATE_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_CREATE_TIMESTAMP);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                            ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_CREATE_DATETIME, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.createDateTime", "Insert\nDate/Time") + "\n${timezone}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CREATE_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_CREATE_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_CREATE_TIMESTAMP);
                        if (ts > 0L) {
                            return fd.filterReturnedValue(FieldLayout.DATA_CREATE_TIMESTAMP, String.valueOf(ts));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.createTimestamp", "Insert\nTimestamp") + "\n(Epoch)";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PING_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    long ts;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    long l = fd.hasValue(FieldLayout.DATA_PING_TIMESTAMP) ? fd.getLong(FieldLayout.DATA_PING_TIMESTAMP) : (ts = dev != null ? dev.getLastPingTime() : -1L);
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                        return fd.filterReturnedValue(FieldLayout.DATA_PING_DATETIME, cv);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.commandDateTime", "Command\nDate/Time") + "\n${timezone}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PING_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    long ts;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    long l = fd.hasValue(FieldLayout.DATA_PING_TIMESTAMP) ? fd.getLong(FieldLayout.DATA_PING_TIMESTAMP) : (ts = dev != null ? dev.getLastPingTime() : -1L);
                    if (ts > 0L) {
                        return fd.filterReturnedValue(FieldLayout.DATA_PING_TIMESTAMP, String.valueOf(ts));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.commandTimestamp", "Command\nTimestamp") + "\n(Epoch)";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ACK_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    long ts;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    long l = fd.hasValue(FieldLayout.DATA_ACK_TIMESTAMP) ? fd.getLong(FieldLayout.DATA_ACK_TIMESTAMP) : (ts = dev != null ? dev.getLastAckTime() : -1L);
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                        return fd.filterReturnedValue(FieldLayout.DATA_ACK_DATETIME, cv);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.ackDateTime", "ACK\nDate/Time") + "\n${timezone}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ACK_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    long ts;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    long l = fd.hasValue(FieldLayout.DATA_ACK_TIMESTAMP) ? fd.getLong(FieldLayout.DATA_ACK_TIMESTAMP) : (ts = dev != null ? dev.getLastAckTime() : -1L);
                    if (ts > 0L) {
                        return fd.filterReturnedValue(FieldLayout.DATA_ACK_TIMESTAMP, String.valueOf(ts));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.ackTimestamp", "ACK\nTimestamp") + "\n(Epoch)";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STATUS_CODE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STATUS_CODE)) {
                        String arg = rc.getArg();
                        int code = (int)fd.getLong(FieldLayout.DATA_STATUS_CODE);
                        String scCode = "0x" + StringTools.toHexString((long)code, (int)16);
                        if (StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("color")) {
                            PrivateLabel bpl;
                            Device dev = fd.getDevice();
                            StatusCodeProvider scp = StatusCode.getStatusCodeProvider((Device)dev, (int)code, (BasicPrivateLabel)(bpl = rd.getPrivateLabel()), null);
                            if (scp == null) {
                                return fd.filterReturnedValue(FieldLayout.DATA_STATUS_CODE, scCode);
                            }
                            ColumnValue cv = new ColumnValue();
                            cv.setValue(scCode);
                            cv.setForegroundColor(scp.getForegroundColor());
                            cv.setBackgroundColor(scp.getBackgroundColor());
                            return fd.filterReturnedValue(FieldLayout.DATA_STATUS_CODE, cv);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_STATUS_CODE, scCode);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.statusCode", "Status#");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STATUS_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String scDesc = fd.getString(FieldLayout.DATA_STATUS_DESC);
                    Device dev = fd.getDevice();
                    PrivateLabel bpl = rd.getPrivateLabel();
                    int code = (int)fd.getLong(FieldLayout.DATA_STATUS_CODE, 0L);
                    if (StringTools.isBlank((String)scDesc) && code != 0) {
                        scDesc = StatusCode.getDescription((Device)dev, (int)code, (BasicPrivateLabel)bpl, null);
                    }
                    if (!StringTools.isBlank((String)scDesc)) {
                        if (code == 0) {
                            return fd.filterReturnedValue(FieldLayout.DATA_STATUS_DESC, scDesc);
                        }
                        if (StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("color")) {
                            StatusCodeProvider scp = StatusCode.getStatusCodeProvider((Device)dev, (int)code, (BasicPrivateLabel)bpl, null);
                            if (scp == null) {
                                return fd.filterReturnedValue(FieldLayout.DATA_STATUS_DESC, scDesc);
                            }
                            ColumnValue cv = new ColumnValue();
                            cv.setValue(scDesc);
                            cv.setForegroundColor(scp.getForegroundColor());
                            cv.setBackgroundColor(scp.getBackgroundColor());
                            return fd.filterReturnedValue(FieldLayout.DATA_STATUS_DESC, cv);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_STATUS_DESC, scDesc);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.statusDescription", "Status");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STATUS_COUNT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    FieldData fd = (FieldData)obj;
                    int code = StringTools.parseInt((String)rc.getArg(), (int)0);
                    String cKey = "statusCount_" + StringTools.toHexString((long)code, (int)16);
                    if (fd.hasValue(cKey)) {
                        int count = (int)fd.getLong(cKey);
                        return fd.filterReturnedValue(FieldLayout.DATA_STATUS_COUNT, String.valueOf(count));
                    }
                    if (fd.hasValue(FieldLayout.DATA_STATUS_COUNT)) {
                        int count = (int)fd.getLong(FieldLayout.DATA_STATUS_COUNT);
                        return fd.filterReturnedValue(FieldLayout.DATA_STATUS_COUNT, String.valueOf(count));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    int code = StringTools.parseInt((String)rc.getArg(), (int)0);
                    Device dev = null;
                    try {
                        dev = rd.getDevice(rd.getFirstDeviceID());
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                    String scDesc = StatusCode.getDescription((Device)dev, (int)code, (BasicPrivateLabel)rd.getPrivateLabel(), null);
                    if (StringTools.isBlank((String)scDesc)) {
                        scDesc = "0x" + StringTools.toHexString((long)code, (int)16);
                    } else {
                        StringBuffer sb = new StringBuffer();
                        int C = 0;
                        for (int i = 0; i < scDesc.length(); ++i) {
                            char ch = scDesc.charAt(i);
                            if (ch == '_' || ch == ' ') {
                                if (C >= 3) {
                                    sb.append("\n");
                                    C = 0;
                                    continue;
                                }
                                sb.append(ch);
                                ++C;
                                continue;
                            }
                            sb.append(ch);
                            ++C;
                        }
                        scDesc = sb.toString();
                    }
                    return scDesc;
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PUSHPIN){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    RequestProperties reqState = rd.getRequestProperties();
                    FieldData fd = (FieldData)obj;
                    String iconURL = fd.getString(FieldLayout.DATA_PUSHPIN);
                    if (StringTools.isBlank((String)iconURL)) {
                        return rc.getBlankFiller();
                    }
                    if (StringTools.isInt((String)iconURL, (boolean)true)) {
                        int ppNdx = StringTools.parseInt((String)iconURL, (int)0);
                        PushpinIcon ppi = reqState.getPushpinIcon(ppNdx);
                        iconURL = ppi != null ? ppi.getIconEvalURL(null, rowNdx) : "";
                        ColumnValue cv = new ColumnValue().setImageURL(iconURL);
                        return fd.filterReturnedValue(FieldLayout.DATA_PUSHPIN, cv);
                    }
                    ColumnValue cv = new ColumnValue().setImageURL(iconURL);
                    return fd.filterReturnedValue(FieldLayout.DATA_PUSHPIN, cv);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.pushpin", "Pushpin");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PROPERTY_KEY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_PROPERTY_KEY)) {
                        long propKey = fd.getLong(FieldLayout.DATA_PROPERTY_KEY);
                        return fd.filterReturnedValue(FieldLayout.DATA_PROPERTY_KEY, "0x" + StringTools.toHexString((long)propKey, (int)16));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.propertyKey", "Property\nKey");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PROPERTY_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String desc = fd.getString(FieldLayout.DATA_PROPERTY_DESC);
                    if (!StringTools.isBlank((String)desc)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_PROPERTY_DESC, desc);
                    }
                    if (fd.hasValue(FieldLayout.DATA_PROPERTY_KEY)) {
                        int propKey = (int)fd.getLong(FieldLayout.DATA_PROPERTY_KEY);
                        return fd.filterReturnedValue(FieldLayout.DATA_PROPERTY_DESC, "0x" + StringTools.toHexString((long)propKey, (int)16));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.propertyDescription", "Property\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PROPERTY_VALUE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    FieldData fd;
                    String arg = rc.getArg();
                    String value = (fd = (FieldData)obj).getString(FieldLayout.DATA_PROPERTY_VALUE);
                    return fd.filterReturnedValue(FieldLayout.DATA_PROPERTY_VALUE, value != null ? value : "");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.propertyValue", "Property\nValue");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DIAGNOSTIC_ERROR){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String isErr = fd.getString(FieldLayout.DATA_DIAGNOSTIC_ERROR);
                    if (!StringTools.isBlank((String)isErr)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DIAGNOSTIC_ERROR, isErr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.diagnosticError", "Is Error?");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DIAGNOSTIC_KEY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_DIAGNOSTIC_ERROR) || fd.hasValue(FieldLayout.DATA_DIAGNOSTIC_KEY)) {
                        boolean isError = fd.getBoolean(FieldLayout.DATA_DIAGNOSTIC_ERROR);
                        long diagKey = fd.getLong(FieldLayout.DATA_DIAGNOSTIC_KEY);
                        return fd.filterReturnedValue(FieldLayout.DATA_DIAGNOSTIC_KEY, (isError ? "[E]" : "[D]") + "0x" + StringTools.toHexString((long)diagKey, (int)16));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.diagnosticKey", "Diagnostic\nKey");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DIAGNOSTIC_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String desc = fd.getString(FieldLayout.DATA_DIAGNOSTIC_DESC);
                    if (!StringTools.isBlank((String)desc)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DIAGNOSTIC_DESC, desc);
                    }
                    if (fd.hasValue(FieldLayout.DATA_DIAGNOSTIC_KEY)) {
                        int diagKey = (int)fd.getLong(FieldLayout.DATA_DIAGNOSTIC_KEY);
                        return fd.filterReturnedValue(FieldLayout.DATA_DIAGNOSTIC_DESC, "0x" + StringTools.toHexString((long)diagKey, (int)16));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.diagnosticDescription", "Diagnostic\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DIAGNOSTIC_VALUE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String value = fd.getString(FieldLayout.DATA_DIAGNOSTIC_VALUE);
                    return value != null ? fd.filterReturnedValue(FieldLayout.DATA_DIAGNOSTIC_VALUE, value) : "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.diagnosticValue", "Diagnostic\nValue");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENTITY_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String desc = fd.getString(FieldLayout.DATA_ENTITY_ID);
                    if (!StringTools.isBlank((String)desc)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_ENTITY_ID, desc);
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_ENTITY_ID, fd.getString(FieldLayout.DATA_ENTITY_DESC));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.entityID", "Entity-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENTITY_TYPE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    long type = fd.getLong(FieldLayout.DATA_ENTITY_TYPE);
                    EntityManager.EntityType et = EntityManager.getEntityTypeFromCode((long)type, null);
                    if (et != null) {
                        Locale locale = rd.getLocale();
                        return fd.filterReturnedValue(FieldLayout.DATA_ENTITY_TYPE, et.toString(locale));
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_ENTITY_TYPE, String.valueOf(type));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.entityType", "Entity-Type");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENTITY_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String desc = fd.getString(FieldLayout.DATA_ENTITY_DESC);
                    if (!StringTools.isBlank((String)desc)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_ENTITY_DESC, desc);
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_ENTITY_DESC, fd.getString(FieldLayout.DATA_ENTITY_ID));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.entityDescription", "Entity\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String driverID = fd.getDriverID();
                    if (driverID != null) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_ID, driverID);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverID", "Driver-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String desc = null;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_DESC)) {
                        desc = fd.getString(FieldLayout.DATA_DRIVER_DESC);
                    } else {
                        Driver driver = fd.getDriver();
                        String string = desc = driver != null ? driver.getDescription() : fd.getDriverID();
                    }
                    if (desc != null) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_DESC, desc);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverDescription", "Driver\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_NICKNAME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String name = null;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_NICKNAME)) {
                        name = fd.getString(FieldLayout.DATA_DRIVER_NICKNAME, null);
                    } else if (fd.hasValue(FieldLayout.DATA_DISPLAY_NAME)) {
                        name = fd.getString(FieldLayout.DATA_DISPLAY_NAME, null);
                    } else {
                        Driver driver = fd.getDriver();
                        String string = name = driver != null ? driver.getDisplayName() : null;
                    }
                    if (name != null) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_NICKNAME, name);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverNickname", "Driver\nNickname");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_STATUS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg());
                    FieldData fd = (FieldData)obj;
                    long drvStat = -1L;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_STATUS)) {
                        drvStat = fd.getLong(FieldLayout.DATA_DRIVER_STATUS);
                    } else {
                        Device device;
                        Driver driver = fd.getDriver();
                        long l = drvStat = driver != null ? driver.getDriverStatus() : -1L;
                        if ((drvStat < 0L || drvStat == -1L) && (device = fd.getDevice()) != null && device.hasDriverStatus()) {
                            drvStat = device.getDriverStatus();
                        }
                    }
                    if (drvStat <= 0L) {
                        return rc.getBlankFiller();
                    }
                    if (StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("desc")) {
                        Driver.DutyStatus ds = Driver.getDutyStatus((long)drvStat);
                        if (ds != null) {
                            Locale locale = rd.getLocale();
                            return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_STATUS, ds.toString(locale));
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_STATUS, String.valueOf(drvStat));
                    }
                    return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_STATUS, String.valueOf(drvStat));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverStatus", "Driver\nStatus");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_BADGEID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String badge = null;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_BADGEID)) {
                        badge = fd.getString(FieldLayout.DATA_DRIVER_BADGEID);
                    } else {
                        Driver driver = fd.getDriver();
                        String string = badge = driver != null ? driver.getBadgeID() : null;
                    }
                    if (badge != null) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_BADGEID, badge);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverBadge", "Driver\nBadge-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_LICENSE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String lic = null;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_LICENSE)) {
                        lic = fd.getString(FieldLayout.DATA_DRIVER_LICENSE);
                    } else {
                        Driver driver = fd.getDriver();
                        String string = lic = driver != null ? driver.getLicenseNumber() : null;
                    }
                    if (lic != null) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_LICENSE, lic);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverLicense", "Driver\nLicense");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_LICENSE_TYPE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String type = null;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_LICENSE_TYPE)) {
                        type = fd.getString(FieldLayout.DATA_DRIVER_LICENSE_TYPE);
                    } else {
                        Driver driver = fd.getDriver();
                        String string = type = driver != null ? driver.getLicenseType() : null;
                    }
                    if (type != null) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_LICENSE_TYPE, type);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverLicenseType", "Driver\nLicense Type");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_LICENSE_EXP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    long licExp = 0L;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_LICENSE_EXP)) {
                        licExp = fd.getLong(FieldLayout.DATA_DRIVER_LICENSE_EXP);
                    } else {
                        Driver driver = fd.getDriver();
                        long l = licExp = driver != null ? driver.getLicenseExpire() : 0L;
                    }
                    if (licExp > 0L) {
                        boolean expired;
                        TimeZone tz = rd.getTimeZone();
                        long currdn = DateTime.getCurrentDayNumber((TimeZone)tz);
                        long days = licExp - currdn;
                        boolean bl = expired = days <= 0L;
                        if (arg.equalsIgnoreCase("days")) {
                            I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                            String expStr = "";
                            ColorTools.RGB fgColor = null;
                            if (days < 0L) {
                                expStr = i18n.getString("FieldLayout.expired", "Expired");
                                fgColor = ColorTools.RED;
                            } else if (days == 0L) {
                                expStr = i18n.getString("FieldLayout.today", "Today");
                                fgColor = ColorTools.RED;
                            } else if (days == 1L) {
                                expStr = i18n.getString("FieldLayout.tomorrow", "Tomorrow");
                                fgColor = ColorTools.DARK_YELLOW;
                            } else if (days <= 30L) {
                                expStr = i18n.getString("FieldLayout.ndays", "{0} days", (Object)String.valueOf(days));
                                fgColor = ColorTools.DARK_YELLOW;
                            } else {
                                expStr = i18n.getString("FieldLayout.ndays", "{0} days", (Object)String.valueOf(days));
                            }
                            ColumnValue cv = new ColumnValue(expStr).setSortKey(licExp);
                            if (fgColor != null) {
                                cv.setForegroundColor(fgColor);
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_LICENSE_EXP, cv);
                        }
                        ReportLayout rl = rd.getReportLayout();
                        DayNumber dn = new DayNumber(licExp);
                        String dnFmt = dn.format(rl.getDateFormat(rd.getPrivateLabel()));
                        ColumnValue cv = new ColumnValue(dnFmt).setSortKey(licExp);
                        if (days <= 0L) {
                            cv.setForegroundColor(ColorTools.RED);
                        } else if (days <= 30L) {
                            cv.setForegroundColor(ColorTools.DARK_YELLOW);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_LICENSE_EXP, cv);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverLicenseExpire", "Driver\nLicense Exp");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_BIRTHDATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    long bDay = 0L;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_BIRTHDATE)) {
                        bDay = fd.getLong(FieldLayout.DATA_DRIVER_BIRTHDATE);
                    } else {
                        Driver driver = fd.getDriver();
                        long l = bDay = driver != null ? driver.getBirthdate() : 0L;
                    }
                    if (bDay > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        DayNumber dn = new DayNumber(bDay);
                        String dnFmt = dn.format(rl.getDateFormat(rd.getPrivateLabel()));
                        ColumnValue cv = new ColumnValue(dnFmt).setSortKey(bDay);
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_BIRTHDATE, cv);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driverBirthday", "Driver\nBirthday");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_DEVICE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String deviceID = null;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_DEVICE_ID)) {
                        deviceID = fd.getString(FieldLayout.DATA_DRIVER_DEVICE_ID);
                    } else if (fd.hasValue(FieldLayout.DATA_DEVICE_ID)) {
                        deviceID = fd.getString(FieldLayout.DATA_DEVICE_ID);
                    } else {
                        Driver driver = fd.getDriver();
                        String string = deviceID = driver != null ? driver.getDeviceID() : null;
                    }
                    if (deviceID != null) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_DEVICE_ID, deviceID);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    Locale locale = rd.getLocale();
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    RequestProperties reqState = rd.getRequestProperties();
                    Object[] devTitles = reqState != null ? reqState.getDeviceTitles() : Device.GetTitles((Locale)locale);
                    return i18n.getString("FieldLayout.driverDeviceID", "Driver\n{0} ID", devTitles);
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVER_DEVICE_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String desc = null;
                    if (fd.hasValue(FieldLayout.DATA_DRIVER_DEVICE_DESC)) {
                        desc = fd.getString(FieldLayout.DATA_DRIVER_DEVICE_DESC, null);
                    } else {
                        Driver driver = fd.getDriver();
                        Device device = driver != null ? driver.getDevice() : null;
                        String string = desc = device != null ? device.getDescription() : null;
                    }
                    if (desc != null) {
                        return fd.filterReturnedValue(FieldLayout.DATA_DRIVER_DEVICE_DESC, desc);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    Locale locale = rd.getLocale();
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    RequestProperties reqState = rd.getRequestProperties();
                    Object[] devTitles = reqState != null ? reqState.getDeviceTitles() : Device.GetTitles((Locale)locale);
                    return i18n.getString("FieldLayout.driverDeviceDesc", "Driver\n{0}", devTitles);
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_LATITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_GEOPOINT) || fd.hasValue(FieldLayout.DATA_LATITUDE)) {
                        double lat;
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_GEOPOINT);
                        double d = lat = gp != null ? gp.getLatitude() : fd.getDouble(FieldLayout.DATA_LATITUDE);
                        if (GeoPoint.isValid((double)lat, (double)1.0)) {
                            arg = StringTools.trim((String)arg);
                            String valStr = "";
                            Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                            if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                                valStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                            } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                                valStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                            } else {
                                String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                                valStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_LATITUDE, valStr);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lat", "Lat");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_LONGITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_GEOPOINT) || fd.hasValue(FieldLayout.DATA_LONGITUDE)) {
                        double lon;
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_GEOPOINT);
                        double d = lon = gp != null ? gp.getLongitude() : fd.getDouble(FieldLayout.DATA_LONGITUDE);
                        if (GeoPoint.isValid((double)1.0, (double)lon)) {
                            arg = StringTools.trim((String)arg);
                            String valStr = "";
                            Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                            if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                                valStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                            } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                                valStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                            } else {
                                String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                                valStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_LONGITUDE, valStr);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lon", "Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_GEOPOINT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_GEOPOINT) || fd.hasValue(FieldLayout.DATA_LATITUDE) || fd.hasValue(FieldLayout.DATA_LONGITUDE)) {
                        double lon;
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_GEOPOINT);
                        double lat = gp != null ? gp.getLatitude() : fd.getDouble(FieldLayout.DATA_LATITUDE);
                        double d = lon = gp != null ? gp.getLongitude() : fd.getDouble(FieldLayout.DATA_LONGITUDE);
                        if (GeoPoint.isValid((double)lat, (double)lon)) {
                            arg = StringTools.trim((String)arg);
                            String valStr = "";
                            Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                            if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            } else {
                                String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_GEOPOINT, valStr);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.latLon", "Lat/Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BEST_LATITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    double lat = 999.0;
                    if (fd.hasValue(FieldLayout.DATA_BEST_GEOPOINT)) {
                        lat = GeoPoint.getLatitude((GeoPointProvider)fd.getGeoPoint(FieldLayout.DATA_BEST_GEOPOINT), (double)999.0);
                    } else if (fd.hasValue(FieldLayout.DATA_BEST_LATITUDE)) {
                        lat = fd.getDouble(FieldLayout.DATA_BEST_LATITUDE);
                    } else if (fd.hasValue(FieldLayout.DATA_GEOPOINT)) {
                        lat = GeoPoint.getLatitude((GeoPointProvider)fd.getGeoPoint(FieldLayout.DATA_GEOPOINT), (double)999.0);
                    } else if (fd.hasValue(FieldLayout.DATA_LATITUDE)) {
                        lat = fd.getDouble(FieldLayout.DATA_LATITUDE);
                    }
                    if (GeoPoint.isValid((double)lat, (double)1.0)) {
                        Locale locale = rd.getLocale();
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            valStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            valStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            valStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_BEST_LATITUDE, valStr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.bestLat", "Lat");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BEST_LONGITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    double lon = 999.0;
                    if (fd.hasValue(FieldLayout.DATA_BEST_GEOPOINT)) {
                        lon = GeoPoint.getLongitude((GeoPointProvider)fd.getGeoPoint(FieldLayout.DATA_BEST_GEOPOINT), (double)999.0);
                    } else if (fd.hasValue(FieldLayout.DATA_BEST_LONGITUDE)) {
                        lon = fd.getDouble(FieldLayout.DATA_BEST_LONGITUDE);
                    } else if (fd.hasValue(FieldLayout.DATA_GEOPOINT)) {
                        lon = GeoPoint.getLongitude((GeoPointProvider)fd.getGeoPoint(FieldLayout.DATA_GEOPOINT), (double)999.0);
                    } else if (fd.hasValue(FieldLayout.DATA_LONGITUDE)) {
                        lon = fd.getDouble(FieldLayout.DATA_LONGITUDE);
                    }
                    if (GeoPoint.isValid((double)1.0, (double)lon)) {
                        Locale locale = rd.getLocale();
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            valStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            valStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            valStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_BEST_LONGITUDE, valStr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.bestLon", "Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BEST_GEOPOINT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    GeoPoint gp;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    double lat = 999.0;
                    double lon = 999.0;
                    if (fd.hasValue(FieldLayout.DATA_BEST_GEOPOINT)) {
                        gp = fd.getGeoPoint(FieldLayout.DATA_BEST_GEOPOINT);
                        lat = GeoPoint.getLatitude((GeoPointProvider)gp, (double)999.0);
                        lon = GeoPoint.getLongitude((GeoPointProvider)gp, (double)999.0);
                    } else if (fd.hasValue(FieldLayout.DATA_BEST_LATITUDE) && fd.hasValue(FieldLayout.DATA_BEST_LONGITUDE)) {
                        lat = fd.getDouble(FieldLayout.DATA_BEST_LATITUDE);
                        lon = fd.getDouble(FieldLayout.DATA_BEST_LONGITUDE);
                    } else if (fd.hasValue(FieldLayout.DATA_GEOPOINT)) {
                        gp = fd.getGeoPoint(FieldLayout.DATA_GEOPOINT);
                        lat = GeoPoint.getLatitude((GeoPointProvider)gp, (double)999.0);
                        lon = GeoPoint.getLongitude((GeoPointProvider)gp, (double)999.0);
                    } else if (fd.hasValue(FieldLayout.DATA_LATITUDE) && fd.hasValue(FieldLayout.DATA_LONGITUDE)) {
                        lat = fd.getDouble(FieldLayout.DATA_LATITUDE);
                        lon = fd.getDouble(FieldLayout.DATA_LONGITUDE);
                    }
                    if (GeoPoint.isValid((double)lat, (double)lon)) {
                        Locale locale = rd.getLocale();
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_BEST_GEOPOINT, valStr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.bestLatLon", "Lat/Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ALTITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ALTITUDE)) {
                        Account.AltitudeUnits altUnits = Account.getAltitudeUnits((Account)rd.getAccount());
                        double alt = altUnits.convertFromMeters(fd.getDouble(FieldLayout.DATA_ALTITUDE));
                        return fd.filterReturnedValue(FieldLayout.DATA_ALTITUDE, FieldLayout.formatDouble(alt, arg, "#0"));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.altitude", "Altitude") + "\n${altitudeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SPEED_LIMIT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_SPEED_LIMIT)) {
                        double kph = fd.getDouble(FieldLayout.DATA_SPEED_LIMIT);
                        if (kph > 0.0) {
                            Account a = rd.getAccount();
                            return fd.filterReturnedValue(FieldLayout.DATA_SPEED_LIMIT, FieldLayout.formatDouble(Account.getSpeedUnits((Account)a).convertFromKPH(kph), arg, "0"));
                        }
                        return "n/a ";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.speedLimit", "Speed Limit") + "\n${speedUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SPEED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_SPEED)) {
                        double kph = fd.getDouble(FieldLayout.DATA_SPEED);
                        if (kph > 0.0) {
                            Account a = rd.getAccount();
                            return fd.filterReturnedValue(FieldLayout.DATA_SPEED, FieldLayout.formatDouble(Account.getSpeedUnits((Account)a).convertFromKPH(kph), arg, "0"));
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_SPEED, "0   ");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.speed", "Speed") + "\n${speedUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SPEED_HEADING){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_SPEED)) {
                        double kph = fd.getDouble(FieldLayout.DATA_SPEED);
                        if (kph > 0.0) {
                            Account a = rd.getAccount();
                            String speedStr = FieldLayout.formatDouble(Account.getSpeedUnits((Account)a).convertFromKPH(kph), arg, "0");
                            String headStr = GeoPoint.GetHeadingString((double)fd.getDouble(FieldLayout.DATA_HEADING), (Locale)rd.getLocale()).toUpperCase();
                            if (headStr.length() == 1) {
                                headStr = headStr + " ";
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_SPEED_HEADING, speedStr + " " + headStr);
                        }
                        return "0   ";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.speed", "Speed") + "\n${speedUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SPEED_UNITS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_SPEED)) {
                        double kph = fd.getDouble(FieldLayout.DATA_SPEED);
                        if (kph > 0.0) {
                            Account a = rd.getAccount();
                            String unitAbbr = Account.getSpeedUnits((Account)a).toString(rd.getLocale());
                            String speedStr = FieldLayout.formatDouble(Account.getSpeedUnits((Account)a).convertFromKPH(kph), arg, "0");
                            String headStr = GeoPoint.GetHeadingString((double)fd.getDouble(FieldLayout.DATA_HEADING), (Locale)rd.getLocale()).toUpperCase();
                            if (headStr.length() == 1) {
                                headStr = headStr + " ";
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_SPEED_UNITS, speedStr + unitAbbr + " " + headStr);
                        }
                        return "0    ";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.speed", "Speed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SPEED_DURATION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg());
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_SPEED_DURATION)) {
                        long duraSec = fd.getLong(FieldLayout.DATA_SPEED_DURATION);
                        if (duraSec >= 0L) {
                            String ds;
                            if (arg.equalsIgnoreCase("sec")) {
                                I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                                ds = i18n.getString("FieldLayout.durationSeconds", "{0} sec", (Object)String.valueOf(duraSec));
                            } else {
                                int fmt = FieldLayout.getElapsedFormat(arg, 0);
                                ds = FieldLayout.formatElapsedTime(duraSec, fmt);
                            }
                            ColumnValue cv = new ColumnValue(ds).setSortKey(duraSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_SPEED_DURATION, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.speedingDuration", "Speeding\nDuration");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_HEADING){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_SPEED)) {
                        double speed = fd.getDouble(FieldLayout.DATA_SPEED);
                        if (speed > 0.0) {
                            double heading = fd.getDouble(FieldLayout.DATA_HEADING);
                            if (!StringTools.isBlank((String)arg)) {
                                return fd.filterReturnedValue(FieldLayout.DATA_HEADING, FieldLayout.formatDouble(heading, arg, "0"));
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_HEADING, GeoPoint.GetHeadingString((double)heading, (Locale)rd.getLocale()).toUpperCase());
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    return GeoPoint.GetHeadingTitle((Locale)rd.getLocale());
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DISTANCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_DISTANCE)) {
                        double dist = fd.getDouble(FieldLayout.DATA_DISTANCE);
                        if (dist > 0.0) {
                            dist = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(dist);
                            return fd.filterReturnedValue(FieldLayout.DATA_DISTANCE, FieldLayout.formatDouble(dist, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.distance", "Distance") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PLAN_DISTANCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    double distKM;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double d = fd.hasValue(FieldLayout.DATA_PLAN_DISTANCE) ? fd.getDouble(FieldLayout.DATA_PLAN_DISTANCE) : (distKM = dev != null ? dev.getPlanDistanceKM() : -1.0);
                    if (distKM > 0.0) {
                        double dist = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(distKM);
                        return fd.filterReturnedValue(FieldLayout.DATA_PLAN_DISTANCE, FieldLayout.formatDouble(dist, arg, "#0"));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.plannedDistance", "Planned\nDistance") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ODOMETER){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double odom = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_ODOMETER)) {
                        odom = fd.getDouble(FieldLayout.DATA_ODOMETER);
                    } else if (fd.hasValue(FieldLayout.DATA_DISTANCE)) {
                        odom = fd.getDouble(FieldLayout.DATA_DISTANCE);
                    } else if (dev != null) {
                        odom = dev.getLastOdometerKM();
                    }
                    if (odom > 0.0) {
                        if (fd.hasValue(FieldLayout.DATA_ODOMETER_OFFSET)) {
                            odom += fd.getDouble(FieldLayout.DATA_ODOMETER_OFFSET);
                        } else if (dev != null) {
                            odom += dev.getOdometerOffsetKM();
                        }
                        odom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(odom);
                        return fd.filterReturnedValue(FieldLayout.DATA_ODOMETER, FieldLayout.formatDouble(odom, arg, "#0"));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.odometer", "Odometer") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_ODOMETER){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_START_ODOMETER)) {
                        double odom = fd.getDouble(FieldLayout.DATA_START_ODOMETER);
                        if (odom > 0.0) {
                            Device dev = fd.getDevice();
                            if (fd.hasValue(FieldLayout.DATA_ODOMETER_OFFSET)) {
                                odom += fd.getDouble(FieldLayout.DATA_ODOMETER_OFFSET);
                            } else if (dev != null) {
                                odom += dev.getOdometerOffsetKM();
                            }
                            odom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(odom);
                            return fd.filterReturnedValue(FieldLayout.DATA_START_ODOMETER, FieldLayout.formatDouble(odom, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.startOdometer", "Start\nOdometer") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ODOMETER_DELTA){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ODOMETER_DELTA)) {
                        double deltaOdom = fd.getDouble(FieldLayout.DATA_ODOMETER_DELTA);
                        if (deltaOdom >= 0.0) {
                            deltaOdom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(deltaOdom);
                            return fd.filterReturnedValue(FieldLayout.DATA_ODOMETER_DELTA, FieldLayout.formatDouble(deltaOdom, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    if (fd.hasValue(FieldLayout.DATA_START_ODOMETER) && fd.hasValue(FieldLayout.DATA_STOP_ODOMETER)) {
                        double startOdom = fd.getDouble(FieldLayout.DATA_START_ODOMETER);
                        double stopOdom = fd.getDouble(FieldLayout.DATA_STOP_ODOMETER);
                        double deltaOdom = stopOdom - startOdom;
                        if (deltaOdom >= 0.0) {
                            deltaOdom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(deltaOdom);
                            return fd.filterReturnedValue(FieldLayout.DATA_ODOMETER_DELTA, FieldLayout.formatDouble(deltaOdom, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.driven", "Driven") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ODOMETER_DELTA_WH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ODOMETER_DELTA_WH)) {
                        double deltaOdom = fd.getDouble(FieldLayout.DATA_ODOMETER_DELTA_WH);
                        if (deltaOdom >= 0.0) {
                            deltaOdom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(deltaOdom);
                            return fd.filterReturnedValue(FieldLayout.DATA_ODOMETER_DELTA_WH, FieldLayout.formatDouble(deltaOdom, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.drivenWorkHours", "Work Hour") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ODOMETER_DELTA_AH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ODOMETER_DELTA_AH)) {
                        double deltaOdom = fd.getDouble(FieldLayout.DATA_ODOMETER_DELTA_AH);
                        if (deltaOdom >= 0.0) {
                            deltaOdom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(deltaOdom);
                            return fd.filterReturnedValue(FieldLayout.DATA_ODOMETER_DELTA_AH, FieldLayout.formatDouble(deltaOdom, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    if (fd.hasValue(FieldLayout.DATA_ODOMETER_DELTA) && fd.hasValue(FieldLayout.DATA_ODOMETER_DELTA_WH)) {
                        double deltaOdomTot = fd.getDouble(FieldLayout.DATA_ODOMETER_DELTA);
                        double deltaOdomWH = fd.getDouble(FieldLayout.DATA_ODOMETER_DELTA_WH);
                        if (deltaOdomWH >= 0.0 && deltaOdomTot >= deltaOdomWH) {
                            double deltaOdom = deltaOdomTot - deltaOdomWH;
                            deltaOdom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(deltaOdom);
                            return fd.filterReturnedValue(FieldLayout.DATA_ODOMETER_DELTA_AH, FieldLayout.formatDouble(deltaOdom, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.drivenAfterHours", "After Hour") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ODOMETER_DELTA_BIT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ODOMETER_DELTA_BIT)) {
                        double deltaOdom = fd.getDouble(FieldLayout.DATA_ODOMETER_DELTA_BIT);
                        if (deltaOdom >= 0.0) {
                            deltaOdom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(deltaOdom);
                            return fd.filterReturnedValue(FieldLayout.DATA_ODOMETER_DELTA_BIT, FieldLayout.formatDouble(deltaOdom, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.drivenInputBit", "Odometer(bit)") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_LAST_HR){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double hours = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_SERVICE_LAST_HR)) {
                        hours = fd.getDouble(FieldLayout.DATA_SERVICE_LAST_HR);
                    } else if (dev != null) {
                        hours = dev.getMaintEngHoursHR0();
                    }
                    if (hours > 0.0) {
                        if (dev != null) {
                            hours += dev.getEngineHoursOffset();
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_LAST_HR, FieldLayout.formatDouble(hours, arg, "#0.0"));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintLastServiceHR", "Last Service\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_INTERVAL_HR){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    double hours = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_SERVICE_INTERVAL_HR)) {
                        hours = fd.getDouble(FieldLayout.DATA_SERVICE_INTERVAL_HR);
                    } else {
                        Device dev = fd.getDevice();
                        if (dev != null) {
                            hours = dev.getMaintIntervalHR0();
                        }
                    }
                    if (hours > 0.0) {
                        return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_INTERVAL_HR, FieldLayout.formatDouble(hours, arg, "#0.0"));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintIntervalHR", "Service\nInterval\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_NEXT_HR){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double hours = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_SERVICE_NEXT_HR)) {
                        hours = fd.getDouble(FieldLayout.DATA_SERVICE_NEXT_HR);
                    } else if (dev != null) {
                        hours = dev.getMaintEngHoursHR0() + dev.getMaintIntervalHR0();
                    }
                    if (hours > 0.0) {
                        if (dev != null) {
                            hours += dev.getEngineHoursOffset();
                        }
                        String hoursS = FieldLayout.formatDouble(hours, arg, "#0.0");
                        double engHrs = dev.getLastEngineHours();
                        if (dev != null) {
                            engHrs += dev.getEngineHoursOffset();
                        }
                        if (engHrs > 0.0 && engHrs >= hours) {
                            return new ColumnValue(hoursS).setForegroundColor(ColorTools.RED);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_NEXT_HR, hoursS);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintNextServiceHR", "Next Service\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_REMAINING_HR){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double remaining = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_SERVICE_REMAINING_HR)) {
                        remaining = fd.getDouble(FieldLayout.DATA_SERVICE_REMAINING_HR);
                    } else {
                        double next = 0.0;
                        if (fd.hasValue(FieldLayout.DATA_SERVICE_NEXT_HR)) {
                            next = fd.getDouble(FieldLayout.DATA_SERVICE_NEXT_HR);
                        } else if (dev != null) {
                            next = dev.getMaintEngHoursHR0() + dev.getMaintIntervalHR0();
                        }
                        double hours = 0.0;
                        if (fd.hasValue(FieldLayout.DATA_ENGINE_HOURS)) {
                            hours = fd.getDouble(FieldLayout.DATA_ENGINE_HOURS);
                        } else if (dev != null) {
                            hours = dev.getLastEngineHours();
                        }
                        double d = remaining = next > 0.0 && hours > 0.0 ? next - hours : 0.0;
                    }
                    if (remaining != 0.0) {
                        String hoursS = FieldLayout.formatDouble(remaining, arg, "#0.0");
                        if (remaining >= 0.0) {
                            return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_REMAINING_HR, hoursS);
                        }
                        return new ColumnValue(hoursS).setForegroundColor(ColorTools.RED);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintRemainingHR", "Remaining\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_LAST){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double dist = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_SERVICE_LAST)) {
                        dist = fd.getDouble(FieldLayout.DATA_SERVICE_LAST);
                    } else if (dev != null) {
                        dist = dev.getMaintOdometerKM0();
                    }
                    if (dist > 0.0) {
                        if (fd.hasValue(FieldLayout.DATA_ODOMETER_OFFSET)) {
                            dist += fd.getDouble(FieldLayout.DATA_ODOMETER_OFFSET);
                        } else if (dev != null) {
                            dist += dev.getOdometerOffsetKM();
                        }
                        dist = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(dist);
                        return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_LAST, FieldLayout.formatDouble(dist, arg, "#0"));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintLastService", "Last Service") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_INTERVAL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    double dist = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_SERVICE_INTERVAL)) {
                        dist = fd.getDouble(FieldLayout.DATA_SERVICE_INTERVAL);
                    } else {
                        Device dev = fd.getDevice();
                        if (dev != null) {
                            dist = dev.getMaintIntervalKM0();
                        }
                    }
                    if (dist > 0.0) {
                        dist = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(dist);
                        return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_INTERVAL, FieldLayout.formatDouble(dist, arg, "#0"));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintInterval", "Service\nInterval");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_NEXT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double dist = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_SERVICE_NEXT)) {
                        dist = fd.getDouble(FieldLayout.DATA_SERVICE_NEXT);
                    } else if (dev != null) {
                        dist = dev.getMaintOdometerKM0() + dev.getMaintIntervalKM0();
                    }
                    if (dist > 0.0) {
                        if (fd.hasValue(FieldLayout.DATA_ODOMETER_OFFSET)) {
                            dist += fd.getDouble(FieldLayout.DATA_ODOMETER_OFFSET);
                        } else if (dev != null) {
                            dist += dev.getOdometerOffsetKM();
                        }
                        double distU = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(dist);
                        String distS = FieldLayout.formatDouble(distU, arg, "#0");
                        double odom = dev.getLastOdometerKM();
                        if (fd.hasValue(FieldLayout.DATA_ODOMETER_OFFSET)) {
                            odom += fd.getDouble(FieldLayout.DATA_ODOMETER_OFFSET);
                        } else if (dev != null) {
                            odom += dev.getOdometerOffsetKM();
                        }
                        if (odom > 0.0 && odom >= dist) {
                            return new ColumnValue(distS).setForegroundColor(ColorTools.RED);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_NEXT, distS);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintNextService", "Next Service") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_REMAINING){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double remaining = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_SERVICE_REMAINING)) {
                        remaining = fd.getDouble(FieldLayout.DATA_SERVICE_REMAINING);
                    } else {
                        double next = 0.0;
                        if (fd.hasValue(FieldLayout.DATA_SERVICE_NEXT)) {
                            next = fd.getDouble(FieldLayout.DATA_SERVICE_NEXT);
                        } else if (dev != null) {
                            next = dev.getMaintOdometerKM0() + dev.getMaintIntervalKM0();
                        }
                        double odom = 0.0;
                        if (fd.hasValue(FieldLayout.DATA_ODOMETER)) {
                            odom = fd.getDouble(FieldLayout.DATA_ODOMETER);
                        } else if (fd.hasValue(FieldLayout.DATA_DISTANCE)) {
                            odom = fd.getDouble(FieldLayout.DATA_DISTANCE);
                        } else if (dev != null) {
                            odom = dev.getLastOdometerKM();
                        }
                        double d = remaining = next > 0.0 && odom > 0.0 ? next - odom : 0.0;
                    }
                    if (remaining != 0.0) {
                        double distU = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(remaining);
                        String distS = FieldLayout.formatDouble(distU, arg, "#0");
                        if (remaining >= 0.0) {
                            return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_REMAINING, distS);
                        }
                        return new ColumnValue(distS).setForegroundColor(ColorTools.RED);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintRemaining", "Remaining") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SERVICE_NOTES){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    String notes = dev != null ? dev.getMaintNotes() : "";
                    return fd.filterReturnedValue(FieldLayout.DATA_SERVICE_NOTES, notes);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.maintServiceNotes", "Service Notes");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ADDRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_ADDRESS, fd.getString(FieldLayout.DATA_ADDRESS));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    Object addrTitle;
                    RequestProperties reqState = rd.getRequestProperties();
                    Object[] addrTitles = reqState != null ? reqState.getAddressTitles() : null;
                    Object object = addrTitle = ListTools.size((Object[])addrTitles) > 0 ? addrTitles[0] : null;
                    if (!StringTools.isBlank((String)addrTitle)) {
                        return addrTitle;
                    }
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.address", "Address");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CITY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_CITY, fd.getString(FieldLayout.DATA_CITY));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.city", "City");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_STATE, fd.getString(FieldLayout.DATA_STATE));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.stateProvince", "State\nProvince");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_COUNTRY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_COUNTRY, fd.getString(FieldLayout.DATA_COUNTRY));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.country", "Country");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_SUBDIVISION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_SUBDIVISION, fd.getString(FieldLayout.DATA_SUBDIVISION));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.subdivision", "Subdivision");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_GEOZONE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_GEOZONE_ID, fd.getString(FieldLayout.DATA_GEOZONE_ID));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.geozoneID", "Geozone-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_GEOZONE_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_GEOZONE_DESC)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_GEOZONE_DESC, fd.getString(FieldLayout.DATA_GEOZONE_DESC));
                    }
                    if (fd.hasValue(FieldLayout.DATA_GEOZONE_ID)) {
                        String geozoneID = fd.getString(FieldLayout.DATA_GEOZONE_ID);
                        try {
                            Object[] gz = Geozone.getGeozone((Account)rd.getAccount(), (String)geozoneID);
                            return !ListTools.isEmpty((Object[])gz) ? gz[0].getDescription() : "";
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.geozoneDescription", "Geozone\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_GEOCORRIDOR_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    String corrID = fd.getString(FieldLayout.DATA_GEOCORRIDOR_ID);
                    if (StringTools.isBlank((String)corrID) && fd.hasValue(FieldLayout.DATA_GEOZONE_ID)) {
                        String geozoneID = fd.getString(FieldLayout.DATA_GEOZONE_ID);
                        try {
                            Object[] gz = Geozone.getGeozone((Account)rd.getAccount(), (String)geozoneID);
                            corrID = !ListTools.isEmpty((Object[])gz) ? gz[0].getCorridorID() : "";
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    if (StringTools.isBlank((String)corrID)) {
                        double lat = 0.0;
                        double lon = 0.0;
                        if (fd.hasValue(FieldLayout.DATA_GEOPOINT)) {
                            GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_GEOPOINT);
                            lat = GeoPoint.getLatitude((GeoPointProvider)gp, (double)999.0);
                            lon = GeoPoint.getLongitude((GeoPointProvider)gp, (double)999.0);
                        } else if (fd.hasValue(FieldLayout.DATA_LATITUDE) && fd.hasValue(FieldLayout.DATA_LONGITUDE)) {
                            lat = fd.getDouble(FieldLayout.DATA_BEST_LATITUDE);
                            lon = fd.getDouble(FieldLayout.DATA_BEST_LONGITUDE);
                        }
                        if (GeoPoint.isValid((double)lat, (double)lon)) {
                            // empty if block
                        }
                    }
                    if (!StringTools.isBlank((String)corrID)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_GEOCORRIDOR_ID, corrID);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.corridorID", "Corridor-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_UTILIZATION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_UTILIZATION)) {
                        double util = fd.getDouble(FieldLayout.DATA_UTILIZATION) * 100.0;
                        return fd.filterReturnedValue(FieldLayout.DATA_UTILIZATION, FieldLayout.formatDouble(util, arg, "#0"));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.utilization", "%Util");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_COUNT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_COUNT)) {
                        long count = fd.getLong(FieldLayout.DATA_COUNT);
                        if (count >= 0L) {
                            return fd.filterReturnedValue(FieldLayout.DATA_COUNT, String.valueOf(count));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.count", "Count");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_START_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_START_TIMESTAMP, -1L);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                            ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_START_DATETIME, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.startDateTime", "Start\nDate/Time");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_START_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_START_TIMESTAMP, -1L);
                        if (ts > 0L) {
                            return fd.filterReturnedValue(FieldLayout.DATA_START_TIMESTAMP, String.valueOf(ts));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.startTimestamp", "Start\nTimestamp");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_LATITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_START_GEOPOINT) || fd.hasValue(FieldLayout.DATA_START_LATITUDE)) {
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_START_GEOPOINT);
                        double lat = gp != null ? gp.getLatitude() : fd.getDouble(FieldLayout.DATA_START_LATITUDE);
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            valStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            valStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            valStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_START_LATITUDE, valStr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lat", "Lat");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_LONGITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_START_GEOPOINT) || fd.hasValue(FieldLayout.DATA_START_LONGITUDE)) {
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_START_GEOPOINT);
                        double lon = gp != null ? gp.getLongitude() : fd.getDouble(FieldLayout.DATA_START_LONGITUDE);
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            valStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            valStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            valStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_START_LONGITUDE, valStr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lon", "Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_GEOPOINT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_START_GEOPOINT) || fd.hasValue(FieldLayout.DATA_START_LATITUDE) || fd.hasValue(FieldLayout.DATA_START_LONGITUDE)) {
                        double lon;
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_START_GEOPOINT);
                        double lat = gp != null ? gp.getLatitude() : fd.getDouble(FieldLayout.DATA_START_LATITUDE);
                        double d = lon = gp != null ? gp.getLongitude() : fd.getDouble(FieldLayout.DATA_START_LONGITUDE);
                        if (GeoPoint.isValid((double)lat, (double)lon)) {
                            arg = StringTools.trim((String)arg);
                            String valStr = "";
                            Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                            if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            } else {
                                String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_START_GEOPOINT, valStr);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.latLon", "Lat/Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENTER_GEOZONE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_ENTER_GEOZONE_ID, fd.getString(FieldLayout.DATA_ENTER_GEOZONE_ID));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.enterGeozoneID", "Arrive\nGeozone-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENTER_ADDRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_ENTER_ADDRESS, fd.getString(FieldLayout.DATA_ENTER_ADDRESS));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.enterAddress", "Arrive\nAddress");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENTER_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ENTER_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_ENTER_TIMESTAMP, -1L);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                            ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_ENTER_DATETIME, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.enterDateTime", "Arrive\nDate/Time");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENTER_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ENTER_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_ENTER_TIMESTAMP, -1L);
                        if (ts > 0L) {
                            return fd.filterReturnedValue(FieldLayout.DATA_ENTER_TIMESTAMP, String.valueOf(ts));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.enterTimestamp", "Arrive\nTimestamp");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_STOP_TIMESTAMP, -1L);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                            ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_DATETIME, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.stopDateTime", "Stop\nDate/Time");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_STOP_TIMESTAMP, -1L);
                        if (ts > 0L) {
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_TIMESTAMP, String.valueOf(ts));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.stopTimestamp", "Stop\nTimestamp");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_EXIT_GEOZONE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_EXIT_GEOZONE_ID, fd.getString(FieldLayout.DATA_EXIT_GEOZONE_ID));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.exitGeozoneID", "Departure\nGeozone-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_EXIT_ADDRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_EXIT_ADDRESS, fd.getString(FieldLayout.DATA_EXIT_ADDRESS));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.exitAddress", "Departure\nAddress");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_EXIT_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_EXIT_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_EXIT_TIMESTAMP, -1L);
                        if (ts > 0L) {
                            ReportLayout rl = rd.getReportLayout();
                            TimeZone tz = rd.getTimeZone();
                            DateTime dt = new DateTime(ts);
                            String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                            ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                            return fd.filterReturnedValue(FieldLayout.DATA_EXIT_DATETIME, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.exitDateTime", "Departure\nDate/Time");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_EXIT_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_EXIT_TIMESTAMP)) {
                        long ts = fd.getLong(FieldLayout.DATA_EXIT_TIMESTAMP, -1L);
                        if (ts > 0L) {
                            return fd.filterReturnedValue(FieldLayout.DATA_EXIT_TIMESTAMP, String.valueOf(ts));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.exitTimestamp", "Departure\nTimestamp");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_LATITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_GEOPOINT) || fd.hasValue(FieldLayout.DATA_STOP_LATITUDE)) {
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_STOP_GEOPOINT);
                        double lat = gp != null ? gp.getLatitude() : fd.getDouble(FieldLayout.DATA_STOP_LATITUDE);
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            valStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            valStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            valStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_STOP_LATITUDE, valStr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lat", "Lat");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_LONGITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_GEOPOINT) || fd.hasValue(FieldLayout.DATA_STOP_LONGITUDE)) {
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_STOP_GEOPOINT);
                        double lon = gp != null ? gp.getLongitude() : fd.getDouble(FieldLayout.DATA_STOP_LONGITUDE);
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            valStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            valStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            valStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                        }
                        return fd.filterReturnedValue(FieldLayout.DATA_STOP_LONGITUDE, valStr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lon", "Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_GEOPOINT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_GEOPOINT) || fd.hasValue(FieldLayout.DATA_STOP_LATITUDE) || fd.hasValue(FieldLayout.DATA_STOP_LONGITUDE)) {
                        double lon;
                        Locale locale = rd.getLocale();
                        GeoPoint gp = fd.getGeoPoint(FieldLayout.DATA_STOP_GEOPOINT);
                        double lat = gp != null ? gp.getLatitude() : fd.getDouble(FieldLayout.DATA_STOP_LATITUDE);
                        double d = lon = gp != null ? gp.getLongitude() : fd.getDouble(FieldLayout.DATA_STOP_LONGITUDE);
                        if (GeoPoint.isValid((double)lat, (double)lon)) {
                            arg = StringTools.trim((String)arg);
                            String valStr = "";
                            Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                            if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            } else {
                                String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                                String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                                String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                                valStr = latStr + "/" + lonStr;
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_GEOPOINT, valStr);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.latLon", "Lat/Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_ODOMETER){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_ODOMETER)) {
                        double odom = fd.getDouble(FieldLayout.DATA_STOP_ODOMETER);
                        if (odom > 0.0) {
                            Device dev = fd.getDevice();
                            if (fd.hasValue(FieldLayout.DATA_ODOMETER_OFFSET)) {
                                odom += fd.getDouble(FieldLayout.DATA_ODOMETER_OFFSET);
                            } else if (dev != null) {
                                odom += dev.getOdometerOffsetKM();
                            }
                            odom = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(odom);
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_ODOMETER, FieldLayout.formatDouble(odom, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.odometer", "Odometer") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_ADDRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_START_ADDRESS, fd.getString(FieldLayout.DATA_START_ADDRESS));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.startAddress", "Starting Address");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_ADDRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_STOP_ADDRESS, fd.getString(FieldLayout.DATA_STOP_ADDRESS));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.address", "Address");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ELAPSE_SEC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ELAPSE_SEC)) {
                        long elapsedSec = fd.getLong(FieldLayout.DATA_ELAPSE_SEC, -1L);
                        if (elapsedSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(elapsedSec, fmt)).setSortKey(elapsedSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_ELAPSE_SEC, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.elapsedTime", "Elapsed\nTime");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_INSIDE_ELAPSED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_INSIDE_ELAPSED)) {
                        long elapsedSec = fd.getLong(FieldLayout.DATA_INSIDE_ELAPSED, -1L);
                        if (elapsedSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(elapsedSec, fmt)).setSortKey(elapsedSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_INSIDE_ELAPSED, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.insideElapsed", "Inside\nElapsed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_OUTSIDE_ELAPSED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_OUTSIDE_ELAPSED)) {
                        long elapsedSec = fd.getLong(FieldLayout.DATA_OUTSIDE_ELAPSED, -1L);
                        if (elapsedSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(elapsedSec, fmt)).setSortKey(elapsedSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_OUTSIDE_ELAPSED, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.outsideElapsed", "Outside\nElapsed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVING_ELAPSED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_DRIVING_ELAPSED)) {
                        long driveSec = fd.getLong(FieldLayout.DATA_DRIVING_ELAPSED, -1L);
                        if (driveSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(driveSec, fmt)).setSortKey(driveSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_DRIVING_ELAPSED, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.drivingElapsed", "Driving\nElapsed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVING_ELAPSED_WH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_DRIVING_ELAPSED_WH)) {
                        long driveSec = fd.getLong(FieldLayout.DATA_DRIVING_ELAPSED_WH, -1L);
                        if (driveSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(driveSec, fmt)).setSortKey(driveSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_DRIVING_ELAPSED_WH, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.drivingElapsedWorkHours", "Work Hour\nElapsed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DRIVING_ELAPSED_AH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_DRIVING_ELAPSED_AH)) {
                        long driveSec = fd.getLong(FieldLayout.DATA_DRIVING_ELAPSED_AH, -1L);
                        if (driveSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(driveSec, fmt)).setSortKey(driveSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_DRIVING_ELAPSED_AH, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    if (fd.hasValue(FieldLayout.DATA_DRIVING_ELAPSED) && fd.hasValue(FieldLayout.DATA_DRIVING_ELAPSED_WH)) {
                        long driveSecTot = fd.getLong(FieldLayout.DATA_DRIVING_ELAPSED, -1L);
                        long driveSecWH = fd.getLong(FieldLayout.DATA_DRIVING_ELAPSED_WH, -1L);
                        if (driveSecWH >= 0L && driveSecTot >= driveSecWH) {
                            long driveSec = driveSecTot - driveSecWH;
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(driveSec, fmt)).setSortKey(driveSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_DRIVING_ELAPSED_AH, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.drivingElapsedAfterHours", "After Hour\nElapsed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_ELAPSED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_ELAPSED)) {
                        long stopSec = fd.getLong(FieldLayout.DATA_STOP_ELAPSED, -1L);
                        if (stopSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(stopSec, fmt)).setSortKey(stopSec);
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_ELAPSED, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.stoppedElapsed", "Stopped\nElapsed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_COUNT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_COUNT)) {
                        double stopCount = fd.getDouble(FieldLayout.DATA_STOP_COUNT, -1.0);
                        if (stopCount >= 0.0) {
                            if ((double)Math.round(stopCount) == stopCount) {
                                return fd.filterReturnedValue(FieldLayout.DATA_STOP_COUNT, String.valueOf((long)stopCount));
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_COUNT, FieldLayout.formatDouble(stopCount, "1", "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.stopCount", "Num. of\nStops");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_COUNT_WH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_COUNT_WH)) {
                        long stopCount = fd.getLong(FieldLayout.DATA_STOP_COUNT_WH, -1L);
                        if (stopCount >= 0L) {
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_COUNT_WH, String.valueOf(stopCount));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.stopCountWH", "Num. of\nStops\nWork Hours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_IDLE_ELAPSED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_IDLE_ELAPSED)) {
                        long idleSec = fd.getLong(FieldLayout.DATA_IDLE_ELAPSED, -1L);
                        if (idleSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(idleSec, fmt)).setSortKey(idleSec);
                            if (idleSec >= DateTime.HourSeconds((long)2L)) {
                                // empty if block
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_IDLE_ELAPSED, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.idleElapsed", "Idle\nElapsed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_AVERAGE_IDLE_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_AVERAGE_IDLE_HOURS)) {
                        long idleSec = fd.getLong(FieldLayout.DATA_AVERAGE_IDLE_HOURS, -1L);
                        if (idleSec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 0);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(idleSec, fmt)).setSortKey(idleSec);
                            if (idleSec >= DateTime.HourSeconds((long)2L)) {
                                // empty if block
                            }
                            return fd.filterReturnedValue(FieldLayout.DATA_AVERAGE_IDLE_HOURS, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.averageIdleHours", "Average\nIdle Hours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ATTACHED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ATTACHED)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_ATTACHED, String.valueOf(fd.getBoolean(FieldLayout.DATA_ATTACHED)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.attached", "Attached");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_RULE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_RULE_ID, fd.getString(FieldLayout.DATA_RULE_ID));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.ruleID", "Rule-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_MESSAGE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_MESSAGE_ID, fd.getString(FieldLayout.DATA_MESSAGE_ID));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.messageID", "Message-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_IPADDRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_IPADDRESS, fd.getString(FieldLayout.DATA_IPADDRESS));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.ipAddress", "IP Address");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ISDUPLEX){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ISDUPLEX)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_ISDUPLEX, String.valueOf(fd.getBoolean(FieldLayout.DATA_ISDUPLEX)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.isDuplex", "Is Duplex?");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_TCP_CONNECTIONS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_TCP_CONNECTIONS)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_TCP_CONNECTIONS, String.valueOf(fd.getLong(FieldLayout.DATA_TCP_CONNECTIONS, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.tcpConnections", "TCP\nConnects");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_UDP_CONNECTIONS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_UDP_CONNECTIONS)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_UDP_CONNECTIONS, String.valueOf(fd.getLong(FieldLayout.DATA_UDP_CONNECTIONS, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.udpConnections", "UDP\nConnects");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CONNECTIONS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_CONNECTIONS)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_CONNECTIONS, String.valueOf(fd.getLong(FieldLayout.DATA_CONNECTIONS, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.connections", "Connections");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BYTES_READ){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_BYTES_READ)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_BYTES_READ, String.valueOf(fd.getLong(FieldLayout.DATA_BYTES_READ, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.bytesRead", "Bytes\nRead");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BYTES_OVERHEAD){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_BYTES_OVERHEAD)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_BYTES_OVERHEAD, String.valueOf(fd.getLong(FieldLayout.DATA_BYTES_OVERHEAD, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.bytesOverhead", "Bytes\nOverhead");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BYTES_WRITTEN){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_BYTES_WRITTEN)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_BYTES_WRITTEN, String.valueOf(fd.getLong(FieldLayout.DATA_BYTES_WRITTEN, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.bytesWritten", "Bytes\nWritten");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BYTES_TOTAL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_BYTES_TOTAL)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_BYTES_TOTAL, String.valueOf(fd.getLong(FieldLayout.DATA_BYTES_TOTAL, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.bytesTotal", "Bytes\nTotal");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BYTES_ROUNDED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_BYTES_ROUNDED)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_BYTES_ROUNDED, String.valueOf(fd.getLong(FieldLayout.DATA_BYTES_ROUNDED, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.bytesRounded", "Bytes\nRounded");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_EVENTS_RECEIVED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_EVENTS_RECEIVED)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_EVENTS_RECEIVED, String.valueOf(fd.getLong(FieldLayout.DATA_EVENTS_RECEIVED, -1L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.eventsReceived", "Events\nReceived");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENGINE_RPM){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_ENGINE_RPM)) {
                        return fd.filterReturnedValue(FieldLayout.DATA_ENGINE_RPM, String.valueOf(fd.getLong(FieldLayout.DATA_ENGINE_RPM, 0L)));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.engineRpm", "Engine\nRPM");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ENGINE_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    double hours = 0.0;
                    if (fd.hasValue(FieldLayout.DATA_ENGINE_HOURS)) {
                        hours = fd.getDouble(FieldLayout.DATA_ENGINE_HOURS, 0.0);
                    } else if (dev != null) {
                        hours = dev.getLastEngineHours();
                    }
                    if (hours > 0.0) {
                        long sec;
                        if (dev != null) {
                            hours += dev.getEngineHoursOffset();
                        }
                        if ((sec = Math.round(hours * 3600.0)) >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 3);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(sec, fmt)).setSortKey(sec);
                            return fd.filterReturnedValue(FieldLayout.DATA_ENGINE_HOURS, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.engineHours", "Engine\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_IDLE_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_IDLE_HOURS)) {
                        double hours = fd.getDouble(FieldLayout.DATA_IDLE_HOURS, 0.0);
                        long sec = Math.round(hours * 3600.0);
                        if (sec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 3);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(sec, fmt)).setSortKey(sec);
                            return fd.filterReturnedValue(FieldLayout.DATA_IDLE_HOURS, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.idleHours", "Idle\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_WORK_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_WORK_HOURS)) {
                        double hours = fd.getDouble(FieldLayout.DATA_WORK_HOURS, 0.0);
                        long sec = Math.round(hours * 3600.0);
                        if (sec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 3);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(sec, fmt)).setSortKey(sec);
                            return fd.filterReturnedValue(FieldLayout.DATA_WORK_HOURS, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.workHours", "Work\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PTO_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_PTO_HOURS)) {
                        double hours = fd.getDouble(FieldLayout.DATA_PTO_HOURS, 0.0);
                        long sec = Math.round(hours * 3600.0);
                        if (sec >= 0L) {
                            int fmt = FieldLayout.getElapsedFormat(arg, 3);
                            ColumnValue cv = new ColumnValue(FieldLayout.formatElapsedTime(sec, fmt)).setSortKey(sec);
                            return fd.filterReturnedValue(FieldLayout.DATA_PTO_HOURS, cv);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.ptoHours", "PTO\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_CAPACITY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_CAPACITY)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_CAPACITY);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_CAPACITY, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelCapacity", "Fuel Capacity") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_LEVEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_LEVEL)) {
                        double level = fd.getDouble(FieldLayout.DATA_FUEL_LEVEL);
                        if (level < 0.0) {
                            I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                            return i18n.getString("FieldLayout.notAvailable", "n/a");
                        }
                        if (level <= 0.0) {
                            return rc.getBlankFiller();
                        }
                        if (level <= 1.0) {
                            String p = Math.round(level * 100.0) + "%";
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_LEVEL, p);
                        }
                        String p = "100%";
                        return fd.filterReturnedValue(FieldLayout.DATA_FUEL_LEVEL, p);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelLevel", "Fuel Level") + "\n%";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_TOTAL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_TOTAL)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_TOTAL);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_TOTAL, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelTotal", "Total Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_REMAIN){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_REMAIN)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_REMAIN);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_REMAIN, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelRemain", "Remaining Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_TRIP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_TRIP)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_TRIP);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_TRIP, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelTrip", "Trip Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_TRIP_WH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_TRIP_WH)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_TRIP_WH);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_TRIP_WH, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelTripWorkHours", "Trip Fuel\nWork Hours") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_TRIP_AH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_TRIP_AH)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_TRIP_AH);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_TRIP_AH, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    if (fd.hasValue(FieldLayout.DATA_FUEL_TRIP) && fd.hasValue(FieldLayout.DATA_FUEL_TRIP_WH)) {
                        double ft = fd.getDouble(FieldLayout.DATA_FUEL_TRIP);
                        double ftwh = fd.getDouble(FieldLayout.DATA_FUEL_TRIP_WH);
                        if (ft >= 0.0 && ft > ftwh) {
                            double vol = ft - ftwh;
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_TRIP_AH, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelTripAfterHours", "Trip Fuel\nAfter Hours") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_IDLE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_IDLE)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_IDLE);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_IDLE, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelIdle", "Idle Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_IDLE_WH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_IDLE_WH)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_IDLE_WH);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_IDLE_WH, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelIdleWorkHours", "Idle Fuel\nWork Hours") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_IDLE_AH){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_IDLE_AH)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_IDLE_AH);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_IDLE_AH, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    if (fd.hasValue(FieldLayout.DATA_FUEL_IDLE) && fd.hasValue(FieldLayout.DATA_FUEL_IDLE_WH)) {
                        double fi = fd.getDouble(FieldLayout.DATA_FUEL_IDLE);
                        double fiwh = fd.getDouble(FieldLayout.DATA_FUEL_IDLE_WH);
                        if (fi >= 0.0 && fi > fiwh) {
                            double vol = fi - fiwh;
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_IDLE_AH, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelIdleWorkHours", "Idle Fuel\nWork Hours") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_WORK){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_WORK)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_WORK);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_WORK, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    if (fd.hasValue(FieldLayout.DATA_FUEL_TOTAL) && fd.hasValue(FieldLayout.DATA_FUEL_IDLE)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_TOTAL) - fd.getDouble(FieldLayout.DATA_FUEL_IDLE);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_WORK, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelWork", "Work Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_PTO){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_PTO)) {
                        double vol = fd.getDouble(FieldLayout.DATA_FUEL_PTO);
                        if (vol > 0.0) {
                            vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_PTO, FieldLayout.formatDouble(vol, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelPTO", "PTO Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_ECONOMY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_ECONOMY)) {
                        double econ = fd.getDouble(FieldLayout.DATA_FUEL_ECONOMY);
                        if (econ > 0.0) {
                            econ = Account.getEconomyUnits((Account)rd.getAccount()).convertFromKPL(econ);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_ECONOMY, FieldLayout.formatDouble(econ, arg, "#0.0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelEcon", "Fuel Econ") + "\n${economyUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_ECONOMY_TYPE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg());
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_ECONOMY_TYPE)) {
                        Object type = fd.getValue(FieldLayout.DATA_FUEL_ECONOMY_TYPE);
                        if (type instanceof Device.FuelEconomyType) {
                            Locale locale = rd.getPrivateLabel().getLocale();
                            String typeStr = arg.equalsIgnoreCase("abbr") ? ((Device.FuelEconomyType)type).getAbbrev(locale) : ((Device.FuelEconomyType)type).toString(locale);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_ECONOMY_TYPE, typeStr);
                        }
                        if (type != null) {
                            String typeStr = StringTools.trim((Object)type);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_ECONOMY_TYPE, typeStr);
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelEconType", "Fuel Econ\nType");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_FUEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_START_FUEL)) {
                        double fuel = fd.getDouble(FieldLayout.DATA_START_FUEL);
                        if (fuel > 0.0) {
                            Device dev = fd.getDevice();
                            fuel = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(fuel);
                            return fd.filterReturnedValue(FieldLayout.DATA_START_FUEL, FieldLayout.formatDouble(fuel, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.startFuel", "Start\nFuel Total") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_START_FUEL_LEVEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_START_FUEL_LEVEL)) {
                        double level = fd.getDouble(FieldLayout.DATA_START_FUEL_LEVEL);
                        if (level < 0.0) {
                            I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                            return i18n.getString("FieldLayout.notAvailable", "n/a");
                        }
                        if (level <= 0.0) {
                            return rc.getBlankFiller();
                        }
                        if (level <= 1.0) {
                            String p = Math.round(level * 100.0) + "%";
                            return fd.filterReturnedValue(FieldLayout.DATA_START_FUEL_LEVEL, p);
                        }
                        String p = "100%";
                        return fd.filterReturnedValue(FieldLayout.DATA_START_FUEL_LEVEL, p);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.startFuelLevel", "Start\nFuel Level") + "\n%";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_FUEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_FUEL)) {
                        double fuel = fd.getDouble(FieldLayout.DATA_STOP_FUEL);
                        if (fuel > 0.0) {
                            Device dev = fd.getDevice();
                            fuel = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(fuel);
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_FUEL, FieldLayout.formatDouble(fuel, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.startFuel", "Start\nFuel Total") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_STOP_FUEL_LEVEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_STOP_FUEL_LEVEL)) {
                        double level = fd.getDouble(FieldLayout.DATA_STOP_FUEL_LEVEL);
                        if (level < 0.0) {
                            I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                            return i18n.getString("FieldLayout.notAvailable", "n/a");
                        }
                        if (level <= 0.0) {
                            return rc.getBlankFiller();
                        }
                        if (level <= 1.0) {
                            String p = Math.round(level * 100.0) + "%";
                            return fd.filterReturnedValue(FieldLayout.DATA_STOP_FUEL_LEVEL, p);
                        }
                        String p = "100%";
                        return fd.filterReturnedValue(FieldLayout.DATA_STOP_FUEL_LEVEL, p);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.stopFuelLevel", "Stop\nFuel Level") + "\n%";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FUEL_DELTA){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_FUEL_DELTA)) {
                        double deltaFuel = fd.getDouble(FieldLayout.DATA_FUEL_DELTA);
                        if (deltaFuel >= 0.0) {
                            deltaFuel = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(deltaFuel);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_DELTA, FieldLayout.formatDouble(deltaFuel, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    if (fd.hasValue(FieldLayout.DATA_START_FUEL) && fd.hasValue(FieldLayout.DATA_STOP_FUEL)) {
                        double startFuel = fd.getDouble(FieldLayout.DATA_START_FUEL);
                        double stopFuel = fd.getDouble(FieldLayout.DATA_STOP_FUEL);
                        double deltaFuel = stopFuel - startFuel;
                        if (deltaFuel >= 0.0) {
                            deltaFuel = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(deltaFuel);
                            return fd.filterReturnedValue(FieldLayout.DATA_FUEL_DELTA, FieldLayout.formatDouble(deltaFuel, arg, "#0"));
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.fuelUsed", "Fuel Used") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DELTA_FUEL_LEVEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    if (fd.hasValue(FieldLayout.DATA_DELTA_FUEL_LEVEL)) {
                        double deltaLevel = fd.getDouble(FieldLayout.DATA_DELTA_FUEL_LEVEL);
                        String p = Math.round(deltaLevel * 100.0) + "%";
                        return fd.filterReturnedValue(FieldLayout.DATA_DELTA_FUEL_LEVEL, p);
                    }
                    if (fd.hasValue(FieldLayout.DATA_START_FUEL_LEVEL) && fd.hasValue(FieldLayout.DATA_STOP_FUEL_LEVEL)) {
                        double startLevel = fd.getDouble(FieldLayout.DATA_START_FUEL_LEVEL);
                        double stopLevel = fd.getDouble(FieldLayout.DATA_STOP_FUEL_LEVEL);
                        double deltaLevel = stopLevel - startLevel;
                        String p = Math.round(deltaLevel * 100.0) + "%";
                        return fd.filterReturnedValue(FieldLayout.DATA_DELTA_FUEL_LEVEL, p);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.deltaFuelLevel", "Delta\nFuel Level") + "\n%";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CHECKIN_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    long ts = 0L;
                    Device dev = fd.getDevice();
                    if (dev != null && (ts = dev.getLastTotalConnectTime()) <= 0L) {
                        try {
                            EventData lastEv = dev.getLastEvent(-1L, false);
                            if (lastEv != null) {
                                ts = lastEv.getTimestamp();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    if (ts > MIN_REASONABLE_TIMESTAMP) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                        long ageSec = DateTime.getCurrentTimeSec() - ts;
                        ReportLayout.AgeColorRange acr = rd.getCheckinAgeColorRange(ageSec);
                        ReportLayout.SetColumnValueAgeColor(cv, acr);
                        return fd.filterReturnedValue(FieldLayout.DATA_CHECKIN_DATETIME, cv);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lastCheckinTime", "Last Check-In\nTime");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CHECKIN_AGE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    long ts = 0L;
                    Device dev = fd.getDevice();
                    if (dev != null && (ts = dev.getLastTotalConnectTime()) <= 0L) {
                        try {
                            EventData lastEv = dev.getLastEvent(-1L, false);
                            if (lastEv != null) {
                                ts = lastEv.getTimestamp();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    if (ts > MIN_REASONABLE_TIMESTAMP) {
                        long ageSec = DateTime.getCurrentTimeSec() - ts;
                        long days = ageSec / DateTime.DaySeconds((long)1L);
                        long hours = ageSec % DateTime.DaySeconds((long)1L) / DateTime.HourSeconds((long)1L);
                        long min = ageSec % DateTime.HourSeconds((long)1L) / DateTime.MinuteSeconds((long)1L);
                        StringBuffer sb = new StringBuffer();
                        sb.append(days).append("d ");
                        if (hours < 10L) {
                            sb.append("0");
                        }
                        sb.append(hours).append("h ");
                        if (min < 10L) {
                            sb.append("0");
                        }
                        sb.append(min).append("m");
                        ColumnValue cv = new ColumnValue(sb.toString()).setSortKey(ageSec);
                        ReportLayout.AgeColorRange acr = rd.getCheckinAgeColorRange(ageSec);
                        ReportLayout.SetColumnValueAgeColor(cv, acr);
                        return fd.filterReturnedValue(FieldLayout.DATA_CHECKIN_AGE, cv);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lastCheckinAge", "Since Last\nCheck-In");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_LAST_IPADDRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    DTIPAddress ipAddr = dev != null ? dev.getDataTransport().getIpAddressCurrent() : null;
                    return ipAddr != null ? fd.filterReturnedValue(FieldLayout.DATA_LAST_IPADDRESS, ipAddr.toString()) : "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lastIPAddress", "Last IP\nAddress");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CODE_VERSION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    String cv = dev != null ? dev.getDataTransport().getCodeVersion() : null;
                    return cv != null ? fd.filterReturnedValue(FieldLayout.DATA_CODE_VERSION, cv) : "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.codeVersion", "Code\nVersion");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_CUSTOM_FIELD){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    String value = dev.getCustomAttribute(arg);
                    return !StringTools.isBlank((String)value) ? value : "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    String arg = rc.getArg();
                    String desc = rd.getPrivateLabel().getStringProperty("deviceInfo.custom." + arg, null);
                    if (!StringTools.isBlank((String)desc)) {
                        int p;
                        if (desc.length() > 12 && (p = desc.lastIndexOf(" ")) > 0) {
                            desc = desc.substring(0, p) + "\n" + desc.substring(p + 1);
                        }
                        return desc;
                    }
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.customAttribute", "Custom\nAttribute");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_FAULT_CODES){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String faultStr;
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    String string = faultStr = dev != null ? dev.getLastFaultCode() : null;
                    if (StringTools.isBlank((String)faultStr)) {
                        return rc.getBlankFiller();
                    }
                    String fc = DTOBDFault.GetFaultString((RTProperties)new RTProperties(faultStr));
                    return fd.filterReturnedValue(FieldLayout.DATA_FAULT_CODES, fc);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.faultCodes", "OBD Faults");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_COMMAND_STATE_MASK){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    long csm = dev != null ? dev.getCommandStateMask() : 0L;
                    String v = "";
                    v = StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("dec") ? String.valueOf(csm) : (arg.equalsIgnoreCase("hex") ? "0x" + StringTools.toHexString((long)csm, (int)16) : (arg.equalsIgnoreCase("bin") ? StringTools.toBinaryString((long)csm, (int)16, null).toString() : String.valueOf(csm)));
                    return fd.filterReturnedValue(FieldLayout.DATA_COMMAND_STATE_MASK, v);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.commandState", "Command\nState");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_COMMAND_STATE_BIT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String[] arg = StringTools.split((String)rc.getArg(), (char)',');
                    int bitNdx = arg.length > 0 ? StringTools.parseInt((String)arg[0], (int)0) : 0;
                    FieldData fd = (FieldData)obj;
                    Device dev = fd.getDevice();
                    boolean state = dev != null ? dev.getCommandStateMaskBit(bitNdx) : false;
                    Locale locale = rd.getPrivateLabel().getLocale();
                    String v = state ? AccountRecord.GetSimpleLocalString((String)(arg.length > 2 ? arg[2] : "1"), (Locale)locale) : AccountRecord.GetSimpleLocalString((String)(arg.length > 1 ? arg[1] : "0"), (Locale)locale);
                    return fd.filterReturnedValue(FieldLayout.DATA_COMMAND_STATE_BIT, v);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    String[] arg = StringTools.split((String)rc.getArg(), (char)',');
                    int bitNdx = arg.length > 0 ? StringTools.parseInt((String)arg[0], (int)0) : 0;
                    String bitNdxS = String.valueOf(bitNdx);
                    return i18n.getString("FieldLayout.commandStateBit", "Command\nState\n#{0}", (Object)bitNdxS);
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_LOGIN_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    long ts = 0L;
                    if (fd.hasValue(FieldLayout.DATA_LOGIN_DATETIME)) {
                        ts = fd.getLong(FieldLayout.DATA_LOGIN_DATETIME);
                    } else {
                        Account acct = fd.getAccount();
                        long l = ts = acct != null ? acct.getLastLoginTime() : 0L;
                    }
                    if (ts > MIN_REASONABLE_TIMESTAMP) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                        long ageSec = DateTime.getCurrentTimeSec() - ts;
                        ReportLayout.AgeColorRange acr = rd.getLoginAgeColorRange(ageSec);
                        ReportLayout.SetColumnValueAgeColor(cv, acr);
                        return fd.filterReturnedValue(FieldLayout.DATA_LOGIN_DATETIME, cv);
                    }
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    String never = i18n.getString("FieldLayout.loginNever", "never");
                    ColumnValue cv = new ColumnValue(never).setSortKey(0);
                    cv.setForegroundColor(ColorTools.RED);
                    return fd.filterReturnedValue(FieldLayout.DATA_LOGIN_DATETIME, cv);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lastLoginTime", "Last Login\nTime");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_LOGIN_AGE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    long ts = 0L;
                    if (fd.hasValue(FieldLayout.DATA_LOGIN_DATETIME)) {
                        ts = fd.getLong(FieldLayout.DATA_LOGIN_DATETIME);
                    } else {
                        Account acct = fd.getAccount();
                        long l = ts = acct != null ? acct.getLastLoginTime() : 0L;
                    }
                    if (ts > MIN_REASONABLE_TIMESTAMP) {
                        long ageSec = DateTime.getCurrentTimeSec() - ts;
                        long days = ageSec / DateTime.DaySeconds((long)1L);
                        long hours = ageSec % DateTime.DaySeconds((long)1L) / DateTime.HourSeconds((long)1L);
                        long min = ageSec % DateTime.HourSeconds((long)1L) / DateTime.MinuteSeconds((long)1L);
                        StringBuffer sb = new StringBuffer();
                        sb.append(days).append("d ");
                        if (hours < 10L) {
                            sb.append("0");
                        }
                        sb.append(hours).append("h ");
                        if (min < 10L) {
                            sb.append("0");
                        }
                        sb.append(min).append("m");
                        ColumnValue cv = new ColumnValue(sb.toString()).setSortKey(ageSec);
                        ReportLayout.AgeColorRange acr = rd.getLoginAgeColorRange(ageSec);
                        ReportLayout.SetColumnValueAgeColor(cv, acr);
                        return fd.filterReturnedValue(FieldLayout.DATA_LOGIN_AGE, cv);
                    }
                    ColumnValue cv = new ColumnValue(rc.getBlankFiller()).setSortKey(999999999L);
                    cv.setForegroundColor(ColorTools.RED);
                    return fd.filterReturnedValue(FieldLayout.DATA_LOGIN_AGE, cv);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.lastLoginAge", "Since Last\nLogin");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_ACCOUNT_ACTIVE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Account acct = fd.getAccount();
                    if (acct != null) {
                        I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                        boolean isActive = acct.isActive();
                        String value = isActive ? i18n.getString("FieldLayout.activeYes", "Yes") : i18n.getString("FieldLayout.activeNo", "No");
                        return fd.filterReturnedValue(FieldLayout.DATA_ACCOUNT_ACTIVE, value);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.accountActive", "Account\nActive");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_DEVICE_COUNT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Account acct = fd.getAccount();
                    if (acct != null) {
                        long devCount = acct.getDeviceCount();
                        return fd.filterReturnedValue(FieldLayout.DATA_DEVICE_COUNT, String.valueOf(devCount));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.deviceCount", "Device\nCount");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_PRIVATE_LABEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    Account acct = fd.getAccount();
                    if (acct != null) {
                        String privLabel = acct.getPrivateLabelName();
                        return fd.filterReturnedValue(FieldLayout.DATA_PRIVATE_LABEL, privLabel);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.privateLabelName", "PrivateLabel\nName");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_LEFT_ALIGN_1){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_LEFT_ALIGN_1, fd.getString(FieldLayout.DATA_LEFT_ALIGN_1));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.leftAlign1", "String 1");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_LEFT_ALIGN_2){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_LEFT_ALIGN_2, fd.getString(FieldLayout.DATA_LEFT_ALIGN_2));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.leftAlign1", "String 1");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_RIGHT_ALIGN_1){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_RIGHT_ALIGN_1, fd.getString(FieldLayout.DATA_RIGHT_ALIGN_1));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.rightAlign1", "String 1");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_RIGHT_ALIGN_2){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    FieldData fd = (FieldData)obj;
                    return fd.filterReturnedValue(FieldLayout.DATA_RIGHT_ALIGN_2, fd.getString(FieldLayout.DATA_RIGHT_ALIGN_2));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(FieldLayout.class);
                    return i18n.getString("FieldLayout.rightAlign2", "String 2");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(FieldLayout.DATA_BLANK_SPACE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    return "";
                }
            }, new String[0]);
        }
    }
}

