/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.field;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.EventDataProvider;
import org.opengts.db.StatusCodeProvider;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.StatusCode;
import org.opengts.dbtools.DBException;
import org.opengts.util.GeoPoint;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.CSSRowClass;
import org.opengts.war.report.DBDataRow;

public class FieldData
implements CSSRowClass {
    public static final String KEY_ACCOUNT = "$account";
    public static final String KEY_DEVICE = "$device";
    public static final String KEY_DEVICE_DESC = "$deviceDesc";
    public static final String KEY_DEVICE_VIN = "$deviceVIN";
    public static final String KEY_DRIVER = "$driver";
    private String cssClass = null;
    private DBDataRow.RowType rowType = DBDataRow.RowType.DETAIL;
    private HashMap<String, Object> fieldValues = new HashMap();
    private static Comparator<FieldData> devDescComparator = null;

    public void setRowType(DBDataRow.RowType rt) {
        this.rowType = rt != null ? rt : DBDataRow.RowType.DETAIL;
    }

    public DBDataRow.RowType getRowType() {
        return this.rowType != null ? this.rowType : DBDataRow.RowType.DETAIL;
    }

    @Override
    public boolean hasCssClass() {
        return !StringTools.isBlank((String)this.getCssClass());
    }

    @Override
    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String rowClass) {
        this.cssClass = rowClass;
    }

    public void setValue(String key, Object val) {
        this.fieldValues.put(key, val);
    }

    public Object getValue(String key, Object dft) {
        Object val = this.fieldValues.get(key);
        return val != null ? val : dft;
    }

    public Object getValue(String key) {
        return this.getValue(key, null);
    }

    public boolean hasValue(String key) {
        return this.fieldValues.containsKey(key);
    }

    public Object filterReturnedValue(String key, Object rtnVal) {
        return rtnVal;
    }

    public String getAccountID() {
        String acctID = this.getString("accountId", null);
        if (acctID != null) {
            return acctID;
        }
        Account acct = this.getAccount(null);
        if (acct != null) {
            return acct.getAccountID();
        }
        return "";
    }

    public void setAccount(Account account) {
        this.setValue(KEY_ACCOUNT, account);
        if (account != null) {
            this.setValue("accountId", account.getAccountID());
        }
    }

    public Account getAccount(Account dft) {
        Object val = this.getValue(KEY_ACCOUNT, null);
        if (val instanceof Account) {
            return (Account)val;
        }
        if (dft != null) {
            return dft;
        }
        Device dev = this.getDevice();
        if (dev != null) {
            Account acct = dev.getAccount();
            this.setAccount(acct);
            return acct;
        }
        return null;
    }

    public Account getAccount() {
        return this.getAccount(null);
    }

    public String getDeviceID() {
        String devID = this.getString("deviceId", null);
        if (devID != null) {
            return devID;
        }
        Device dev = this.getDevice(null);
        if (dev != null) {
            return dev.getDeviceID();
        }
        return "";
    }

    public void setDevice(Device device) {
        this.setValue(KEY_DEVICE, device);
        if (device != null) {
            this.setValue("deviceId", device.getDeviceID());
        }
    }

    public Device getDevice(Device dft) {
        Object val = this.getValue(KEY_DEVICE, null);
        return val instanceof Device ? (Device)val : dft;
    }

    public Device getDevice() {
        return this.getDevice(null);
    }

    public String getDeviceDescription() {
        Object devDesc = this.getValue(KEY_DEVICE_DESC, null);
        if (devDesc != null) {
            return (String)devDesc;
        }
        Device dev = this.getDevice(null);
        if (dev != null) {
            String desc = dev.getDescription();
            this.setValue(KEY_DEVICE_DESC, desc);
            return desc;
        }
        return this.getString("deviceId", "");
    }

    public String getDeviceVIN() {
        Object devVIN = this.getValue(KEY_DEVICE_VIN, null);
        if (devVIN != null) {
            return (String)devVIN;
        }
        Device dev = this.getDevice(null);
        if (dev != null) {
            String vin = dev.getDeviceVIN();
            this.setValue(KEY_DEVICE_VIN, vin);
            return vin;
        }
        return this.getString("deviceId", "");
    }

    public String getDriverID() {
        String driverID = this.getString("driverId", null);
        if (driverID != null) {
            return driverID;
        }
        Device device = this.getDevice(null);
        if (device != null) {
            return device.getDriverID();
        }
        return "";
    }

    public void setDriver(Driver driver) {
        this.setValue(KEY_DRIVER, driver);
        if (driver != null) {
            this.setValue("driverId", driver.getDriverID());
        }
    }

    public Driver getDriver(Driver dft) {
        Object val = this.getValue(KEY_DRIVER, null);
        if (val instanceof Driver) {
            return (Driver)val;
        }
        if (dft != null) {
            return dft;
        }
        Account account = this.getAccount();
        String driverID = this.getDriverID();
        try {
            Driver driver = Driver.getDriver((Account)account, (String)driverID);
            if (driver != null) {
                this.setDriver(driver);
                return driver;
            }
            return null;
        }
        catch (DBException dbe) {
            return null;
        }
    }

    public Driver getDriver() {
        return this.getDriver(null);
    }

    public long getTimestamp(String key) {
        return this.getLong(key, 0L);
    }

    public void setGeoPoint(String key, GeoPoint gp) {
        this.setValue(key, gp);
    }

    public GeoPoint getGeoPoint(String key, GeoPoint dft) {
        Object val = this.getValue(key, null);
        if (val instanceof GeoPoint) {
            return (GeoPoint)val;
        }
        return dft;
    }

    public GeoPoint getGeoPoint(String key) {
        return this.getGeoPoint(key, null);
    }

    public double getLatitude(String key) {
        Object val = this.getValue(key, null);
        if (val instanceof GeoPoint) {
            return ((GeoPoint)val).getLatitude();
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return 0.0;
    }

    public double getLongitude(String key) {
        Object val = this.getValue(key, null);
        if (val instanceof GeoPoint) {
            return ((GeoPoint)val).getLongitude();
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return 0.0;
    }

    public void setValue(String key, boolean val) {
        this.setValue(key, new Boolean(val));
    }

    public void setBoolean(String key, boolean val) {
        this.setValue(key, new Boolean(val));
    }

    public boolean getBoolean(String key, boolean dft) {
        Object val = this.getValue(key, null);
        return StringTools.parseBoolean((Object)val, (boolean)dft);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public void setString(String key, String val) {
        this.setValue(key, val);
    }

    public String getString(String key, String dft) {
        Object val = this.getValue(key, null);
        return val != null ? val.toString() : dft;
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public void setValue(String key, int val) {
        this.setValue(key, new Integer(val));
    }

    public void setInt(String key, int val) {
        this.setValue(key, new Integer(val));
    }

    public int getInt(String key, int dft) {
        Object val = this.getValue(key, null);
        return val instanceof Number ? ((Number)val).intValue() : dft;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public void setValue(String key, long val) {
        this.setValue(key, new Long(val));
    }

    public void setLong(String key, long val) {
        this.setValue(key, new Long(val));
    }

    public long getLong(String key, long dft) {
        Object val = this.getValue(key, null);
        return val instanceof Number ? ((Number)val).longValue() : dft;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public void setValue(String key, double val) {
        this.setValue(key, new Double(val));
    }

    public void setDouble(String key, double val) {
        this.setValue(key, new Double(val));
    }

    public double getDouble(String key, double dft) {
        Object val = this.getValue(key, null);
        return val instanceof Number ? ((Number)val).doubleValue() : dft;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public static Comparator<FieldData> getDeviceDescriptionComparator() {
        if (devDescComparator == null) {
            devDescComparator = new DeviceDescriptionComparator();
        }
        return devDescComparator;
    }

    public static void sortByDeviceDescription(List<FieldData> fieldDataList) {
        if (fieldDataList != null) {
            try {
                Collections.sort(fieldDataList, FieldData.getDeviceDescriptionComparator());
            }
            catch (Throwable th) {
                Print.logException((String)"Invalid FieldData list", (Throwable)th);
            }
        }
    }

    public static class FieldEventDataProvider
    extends FieldData
    implements EventDataProvider {
        @Override
        public String getAccountID() {
            return super.getAccountID();
        }

        @Override
        public String getDeviceID() {
            return super.getDeviceID();
        }

        @Override
        public String getDeviceDescription() {
            return super.getDeviceDescription();
        }

        @Override
        public String getDeviceVIN() {
            return super.getDeviceVIN();
        }

        public long getTimestamp() {
            return super.getTimestamp("timestamp");
        }

        public int getStatusCode() {
            return 61472;
        }

        public String getStatusCodeDescription(BasicPrivateLabel bpl) {
            Device dev = null;
            int code = this.getStatusCode();
            return StatusCode.getDescription(dev, (int)code, (BasicPrivateLabel)bpl, (String)"Location");
        }

        public StatusCodeProvider getStatusCodeProvider(BasicPrivateLabel bpl) {
            Device dev = null;
            int code = this.getStatusCode();
            return StatusCode.getStatusCodeProvider(dev, (int)code, (BasicPrivateLabel)bpl, null);
        }

        public int getPushpinIconIndex(String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, BasicPrivateLabel bpl) {
            String pid = null;
            return EventData._getPushpinIconIndex(pid, iconKeys, (int)3);
        }

        public boolean isValidGeoPoint() {
            return GeoPoint.isValid((double)this.getLatitude(), (double)this.getLongitude());
        }

        public double getLatitude() {
            return super.getLatitude("geoPoint");
        }

        public double getLongitude() {
            return super.getLongitude("geoPoint");
        }

        public GeoPoint getGeoPoint() {
            return super.getGeoPoint("geoPoint");
        }

        public long getGpsAge() {
            return 0L;
        }

        public long getCreationAge() {
            return 0L;
        }

        public double getHorzAccuracy() {
            return -1.0;
        }

        public GeoPoint getBestGeoPoint() {
            return this.getGeoPoint();
        }

        public double getBestAccuracy() {
            return this.getHorzAccuracy();
        }

        public int getSatelliteCount() {
            return 0;
        }

        public double getBatteryLevel() {
            return super.getDouble("deviceBattery", 0.0);
        }

        public double getSpeedKPH() {
            return super.getDouble("speed", 0.0);
        }

        public double getHeading() {
            return super.getDouble("heading", 0.0);
        }

        public double getAltitude() {
            return super.getDouble("altitude", 0.0);
        }

        public double getOdometerKM() {
            return super.getDouble("odometer", 0.0);
        }

        public String getGeozoneID() {
            return super.getString("geozoneId", "");
        }

        public String getAddress() {
            return super.getString("address", "");
        }

        public long getInputMask() {
            return 0L;
        }

        public void setEventIndex(int ndx) {
            super.setInt("eventIndex", ndx);
        }

        public int getEventIndex() {
            return super.getInt("eventIndex", -1);
        }

        public boolean getIsFirstEvent() {
            return this.getEventIndex() == 0;
        }

        public void setIsLastEvent(boolean isLast) {
            super.setBoolean("lastEvent", isLast);
        }

        public boolean getIsLastEvent() {
            return super.getBoolean("lastEvent", false);
        }
    }

    public static class DeviceDescriptionComparator
    implements Comparator<FieldData> {
        private boolean ascending = true;

        public DeviceDescriptionComparator() {
            this(true);
        }

        public DeviceDescriptionComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(FieldData o1, FieldData o2) {
            String D1 = o1.getDeviceDescription();
            String D2 = o2.getDeviceDescription();
            return this.ascending ? D1.compareTo(D2) : D2.compareTo(D1);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof DeviceDescriptionComparator) {
                DeviceDescriptionComparator ddc = (DeviceDescriptionComparator)other;
                return this.ascending == ddc.ascending;
            }
            return false;
        }
    }
}

