/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.field;

import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class EventCountReport
extends ReportData {
    private static final String PROP_summarizeByDay = "summarizeByDay";
    private List<FieldData> rowData = null;
    private boolean summarizeByDay = false;

    public EventCountReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
    }

    @Override
    public void postInitialize() {
        RTProperties rtp = this.getProperties();
        this.summarizeByDay = rtp.getBoolean(PROP_summarizeByDay, false);
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return EventCountReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                Device device = devList.getDevice(devID);
                if (device == null) {
                    Print.logError((String)("Returned DeviceList 'Device' is null: " + devID), (Object[])new Object[0]);
                    continue;
                }
                long startTime = this.getTimeStart();
                long endTime = this.getTimeEnd();
                TimeZone tz = this.getTimeZone();
                if (this.summarizeByDay) {
                    long dayStart = startTime;
                    while (dayStart < endTime) {
                        DateTime dayDT = new DateTime(dayStart, tz);
                        long dayEnd = dayDT.getDayEnd(tz);
                        if (dayEnd > endTime) {
                            dayEnd = endTime;
                        }
                        long rcdCount = this.countEventData(device, dayStart, dayEnd);
                        FieldData fd = new FieldData();
                        fd.setDevice(device);
                        fd.setString("deviceId", devID);
                        fd.setLong("date", dayDT.getDayNumber(tz));
                        fd.setLong("count", rcdCount);
                        this.rowData.add(fd);
                        dayStart = dayEnd + 1L;
                    }
                    continue;
                }
                long rcdCount = this.countEventData(device, startTime, endTime);
                FieldData fd = new FieldData();
                fd.setDevice(device);
                fd.setString("deviceId", devID);
                fd.setLong("count", rcdCount);
                this.rowData.add(fd);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData count for Device: " + devID), (Object[])new Object[0]);
            }
        }
        FieldData.sortByDeviceDescription(this.rowData);
        return new ReportData.ListDataIterator(this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

