/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.event;

import java.util.Arrays;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.util.DateTime;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.event.EventDataLayout;
import org.opengts.war.tools.RequestProperties;

public class EventSummaryReport
extends ReportData {
    private static String PROP_minimumCheckInAge = "minimumCheckInAge";
    private long minCheckInAgeSec = 0L;

    public EventSummaryReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
    }

    @Override
    public void postInitialize() {
        ReportConstraints rc = this.getReportConstraints();
        rc.setTimeStart(-1L);
        this.minCheckInAgeSec = this.getProperties().getLong(PROP_minimumCheckInAge, 0L);
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return true;
    }

    @Override
    public boolean getSupportsKmlDisplay() {
        return true;
    }

    public static ReportLayout GetReportLayout() {
        return EventDataLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return EventSummaryReport.GetReportLayout();
    }

    @Override
    protected boolean isEventDataMatch(EventData ev) {
        if (this.minCheckInAgeSec > 0L) {
            Device dev = ev.getDevice();
            long lcTime = dev != null ? dev.getLastTotalConnectTime() : 0L;
            long lcAge = DateTime.getCurrentTimeSec() - lcTime;
            if (lcAge < this.minCheckInAgeSec) {
                return false;
            }
        }
        return true;
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        Object[] ed = this.getEventData(null);
        Arrays.sort(ed, new EventData.DeviceDescriptionComparator());
        return new ReportData.ArrayDataIterator(ed);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    @Override
    public EventData.LimitType getSelectionLimitType() {
        return EventData.LimitType.LAST;
    }

    @Override
    public long getSelectionLimit() {
        return 1L;
    }
}

