/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.event;

import java.util.Locale;
import java.util.TimeZone;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DCServerFactory;
import org.opengts.db.EntityManager;
import org.opengts.db.StatusCodeProvider;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtypes.DTOBDFault;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.PixelDimension;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.war.report.ColumnValue;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.tools.ComboOption;
import org.opengts.war.tools.MapDimension;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.PushpinIcon;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPageAdaptor;

public class EventDataLayout
extends ReportLayout {
    private static final long MINIMUM_REASONABLE_TIMESTAMP = new DateTime(null, 2000, 1, 1).getTimeSec();
    public static final String DATA_INDEX = "index";
    public static final String DATA_ATTACHMENT_URL = "attachURL";
    public static final String DATA_DEVICE_ID = "deviceId";
    public static final String DATA_DEVICE_DESC = "deviceDesc";
    public static final String DATA_DEVICE_BATTERY = "deviceBattery";
    public static final String DATA_DEVICE_VIN = "deviceVehicleID";
    public static final String DATA_DEVICE_CREATION = "deviceCreateDateTime";
    public static final String DATA_DATE = "date";
    public static final String DATA_TIME = "time";
    public static final String DATA_DATETIME = "dateTime";
    public static final String DATA_TIMESTAMP = "timestamp";
    public static final String DATA_GROUP_ID = "groupId";
    public static final String DATA_STATUS_CODE = "statusCode";
    public static final String DATA_STATUS_DESC = "statusDesc";
    public static final String DATA_PUSHPIN = "pushpin";
    public static final String DATA_GPS_AGE = "gpsAge";
    public static final String DATA_LATITUDE = "latitude";
    public static final String DATA_LONGITUDE = "longitude";
    public static final String DATA_GEOPOINT = "geoPoint";
    public static final String DATA_GPSFIX_TYPE = "gpsFixType";
    public static final String DATA_GPSFIX_STATUS = "gpsFixStatus";
    public static final String DATA_ACCURACY = "accuracy";
    public static final String DATA_ALTITUDE = "altitude";
    public static final String DATA_SATELLITES = "satellites";
    public static final String DATA_SPEED_LIMIT = "speedLimit";
    public static final String DATA_SPEED = "speed";
    public static final String DATA_SPEED_HEADING = "speedH";
    public static final String DATA_SPEED_UNITS = "speedU";
    public static final String DATA_HEADING = "heading";
    public static final String DATA_DISTANCE = "distance";
    public static final String DATA_ODOMETER = "odometer";
    public static final String DATA_REPORT_DISTANCE = "reportDistance";
    public static final String DATA_CELL_LATITUDE = "cellLatitude";
    public static final String DATA_CELL_LONGITUDE = "cellLongitude";
    public static final String DATA_CELL_GEOPOINT = "cellGeoPoint";
    public static final String DATA_CELL_ACCURACY = "cellAccuracy";
    public static final String DATA_BEST_LATITUDE = "bestLatitude";
    public static final String DATA_BEST_LONGITUDE = "bestLongitude";
    public static final String DATA_BEST_GEOPOINT = "bestGeoPoint";
    public static final String DATA_BEST_ACCURACY = "bestAccuracy";
    public static final String DATA_BATTERY = "battery";
    public static final String DATA_BATTERY_VOLTS = "batteryVolts";
    public static final String DATA_BATTERY_PERCENT = "batteryPercent";
    public static final String DATA_INPUT_STATE = "inputState";
    public static final String DATA_INPUT_BIT = "inputBit";
    public static final String DATA_OUTPUT_STATE = "outputState";
    public static final String DATA_OUTPUT_BIT = "outputBit";
    public static final String DATA_SEATBELT_STATE = "seatbeltState";
    public static final String DATA_SEATBELT_BIT = "seatbeltBit";
    public static final String DATA_ANALOG_0 = "analog0";
    public static final String DATA_ANALOG_1 = "analog1";
    public static final String DATA_ANALOG_2 = "analog2";
    public static final String DATA_ANALOG_3 = "analog3";
    public static final String DATA_PULSE_COUNT = "pulseCount";
    public static final String DATA_ADDRESS = "address";
    public static final String DATA_CITY = "city";
    public static final String DATA_STATE = "state";
    public static final String DATA_COUNTRY = "country";
    public static final String DATA_SUBDIVISION = "subdivision";
    public static final String DATA_GEOZONE_ID = "geozoneId";
    public static final String DATA_GEOZONE_DESC = "geozoneDesc";
    public static final String DATA_ENTITY_ID = "entityId";
    public static final String DATA_ENTITY_DESC = "entityDesc";
    public static final String DATA_DRIVER_ID = "driverId";
    public static final String DATA_DRIVER_DESC = "driverDesc";
    public static final String DATA_DRIVER_STATUS = "driverStatus";
    public static final String DATA_DRIVER_MESSAGE = "driverMessage";
    public static final String DATA_JOB_NUMBER = "jobNumber";
    public static final String DATA_RFID_TAG = "rfidTag";
    public static final String DATA_SAMPLE_INDEX = "sampleIndex";
    public static final String DATA_SAMPLE_ID = "sampleId";
    public static final String DATA_ETA_DATETIME = "etaDateTime";
    public static final String DATA_ETA_TIMESTAMP = "etaTimestamp";
    public static final String DATA_ETA_UNIQUE_ID = "etaUniqueID";
    public static final String DATA_ETA_DISTANCE = "etaDistance";
    public static final String DATA_ETA_LATITUDE = "etaLatitude";
    public static final String DATA_ETA_LONGITUDE = "etaLongitude";
    public static final String DATA_ETA_GEOPOINT = "etaGeoPoint";
    public static final String DATA_STOP_UNIQUE_ID = "stopUniqueID";
    public static final String DATA_STOP_STATUS = "stopStatus";
    public static final String DATA_STOP_STATUS_DESC = "stopStatusDesc";
    public static final String DATA_STOP_INDEX = "stopIndex";
    public static final String DATA_BAROMETER = "barometer";
    public static final String DATA_AMBIENT_TEMP = "ambientTemp";
    public static final String DATA_THERMO_1 = "thermo1";
    public static final String DATA_THERMO_2 = "thermo2";
    public static final String DATA_THERMO_3 = "thermo3";
    public static final String DATA_THERMO_4 = "thermo4";
    public static final String DATA_THERMO_5 = "thermo5";
    public static final String DATA_THERMO_6 = "thermo6";
    public static final String DATA_THERMO_7 = "thermo7";
    public static final String DATA_THERMO_8 = "thermo8";
    public static final String DATA_FUEL_LEVEL = "fuelLevel";
    public static final String DATA_FUEL_LEVEL_VOL = "fuelLevelVolume";
    public static final String DATA_FUEL_ECONOMY = "fuelEconomy";
    public static final String DATA_FUEL_ECONOMY_TYPE = "fuelEconomyType";
    public static final String DATA_FUEL_TOTAL = "fuelTotal";
    public static final String DATA_FUEL_REMAIN = "fuelRemain";
    public static final String DATA_FUEL_TRIP = "fuelTrip";
    public static final String DATA_FUEL_IDLE = "fuelIdle";
    public static final String DATA_FUEL_ENGINE_ON = "fuelEngineOn";
    public static final String DATA_FUEL_PRESSURE = "fuelPressure";
    public static final String DATA_FUEL_RATE = "fuelRate";
    public static final String DATA_FUEL_LEVEL_2 = "fuelLevel2";
    public static final String DATA_FUEL_LEVEL_VOL_2 = "fuelLevelVolume2";
    public static final String DATA_FAULT_CODES = "faultCodes";
    public static final String DATA_FAULT_CODE = "faultCode";
    public static final String DATA_MALFUNCTION_LAMP = "malfunctionLamp";
    public static final String DATA_OIL_LEVEL = "oilLevel";
    public static final String DATA_OIL_PRESSURE = "oilPressure";
    public static final String DATA_OIL_TEMP = "oilTemp";
    public static final String DATA_ENGINE_RPM = "engineRpm";
    public static final String DATA_ENGINE_HOURS = "engineHours";
    public static final String DATA_ENGINE_ON_HOURS = "engineOnHours";
    public static final String DATA_ENGINE_LOAD = "engineLoad";
    public static final String DATA_IDLE_HOURS = "idleHours";
    public static final String DATA_TRANS_OIL_TEMP = "transOilTemp";
    public static final String DATA_COOLANT_LEVEL = "coolantLevel";
    public static final String DATA_COOLANT_TEMP = "coolantTemp";
    public static final String DATA_BRAKE_G_FORCE = "brakeGForce";
    public static final String DATA_BRAKE_FORCE = "brakeForce";
    public static final String DATA_BRAKE_PRESSURE = "brakePressure";
    public static final String DATA_BRAKE_POSITION = "brakePos";
    public static final String DATA_ACCELERATION = "acceleration";
    public static final String DATA_PTO_ENGAGED = "ptoEngaged";
    public static final String DATA_PTO_HOURS = "ptoHours";
    public static final String DATA_VEH_BATTERY_VOLTS = "vBatteryVolts";
    public static final String DATA_THROTTLE_POSITION = "throttlePos";
    public static final String DATA_INTAKE_TEMP = "intakeTemp";
    public static final String DATA_AIR_PRESSURE = "airPressure";
    public static final String DATA_AIR_FILTER_PRESS = "airFilterPressure";
    public static final String DATA_MASS_AIR_FLOW = "massAirFlow";
    public static final String DATA_TURBO_PRESS = "turboPressure";
    public static final String DATA_TIRE_PRESSURE = "tirePressure";
    public static final String DATA_TIRE_TEMPERATURE = "tireTemp";
    public static final String DATA_TANK_LEVEL = "tankLevel";
    public static final String DATA_EVENT_FIELD = "eventField";
    public static final String DATA_CHECKIN_DATETIME = "checkinDateTime";
    public static final String DATA_CHECKIN_AGE = "checkinAge";
    public static final String DATA_CUSTOM_FIELD = "customField";
    public static final String DATA_LAST_BATTERY_PCT = "lastBatteryPercent";
    public static final String DATA_LAST_FAULT_CODES = "lastFaultCodes";
    public static final String DATA_FUEL_CAPACITY = "fuelCapacity";
    public static final String DATA_DATA_SOURCE = "dataSource";
    public static final String DATA_RAW_DATA = "rawData";
    public static final String DATA_CREATE_DATE = "createDate";
    public static final String DATA_CREATE_TIME = "createTime";
    public static final String DATA_CREATE_DATETIME = "createDateTime";
    public static final String DATA_CREATE_TIMESTAMP = "createTimestamp";
    public static final String DATA_CREATE_AGE = "createAge";
    public static final String DATA_CREATE_MILLIS = "createMillis";
    public static final String DATA_DAY_ENGINE_STARTS = "dayEngineStarts";
    public static final String DATA_DAY_IDLE_HOURS = "dayIdleHours";
    public static final String DATA_DAY_FUEL_IDLE = "dayFuelIdle";
    public static final String DATA_DAY_WORK_HOURS = "dayWorkHours";
    public static final String DATA_DAY_FUEL_WORK = "dayFuelWork";
    public static final String DATA_DAY_FUEL_PTO = "dayFuelPTO";
    public static final String DATA_DAY_FUEL_TOTAL = "dayFuelTotal";
    public static final String DATA_DAY_DISTANCE = "dayDistance";
    private static EventDataLayout reportDef = null;

    public static ReportLayout getReportLayout() {
        if (reportDef == null) {
            reportDef = new EventDataLayout();
        }
        return reportDef;
    }

    private EventDataLayout() {
        this.setDataRowTemplate(new EventDataRow());
    }

    protected static String formatDouble(double value, String arg, String dftFmt) {
        String fmt = dftFmt;
        if (StringTools.isBlank((String)arg)) {
            fmt = dftFmt;
        } else if (arg.startsWith("#")) {
            fmt = arg.substring(1);
        } else {
            switch (arg.charAt(0)) {
                case '0': {
                    fmt = "0";
                    break;
                }
                case '1': {
                    fmt = "0.0";
                    break;
                }
                case '2': {
                    fmt = "0.00";
                    break;
                }
                case '3': {
                    fmt = "0.000";
                    break;
                }
                case '4': {
                    fmt = "0.0000";
                    break;
                }
                case '5': {
                    fmt = "0.00000";
                    break;
                }
                case '6': {
                    fmt = "0.000000";
                    break;
                }
                case '7': {
                    fmt = "0.0000000";
                    break;
                }
                case '8': {
                    fmt = "0.00000000";
                    break;
                }
                case '9': {
                    fmt = "0.000000000";
                    break;
                }
                default: {
                    fmt = dftFmt;
                }
            }
        }
        return StringTools.format((double)value, (String)fmt);
    }

    protected static String formatTemperature(double thermoC, String arg, ReportData rd, String dft) {
        if (EventData.isValidTemperature((double)thermoC)) {
            Account a = rd.getAccount();
            double thermo = Account.getTemperatureUnits((Account)a).convertFromC(thermoC);
            String unitAbbr = Account.getTemperatureUnits((Account)a).toString(rd.getLocale());
            return EventDataLayout.formatDouble(thermo, arg, "0.0") + unitAbbr;
        }
        if (dft != null) {
            return dft;
        }
        I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
        String na = i18n.getString("EventDataLayout.notAvailable", "n/a");
        return "--";
    }

    protected static String formatKM(double dist, String arg, ReportData rd) {
        if (dist > 0.0) {
            dist = Account.getDistanceUnits((Account)rd.getAccount()).convertFromKM(dist);
            return EventDataLayout.formatDouble(dist, arg, "0");
        }
        return "";
    }

    protected static int getElapsedFormat(String arg, int dft) {
        if (StringTools.isBlank((String)arg)) {
            return dft;
        }
        if (arg.startsWith("-1")) {
            return -1;
        }
        if (arg.startsWith("0")) {
            return 0;
        }
        if (arg.startsWith("1")) {
            return 1;
        }
        if (arg.startsWith("2")) {
            return 2;
        }
        if (arg.startsWith("3")) {
            return 3;
        }
        if ((arg = arg.toLowerCase()).equals("ss") || arg.equals("s") || arg.startsWith("sec")) {
            return -1;
        }
        if (arg.equals("hhmmss") || arg.equals("hms") || arg.equals("hh:mm:ss")) {
            return 0;
        }
        if (arg.equals("hhmm") || arg.equals("hm") || arg.equals("hh:mm")) {
            return 1;
        }
        if (arg.equals("hhh.hh") || arg.equals("hh.hh") || arg.equals("h.hh")) {
            return 2;
        }
        if (arg.equals("hhh.h") || arg.equals("hh.h") || arg.equals("h.h")) {
            return 3;
        }
        return dft;
    }

    protected static String formatElapsedTime(long elapsedSec, int fmt) {
        return StringTools.formatElapsedSeconds((long)elapsedSec, (int)fmt);
    }

    protected static class EventDataRow
    extends DataRowTemplate {
        public EventDataRow() {
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_INDEX){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    if (rowNdx >= 0) {
                        String arg = rc.getArg();
                        if (StringTools.isBlank((String)arg)) {
                            return String.valueOf(rowNdx + 1);
                        }
                        if (arg.equalsIgnoreCase("map") || arg.equalsIgnoreCase("mapLink")) {
                            String ndxVal = String.valueOf(rowNdx + 1);
                            URIArg mapURL = rd.getMapURL();
                            if (mapURL != null) {
                                mapURL.addArg("showpp", rowNdx + 1);
                                mapURL.addArg("zoompp", rowNdx + 1);
                                RequestProperties reqState = rd.getRequestProperties();
                                MapDimension sz = rd.getMapWindowSize();
                                int W = sz.getWidth();
                                int H = sz.getHeight();
                                String encMapURL = WebPageAdaptor.EncodeURL(reqState, mapURL);
                                ColumnValue cv = new ColumnValue();
                                cv.setValue(" " + ndxVal + " ");
                                cv.setLinkURL("javascript:openResizableWindow('" + encMapURL + "','ReportMap'," + W + "," + H + ");", null);
                                return cv;
                            }
                            return ndxVal;
                        }
                        if (arg.charAt(0) == '0') {
                            return String.valueOf(rowNdx);
                        }
                        return String.valueOf(rowNdx + 1);
                    }
                    return "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    return "#";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ATTACHMENT_URL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    RequestProperties reqState = rd.getRequestProperties();
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    if (ed.hasAttachData()) {
                        int H;
                        PixelDimension dim = HTMLTools.getImageDimension((byte[])ed.getAttachData());
                        Print.logInfo((String)("Image Dim: " + dim), (Object[])new Object[0]);
                        String extn = HTMLTools.getExtensionFromMimeType((String)ed.getAttachType(), (String)"txt");
                        String dftURI = "./Attach." + extn;
                        URIArg attURL = new URIArg(dftURI, true);
                        attURL.addArg("d", ed.getDeviceID());
                        attURL.addArg("ts", ed.getTimestamp());
                        attURL.addArg("sc", "0x" + StringTools.toHexString((long)ed.getStatusCode(), (int)16));
                        int W = dim != null ? dim.getWidth() : 600;
                        int n = H = dim != null ? dim.getHeight() : 400;
                        if (W > 1024 || H > 1024) {
                            double scale;
                            if (W > 1024 && W > H) {
                                W = 1024;
                                scale = (double)H / (double)W;
                                if ((H = (int)Math.round((double)W * scale)) <= 0) {
                                    H = 1;
                                }
                            } else {
                                H = 1024;
                                scale = (double)W / (double)H;
                                if ((W = (int)Math.round((double)H * scale)) <= 0) {
                                    W = 1;
                                }
                            }
                        }
                        String encURL = WebPageAdaptor.EncodeURL(reqState, attURL);
                        ColumnValue cv = new ColumnValue();
                        cv.setValue(" " + extn + " ");
                        cv.setLinkURL("javascript:openResizableWindow('" + encURL + "','Attachment'," + W + "," + H + ");", null);
                        return cv;
                    }
                    return "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.attachment", "Attachment");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DEVICE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    String deviceID = ed.getDeviceID();
                    if (arg.startsWith("admin")) {
                        ColumnValue cv = new ColumnValue(deviceID);
                        RequestProperties reqState = rd.getRequestProperties();
                        URIArg devAdminURL = WebPageAdaptor.MakeURL(reqState.getBaseURI(), "dev.info");
                        devAdminURL.addArg("device", deviceID);
                        devAdminURL.addArg("page_cmd", "selectDev");
                        if (arg.equalsIgnoreCase("adminEdit")) {
                            devAdminURL.addArg("d_subedit", "edit");
                        } else {
                            devAdminURL.addArg("d_subview", "view");
                        }
                        cv.setLinkURL(devAdminURL.toString(), null);
                        return cv;
                    }
                    return deviceID;
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.deviceID", "Device-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DEVICE_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    if (dev != null) {
                        return dev.getDescription();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.deviceDescription", "Device\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DEVICE_BATTERY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    if (dev != null) {
                        double level = dev.getLastBatteryLevel();
                        if (level <= 0.0) {
                            return rc.getBlankFiller();
                        }
                        if (level <= 1.0) {
                            return Math.round(level * 100.0) + "%";
                        }
                        return EventDataLayout.formatDouble(level, arg, "0.0") + "v";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.deviceBattery", "Last\nBattery");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DEVICE_VIN){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    if (dev != null) {
                        return dev.getVehicleID();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.deviceVehicleID", "Vehicle ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DEVICE_CREATION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    long ts = dev.getCreationTime();
                    if (ts > MINIMUM_REASONABLE_TIMESTAMP) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                        return cv;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.deviceCreationTime", "Device Create\nTime");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_GROUP_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    if (dev != null) {
                        String gid = dev.getGroupID();
                        return gid;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.groupID", "Group-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getTimestamp();
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateFormat(rd.getPrivateLabel()), tz);
                        return new ColumnValue(dtFmt).setSortKey(ts);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.date", "Date");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_TIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getTimestamp();
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        return dt.format(rl.getTimeFormat(rd.getPrivateLabel()), tz);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.time", "Time");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getTimestamp();
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        return new ColumnValue(dtFmt).setSortKey(ts);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dateTime", "Date/Time") + "\n${timezone}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getTimestamp();
                    return String.valueOf(ts);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.timestamp", "Timestamp") + "\n(Epoch)";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CREATE_DATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getCreationTime();
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateFormat(rd.getPrivateLabel()), tz);
                        long ca = ed.getCreationAge();
                        ReportLayout.AgeColorRange acr = rd.getCreationAgeColorRange(ca);
                        ColumnValue ccv = new ColumnValue(dtFmt).setSortKey(ts);
                        return ReportLayout.SetColumnValueAgeColor(ccv, acr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.createDate", "Insert\nDate");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CREATE_TIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getCreationTime();
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getTimeFormat(rd.getPrivateLabel()), tz);
                        long ca = ed.getCreationAge();
                        ReportLayout.AgeColorRange acr = rd.getCreationAgeColorRange(ca);
                        ColumnValue ccv = new ColumnValue(dtFmt).setSortKey(ts);
                        return ReportLayout.SetColumnValueAgeColor(ccv, acr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.createTime", "insert\nTime");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CREATE_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getCreationTime();
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        long ca = ed.getCreationAge();
                        ReportLayout.AgeColorRange acr = rd.getCreationAgeColorRange(ca);
                        ColumnValue ccv = new ColumnValue(dtFmt).setSortKey(ts);
                        return ReportLayout.SetColumnValueAgeColor(ccv, acr);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.createDateTime", "Insert\nDate/Time") + "\n${timezone}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CREATE_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getCreationTime();
                    long ca = ed.getCreationAge();
                    ReportLayout.AgeColorRange acr = rd.getCreationAgeColorRange(ca);
                    ColumnValue ccv = new ColumnValue(ts).setSortKey(ts);
                    return ReportLayout.SetColumnValueAgeColor(ccv, acr);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.createTimestamp", "Insert\nTimestamp") + "\n(Epoch)";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CREATE_AGE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ca = ed.getCreationAge();
                    int fmt = EventDataLayout.getElapsedFormat(arg, 0);
                    String caFmt = EventDataLayout.formatElapsedTime(ca, fmt);
                    ReportLayout.AgeColorRange acr = rd.getCreationAgeColorRange(ca);
                    ColumnValue ccv = new ColumnValue(caFmt).setSortKey(ca);
                    return ReportLayout.SetColumnValueAgeColor(ccv, acr);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.createAge", "Creation Age");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CREATE_MILLIS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getCreationMillis();
                    if (!StringTools.isBlank((String)arg)) {
                        if (arg.equalsIgnoreCase("frac") || arg.equalsIgnoreCase("fraction")) {
                            ts %= 1000L;
                        } else if (arg.equalsIgnoreCase("sec") || arg.equalsIgnoreCase("seconds")) {
                            ts /= 1000L;
                        }
                    }
                    return String.valueOf(ts);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.createMillis", "Creation\nMillisecond");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_STATUS_CODE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg()).toLowerCase();
                    EventData ed = (EventData)obj;
                    int sc = ed.getStatusCode();
                    if (StringTools.isBlank((String)arg) || arg.indexOf("color") >= 0) {
                        String scCode = arg.startsWith("dec") ? String.valueOf(sc) : "0x" + StringTools.toHexString((long)sc, (int)16);
                        StatusCodeProvider scp = ed.getStatusCodeProvider((BasicPrivateLabel)rd.getPrivateLabel());
                        if (scp == null) {
                            return scCode;
                        }
                        if (StringTools.isBlank((String)scp.getForegroundColor()) && StringTools.isBlank((String)scp.getBackgroundColor())) {
                            return scCode;
                        }
                        ColumnValue cv = new ColumnValue();
                        cv.setValue(scCode);
                        cv.setForegroundColor(scp.getForegroundColor());
                        cv.setBackgroundColor(scp.getBackgroundColor());
                        return cv;
                    }
                    if (arg.startsWith("dec")) {
                        return String.valueOf(sc);
                    }
                    return "0x" + StringTools.toHexString((long)sc, (int)16);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.statusCode", "Status#");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_STATUS_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    if (StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("color")) {
                        StatusCodeProvider scp = ed.getStatusCodeProvider((BasicPrivateLabel)rd.getPrivateLabel());
                        if (scp == null) {
                            String scDesc = "0x" + StringTools.toHexString((long)ed.getStatusCode(), (int)16);
                            return scDesc;
                        }
                        String scDesc = scp.getDescription(rd.getLocale());
                        String scFG = scp.getForegroundColor();
                        String scBG = scp.getBackgroundColor();
                        if (StringTools.isBlank((String)scFG) && StringTools.isBlank((String)scBG)) {
                            return scDesc;
                        }
                        ColumnValue cv = new ColumnValue();
                        cv.setValue(scDesc);
                        cv.setForegroundColor(scFG);
                        cv.setBackgroundColor(scBG);
                        return cv;
                    }
                    String scDesc = ed.getStatusCodeDescription((BasicPrivateLabel)rd.getPrivateLabel());
                    return scDesc;
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.statusDescription", "Status");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_PUSHPIN){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    RequestProperties reqState = rd.getRequestProperties();
                    PrivateLabel bpl = rd.getPrivateLabel();
                    OrderedSet<String> iconKeys = reqState.getMapProviderIconKeys();
                    int ppNdx = ed.getPushpinIconIndex(null, iconKeys, false, (BasicPrivateLabel)bpl);
                    PushpinIcon ppi = reqState.getPushpinIcon(ppNdx);
                    String iconURL = ppi != null ? ppi.getIconEvalURL(ed, rowNdx) : "";
                    ColumnValue cv = new ColumnValue().setImageURL(iconURL);
                    return cv;
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.pushpin", "Pushpin");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ENTITY_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getEntityID();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.entityID", "Entity-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ENTITY_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    String aid = ed.getAccountID();
                    String eid = ed.getEntityID();
                    return Device.getEntityDescription((String)aid, (String)eid, (int)EntityManager.EntityType.TRAILER.getIntValue());
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.entityDescription", "Entity\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DRIVER_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getDriverID();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.driverID", "Driver-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DRIVER_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    String drvID = ed.getDriverID();
                    if (StringTools.isBlank((String)drvID)) {
                        Device dev = ed.getDevice();
                        drvID = dev != null ? dev.getDriverID() : null;
                    }
                    String desc = drvID;
                    if (!StringTools.isBlank((String)drvID)) {
                        try {
                            Driver driver = Driver.getDriver((Account)ed.getAccount(), (String)drvID);
                            desc = driver != null ? driver.getDescription() : drvID;
                        }
                        catch (DBException dbe) {
                            desc = drvID;
                        }
                    }
                    return desc;
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.driverDescription", "Driver\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DRIVER_STATUS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg());
                    EventData ed = (EventData)obj;
                    long drvStat = ed.getDriverStatus();
                    if (drvStat <= 0L) {
                        return rc.getBlankFiller();
                    }
                    if (StringTools.isBlank((String)arg) || arg.equalsIgnoreCase("desc")) {
                        Driver.DutyStatus ds = Driver.getDutyStatus((long)drvStat);
                        if (ds != null) {
                            return ds.toString(rd.getLocale());
                        }
                        return String.valueOf(drvStat);
                    }
                    return String.valueOf(drvStat);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.driverStatus", "Driver\nStatus");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DRIVER_MESSAGE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getDriverMessage();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.driverMessage", "Driver\nMessage");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_JOB_NUMBER){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getJobNumber();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.jobNumber", "Job\nNumber");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_RFID_TAG){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getRfidTag();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.rfidTag", "RFID/Bar\nCode");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SAMPLE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getSampleID();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.sampleID", "Sample\nID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SAMPLE_INDEX){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return String.valueOf(ed.getSampleIndex());
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.sampleIndex", "Sample\nIndex");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ETA_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getEtaTimestamp();
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        return new ColumnValue(dtFmt).setSortKey(ts);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.etaDateTime", "ETA\nDate/Time") + "\n${timezone}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ETA_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getEtaTimestamp();
                    return String.valueOf(ts);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.etaTimestamp", "ETA\nTimestamp") + "\n(Epoch)";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ETA_UNIQUE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long ts = ed.getEtaUniqueID();
                    return String.valueOf(ts);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.etaUniqueID", "ETA\nUniqueID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ETA_DISTANCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double dist = ed.getEtaDistanceKM();
                    if (dist > 0.0) {
                        return EventDataLayout.formatKM(dist, arg, rd);
                    }
                    return EventDataLayout.formatKM(dist, arg, rd);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.etaDistance", "ETA\nDistance") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ETA_LATITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lat = ed.getEtaLatitude();
                    arg = StringTools.trim((String)arg);
                    String valStr = "";
                    Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                    if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                        valStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                    } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                        valStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                    } else {
                        String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                        valStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                    }
                    if (!StringTools.isBlank((String)valStr)) {
                        return valStr;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.etaLat", "ETA\nLat");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ETA_LONGITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lon = ed.getEtaLongitude();
                    arg = StringTools.trim((String)arg);
                    String valStr = "";
                    Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                    if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                        valStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                    } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                        valStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                    } else {
                        String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                        valStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                    }
                    if (!StringTools.isBlank((String)valStr)) {
                        return valStr;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.etaLon", "ETA Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ETA_GEOPOINT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    double lon;
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lat = ed.getEtaLatitude();
                    if (GeoPoint.isValid((double)lat, (double)(lon = ed.getEtaLongitude()))) {
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        }
                        if (!StringTools.isBlank((String)valStr)) {
                            return valStr;
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.etaLatLon", "ETA Lat/Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_STOP_UNIQUE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long id = ed.getStopID();
                    return String.valueOf(id);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.stopUniqueID", "Stop\nUniqueID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_STOP_STATUS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long sst = ed.getStopStatus();
                    return String.valueOf(sst);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.stopStatus", "Stop\nStatus");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_STOP_STATUS_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    int sst = ed.getStopStatus();
                    return DCServerFactory.Garmin_getStopStatusDescription((Locale)locale, (int)sst);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.stopStatusDesc", "Stop\nStatus");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_STOP_INDEX){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    int ndx = ed.getStopIndex();
                    return String.valueOf(ndx);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.stopIndex", "Stop\nIndex");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_GPS_AGE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long gpsAge = ed.getGpsAge();
                    ReportLayout.AgeColorRange acr = rd.getGpsAgeColorRange(gpsAge);
                    if (acr != null) {
                        ColumnValue gcv = new ColumnValue(gpsAge);
                        return ReportLayout.SetColumnValueAgeColor(gcv, acr);
                    }
                    return String.valueOf(gpsAge);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.gpsAge", "GPS\nAge");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_LATITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lat = ed.getLatitude();
                    arg = StringTools.trim((String)arg);
                    String valStr = "";
                    Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                    if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                        valStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                    } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                        valStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                    } else {
                        String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                        valStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                    }
                    long gpsAge = ed.getGpsAge();
                    ReportLayout.AgeColorRange acr = rd.getGpsAgeColorRange(gpsAge);
                    if (acr != null) {
                        ColumnValue gcv = new ColumnValue(valStr);
                        return ReportLayout.SetColumnValueAgeColor(gcv, acr);
                    }
                    if (!StringTools.isBlank((String)valStr)) {
                        return valStr;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.lat", "Lat");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_LONGITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lon = ed.getLongitude();
                    arg = StringTools.trim((String)arg);
                    String valStr = "";
                    Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                    if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                        valStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                    } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                        valStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                    } else {
                        String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                        valStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                    }
                    long gpsAge = ed.getGpsAge();
                    ReportLayout.AgeColorRange acr = rd.getGpsAgeColorRange(gpsAge);
                    if (acr != null) {
                        ColumnValue gcv = new ColumnValue(valStr);
                        return ReportLayout.SetColumnValueAgeColor(gcv, acr);
                    }
                    if (!StringTools.isBlank((String)valStr)) {
                        return valStr;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.lon", "Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_GEOPOINT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    double lon;
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lat = ed.getLatitude();
                    if (GeoPoint.isValid((double)lat, (double)(lon = ed.getLongitude()))) {
                        String latStr;
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            latStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            latStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            String latStr2 = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                            valStr = latStr2 + "/" + lonStr;
                        }
                        long gpsAge = ed.getGpsAge();
                        ReportLayout.AgeColorRange acr = rd.getGpsAgeColorRange(gpsAge);
                        if (acr != null) {
                            ColumnValue gcv = new ColumnValue(valStr);
                            return ReportLayout.SetColumnValueAgeColor(gcv, acr);
                        }
                        if (!StringTools.isBlank((String)valStr)) {
                            return valStr;
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.latLon", "Lat/Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_GPSFIX_TYPE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    return ed.getGpsFixTypeDescription(locale);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.gpsFixType", "Fix Type");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_GPSFIX_STATUS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg()).toLowerCase();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    long fixStat = ed.getGpsFixStatus();
                    if (arg.equalsIgnoreCase("dec")) {
                        return String.valueOf(fixStat);
                    }
                    if (arg.equalsIgnoreCase("hex")) {
                        return "0x" + StringTools.toHexString((long)fixStat, (int)16);
                    }
                    if (arg.equalsIgnoreCase("bin")) {
                        return "b" + StringTools.toBinaryString((long)fixStat, (int)32, null).toString();
                    }
                    return String.valueOf(fixStat);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.gpsFixStatus", "Fix Status");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ACCURACY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double acc = ed.getHorzAccuracy();
                    if (acc > 0.0) {
                        Account.AltitudeUnits altUnits = Account.getAltitudeUnits((Account)rd.getAccount());
                        acc = altUnits.convertFromMeters(acc);
                        return EventDataLayout.formatDouble(acc, arg, "0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.accuracy", "Accuracy") + "\n${accuracyUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ALTITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Account.AltitudeUnits altUnits = Account.getAltitudeUnits((Account)rd.getAccount());
                    double alt = altUnits.convertFromMeters(ed.getAltitude());
                    return EventDataLayout.formatDouble(alt, arg, "0");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.altitude", "Altitude") + "\n${altitudeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SPEED_LIMIT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kph = ed.getSpeedLimitKPH();
                    if (kph > 0.0) {
                        Account a = rd.getAccount();
                        double speed = Account.getSpeedUnits((Account)a).convertFromKPH(kph);
                        return EventDataLayout.formatDouble(speed, arg, "0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.speedLimit", "Speed Limit") + "\n${speedUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SPEED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kph = ed.getSpeedKPH();
                    if (kph > 0.0) {
                        Account a = rd.getAccount();
                        double speed = Account.getSpeedUnits((Account)a).convertFromKPH(kph);
                        return EventDataLayout.formatDouble(speed, arg, "0");
                    }
                    return "0   ";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.speed", "Speed") + "\n${speedUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SPEED_HEADING){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kph = ed.getSpeedKPH();
                    if (kph > 0.0) {
                        Account a = rd.getAccount();
                        double speed = Account.getSpeedUnits((Account)a).convertFromKPH(kph);
                        String speedStr = EventDataLayout.formatDouble(speed, arg, "0");
                        String headStr = GeoPoint.GetHeadingString((double)ed.getHeading(), (Locale)rd.getLocale()).toUpperCase();
                        if (headStr.length() == 1) {
                            headStr = headStr + " ";
                        }
                        return speedStr + " " + headStr;
                    }
                    return "0   ";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.speed", "Speed") + "\n${speedUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SPEED_UNITS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kph = ed.getSpeedKPH();
                    if (kph > 0.0) {
                        Account a = rd.getAccount();
                        String unitAbbr = Account.getSpeedUnits((Account)a).toString(rd.getLocale());
                        double speed = Account.getSpeedUnits((Account)a).convertFromKPH(kph);
                        String speedStr = EventDataLayout.formatDouble(speed, arg, "0");
                        String headStr = GeoPoint.GetHeadingString((double)ed.getHeading(), (Locale)rd.getLocale()).toUpperCase();
                        if (headStr.length() == 1) {
                            headStr = headStr + " ";
                        }
                        return speedStr + unitAbbr + " " + headStr;
                    }
                    return "0    ";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.speed", "Speed");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_HEADING){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kph = ed.getSpeedKPH();
                    if (kph > 0.0) {
                        double heading = ed.getHeading();
                        if (!StringTools.isBlank((String)arg)) {
                            return EventDataLayout.formatDouble(heading, arg, "0");
                        }
                        return GeoPoint.GetHeadingString((double)heading, (Locale)rd.getLocale()).toUpperCase();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    return GeoPoint.GetHeadingTitle((Locale)rd.getLocale());
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SATELLITES){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    int satCount = ed.getSatelliteCount();
                    if (satCount > 0) {
                        return String.valueOf(satCount);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.satelliteCount", "Sat\nCount");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DISTANCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double dist = ed.getDistanceKM();
                    if (dist > 0.0) {
                        return EventDataLayout.formatKM(dist, arg, rd);
                    }
                    return EventDataLayout.formatKM(dist, arg, rd);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.distance", "Distance") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ODOMETER){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    double odom = ed.getOdometerKM();
                    if (odom > 0.0) {
                        odom = ed.getOdometerWithOffsetKM();
                    } else {
                        odom = ed.getDistanceKM();
                        odom += ed.getOdometerOffsetKM(null);
                    }
                    return EventDataLayout.formatKM(odom, arg, rd);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.odometer", "Odometer") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_REPORT_DISTANCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    double dist = ed.getReportDistanceKM();
                    if (dist > 0.0) {
                        return EventDataLayout.formatKM(dist, arg, rd);
                    }
                    return EventDataLayout.formatKM(dist, arg, rd);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.reportDistance", "Report\nDistance") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CELL_LATITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lat = ed.getCellLatitude();
                    arg = StringTools.trim((String)arg);
                    String valStr = "";
                    Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                    if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                        valStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                    } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                        valStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                    } else {
                        String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                        valStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                    }
                    if (!StringTools.isBlank((String)valStr)) {
                        return valStr;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.cellLat", "Cell\nLat");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CELL_LONGITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lon = ed.getCellLongitude();
                    arg = StringTools.trim((String)arg);
                    String valStr = "";
                    Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                    if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                        valStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                    } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                        valStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                    } else {
                        String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                        valStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                    }
                    if (!StringTools.isBlank((String)valStr)) {
                        return valStr;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.cellLon", "Cell\nLon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CELL_GEOPOINT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    double lon;
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lat = ed.getCellLatitude();
                    if (GeoPoint.isValid((double)lat, (double)(lon = ed.getCellLongitude()))) {
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        }
                        if (!StringTools.isBlank((String)valStr)) {
                            return valStr;
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.cellLatLon", "Cell\nLat/Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CELL_ACCURACY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double acc = ed.getCellAccuracy();
                    if (acc > 0.0) {
                        Account.AltitudeUnits altUnits = Account.getAltitudeUnits((Account)rd.getAccount());
                        acc = altUnits.convertFromMeters(acc);
                        return EventDataLayout.formatDouble(acc, arg, "0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.cellAccuracy", "Cell Accuracy") + "\n${accuracyUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BEST_LATITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lat = ed.getBestLatitude();
                    arg = StringTools.trim((String)arg);
                    String valStr = "";
                    Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                    if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                        valStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                    } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                        valStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                    } else {
                        String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                        valStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                    }
                    if (!StringTools.isBlank((String)valStr)) {
                        return valStr;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.bestLat", "Lat");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BEST_LONGITUDE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lon = ed.getBestLongitude();
                    arg = StringTools.trim((String)arg);
                    String valStr = "";
                    Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                    if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                        valStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                    } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                        valStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                    } else {
                        String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                        valStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                    }
                    if (!StringTools.isBlank((String)valStr)) {
                        return valStr;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.bestLon", "Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BEST_GEOPOINT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    double lon;
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double lat = ed.getBestLatitude();
                    if (GeoPoint.isValid((double)lat, (double)(lon = ed.getBestLongitude()))) {
                        arg = StringTools.trim((String)arg);
                        String valStr = "";
                        Account.LatLonFormat latlonFmt = Account.getLatLonFormat((Account)rd.getAccount());
                        if (arg.equalsIgnoreCase("DMS") || StringTools.isBlank((String)arg) && latlonFmt.isDegMinSec()) {
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)"DMS", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DMS", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else if (arg.equalsIgnoreCase("DM") || StringTools.isBlank((String)arg) && latlonFmt.isDegMin()) {
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)"DM", (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)"DM", (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        } else {
                            String fmt = StringTools.isBlank((String)arg) ? "4" : arg;
                            String latStr = GeoPoint.formatLatitude((double)lat, (String)fmt, (Locale)locale);
                            String lonStr = GeoPoint.formatLongitude((double)lon, (String)fmt, (Locale)locale);
                            valStr = latStr + "/" + lonStr;
                        }
                        if (!StringTools.isBlank((String)valStr)) {
                            return valStr;
                        }
                        return rc.getBlankFiller();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.bestLatLon", "Lat/Lon");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BEST_ACCURACY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Locale locale = rd.getLocale();
                    double acc = ed.getBestAccuracy();
                    if (acc > 0.0) {
                        Account.AltitudeUnits altUnits = Account.getAltitudeUnits((Account)rd.getAccount());
                        acc = altUnits.convertFromMeters(acc);
                        return EventDataLayout.formatDouble(acc, arg, "0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.bestAccuracy", "Accuracy") + "\n${accuracyUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_INPUT_STATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    int blen;
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    int input = (int)ed.getInputMask();
                    String s = StringTools.toBinaryString((int)input);
                    int slen = s.length();
                    int len = slen >= (blen = StringTools.parseInt((String)arg, (int)8)) ? slen - blen : 0;
                    return s.substring(len, slen);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.inputBitMask", "Inputs\n(BitMask)");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_INPUT_BIT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    int argBit = StringTools.parseInt((String)rc.getArg(), (int)0);
                    EventData ed = (EventData)obj;
                    int input = (int)ed.getInputMask();
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    if ((input & 1 << argBit) != 0) {
                        return i18n.getString("EventDataLayout.bitTrue", "On");
                    }
                    return i18n.getString("EventDataLayout.bitFalse", "Off");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    int argBit = StringTools.parseInt((String)rc.getArg(), (int)0);
                    String bitStr = String.valueOf(argBit);
                    return i18n.getString("EventDataLayout.inputBitValue", "Input\n#{0}", (Object)bitStr);
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_OUTPUT_STATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    int blen;
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    int output = (int)ed.getOutputMask();
                    String s = StringTools.toBinaryString((int)output);
                    int slen = s.length();
                    int len = slen >= (blen = StringTools.parseInt((String)arg, (int)8)) ? slen - blen : 0;
                    return s.substring(len, slen);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.outputBitMask", "Outputs\n(BitMask)");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_OUTPUT_BIT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    int argBit = StringTools.parseInt((String)rc.getArg(), (int)0);
                    EventData ed = (EventData)obj;
                    int output = (int)ed.getOutputMask();
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    if ((output & 1 << argBit) != 0) {
                        return i18n.getString("EventDataLayout.bitTrue", "On");
                    }
                    return i18n.getString("EventDataLayout.bitFalse", "Off");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    int argBit = StringTools.parseInt((String)rc.getArg(), (int)0);
                    String bitStr = String.valueOf(argBit);
                    return i18n.getString("EventDataLayout.outputBitValue", "Output\n#{0}", (Object)bitStr);
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SEATBELT_STATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    int blen;
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    int seatbelt = (int)ed.getSeatbeltMask();
                    String s = StringTools.toBinaryString((int)seatbelt);
                    int slen = s.length();
                    int len = slen >= (blen = StringTools.parseInt((String)arg, (int)4)) ? slen - blen : 0;
                    return s.substring(len, slen);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.seatbeltBitMask", "Seatbelts\n(BitMask)");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SEATBELT_BIT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    int argBit = StringTools.parseInt((String)rc.getArg(), (int)0);
                    EventData ed = (EventData)obj;
                    int seatbelt = (int)ed.getSeatbeltMask();
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    if ((seatbelt & 1 << argBit) != 0) {
                        return i18n.getString("EventDataLayout.bitTrue", "On");
                    }
                    return i18n.getString("EventDataLayout.bitFalse", "Off");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    int argBit = StringTools.parseInt((String)rc.getArg(), (int)0);
                    String bitStr = String.valueOf(argBit);
                    return i18n.getString("EventDataLayout.seatbeltBitValue", "Seatbelt\n#{0}", (Object)bitStr);
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_GEOZONE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getGeozoneID();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.geozoneID", "Geozone-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_GEOZONE_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getGeozoneDescription();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.geozoneDescription", "Geozone\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ADDRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getAddress();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    Object addrTitle;
                    RequestProperties reqState = rd.getRequestProperties();
                    Object[] addrTitles = reqState != null ? reqState.getAddressTitles() : null;
                    Object object = addrTitle = ListTools.size((Object[])addrTitles) > 0 ? addrTitles[0] : null;
                    if (!StringTools.isBlank((String)addrTitle)) {
                        return addrTitle;
                    }
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.address", "Address");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CITY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getCity();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.city", "City");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_STATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getStateProvince();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.stateProvince", "State\nProvince");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_COUNTRY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getCountry();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.country", "Country");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_SUBDIVISION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getSubdivision();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.subdivision", "Subdivision");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BAROMETER){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kPa = ed.getBarometer();
                    if (kPa > 0.0) {
                        double pressure = Account.PressureUnits.MMHG.convertFromKPa(kPa);
                        return EventDataLayout.formatDouble(pressure, arg, "0.00");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.barometer", "Barometer") + "\nmmHg";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_AMBIENT_TEMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double thermo = ed.getAmbientTemp();
                    String tempS = EventDataLayout.formatTemperature(thermo, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(thermo * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.ambientTemp", "Ambient\nTemp");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THERMO_1){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tempC = ed.getThermoAverage(0);
                    String tempS = EventDataLayout.formatTemperature(tempC, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(tempC * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.temperature", "Temp") + "\n#1";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THERMO_2){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tempC = ed.getThermoAverage(1);
                    String tempS = EventDataLayout.formatTemperature(tempC, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(tempC * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.temperature", "Temp") + "\n#2";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THERMO_3){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tempC = ed.getThermoAverage(2);
                    String tempS = EventDataLayout.formatTemperature(tempC, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(tempC * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.temperature", "Temp") + "\n#3";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THERMO_4){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tempC = ed.getThermoAverage(3);
                    String tempS = EventDataLayout.formatTemperature(tempC, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(tempC * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.temperature", "Temp") + "\n#4";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THERMO_5){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tempC = ed.getThermoAverage(4);
                    String tempS = EventDataLayout.formatTemperature(tempC, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(tempC * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.temperature", "Temp") + "\n#5";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THERMO_6){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tempC = ed.getThermoAverage(5);
                    String tempS = EventDataLayout.formatTemperature(tempC, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(tempC * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.temperature", "Temp") + "\n#6";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THERMO_7){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tempC = ed.getThermoAverage(6);
                    String tempS = EventDataLayout.formatTemperature(tempC, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(tempC * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.temperature", "Temp") + "\n#7";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THERMO_8){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tempC = ed.getThermoAverage(7);
                    String tempS = EventDataLayout.formatTemperature(tempC, arg, rd, null);
                    return new ColumnValue(tempS).setSortKey((long)(tempC * 100.0));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.temperature", "Temp") + "\n#8";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BATTERY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double level = ed.getBatteryLevel();
                    double volts = ed.getBatteryVolts();
                    if (level > 0.0) {
                        if (level <= 1.0) {
                            return Math.round(level * 100.0) + "%";
                        }
                        return EventDataLayout.formatDouble(level, arg, "0.0") + "v";
                    }
                    if (volts > 0.0) {
                        return EventDataLayout.formatDouble(volts, arg, "0.0") + "v";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.BatteryLevel", "Battery\nLevel");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BATTERY_VOLTS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double level = ed.getBatteryVolts();
                    if (level > 0.0) {
                        return EventDataLayout.formatDouble(level, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.BatteryVolts", "Battery\nVolts");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BATTERY_PERCENT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double level = ed.getBatteryLevel();
                    if (level > 0.0) {
                        double pct100 = level <= 1.0 ? level * 100.0 : level;
                        return Math.round(pct100) + "%";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.BatteryPercent", "Battery\n%");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_LAST_BATTERY_PCT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    double level = dev.getLastBatteryLevel();
                    if (level > 0.0) {
                        double pct100 = level <= 1.0 ? level * 100.0 : level;
                        return Math.round(pct100) + "%";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.latestBatteryPercent", "Latest\nBatt %");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ANALOG_0){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double level = ed.getAnalog0();
                    return EventDataLayout.formatDouble(level, arg, "0.0");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.analog0", "Analog 0");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ANALOG_1){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double level = ed.getAnalog1();
                    return EventDataLayout.formatDouble(level, arg, "0.0");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.analog1", "Analog 1");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ANALOG_2){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double level = ed.getAnalog2();
                    return EventDataLayout.formatDouble(level, arg, "0.0");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.analog2", "Analog 2");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ANALOG_3){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double level = ed.getAnalog3();
                    return EventDataLayout.formatDouble(level, arg, "0.0");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.analog3", "Analog 3");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_PULSE_COUNT){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double pc = ed.getPulseCount();
                    return EventDataLayout.formatDouble(pc, arg, "0.0");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.pulseCount", "Pulse\nCount");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_CAPACITY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    double vol = dev.getFuelCapacity();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelCapacity", "Fuel Capacity") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_LEVEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double fuelLevel = ed.getFuelLevel(true);
                    if (fuelLevel > 0.0) {
                        return Math.round(fuelLevel * 100.0) + "%";
                    }
                    if (fuelLevel < 0.0) {
                        I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                        return i18n.getString("EventDataLayout.notAvailable", "n/a");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelPercent", "Fuel%");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_LEVEL_VOL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    double capacity = dev.getFuelCapacity();
                    double percent = ed.getFuelLevel(true);
                    if (percent <= 0.0 && capacity <= 0.0) {
                        return rc.getBlankFiller();
                    }
                    if (capacity <= 0.0) {
                        I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                        return i18n.getString("EventDataLayout.notAvailable", "n/a");
                    }
                    double liters = capacity * percent;
                    double vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(liters);
                    return EventDataLayout.formatDouble(vol, arg, "0.0");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelLevelVolume", "Fuel Vol") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_TOTAL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getFuelTotal();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelTotal", "Total Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_REMAIN){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getFuelRemain(true);
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelRemain", "Remaining Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_TRIP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getFuelTrip();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelTrip", "Trip Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_IDLE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getFuelIdle();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelIdle", "Idle Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_ENGINE_ON){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getFuelEngineOn();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelEngineOn", "Engine On Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_ECONOMY){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double econ = ed.getFuelEconomy();
                    if (econ > 0.0) {
                        econ = Account.getEconomyUnits((Account)rd.getAccount()).convertFromKPL(econ);
                        return EventDataLayout.formatDouble(econ, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelEcon", "Fuel Econ") + "\n${economyUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_ECONOMY_TYPE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg());
                    EventData ed = (EventData)obj;
                    Device.FuelEconomyType econType = Device.FuelEconomyType.EVENT_ECONOMY;
                    Locale locale = rd.getPrivateLabel().getLocale();
                    String typeStr = arg.equalsIgnoreCase("abbr") ? econType.getAbbrev(locale) : econType.toString(locale);
                    return typeStr;
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelEconType", "Fuel Econ\nType");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_PRESSURE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kPa = ed.getFuelPressure();
                    if (kPa != 0.0) {
                        double pressure = Account.getPressureUnits((Account)rd.getAccount()).convertFromKPa(kPa);
                        return EventDataLayout.formatDouble(pressure, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelPressure", "Fuel Press.") + "\n${pressureUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_RATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double lph = ed.getFuelUsage();
                    if (lph != 0.0) {
                        double rate = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(lph);
                        return EventDataLayout.formatDouble(rate, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelRate", "Fuel Rate") + "\n${volumeUnits}/Hr";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_LEVEL_2){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double fuelLevel = ed.getFuelLevel2();
                    if (fuelLevel > 0.0) {
                        return Math.round(fuelLevel * 100.0) + "%";
                    }
                    if (fuelLevel < 0.0) {
                        I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                        return i18n.getString("EventDataLayout.notAvailable", "n/a");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelPercent2", "Fuel2%");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FUEL_LEVEL_VOL_2){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    double capacity = dev.getFuelCapacity();
                    double percent = ed.getFuelLevel2();
                    if (percent <= 0.0 && capacity <= 0.0) {
                        return rc.getBlankFiller();
                    }
                    if (capacity <= 0.0) {
                        I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                        return i18n.getString("EventDataLayout.notAvailable", "n/a");
                    }
                    double liters = capacity * percent;
                    double vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(liters);
                    return EventDataLayout.formatDouble(vol, arg, "0.0");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.fuelLevelVolume2", "Fuel Vol 2") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_PTO_ENGAGED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    boolean pto = ed.getPtoEngaged();
                    return ComboOption.getYesNoText(rd.getLocale(), pto);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.ptoEngaged", "PTO\nEngaged");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_PTO_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double hours = ed.getPtoHours();
                    if (hours > 0.0) {
                        return EventDataLayout.formatDouble(hours, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.ptoHours", "PTO\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_VEH_BATTERY_VOLTS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double volts = ed.getVBatteryVolts();
                    if (volts > 0.0) {
                        return EventDataLayout.formatDouble(volts, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.vBatteryVolts", "Veh Batt.\nVolts");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_THROTTLE_POSITION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double throttlePos = ed.getThrottlePos();
                    if (throttlePos > 0.0) {
                        return Math.round(throttlePos * 100.0) + "%";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.throttlePosition", "Throttle\nPosition");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_INTAKE_TEMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double C = ed.getIntakeTemp();
                    if (C > 0.0) {
                        String tempS = EventDataLayout.formatTemperature(C, arg, rd, null);
                        return new ColumnValue(tempS).setSortKey((long)(C * 100.0));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.intakeTemp", "Intake\nTemp.");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_AIR_PRESSURE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kPa = ed.getAirPressure();
                    if (kPa != 0.0) {
                        double pressure = Account.getPressureUnits((Account)rd.getAccount()).convertFromKPa(kPa);
                        return EventDataLayout.formatDouble(pressure, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.airPressure", "Air Press.") + "\n${pressureUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_AIR_FILTER_PRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kPa = ed.getAirFilterPressure();
                    if (kPa != 0.0) {
                        double pressure = Account.getPressureUnits((Account)rd.getAccount()).convertFromKPa(kPa);
                        return EventDataLayout.formatDouble(pressure, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.airFilterPressure", "Air Filt\nPress.") + "\n${pressureUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_MASS_AIR_FLOW){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double rate = ed.getMassAirFlowRate();
                    if (rate != 0.0) {
                        return EventDataLayout.formatDouble(rate, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.massAirFlow", "Mass Air Flow") + "\ng/sec";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_TURBO_PRESS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kPa = ed.getTurboPressure();
                    if (kPa != 0.0) {
                        double pressure = Account.getPressureUnits((Account)rd.getAccount()).convertFromKPa(kPa);
                        return EventDataLayout.formatDouble(pressure, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.turboPressure", "Turbo\nPress.") + "\n${pressureUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_TIRE_PRESSURE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double[] kPa = ed.getTirePressure_kPa();
                    if (!ListTools.isEmpty((double[])kPa)) {
                        Account.PressureUnits pu = Account.getPressureUnits((Account)rd.getAccount());
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < kPa.length; ++i) {
                            double pressure = pu.convertFromKPa(kPa[i]);
                            if (sb.length() > 0) {
                                sb.append(",");
                            }
                            sb.append(EventDataLayout.formatDouble(pressure, arg, "0"));
                        }
                        return sb.toString();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.tirePressure", "Tire Press.") + "\n${pressureUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_TIRE_TEMPERATURE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double[] C = ed.getTireTemp_C();
                    if (!ListTools.isEmpty((double[])C)) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < C.length; ++i) {
                            if (sb.length() > 0) {
                                sb.append(",");
                            }
                            String tempFmt = EventDataLayout.formatTemperature(C[i], arg, rd, "?");
                            sb.append(tempFmt);
                        }
                        return sb.toString();
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.tireTemperature", "Tire Temp.");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_TANK_LEVEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double tankLevel = ed.getTankLevel();
                    if (tankLevel > 0.0) {
                        return Math.round(tankLevel * 100.0) + "%";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.tankPercent", "Tank%");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FAULT_CODES){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg());
                    EventData ed = (EventData)obj;
                    String faultStr = ed.getFaultCode();
                    if (StringTools.isBlank((String)faultStr)) {
                        long fault = ed.getOBDFault();
                        if (fault == 0L) {
                            return rc.getBlankFiller();
                        }
                        return DTOBDFault.GetFaultString((long)fault);
                    }
                    return DTOBDFault.GetFaultString((RTProperties)new RTProperties(faultStr));
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.j1708Faults", "OBD Faults");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_FAULT_CODE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = StringTools.trim((String)rc.getArg());
                    EventData ed = (EventData)obj;
                    long fault = ed.getOBDFault();
                    if (fault == 0L) {
                        return rc.getBlankFiller();
                    }
                    if (DTOBDFault.IsJ1708((long)fault)) {
                        if (DTOBDFault.HasDescriptionProvider((long)fault)) {
                            Locale locale = rd.getLocale();
                            if (arg.equalsIgnoreCase("link")) {
                                ColumnValue cv = new ColumnValue(DTOBDFault.GetFaultString((long)fault));
                                RequestProperties reqState = rd.getRequestProperties();
                                URIArg j1587URL = WebPageAdaptor.MakeURL(reqState.getBaseURI(), "j1587.show");
                                j1587URL.addArg("mid", DTOBDFault.DecodeSystem((long)fault));
                                j1587URL.addArg("spid", DTOBDFault.DecodeSPID((long)fault));
                                j1587URL.addArg("fmi", DTOBDFault.DecodeFMI((long)fault));
                                cv.setLinkURL("javascript:openResizableWindow('" + j1587URL + "','J1587Desc',320,100);", null);
                                return cv;
                            }
                            if (arg.equalsIgnoreCase("desc")) {
                                String desc = DTOBDFault.GetFaultDescription((long)fault, (Locale)locale);
                                return desc;
                            }
                            return DTOBDFault.GetFaultString((long)fault);
                        }
                        return DTOBDFault.GetFaultString((long)fault);
                    }
                    if (DTOBDFault.IsOBDII((long)fault)) {
                        if (DTOBDFault.HasDescriptionProvider((long)fault)) {
                            return DTOBDFault.GetFaultString((long)fault);
                        }
                        return DTOBDFault.GetFaultString((long)fault);
                    }
                    return DTOBDFault.GetFaultString((long)fault);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.j1708Fault", "OBD Fault");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_MALFUNCTION_LAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    boolean mil = ed.getMalfunctionLamp();
                    return ComboOption.getOnOffText(rd.getLocale(), mil);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.malfunctionLamp", "Malfunction\nLamp");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_LAST_FAULT_CODES){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    return dev.getLastFaultCode().toUpperCase();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.latestFaultCodes", "Fault Codes");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_OIL_LEVEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double oilLvl = ed.getOilLevel();
                    if (oilLvl > 0.0) {
                        return Math.round(oilLvl * 100.0) + "%";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.oilLevel", "Oil Level");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_OIL_PRESSURE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kPa = ed.getOilPressure();
                    if (kPa > 0.0) {
                        double pressure = Account.getPressureUnits((Account)rd.getAccount()).convertFromKPa(kPa);
                        return EventDataLayout.formatDouble(pressure, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.oilPressure", "Oil Press.") + "\n${pressureUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_OIL_TEMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double C = ed.getOilTemp();
                    if (C > 0.0) {
                        String tempS = EventDataLayout.formatTemperature(C, arg, rd, null);
                        return new ColumnValue(tempS).setSortKey((long)(C * 100.0));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.oilTemp", "Oil\nTemp.");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ENGINE_RPM){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    long rpm = ed.getEngineRpm();
                    if (rpm >= 0L) {
                        return String.valueOf(rpm);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.engineRpm", "Engine\nRPM");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ENGINE_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    double hours = ed.getEngineHours();
                    if ((hours += dev.getEngineHoursOffset()) > 0.0) {
                        return EventDataLayout.formatDouble(hours, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.engineHours", "Engine\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ENGINE_ON_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double hours = ed.getEngineOnHours();
                    if (hours > 0.0) {
                        return EventDataLayout.formatDouble(hours, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.engineOnHours", "Engine On\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ENGINE_LOAD){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double engineLoad = ed.getEngineLoad();
                    if (engineLoad > 0.0) {
                        return Math.round(engineLoad * 100.0) + "%";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.engineLoad", "Engine\nLoad %");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_IDLE_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double hours = ed.getIdleHours();
                    if (hours > 0.0) {
                        return EventDataLayout.formatDouble(hours, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.idleHours", "Idle\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_TRANS_OIL_TEMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double C = ed.getTransOilTemp();
                    if (C > 0.0) {
                        String tempS = EventDataLayout.formatTemperature(C, arg, rd, null);
                        return new ColumnValue(tempS).setSortKey((long)(C * 100.0));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.transOilTemp", "Trans Oil\nTemp.");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_COOLANT_LEVEL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double coolantLevel = ed.getCoolantLevel();
                    if (coolantLevel > 0.0) {
                        return Math.round(coolantLevel * 100.0) + "%";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.coolantLevel", "Coolant\nLevel");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_COOLANT_TEMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double C = ed.getCoolantTemp();
                    if (C > 0.0) {
                        String tempS = EventDataLayout.formatTemperature(C, arg, rd, null);
                        return new ColumnValue(tempS).setSortKey((long)(C * 100.0));
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.coolantTemp", "Coolant\nTemp.");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BRAKE_G_FORCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double bgf = ed.getBrakeGForce();
                    if (bgf != 0.0) {
                        return EventDataLayout.formatDouble(bgf, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.brakeGForce", "Braking\nG-force");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BRAKE_FORCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double bgf = ed.getBrakeGForce();
                    double kphs = 9.80665 * bgf / 1000.0 * 3600.0;
                    if (kphs != 0.0) {
                        return EventDataLayout.formatKM(kphs, arg, rd);
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.brakeForce", "Braking\n${distanceUnits}/hr/sec");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BRAKE_PRESSURE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double kPa = ed.getBrakePressure();
                    if (kPa != 0.0) {
                        double pressure = Account.getPressureUnits((Account)rd.getAccount()).convertFromKPa(kPa);
                        return EventDataLayout.formatDouble(pressure, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.brakePressure", "Brake Press.") + "\n${pressureUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_BRAKE_POSITION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double throttlePos = ed.getBrakePos();
                    if (throttlePos > 0.0) {
                        return Math.round(throttlePos * 100.0) + "%";
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.brakePosition", "Brake\nPosition");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_ACCELERATION){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double mss = ed.getAcceleration();
                    if (mss != 0.0) {
                        return EventDataLayout.formatDouble(mss, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.acceleration", "Accel\nm/s/s");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CHECKIN_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    long ts = dev.getLastTotalConnectTime();
                    if (ts <= 0L) {
                        try {
                            EventData lastEv = dev.getLastEvent(-1L, false);
                            if (lastEv != null) {
                                ts = lastEv.getTimestamp();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    if (ts > MINIMUM_REASONABLE_TIMESTAMP) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        String dtFmt = dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                        ColumnValue cv = new ColumnValue(dtFmt).setSortKey(ts);
                        long ageSec = DateTime.getCurrentTimeSec() - ts;
                        if (ageSec >= DateTime.HourSeconds((long)24L)) {
                            cv.setForegroundColor("red");
                        }
                        return cv;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.lastCheckinTime", "Last Check-In\nTime");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CHECKIN_AGE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    long ts = dev.getLastTotalConnectTime();
                    if (ts <= 0L) {
                        try {
                            EventData lastEv = dev.getLastEvent(-1L, false);
                            if (lastEv != null) {
                                ts = lastEv.getTimestamp();
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    if (ts > MINIMUM_REASONABLE_TIMESTAMP) {
                        long ageSec = DateTime.getCurrentTimeSec() - ts;
                        long days = ageSec / DateTime.DaySeconds((long)1L);
                        long hours = ageSec % DateTime.DaySeconds((long)1L) / DateTime.HourSeconds((long)1L);
                        long min = ageSec % DateTime.HourSeconds((long)1L) / DateTime.MinuteSeconds((long)1L);
                        StringBuffer sb = new StringBuffer();
                        sb.append(days).append("d ");
                        if (hours < 10L) {
                            sb.append("0");
                        }
                        sb.append(hours).append("h ");
                        if (min < 10L) {
                            sb.append("0");
                        }
                        sb.append(min).append("m");
                        ColumnValue cv = new ColumnValue(sb.toString()).setSortKey(ageSec);
                        if (ageSec >= DateTime.HourSeconds((long)24L)) {
                            cv.setForegroundColor("red");
                        }
                        return cv;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.lastCheckinAge", "Since Last\nCheck-In");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_CUSTOM_FIELD){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String value;
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    Device dev = ed.getDevice();
                    String string = value = dev != null ? dev.getCustomAttribute(arg) : "";
                    if (!StringTools.isBlank((String)value)) {
                        return value;
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    String arg = rc.getArg();
                    String desc = rd.getPrivateLabel().getStringProperty("deviceInfo.custom." + arg, null);
                    if (!StringTools.isBlank((String)desc)) {
                        int p;
                        if (desc.length() > 12 && (p = desc.lastIndexOf(" ")) > 0) {
                            desc = desc.substring(0, p) + "\n" + desc.substring(p + 1);
                        }
                        return desc;
                    }
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.customAttribute", "Custom\nAttribute");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DATA_SOURCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getDataSource();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dataSource", "Data Source");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_RAW_DATA){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    return ed.getRawData();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.rawData", "Raw Data");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DAY_ENGINE_STARTS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    int engStarts = ed.getDayEngineStarts();
                    return String.valueOf(engStarts);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dayEngineStarts", "Day Engine\nStarts");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DAY_IDLE_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double hours = ed.getDayIdleHours();
                    if (hours > 0.0) {
                        return EventDataLayout.formatDouble(hours, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dayIdleHours", "Day Idle\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DAY_FUEL_IDLE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getDayFuelIdle();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dayFuelIdle", "Day Idle\nFuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DAY_WORK_HOURS){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double hours = ed.getDayWorkHours();
                    if (hours > 0.0) {
                        return EventDataLayout.formatDouble(hours, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dayWorkHours", "Day Work\nHours");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DAY_FUEL_WORK){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getDayFuelWork();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dayFuelWork", "Day Work\nFuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DAY_FUEL_PTO){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getDayFuelPTO();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dayFuelPTO", "Day PTO\nFuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DAY_FUEL_TOTAL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double vol = ed.getDayFuelTotal();
                    if (vol > 0.0) {
                        vol = Account.getVolumeUnits((Account)rd.getAccount()).convertFromLiters(vol);
                        return EventDataLayout.formatDouble(vol, arg, "0.0");
                    }
                    return rc.getBlankFiller();
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dayFuelTotal", "Day Total\nFuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_DAY_DISTANCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    EventData ed = (EventData)obj;
                    double dist = ed.getDayDistanceKM();
                    if (dist > 0.0) {
                        return EventDataLayout.formatKM(dist, arg, rd);
                    }
                    return EventDataLayout.formatKM(dist, arg, rd);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    return i18n.getString("EventDataLayout.dayDistance", "Day\nDistance") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(EventDataLayout.DATA_EVENT_FIELD){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    EventData ed = (EventData)obj;
                    String fldName = rc.getArg();
                    DBField edFld = EventData.getFactory().getField(fldName);
                    if (edFld != null) {
                        Object val = ed.getFieldValue(fldName);
                        return StringTools.trim((String)edFld.formatValue(val));
                    }
                    return "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    Locale locale = rd.getLocale();
                    String fldName = rc.getArg();
                    DBField edFld = EventData.getFactory().getField(fldName);
                    if (edFld != null) {
                        String title = edFld.getTitle(locale);
                        return rc.getTitle(locale, title);
                    }
                    I18N i18n = rd.getPrivateLabel().getI18N(EventDataLayout.class);
                    String title = i18n.getString("EventDataLayout.eventField", "Event\nField");
                    return rc.getTitle(locale, title);
                }
            }, new String[0]);
        }
    }
}

