/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.dmtp;

import java.util.List;
import java.util.Vector;
import org.opengts.db.dmtp.Property;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class PropertyReport
extends ReportData {
    private List<FieldData> rowData = null;

    public PropertyReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        if (this.getDeviceCount() != 1) {
            throw new ReportException("1 and only 1 Device must be specified");
        }
    }

    @Override
    public void postInitialize() {
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return PropertyReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        String accountID = this.getAccountID();
        String deviceID = this.getFirstDeviceID();
        try {
            Device device = this.getDevice(deviceID);
            if (device != null) {
                Property[] properties = Property.getProperties((String)accountID, (String)deviceID);
                if (properties != null) {
                    for (int i = 0; i < properties.length; ++i) {
                        FieldData fd = new FieldData();
                        fd.setDevice(device);
                        fd.setString("deviceId", deviceID);
                        fd.setLong("timestamp", properties[i].getTimestamp());
                        fd.setLong("propertyKey", properties[i].getPropKey());
                        fd.setString("propertyDesc", properties[i].getDescription());
                        fd.setString("propertyValue", properties[i].getValueAsString());
                        this.rowData.add(fd);
                    }
                }
            } else {
                Print.logError((String)("Returned DeviceList 'Device' is null: " + deviceID), (Object[])new Object[0]);
            }
        }
        catch (DBException dbe) {
            Print.logError((String)("Error retrieving Device: " + deviceID), (Object[])new Object[0]);
        }
        return new ReportData.ListDataIterator(this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

