/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report.dmtp;

import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.dmtp.Diagnostic;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class DiagnosticReport
extends ReportData {
    private List<FieldData> rowData = null;

    public DiagnosticReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        if (this.getDeviceCount() != 1) {
            throw new ReportException("1 and only 1 Device must be specified");
        }
    }

    @Override
    public void postInitialize() {
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return DiagnosticReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        String accountID = this.getAccountID();
        String deviceID = this.getFirstDeviceID();
        long timeStart = this.getTimeStart();
        long timeEnd = this.getTimeEnd();
        try {
            Account account = this.getAccount();
            Device device = this.getDevice(deviceID);
            if (account != null && device != null) {
                TimeZone tz = account.getTimeZone(null);
                Diagnostic[] diags = Diagnostic.getDiagnostics((String)accountID, (String)deviceID, (long)timeStart, (long)timeEnd);
                if (diags != null) {
                    for (int i = 0; i < diags.length; ++i) {
                        diags[i].setDevice(device);
                        FieldData fd = new FieldData();
                        fd.setDevice(device);
                        fd.setString("deviceId", deviceID);
                        fd.setLong("timestamp", diags[i].getTimestamp());
                        fd.setBoolean("diagError", diags[i].isError());
                        fd.setLong("diagKey", diags[i].getCodeKey());
                        fd.setString("diagDesc", diags[i].getDescription());
                        fd.setString("diagValue", diags[i].getValueAsString(tz));
                        this.rowData.add(fd);
                    }
                }
            } else {
                Print.logError((String)("Returned DeviceList 'Device' is null: " + deviceID), (Object[])new Object[0]);
            }
        }
        catch (DBException dbe) {
            Print.logError((String)("Error retrieving Device: " + deviceID), (Object[])new Object[0]);
        }
        return new ReportData.ListDataIterator(this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

