/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.io.OutputStream;
import org.opengts.util.ExcelAPI;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.ReportData;

public class ReportSpreadsheet {
    private static boolean CONVERT_VALUES_TO_NUMERIC = false;
    private static boolean initExcelSpreadsheetClass = false;
    private static Class ExcelSpreadsheetClass = null;
    private ReportData rptData = null;
    private ExcelAPI excel = null;
    private boolean xlsx = false;
    private int currentRow = 0;
    private int currentCol = 0;

    public static Class GetExcelSpreadsheetClass() {
        if (!initExcelSpreadsheetClass) {
            initExcelSpreadsheetClass = true;
            try {
                ExcelSpreadsheetClass = Class.forName("org.opengts.util.ExcelTools$Spreadsheet");
            }
            catch (NoClassDefFoundError ncdfe) {
                Print.logWarn((String)("Excel interface not supported: " + ncdfe), (Object[])new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                Print.logWarn((String)("Excel interface not supported: " + cnfe), (Object[])new Object[0]);
            }
            catch (Throwable th) {
                Print.logException((String)"Excel interface not supported", (Throwable)th);
            }
        }
        return ExcelSpreadsheetClass;
    }

    public static boolean IsExcelSpreadsheetSupported() {
        return ReportSpreadsheet.GetExcelSpreadsheetClass() != null;
    }

    public ReportSpreadsheet(boolean xlsx, ReportData rd) {
        this.xlsx = xlsx;
        this.rptData = rd;
        Class ssClass = ReportSpreadsheet.GetExcelSpreadsheetClass();
        if (ssClass == null) {
            return;
        }
        try {
            Print.logInfo((String)"Creating Excel spreadsheet report instance ...", (Object[])new Object[0]);
            this.excel = (ExcelAPI)ssClass.newInstance();
            this.excel.init(this.xlsx, this.rptData.getReportName());
        }
        catch (Throwable th) {
            Print.logException((String)"Error creating Excel Spreadsheet instance", (Throwable)th);
            this.excel = null;
        }
    }

    public boolean isValid() {
        return this.excel != null;
    }

    public boolean isXLS() {
        return !this.xlsx;
    }

    public boolean isXLSX() {
        return this.xlsx;
    }

    public int incrementRowIndex() {
        ++this.currentRow;
        this.currentCol = 0;
        return this.currentRow;
    }

    public int getCurrentRowIndex() {
        return this.currentRow;
    }

    public int getCurrentColumnIndex() {
        return this.currentCol;
    }

    public int incrementColumnIndex() {
        return this.incrementColumnIndex(1);
    }

    public int incrementColumnIndex(int span) {
        this.currentCol += span;
        return this.currentCol;
    }

    public void setHeaderTitle(String title) {
        if (this.excel != null) {
            try {
                int rowIndex = this.getCurrentRowIndex();
                int colSpan = this.rptData.getColumnCount();
                this.excel.setTitle(rowIndex, title, colSpan);
                this.incrementRowIndex();
            }
            catch (Throwable th) {
                Print.logException((String)"Excel spreadsheet error", (Throwable)th);
                this.excel = null;
            }
        } else {
            Print.logWarn((String)"Excel spreadsheet reporting not available ...", (Object[])new Object[0]);
        }
    }

    public void setHeaderSubtitle(String title) {
        if (this.excel != null) {
            try {
                int rowIndex = this.getCurrentRowIndex();
                int colSpan = this.rptData.getColumnCount();
                this.excel.setSubtitle(rowIndex, title, colSpan);
                this.incrementRowIndex();
            }
            catch (Throwable th) {
                Print.logException((String)"Excel spreadsheet error", (Throwable)th);
                this.excel = null;
            }
        }
    }

    public void setBlankRow() {
        if (this.excel != null) {
            try {
                int rowIndex = this.getCurrentRowIndex();
                int colSpan = this.rptData.getColumnCount();
                this.excel.setBlankRow(rowIndex, colSpan);
                this.incrementRowIndex();
            }
            catch (Throwable th) {
                Print.logException((String)"Excel spreadsheet error", (Throwable)th);
                this.excel = null;
            }
        }
    }

    public void addHeaderColumn(String colTitle, int charWidth) {
        this.addHeaderColumn(1, colTitle, charWidth);
    }

    public void addHeaderColumn(int colSpan, String colTitle, int charWidth) {
        if (this.excel != null) {
            try {
                int rowIndex = this.getCurrentRowIndex();
                int colIndex = this.getCurrentColumnIndex();
                this.excel.addHeaderColumn(rowIndex, colIndex, colSpan, colTitle, charWidth);
                this.incrementColumnIndex(colSpan);
            }
            catch (Throwable th) {
                Print.logException((String)"Excel spreadsheet error", (Throwable)th);
                this.excel = null;
            }
        }
    }

    /*
     * Loose catch block
     */
    private Object convertToNumericIfPossible(Object value) {
        String ns;
        block8: {
            if (value == null) {
                return value;
            }
            if (value instanceof Number) {
                return value;
            }
            String v = StringTools.trim((Object)value);
            StringTools.FilterNumber fn = new StringTools.FilterNumber(v, Double.class);
            if (!fn.isValid(true)) {
                return value;
            }
            ns = fn.getValueString();
            if (!fn.hasDecimalPoint()) break block8;
            return new Double(ns);
            {
                catch (NumberFormatException nfe2) {
                    Print.logWarn((String)("Unable to convert to Double: " + v), (Object[])new Object[0]);
                    return value;
                }
            }
        }
        try {
            return new Long(ns);
        }
        catch (NumberFormatException nfe) {
            return new Double(ns);
        }
    }

    public void addBodyColumn(Object value) {
        if (this.excel != null) {
            try {
                int rowIndex = this.getCurrentRowIndex();
                int colIndex = this.getCurrentColumnIndex();
                if (CONVERT_VALUES_TO_NUMERIC) {
                    value = this.convertToNumericIfPossible(value);
                }
                this.excel.addBodyColumn(rowIndex, colIndex, value);
                this.incrementColumnIndex();
            }
            catch (Throwable th) {
                Print.logException((String)"Excel spreadsheet error", (Throwable)th);
                this.excel = null;
            }
        }
    }

    public void addSubtotalColumn(Object value) {
        if (this.excel != null) {
            try {
                int rowIndex = this.getCurrentRowIndex();
                int colIndex = this.getCurrentColumnIndex();
                if (CONVERT_VALUES_TO_NUMERIC) {
                    value = this.convertToNumericIfPossible(value);
                }
                this.excel.addSubtotalColumn(rowIndex, colIndex, value);
                this.incrementColumnIndex();
            }
            catch (Throwable th) {
                Print.logException((String)"Excel spreadsheet error", (Throwable)th);
                this.excel = null;
            }
        }
    }

    public void addTotalColumn(Object value) {
        if (this.excel != null) {
            try {
                int rowIndex = this.getCurrentRowIndex();
                int colIndex = this.getCurrentColumnIndex();
                if (CONVERT_VALUES_TO_NUMERIC) {
                    value = this.convertToNumericIfPossible(value);
                }
                this.excel.addTotalColumn(rowIndex, colIndex, value);
                this.incrementColumnIndex();
            }
            catch (Throwable th) {
                Print.logException((String)"Excel spreadsheet error", (Throwable)th);
                this.excel = null;
            }
        }
    }

    public boolean write(OutputStream out) {
        if (this.excel != null) {
            try {
                Print.logInfo((String)"Writing Excel spreadsheet to output stream ...", (Object[])new Object[0]);
                return this.excel.write(out);
            }
            catch (Throwable th) {
                Print.logException((String)"Excel spreadsheet error", (Throwable)th);
                this.excel = null;
                return false;
            }
        }
        Print.logWarn((String)"Excel spreadsheet reporting not available ...", (Object[])new Object[0]);
        return false;
    }
}

