/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.util.Locale;
import org.opengts.db.tables.Account;
import org.opengts.util.I18N;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.tools.RequestProperties;

public class ReportOption {
    private String optName = null;
    private I18N.Text optDesc = null;
    private RTProperties optProps = null;

    public ReportOption(String name, I18N.Text desc, RTProperties rtProps) {
        this.optName = StringTools.trim((String)name);
        this.optDesc = desc;
        this.optProps = rtProps;
    }

    public ReportOption(String name, String desc, RTProperties rtProps) {
        this.optName = StringTools.trim((String)name);
        this.optDesc = !StringTools.isBlank((String)desc) ? new I18N.Text(desc) : null;
        this.optProps = rtProps;
    }

    public ReportOption(String name) {
        this(name, (I18N.Text)null, null);
    }

    public String getName() {
        return this.optName;
    }

    public void setDescription(String desc) {
        this.optDesc = I18N.parseText(null, null, (String)desc, (boolean)false);
    }

    public void setDescription(I18N.Text desc) {
        this.optDesc = desc;
    }

    public String getDescription(Locale locale) {
        return this.optDesc != null ? this.optDesc.toString(locale) : "";
    }

    public String getDescription(final Locale locale, final RequestProperties reqState) {
        Account currAcct;
        String desc = this.getDescription(locale);
        Account account = currAcct = reqState != null ? reqState.getCurrentAccount() : null;
        if (currAcct == null) {
            return desc;
        }
        StringTools.KeyValueMap kvm = new StringTools.KeyValueMap(){

            public String getKeyValue(String key, String arg, String dft) {
                if (key.equalsIgnoreCase("kph")) {
                    double kph = StringTools.parseDouble((String)arg, (double)-1.0);
                    if (kph >= 0.0) {
                        Account.SpeedUnits speedUnits = Account.getSpeedUnits((Account)currAcct);
                        double speed = speedUnits.convertFromKPH(kph);
                        return Math.round(speed) + " " + speedUnits.toString(locale);
                    }
                    return dft;
                }
                if (key.equalsIgnoreCase("mph")) {
                    double mph = StringTools.parseDouble((String)arg, (double)-1.0);
                    if (mph >= 0.0) {
                        double kph = mph * 1.609344;
                        Account.SpeedUnits speedUnits = Account.getSpeedUnits((Account)currAcct);
                        double speed = speedUnits.convertFromKPH(kph);
                        return Math.round(speed) + " " + speedUnits.toString(locale);
                    }
                    return dft;
                }
                String v = reqState.getKeyValue(key, arg, null);
                return v != null ? v : dft;
            }
        };
        if (desc.indexOf("${") >= 0) {
            desc = StringTools.replaceKeys((String)desc, (StringTools.KeyValueMap)kvm, null, (String)"${", (String)"}", (String)":", (String)"=");
        }
        String keyStart = "%{";
        String keyEnd = "}";
        if (desc.indexOf(keyStart) >= 0) {
            desc = StringTools.replaceKeys((String)desc, (StringTools.KeyValueMap)kvm, null, (String)keyStart, (String)keyEnd, (String)":", (String)"=");
        }
        return desc;
    }

    public boolean hasProperties() {
        return this.optProps != null;
    }

    public RTProperties getProperties() {
        return this.optProps;
    }

    public void setValue(String key, String val) {
        if (this.optProps == null) {
            this.optProps = new RTProperties();
        }
        this.optProps.setString(key, val);
    }

    public String getValue(String key) {
        return this.optProps != null ? this.optProps.getString(key, null) : null;
    }
}

