/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.EventData;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.war.report.ColumnValue;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportOption;
import org.opengts.war.report.ReportPresentation;
import org.opengts.war.tools.OutputProvider;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;

public abstract class ReportLayout {
    public static final String CSS_CLASS_TABLE = "rptTbl";
    public static final String CSS_CLASS_TABLE_SORT = "rptTbl_sortable";
    public static final String CSS_CLASS_ODD = "rptBodyRowOdd";
    public static final String CSS_CLASS_EVEN = "rptBodyRowEven";
    public static final String CSS_CLASS_BODY_TOTAL = "rptBodyRowTotal";
    public static final String CSS_CLASS_TOTAL = "rptTotalRow";
    public static final String CSS_CLASS_TOTAL_2 = "rptTotalRow2";
    public static final long RPT_MULTI_DEVICES = 1L;
    public static final long RPT_START_DATE = 2L;
    public static final long RPT_END_DATE = 4L;
    private static final char KEY_START_ESC = '\\';
    private static final String KEY_START = "${";
    private static final String KEY_END = "}";
    public static final String HEADER_TIMEZONE = "timezone";
    public static final String HEADER_DATERANGE = "dateRange";
    public static final String HEADER_LIMIT = "limit";
    private static Map<String, CustomHeaderValue> customLookupTable = null;
    private static Collection<String> defaultCSSFiles = null;
    private static String defaultStyleSheet = "";
    private static final String DEFAULT_REPORT_PRESENTATION = "org.opengts.war.report.presentation.ReportTable";
    private static Class<ReportPresentation> reportPresClass = null;
    private Collection<String> cssFiles = null;
    private String styleSheet = null;
    private String dateFormat = null;
    private String timeFormat = null;
    private ReportPresentation reportTable = null;
    private DataRowTemplate reportDataRow = null;
    private static final String[] ARG_LIST = new String[]{"list"};

    public static AgeColorRange[] ParseAgeColorRange(String crs, AgeColorRange[] dft) {
        String[] crsa = StringTools.split((String)crs, (char)',');
        Vector<AgeColorRange> crv = new Vector<AgeColorRange>();
        for (String crsi : crsa) {
            AgeColorRange cr;
            if (StringTools.isBlank((String)crsi) || !(cr = new AgeColorRange(crsi)).isValid()) continue;
            crv.add(cr);
        }
        if (!ListTools.isEmpty(crv)) {
            Object[] cra = crv.toArray(new AgeColorRange[crv.size()]);
            return (AgeColorRange[])ListTools.sort((Object[])cra, (Comparator)new ListTools.StringComparator(false));
        }
        return dft;
    }

    public static AgeColorRange GetAgeColorRange(long age, AgeColorRange[] cra) {
        if (!ListTools.isEmpty((Object[])cra)) {
            for (AgeColorRange cr : cra) {
                if (age < cr.getAge()) continue;
                return cr;
            }
        }
        return null;
    }

    public static ColumnValue SetColumnValueAgeColor(ColumnValue cv, AgeColorRange acr) {
        if (cv != null && acr != null) {
            if (acr.hasForegroundColor()) {
                cv.setForegroundColor(acr.getForegroundColor());
            }
            if (acr.hasFontStyle()) {
                cv.setFontStyle(acr.getFontStyle());
            }
        }
        return cv;
    }

    public static void setDefaultCSSFiles(Collection<String> cssFiles) {
        defaultCSSFiles = !ListTools.isEmpty(cssFiles) ? cssFiles : null;
    }

    public static boolean hasDefaultCSSFiles() {
        return !ListTools.isEmpty(defaultCSSFiles);
    }

    public static Collection<String> getDefaultCSSFiles() {
        return defaultCSSFiles;
    }

    public static void setDefaultStyleSheet(String styleSheet) {
        if (StringTools.isBlank((String)styleSheet)) {
            defaultStyleSheet = "";
        } else {
            defaultStyleSheet = styleSheet;
            if (!defaultStyleSheet.endsWith("\n")) {
                defaultStyleSheet = defaultStyleSheet + "\n";
            }
        }
    }

    public static boolean hasDefaultStyleSheet() {
        return !StringTools.isBlank((String)defaultStyleSheet);
    }

    public static String getDefaultStyleSheet() {
        return defaultStyleSheet;
    }

    public static boolean setReportPresentationClassName(String className) {
        if (!StringTools.isBlank((String)className)) {
            try {
                Class<?> presClass = Class.forName(className);
                if (!ReportPresentation.class.isAssignableFrom(presClass)) {
                    new RuntimeException("Must be a subclass of ReportPresentation");
                }
                Print.logInfo((String)("Installing custom ReportPresentation class: " + StringTools.className(presClass)), (Object[])new Object[0]);
                reportPresClass = presClass;
                return true;
            }
            catch (Throwable th) {
                Print.logException((String)("Unable to install custom ReportPresentation: " + className), (Throwable)th);
                reportPresClass = null;
                return false;
            }
        }
        reportPresClass = null;
        return true;
    }

    protected static ReportPresentation createReportPresentation() {
        if (reportPresClass == null && !ReportLayout.setReportPresentationClassName(DEFAULT_REPORT_PRESENTATION)) {
            Print.logStackTrace((String)"Unable to create default ReportPresentation: org.opengts.war.report.presentation.ReportTable");
            return null;
        }
        try {
            return reportPresClass.newInstance();
        }
        catch (Throwable th) {
            Print.logException((String)("Unable to create custom ReportPresentation: " + StringTools.className(reportPresClass)), (Throwable)th);
            return null;
        }
    }

    protected ReportLayout() {
        ReportLayout.InitCustomHeaderValueLookup();
    }

    protected ReportPresentation getReportPresentation() {
        if (this.reportTable == null) {
            this.reportTable = ReportLayout.createReportPresentation();
        }
        return this.reportTable;
    }

    public void setDateTimeFormat(String dateFmt, String timeFmt) {
        this.dateFormat = dateFmt != null && !dateFmt.equals("") ? dateFmt.trim() : null;
        this.timeFormat = timeFmt != null && !timeFmt.equals("") ? timeFmt.trim() : null;
    }

    public String getDateFormat(PrivateLabel privLabel) {
        if (this.dateFormat == null) {
            if (privLabel != null) {
                return privLabel.getDateFormat();
            }
            return BasicPrivateLabel.getDefaultDateFormat();
        }
        return this.dateFormat;
    }

    public String getTimeFormat(PrivateLabel privLabel) {
        if (this.timeFormat == null) {
            if (privLabel != null) {
                return privLabel.getTimeFormat();
            }
            return BasicPrivateLabel.getDefaultTimeFormat();
        }
        return this.timeFormat;
    }

    public String getDateTimeFormat(PrivateLabel privLabel) {
        return this.getDateFormat(privLabel) + " " + this.getTimeFormat(privLabel);
    }

    public void setCSSFiles(Collection<String> cssFiles) {
        this.cssFiles = !ListTools.isEmpty(cssFiles) ? cssFiles : null;
    }

    public boolean hasCSSFiles() {
        return !ListTools.isEmpty(this.cssFiles);
    }

    public Collection<String> getCSSFiles() {
        return this.cssFiles;
    }

    public Collection<String> getCSSFiles(boolean inclDefault) {
        if (!inclDefault) {
            return this.getCSSFiles();
        }
        if (!ReportLayout.hasDefaultCSSFiles()) {
            return this.getCSSFiles();
        }
        if (!this.hasCSSFiles()) {
            return ReportLayout.getDefaultCSSFiles();
        }
        Vector<String> list = new Vector<String>();
        list.addAll(ReportLayout.getDefaultCSSFiles());
        list.addAll(this.getCSSFiles());
        return list;
    }

    public void setStyleSheet(String style) {
        this.styleSheet = style;
    }

    public boolean hasStyleSheet() {
        return !StringTools.isBlank((String)this.styleSheet);
    }

    public String getStyleSheet() {
        return this.styleSheet != null ? this.styleSheet : "";
    }

    public String getStyleSheet(boolean inclDefault) {
        if (!inclDefault) {
            return this.getStyleSheet();
        }
        if (!ReportLayout.hasDefaultStyleSheet()) {
            return this.getStyleSheet();
        }
        if (!this.hasStyleSheet()) {
            return ReportLayout.getDefaultStyleSheet();
        }
        StringBuffer style = new StringBuffer();
        style.append(ReportLayout.getDefaultStyleSheet());
        style.append(this.getStyleSheet());
        return style.toString();
    }

    public void writeReportStyle(String format, ReportData report, OutputProvider out, int indentLevel) throws ReportException {
        if (StringTools.isBlank((String)format) || format.equalsIgnoreCase("html")) {
            String cstStyle;
            PrintWriter pw = null;
            try {
                pw = out.getWriter();
            }
            catch (IOException ioe) {
                throw new ReportException("Error getting PrintWriter", ioe);
            }
            pw.write("\n");
            String dftStyle = ReportLayout.getDefaultStyleSheet();
            if (!StringTools.isBlank((String)dftStyle)) {
                pw.write(dftStyle);
                pw.write("\n");
            }
            if (!StringTools.isBlank((String)(cstStyle = this.getStyleSheet()))) {
                pw.write(cstStyle);
                pw.write("\n");
            }
        }
    }

    public int writeReport(String format, ReportData rd, OutputProvider out, int indentLevel) throws ReportException {
        ReportPresentation rp = this.getReportPresentation();
        if (rp != null) {
            return rp.writeReport(format, rd, out, indentLevel);
        }
        return 0;
    }

    public void setDataRowTemplate(DataRowTemplate rdp) {
        this.reportDataRow = rdp;
    }

    public DataRowTemplate getDataRowTemplate() {
        return this.reportDataRow;
    }

    public static String expandHeaderText(String text, ReportData rd) {
        return ReportLayout.expandHeaderText(text, rd, null, null);
    }

    public static String expandHeaderText(String text, RequestProperties reqState, ReportOption ro) {
        return ReportLayout.expandHeaderText(text, null, reqState, ro);
    }

    public static String expandHeaderText(String text, ReportData rd, RequestProperties reqState, ReportOption ro) {
        int ke;
        if (reqState == null) {
            if (rd != null) {
                reqState = rd.getRequestProperties();
            } else {
                return text;
            }
        }
        Locale locale = reqState.getLocale();
        if (ro == null && rd != null) {
            ro = rd.getReportOption();
        }
        Account account = rd != null ? rd.getAccount() : reqState.getCurrentAccount();
        String keyStart = KEY_START;
        String keyEnd = KEY_END;
        String argDelim = ":";
        String dftDelim = "=";
        int ks = text.indexOf(keyStart);
        StringBuffer repText = new StringBuffer(text);
        while (ks >= 0 && (ke = repText.indexOf(keyEnd, ks)) >= 0) {
            String key;
            String arg;
            String keyArg;
            String dftStr;
            int ksi = ks > 0 && repText.charAt(ks - 1) == '\\' ? ks - 1 : ks;
            int ksx = ks + keyStart.length();
            int kex = ke + keyEnd.length();
            String keyArgDft = repText.substring(ksx, ke);
            int d = keyArgDft.indexOf(dftDelim);
            if (d >= 0) {
                dftStr = keyArgDft.substring(d + dftDelim.length());
                keyArg = keyArgDft.substring(0, d).trim();
            } else {
                dftStr = "";
                keyArg = keyArgDft;
            }
            int a = keyArg.indexOf(argDelim);
            if (a >= 0) {
                arg = keyArg.substring(a + argDelim.length());
                key = keyArg.substring(0, a).trim();
            } else {
                arg = null;
                key = keyArg;
            }
            String kv = null;
            if (ro != null) {
                kv = key.equalsIgnoreCase("description") ? ro.getDescription(locale, reqState) : ro.getValue(key);
            }
            if (kv == null) {
                if (rd != null) {
                    kv = ReportLayout.lookupCustomHeaderText(key, arg, rd);
                } else {
                    String v = reqState.getKeyValue(key, arg, null);
                    if (v != null) {
                        kv = v;
                    } else {
                        Print.logWarn((String)("Header text replacement key not found: " + key), (Object[])new Object[0]);
                        kv = key.toUpperCase();
                    }
                }
            }
            String fv = kv != null ? kv : dftStr;
            repText.replace(ksi, kex, fv);
            ks = repText.indexOf(keyStart, ks);
        }
        int nl = repText.indexOf("\\n");
        while (nl >= 0) {
            repText.replace(nl, nl + 2, "\n");
            nl = repText.indexOf("\\n", nl);
        }
        return repText.toString().trim();
    }

    private static String lookupCustomHeaderText(String key, String arg, ReportData rd) {
        if (key == null) {
            return "";
        }
        if (rd == null) {
            return "";
        }
        CustomHeaderValue cv = customLookupTable.get(key);
        if (cv != null) {
            return cv.getValue(arg, rd);
        }
        RequestProperties reqState = rd.getRequestProperties();
        String v = reqState.getKeyValue(key, arg, null);
        if (v != null) {
            return v;
        }
        Print.logWarn((String)("Header text replacement key not found: " + key), (Object[])new Object[0]);
        return key.toUpperCase();
    }

    private static void InitCustomHeaderValueLookup() {
        if (customLookupTable != null) {
            return;
        }
        customLookupTable = new OrderedMap();
        ((OrderedMap)customLookupTable).setIgnoreCase(true);
        customLookupTable.put("deviceID", new CustomHeaderValue(){

            @Override
            public String getValue(String arg, ReportData rd) {
                ReportDeviceList devList = rd.getReportDeviceList();
                int devSize = devList.size();
                if (devSize <= 0) {
                    return "";
                }
                if (devSize == 1) {
                    return devList.getFirstDeviceID();
                }
                I18N i18n = rd.getPrivateLabel().getI18N(ReportLayout.class);
                return i18n.getString("ReportLayout.multipleDevices", "(Multiple Devices)");
            }
        });
        customLookupTable.put("deviceDesc", new CustomHeaderValue(){

            @Override
            public String getValue(String arg, ReportData rd) {
                ReportDeviceList devList = rd.getReportDeviceList();
                int devSize = devList.size();
                if (devSize <= 0) {
                    return "";
                }
                if (devSize == 1) {
                    Device d = devList.getFirstDevice();
                    return d != null ? d.getDescription() : "";
                }
                I18N i18n = rd.getPrivateLabel().getI18N(ReportLayout.class);
                return i18n.getString("ReportLayout.multipleDevices", "(Multiple Devices)");
            }
        });
        customLookupTable.put("groupID", new CustomHeaderValue(){

            @Override
            public String getValue(String arg, ReportData rd) {
                ReportDeviceList rdl = rd.getReportDeviceList();
                DeviceGroup devGrp = rdl.getDeviceGroup();
                if (devGrp != null) {
                    return devGrp.getGroupID();
                }
                return "all";
            }
        });
        customLookupTable.put("groupDesc", new CustomHeaderValue(){

            @Override
            public String getValue(String arg, ReportData rd) {
                ReportDeviceList rdl = rd.getReportDeviceList();
                DeviceGroup devGrp = rdl.getDeviceGroup();
                if (devGrp != null) {
                    String desc = devGrp.getDescription();
                    return !desc.equals("") ? desc : devGrp.getGroupID();
                }
                return DeviceGroup.GetDeviceGroupAll((Locale)rd.getLocale());
            }
        });
        customLookupTable.put(HEADER_TIMEZONE, new CustomHeaderValue(){

            @Override
            public String getValue(String arg, ReportData rd) {
                return rd.getTimeZoneString();
            }
        });
        customLookupTable.put(HEADER_DATERANGE, new CustomHeaderValue(){

            @Override
            public String getValue(String arg, ReportData rd) {
                PrivateLabel privLabel = rd.getPrivateLabel();
                I18N i18n = privLabel.getI18N(ReportLayout.class);
                ReportLayout rl = rd.getReportLayout();
                ReportConstraints rc = rd.getReportConstraints();
                long timeStart = rc.getTimeStart();
                long timeEnd = rc.getTimeEnd();
                String timeFmt = rl.getDateTimeFormat(privLabel);
                String dateFmt = rl.getDateFormat(privLabel);
                String tzName = rd.getTimeZoneString();
                TimeZone tz = rd.getTimeZone();
                DateTime dtStr = new DateTime(timeStart, tz);
                DateTime dtEnd = new DateTime(timeEnd, tz);
                String fmtStr = timeStart > 0L && timeStart == dtStr.getDayStart(tz) ? dateFmt : timeFmt;
                String fmtEnd = timeEnd > 0L && timeEnd == dtEnd.getDayEnd(tz) ? dateFmt : timeFmt;
                StringBuffer dt = new StringBuffer();
                if (timeStart > 0L && timeEnd > 0L) {
                    String ds = dtStr.format(fmtStr, tz);
                    String de = dtEnd.format(fmtEnd, tz);
                    dt.append(i18n.getString("ReportLayout.throughDate", "''{0}'' through ''{1}''", (Object)ds, (Object)de));
                } else if (timeStart > 0L) {
                    String ds = dtStr.format(fmtStr, tz);
                    dt.append(i18n.getString("ReportLayout.throughPresent", "''{0}'' through Present", (Object)ds));
                } else if (timeEnd > 0L) {
                    String de = dtEnd.format(fmtEnd, tz);
                    dt.append(i18n.getString("ReportLayout.asOfDate", "As of ''{0}''", (Object)de));
                }
                if (tzName != null) {
                    dt.append(" [");
                    dt.append(tzName);
                    dt.append("]");
                }
                return dt.toString();
            }
        });
        customLookupTable.put(HEADER_LIMIT, new CustomHeaderValue(){

            @Override
            public String getValue(String arg, ReportData rd) {
                PrivateLabel privLabel = rd.getPrivateLabel();
                I18N i18n = privLabel.getI18N(ReportLayout.class);
                ReportLayout rl = rd.getReportLayout();
                ReportConstraints rc = rd.getReportConstraints();
                long rptLimit = rc.getReportLimit();
                StringBuffer dt = new StringBuffer();
                if (rptLimit > 0L) {
                    EventData.LimitType type = rc.getSelectionLimitType();
                    if (EventData.LimitType.FIRST.equals((Object)type)) {
                        if (rptLimit == 1L) {
                            dt.append(i18n.getString("ReportLayout.firstRecord", "(First record)"));
                        } else {
                            dt.append(i18n.getString("ReportLayout.firstLimitRecords", "(First {0} records)", (Object)new Long(rptLimit)));
                        }
                    } else if (EventData.LimitType.LAST.equals((Object)type)) {
                        dt.append(" ");
                        if (rptLimit == 1L) {
                            dt.append(i18n.getString("ReportLayout.lastRecord", "(Last record)"));
                        } else {
                            dt.append(i18n.getString("ReportLayout.lastLimitRecords", "(Last {0} records)", (Object)new Long(rptLimit)));
                        }
                    } else {
                        dt.append(" ");
                        dt.append(i18n.getString("ReportLayout.unknownType", "(Unknown type)"));
                    }
                }
                return dt.toString();
            }
        });
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + ReportLayout.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -list          List available columns", (Object[])new Object[0]);
        System.exit(1);
    }

    private static ReportLayout _createNewInstance(Class<ReportLayout> layoutClass) {
        try {
            return layoutClass.newInstance();
        }
        catch (Throwable th) {
            Print.logException((String)("Unable to create instance of " + StringTools.className(layoutClass)), (Throwable)th);
            return null;
        }
    }

    public static void main(String[] argv) {
        boolean listColumns;
        DBConfig.cmdLineInit((String[])argv, (boolean)true);
        Class<ReportLayout> layoutClass = null;
        if (layoutClass == null) {
            // empty if block
        }
        if (listColumns = RTConfig.getBoolean((String[])ARG_LIST, (boolean)false)) {
            Print.sysPrintln((String)"Available Columns:", (Object[])new Object[0]);
            ReportLayout rpt = ReportLayout._createNewInstance(layoutClass);
            if (rpt != null) {
                DataRowTemplate drt = rpt.getDataRowTemplate();
                Set<String> colNames = drt.getColumnNames();
                for (String cn : colNames) {
                    DataColumnTemplate dct = drt.getColumnTemplate(cn);
                    String ct = dct.getTitle(null, null);
                    Print.sysPrintln((String)("  Column: " + StringTools.padRight((String)cn, (char)' ', (int)12) + " => " + ct.replace('\n', ' ')), (Object[])new Object[0]);
                }
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        ReportLayout.usage();
    }

    private static interface CustomHeaderValue {
        public String getValue(String var1, ReportData var2);
    }

    public static class AgeColorRange {
        private long ageDur = 0L;
        private String color = "";
        private String fontStyle = "";

        public AgeColorRange(String acl) {
            if (acl != null) {
                String[] aca = null;
                aca = acl.indexOf(58) >= 0 ? StringTools.split((String)acl, (char)':') : (acl.indexOf(47) >= 0 ? StringTools.split((String)acl, (char)'/') : StringTools.split((String)acl, (char)','));
                long age = aca.length > 0 ? StringTools.parseLong((String)aca[0], (long)0L) : 0L;
                String clr = aca.length > 1 ? StringTools.trim((String)aca[1]) : "";
                String fs = aca.length > 2 ? StringTools.trim((String)aca[2]) : "";
                this.ageDur = age >= 0L ? age : 0L;
                this.color = clr;
                this.fontStyle = fs;
            } else {
                this.ageDur = 0L;
                this.color = "";
                this.fontStyle = "";
            }
        }

        public AgeColorRange(long age, String clr, String fs) {
            this.ageDur = age >= 0L ? age : 0L;
            this.color = StringTools.trim((String)clr);
            this.fontStyle = StringTools.trim((String)fs);
        }

        public long getAge() {
            return this.ageDur;
        }

        public boolean hasForegroundColor() {
            return !StringTools.isBlank((String)this.color);
        }

        public String getForegroundColor() {
            return this.color;
        }

        public boolean hasFontStyle() {
            return !StringTools.isBlank((String)this.fontStyle);
        }

        public String getFontStyle() {
            return this.fontStyle;
        }

        public boolean isValid() {
            return this.ageDur >= 0L && !StringTools.isBlank((String)this.color);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(StringTools.format((long)this.getAge(), (String)"00000000"));
            sb.append(":");
            sb.append(this.getForegroundColor());
            if (this.hasFontStyle()) {
                sb.append(":");
                sb.append(this.getFontStyle());
            }
            return sb.toString();
        }
    }
}

