/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.db.DBConfig;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportHeaderGroup;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.ReportOption;
import org.opengts.war.report.ReportOptionsProvider;
import org.opengts.war.tools.OutputProvider;
import org.opengts.war.tools.RequestProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportFactory {
    private static boolean IGNORE_MISSING_REPORTS = true;
    public static final String REPORT_TYPE_DEVICE_DETAIL = "device.detail";
    public static final String REPORT_TYPE_DEVICE_SUMMARY = "device.summary";
    public static final String REPORT_TYPE_FLEET_DETAIL = "fleet.detail";
    public static final String REPORT_TYPE_FLEET_SUMMARY = "fleet.summary";
    public static final String REPORT_TYPE_DRIVER_PERFORM = "driver.performance";
    public static final String REPORT_TYPE_IFTA_DETAIL = "ifta.detail";
    public static final String REPORT_TYPE_IFTA_SUMMARY = "ifta.summary";
    public static final String REPORT_TYPE_SYSADMIN_SUMMARY = "sysadmin.summary";
    public static final String[] REPORT_TYPES = new String[]{"device.detail", "device.summary", "fleet.detail", "fleet.summary", "driver.performance", "ifta.detail", "ifta.summary", "sysadmin.summary"};
    public static final String[] OPTIONS_TYPE_list = new String[]{"list", "default"};
    public static final String[] OPTIONS_TYPE_geozone = new String[]{"geozone", "geozones", "zones"};
    public static final String[] OPTIONS_TYPE_fleet = new String[]{"fleet", "devicegroup", "devicegroups"};
    public static final String[] OPTIONS_TYPE_statusCode = new String[]{"statusCode", "statusCodes"};
    public static final String[] OPTIONS_TYPE_custom = new String[]{"custom", "provider"};
    public static final String TAG_ReportDefinition = "ReportDefinition";
    public static final String TAG_DefaultStyle = "DefaultStyle";
    public static final String TAG_ReportLayout = "ReportLayout";
    public static final String TAG_DateFormat = "DateFormat";
    public static final String TAG_TimeFormat = "TimeFormat";
    public static final String TAG_LayoutStyle = "LayoutStyle";
    public static final String TAG_ReportTypes = "ReportTypes";
    public static final String TAG_ReportType = "ReportType";
    public static final String TAG_Report = "Report";
    public static final String TAG_MenuDescription = "MenuDescription";
    public static final String TAG_Title = "Title";
    public static final String TAG_Subtitle = "Subtitle";
    public static final String TAG_SimpleColumns = "SimpleColumns";
    public static final String TAG_HeaderGroups = "HeaderGroups";
    public static final String TAG_HeaderGroup = "HeaderGroup";
    public static final String TAG_Columns = "Columns";
    public static final String TAG_Column = "Column";
    public static final String TAG_MapIconSelector = "MapIconSelector";
    public static final String TAG_Properties = "Properties";
    public static final String TAG_Property = "Property";
    public static final String TAG_Options = "Options";
    public static final String TAG_Option = "Option";
    public static final String TAG_Description = "Description";
    public static final String TAG_Constraints = "Constraints";
    public static final String TAG_TimeStart = "TimeStart";
    public static final String TAG_TimeEnd = "TimeEnd";
    public static final String TAG_ValidGPSRequired = "ValidGPSRequired";
    public static final String TAG_SelectionLimit = "SelectionLimit";
    public static final String TAG_ReportLimit = "ReportLimit";
    public static final String TAG_OrderAscending = "OrderAscending";
    public static final String TAG_OrderDescending = "OrderDescending";
    public static final String TAG_Where = "Where";
    public static final String TAG_RuleSelector = "RuleSelector";
    public static final String TAG_ReportJobs = "ReportJobs";
    public static final String TAG_IntervalTag = "IntervalTag";
    public static final String TAG_Include = "Include";
    public static final String ATTR_i18nPackage = "i18nPackage";
    public static final String ATTR_name = "name";
    public static final String ATTR_title = "title";
    public static final String ATTR_class = "class";
    public static final String ATTR_layout = "layout";
    public static final String ATTR_modules = "modules";
    public static final String ATTR_optional = "optional";
    public static final String ATTR_type = "type";
    public static final String ATTR_i18n = "i18n";
    public static final String ATTR_key = "key";
    public static final String ATTR_arg = "arg";
    public static final String ATTR_isGroup = "isGroup";
    public static final String ATTR_ruleFactoryName = "ruleFactoryName";
    public static final String ATTR_sysAdminOnly = "sysAdminOnly";
    public static final String ATTR_sortable = "sortable";
    public static final String ATTR_cssFile = "cssFile";
    public static final String ATTR_ifTrue = "ifTrue";
    public static final String ATTR_ifFalse = "ifFalse";
    public static final String ATTR_blankFill = "blankFill";
    public static final String ATTR_file = "file";
    public static final String ATTR_dir = "dir";
    public static final String ATTR_colSpan = "colSpan";
    public static final String ATTR_id = "id";
    public static final String ATTR_fromTime = "fromTime";
    public static final String ATTR_toTime = "toTime";
    private static final String PROP_ReportDefinition_ = "ReportDefinition.";
    private static ReportFactoryVars GlobalReportFactoryVars = null;
    public static final String REPORT_FACTORY_XML = "reports.xml";
    private static HashMap<String, ReportType> ReportTypeMap = null;
    public static boolean SAVE_I18N_STRINGS = false;
    public static Set<I18N.Text> I18N_STRINGS = null;
    private String className = null;
    private Class classObj = null;
    private ReportHeaderGroup[] reportHeaderGroups = null;
    private ReportColumn[] reportColumns = null;
    private String reportName = "report";
    private I18N.Text reportTitle = null;
    private I18N.Text reportSubtitle = null;
    private String reportType = "device.detail";
    private I18N.Text menuDescription = null;
    private ReportConstraints dftConstraints = null;
    private String mapIconSelector = null;
    private RTProperties reportProperties = null;
    private OrderedMap<String, ReportOption> reportOptions = null;
    private ReportOptionsProvider reportOptionsProvider = null;
    private boolean isSysAdminOnly = false;
    private boolean isTableSortable = false;
    private static final String[] ARG_XML = new String[]{"xml"};
    private static final String[] ARG_OUT = new String[]{"out"};
    private static final String[] ARG_REPORT = new String[]{"report"};
    private static final String[] ARG_INFO = new String[]{"info"};
    private static final String[] ARG_ACCOUNT = new String[]{"account"};
    private static final String[] ARG_DEVICE = new String[]{"device"};
    private static final String[] ARG_FORMAT = new String[]{"format"};

    public static void setIgnoreMissingReports(boolean ignMissing) {
        IGNORE_MISSING_REPORTS = ignMissing;
    }

    public static String getReportTypeShortTitle(RequestProperties reqState, String rptType) {
        Object[] grpTitles;
        Locale locale = reqState != null ? reqState.getLocale() : null;
        I18N i18n = I18N.getI18N(ReportFactory.class, (Locale)locale);
        Object[] devTitles = reqState != null ? reqState.getDeviceTitles() : Device.GetTitles((Locale)locale);
        Object[] objectArray = grpTitles = reqState != null ? reqState.getDeviceGroupTitles() : DeviceGroup.GetTitles((Locale)locale);
        if (rptType.equalsIgnoreCase(REPORT_TYPE_DEVICE_DETAIL)) {
            return i18n.getString("ReportFactory.deviceDetailReports", "{0} Detail", devTitles);
        }
        if (rptType.equalsIgnoreCase(REPORT_TYPE_DEVICE_SUMMARY)) {
            return i18n.getString("ReportFactory.deviceSummaryReports", "{0} Summary", devTitles);
        }
        if (rptType.equalsIgnoreCase(REPORT_TYPE_FLEET_DETAIL)) {
            return i18n.getString("ReportFactory.fleetDetailReports", "{0} Detail", grpTitles);
        }
        if (rptType.equalsIgnoreCase(REPORT_TYPE_FLEET_SUMMARY)) {
            return i18n.getString("ReportFactory.fleetSummaryReports", "{0} Summary", grpTitles);
        }
        if (rptType.equalsIgnoreCase(REPORT_TYPE_DRIVER_PERFORM)) {
            return i18n.getString("ReportFactory.driverPerformanceReports", "Performance");
        }
        if (rptType.equalsIgnoreCase(REPORT_TYPE_IFTA_DETAIL)) {
            return i18n.getString("ReportFactory.iftaReports", "I.F.T.A. Detail");
        }
        if (rptType.equalsIgnoreCase(REPORT_TYPE_IFTA_SUMMARY)) {
            return i18n.getString("ReportFactory.iftaSummaryReports", "I.F.T.A. Summary");
        }
        if (rptType.equalsIgnoreCase(REPORT_TYPE_SYSADMIN_SUMMARY)) {
            return i18n.getString("ReportFactory.sysadminReports", "System Admin");
        }
        return "";
    }

    public static String getReportTypeDescription(RequestProperties reqState, String rptType) {
        Locale locale = reqState != null ? reqState.getLocale() : null;
        String desc = ReportFactory.getReportTypeDescription(rptType, locale);
        if (!StringTools.isBlank((String)desc)) {
            return desc;
        }
        return ReportFactory.getReportTypeShortTitle(reqState, rptType);
    }

    public static boolean hasParsingErrors() {
        if (GlobalReportFactoryVars == null) {
            return false;
        }
        return GlobalReportFactoryVars.hasParsingErrors();
    }

    public static boolean hasParsingWarnings() {
        if (GlobalReportFactoryVars == null) {
            return false;
        }
        return GlobalReportFactoryVars.hasParsingWarnings();
    }

    public static Collection<ReportFactory> getReportFactories() {
        if (GlobalReportFactoryVars == null) {
            return null;
        }
        return GlobalReportFactoryVars.getReportFactories();
    }

    public static File _getReportXMLFile() {
        File cfgFile = RTConfig.getLoadedConfigFile();
        if (cfgFile != null) {
            return new File(cfgFile.getParentFile(), REPORT_FACTORY_XML);
        }
        return null;
    }

    private static Document _getDocument(File xmlFile) {
        if (xmlFile == null) {
            Print.logError((String)("ReportFactory XML file not specified: " + xmlFile), (Object[])new Object[0]);
            return null;
        }
        if (!xmlFile.exists()) {
            Print.logError((String)("ReportFactory XML file does not exist: " + xmlFile), (Object[])new Object[0]);
            return null;
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(xmlFile);
        }
        catch (ParserConfigurationException pce) {
            Print.logException((String)"Parse error: ", (Throwable)pce);
        }
        catch (SAXException se) {
            Print.logException((String)"Parse error: ", (Throwable)se);
        }
        catch (IOException ioe) {
            Print.logException((String)"Parse error: ", (Throwable)ioe);
        }
        return doc;
    }

    private static String getNodeText(Node root, String repNewline) {
        StringBuffer text = new StringBuffer();
        if (root != null) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() == 4) {
                    text.append(n.getNodeValue());
                    continue;
                }
                if (n.getNodeType() != 3) continue;
                text.append(n.getNodeValue());
            }
        }
        if (repNewline != null) {
            StringBuffer sb = new StringBuffer();
            String[] s = StringTools.parseStringArray((String)text.toString(), (String)"\n\r");
            for (int i = 0; i < s.length; ++i) {
                String line = s[i].trim();
                if (line.equals("")) continue;
                if (sb.length() > 0) {
                    sb.append(repNewline);
                }
                sb.append(line);
            }
            text = sb;
        }
        return text.toString().trim();
    }

    public static ReportFactoryVars loadReportDefinitionXML_file(File xmlFile) {
        ReportFactoryVars rpv = new ReportFactoryVars(xmlFile);
        try {
            ReportFactory._loadReportDefinitionXML(rpv);
        }
        catch (Throwable t) {
            Print.logException((String)"Unable to load ReportFactory XML", (Throwable)t);
            rpv.setHasParsingErrors();
        }
        return rpv;
    }

    public static ReportFactoryVars loadReportDefinitionXML() {
        if (GlobalReportFactoryVars == null) {
            GlobalReportFactoryVars = new ReportFactoryVars(null);
        }
        try {
            ReportFactory._loadReportDefinitionXML(GlobalReportFactoryVars);
        }
        catch (Throwable t) {
            Print.logException((String)"Unable to load ReportFactory XML", (Throwable)t);
            GlobalReportFactoryVars.setHasParsingErrors();
        }
        return GlobalReportFactoryVars;
    }

    private static int _loadReportDefinitionXML(ReportFactoryVars rfv) {
        int count = 0;
        boolean isReload = rfv.isReload();
        rfv.reset();
        File xmlFile = rfv.getXMLFile();
        Document xmlDoc = ReportFactory._getDocument(xmlFile);
        if (xmlDoc == null) {
            rfv.setHasParsingErrors();
            return rfv.getCount();
        }
        Element reportDef = xmlDoc.getDocumentElement();
        if (!reportDef.getTagName().equalsIgnoreCase(TAG_ReportDefinition)) {
            Print.logError((String)("[" + xmlFile + "] Invalid root tag ID: " + reportDef.getTagName()), (Object[])new Object[0]);
            rfv.setHasParsingErrors();
            return count;
        }
        String i18nPkgName = reportDef.getAttribute(ATTR_i18nPackage);
        if (StringTools.isBlank((String)i18nPkgName)) {
            i18nPkgName = ReportFactory.class.getPackage().getName();
        }
        RTProperties rptDefProps = new RTProperties();
        NodeList propertiesNodes = XMLTools.getChildElements((Node)reportDef, (String)TAG_Properties);
        for (int pn = 0; pn < propertiesNodes.getLength(); ++pn) {
            Element propsTag = (Element)propertiesNodes.item(pn);
            NodeList propNodes = XMLTools.getChildElements((Node)propsTag, (String)TAG_Property);
            for (int p = 0; p < propNodes.getLength(); ++p) {
                Element propTag = (Element)propNodes.item(p);
                String propKey = XMLTools.getAttribute((Element)propTag, (String)ATTR_key, null);
                if (!StringTools.isBlank((String)propKey)) {
                    String propVal = ReportFactory.getNodeText(propTag, "\\n");
                    rptDefProps.setString(propKey, propVal);
                    continue;
                }
                Print.logError((String)("[" + xmlFile + "] Report Property 'key' is blank"), (Object[])new Object[0]);
                rfv.setHasParsingErrors();
            }
        }
        RTProperties globalProps = RTConfig.getProperties((String)PROP_ReportDefinition_, (boolean)false);
        for (Object gk : globalProps.getPropertyKeys()) {
            Object gv;
            if (!(gk instanceof String) || !((String)gk).startsWith(PROP_ReportDefinition_) || !((gv = globalProps.getProperty(gk, null)) instanceof String)) continue;
            String propKey = ((String)gk).substring(PROP_ReportDefinition_.length());
            String propVal = (String)gv;
            rptDefProps.setString(propKey, propVal);
        }
        Vector<String> dftCssFiles = new Vector<String>();
        StringBuffer dftStyle = new StringBuffer();
        NodeList defaultStyleNodes = XMLTools.getChildElements((Node)reportDef, (String)TAG_DefaultStyle);
        for (int dsl = 0; dsl < defaultStyleNodes.getLength(); ++dsl) {
            String style;
            Element dsTag = (Element)defaultStyleNodes.item(dsl);
            String cssFile = XMLTools.getAttribute((Element)dsTag, (String)ATTR_cssFile, null);
            if (!StringTools.isBlank((String)cssFile)) {
                dftCssFiles.add(cssFile);
            }
            if (StringTools.isBlank((String)(style = ReportFactory.getNodeText(dsTag, null)))) continue;
            dftStyle.append(style);
            dftStyle.append("\n");
        }
        ReportLayout.setDefaultCSSFiles(dftCssFiles);
        ReportLayout.setDefaultStyleSheet(ReportFactory.reformatStyle(dftStyle));
        NodeList layoutList = XMLTools.getChildElements((Node)reportDef, (String)TAG_ReportLayout);
        for (int rl = 0; rl < layoutList.getLength(); ++rl) {
            Element reportLayout = (Element)layoutList.item(rl);
            String layoutClass = reportLayout.getAttribute(ATTR_class);
            if (StringTools.isBlank((String)layoutClass)) {
                layoutClass = reportLayout.getAttribute(ATTR_layout);
            }
            Boolean isOptional = StringTools.parseBoolean((String)reportLayout.getAttribute(ATTR_optional), (boolean)false);
            String dateFmt = null;
            int fmt = 0;
            NodeList dateFmtNodes = XMLTools.getChildElements((Node)reportLayout, (String)TAG_DateFormat);
            if (fmt < dateFmtNodes.getLength()) {
                Element fmtTag = (Element)dateFmtNodes.item(fmt);
                dateFmt = ReportFactory.getNodeText(fmtTag, "");
            }
            String timeFmt = null;
            int fmt2 = 0;
            NodeList timeFmtNodes = XMLTools.getChildElements((Node)reportLayout, (String)TAG_TimeFormat);
            if (fmt2 < timeFmtNodes.getLength()) {
                Element fmtTag = (Element)timeFmtNodes.item(fmt2);
                timeFmt = ReportFactory.getNodeText(fmtTag, "");
            }
            Vector<String> cssFiles = new Vector<String>();
            StringBuffer layoutStyle = new StringBuffer();
            NodeList layoutStyleNodes = XMLTools.getChildElements((Node)reportLayout, (String)TAG_LayoutStyle);
            for (int dsl = 0; dsl < layoutStyleNodes.getLength(); ++dsl) {
                String style;
                Element lsTag = (Element)layoutStyleNodes.item(dsl);
                String cssFile = XMLTools.getAttribute((Element)lsTag, (String)ATTR_cssFile, null);
                if (!StringTools.isBlank((String)cssFile)) {
                    cssFiles.add(cssFile);
                }
                if (StringTools.isBlank((String)(style = ReportFactory.getNodeText(lsTag, null)))) continue;
                layoutStyle.append(style);
                layoutStyle.append("\n");
            }
            boolean foundLayout = false;
            try {
                MethodAction ma = new MethodAction((Object)layoutClass, "getReportLayout");
                ReportLayout rptLayout = (ReportLayout)ma.invoke();
                rptLayout.setDateTimeFormat(dateFmt, timeFmt);
                rptLayout.setCSSFiles(cssFiles);
                rptLayout.setStyleSheet(ReportFactory.reformatStyle(layoutStyle));
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                if (!IGNORE_MISSING_REPORTS && !isOptional.booleanValue()) {
                    Print.logError((String)("[" + xmlFile + "] ReportLayout class not found: " + layoutClass), (Object[])new Object[0]);
                    rfv.setHasParsingErrors();
                    continue;
                }
                if (RTConfig.isDebugMode()) {
                    Print.logWarn((String)("Optional ReportLayout class not found: " + layoutClass), (Object[])new Object[0]);
                    rfv.setHasParsingErrors();
                    continue;
                }
                Print.logDebug((String)("Ignoring Optional ReportLayout: " + layoutClass), (Object[])new Object[0]);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                Print.logError((String)("[" + xmlFile + "] ReportLayout static method not found: " + layoutClass + ".getReportLayout()"), (Object[])new Object[0]);
                rfv.setHasParsingErrors();
                continue;
            }
            catch (Throwable t) {
                Print.logException((String)("[" + xmlFile + "] Exception while initializing ReportLayout: " + layoutClass), (Throwable)t);
                rfv.setHasParsingErrors();
            }
        }
        NodeList rptTypesList = XMLTools.getChildElements((Node)reportDef, (String)TAG_ReportTypes);
        for (int ty = 0; ty < rptTypesList.getLength(); ++ty) {
            Element rptTypes = (Element)rptTypesList.item(ty);
            NodeList typeList = XMLTools.getChildElements((Node)rptTypes, (String)TAG_ReportType);
            for (int c = 0; c < typeList.getLength(); ++c) {
                Element type = (Element)typeList.item(c);
                String typeName = type.getAttribute(ATTR_name);
                boolean typeGroup = StringTools.parseBoolean((String)type.getAttribute(ATTR_isGroup), (boolean)false);
                String i18nKey = type.getAttribute(ATTR_i18n);
                String typeDescDft = ReportFactory.getNodeText(type, " ");
                I18N.Text typeDesc = ReportFactory.parseI18N(i18nPkgName, i18nKey, typeDescDft);
                ReportFactory.addReportType(typeName, typeGroup, typeDesc);
            }
        }
        NodeList reportList = XMLTools.getChildElements((Node)reportDef, (String)TAG_Report);
        block25: for (int r = 0; r < reportList.getLength(); ++r) {
            Element report = (Element)reportList.item(r);
            String rptName = report.getAttribute(ATTR_name);
            String rptType = report.getAttribute(ATTR_type);
            String rptClassName = report.getAttribute(ATTR_class);
            String rptLayout = report.getAttribute(ATTR_layout);
            String rptModules = report.getAttribute(ATTR_modules);
            boolean rptOptional = XMLTools.getAttributeBoolean((Element)report, (String)ATTR_optional, (boolean)false);
            boolean rptSysAdminOnly = XMLTools.getAttributeBoolean((Element)report, (String)ATTR_sysAdminOnly, (boolean)false);
            boolean rptTableSortable = XMLTools.getAttributeBoolean((Element)report, (String)ATTR_sortable, (boolean)false);
            I18N.Text rptMenu = null;
            I18N.Text rptTitle = null;
            I18N.Text rptSubt = null;
            Object[] rptHdrG = null;
            ReportColumn[] rptCols = null;
            Object rptColList = null;
            ReportConstraints rptRC = null;
            String rptIconSel = null;
            RTProperties rptProps = new RTProperties();
            OrderedMap rptOptMap = null;
            String rptOptType = null;
            if (!StringTools.isBlank((String)rptModules)) {
                String[] modules;
                for (String m : modules = StringTools.split((String)rptModules, (char)',')) {
                    if (StringTools.isBlank((String)m)) continue;
                    if (m.equalsIgnoreCase("extra") || m.equalsIgnoreCase("gtse")) {
                        if (DBConfig.hasExtraPackage()) continue;
                        Print.logDebug((String)("[Report '" + rptName + "'] Module not present: " + m), (Object[])new Object[0]);
                        continue block25;
                    }
                    if (m.equalsIgnoreCase("rule") || m.equalsIgnoreCase("enre")) {
                        if (DBConfig.hasRulePackage()) continue;
                        Print.logDebug((String)("[Report '" + rptName + "'] Module not present: " + m), (Object[])new Object[0]);
                        continue block25;
                    }
                    if (m.equalsIgnoreCase("bcross")) {
                        if (DBConfig.hasBCrossPackage()) continue;
                        Print.logDebug((String)("[Report '" + rptName + "'] Module not present: " + m), (Object[])new Object[0]);
                        continue block25;
                    }
                    Print.logWarn((String)("[Report '" + rptName + "'] Unrecognized module: " + m), (Object[])new Object[0]);
                    continue block25;
                }
            }
            NodeList attrList = report.getChildNodes();
            for (int c = 0; c < attrList.getLength(); ++c) {
                String colName;
                String ifFalse;
                String ifTrue;
                String i18nKey;
                Node attrNode = attrList.item(c);
                if (!(attrNode instanceof Element)) continue;
                String attrName = attrNode.getNodeName();
                Element attrElem = (Element)attrNode;
                if (attrName.equalsIgnoreCase(TAG_MenuDescription)) {
                    i18nKey = attrElem.getAttribute(ATTR_i18n);
                    String textDft = ReportFactory.getNodeText(attrElem, "\\n");
                    rptMenu = ReportFactory.parseI18N(i18nPkgName, i18nKey, textDft);
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Title)) {
                    i18nKey = attrElem.getAttribute(ATTR_i18n);
                    String textDft = ReportFactory.getNodeText(attrElem, "\\n");
                    rptTitle = ReportFactory.parseI18N(i18nPkgName, i18nKey, textDft);
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Subtitle)) {
                    i18nKey = attrElem.getAttribute(ATTR_i18n);
                    String textDft = ReportFactory.getNodeText(attrElem, "\\n");
                    rptSubt = ReportFactory.parseI18N(i18nPkgName, i18nKey, textDft);
                    continue;
                }
                if (rptHdrG == null && attrName.equalsIgnoreCase(TAG_HeaderGroups)) {
                    Vector<ReportHeaderGroup> grpList = new Vector<ReportHeaderGroup>();
                    NodeList groupList = XMLTools.getChildElements((Node)attrElem, (String)TAG_HeaderGroup);
                    int colIndex = 0;
                    for (int z = 0; z < groupList.getLength(); ++z) {
                        Element group = (Element)groupList.item(z);
                        String grpName = XMLTools.getAttribute((Element)group, (String)ATTR_name, (String)"");
                        ifTrue = XMLTools.getAttribute((Element)group, (String)ATTR_ifTrue, null);
                        ifFalse = XMLTools.getAttribute((Element)group, (String)ATTR_ifFalse, null);
                        if (!StringTools.isBlank((String)ifTrue) && !rptDefProps.getBoolean(ifTrue, true)) {
                            Print.logDebug((String)("Ignoring header group [" + ifTrue + "==true]: " + rptName + "." + grpName), (Object[])new Object[0]);
                            continue;
                        }
                        if (!StringTools.isBlank((String)ifFalse) && rptDefProps.getBoolean(ifFalse, true)) {
                            Print.logDebug((String)("Ignoring header group [" + ifFalse + "==false]: " + rptName + "." + grpName), (Object[])new Object[0]);
                            continue;
                        }
                        int colSpan = XMLTools.getAttributeInt((Element)group, (String)ATTR_colSpan, (int)1);
                        String titleStr = ReportFactory.getNodeText(group, "\\n");
                        I18N.Text colTitle = null;
                        if (!StringTools.isBlank((String)titleStr)) {
                            String i18nKey2 = XMLTools.getAttribute((Element)group, (String)ATTR_i18n, null);
                            colTitle = ReportFactory.parseI18N(i18nPkgName, i18nKey2, titleStr);
                        }
                        ReportHeaderGroup rhg = new ReportHeaderGroup(colIndex, colSpan, colTitle);
                        grpList.add(rhg);
                        colIndex += colSpan;
                    }
                    if (ListTools.isEmpty(grpList)) continue;
                    rptHdrG = grpList.toArray(new ReportHeaderGroup[grpList.size()]);
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Columns)) {
                    String ts;
                    Vector<ReportColumn> colList = new Vector<ReportColumn>();
                    NodeList columnList = XMLTools.getChildElements((Node)attrElem, (String)TAG_Column);
                    for (int z = 0; z < columnList.getLength(); ++z) {
                        Object[] pk;
                        Element column = (Element)columnList.item(z);
                        colName = XMLTools.getAttribute((Element)column, (String)ATTR_name, (String)column.getAttribute(ATTR_key));
                        boolean showCol = true;
                        ifTrue = XMLTools.getAttribute((Element)column, (String)ATTR_ifTrue, null);
                        ifFalse = XMLTools.getAttribute((Element)column, (String)ATTR_ifFalse, null);
                        if (StringTools.isBlank((String)colName)) {
                            showCol = false;
                            Print.logWarn((String)("Ignoring column with blank name: " + rptName + ".#" + z), (Object[])new Object[0]);
                        } else if (!StringTools.isBlank((String)ifTrue)) {
                            pk = new String[]{rptName + "." + ifTrue, ifTrue};
                            if (rptDefProps.hasProperty(pk) && !rptDefProps.getBoolean((String[])pk, true)) {
                                showCol = false;
                                Print.logDebug((String)("Ignoring column [" + ifTrue + "==true]: " + rptName + "." + colName), (Object[])new Object[0]);
                            }
                        } else if (!StringTools.isBlank((String)ifFalse) && rptDefProps.hasProperty(pk = new String[]{rptName + "." + ifFalse, ifFalse}) && rptDefProps.getBoolean((String[])pk, false)) {
                            showCol = false;
                            Print.logDebug((String)("Ignoring column [" + ifFalse + "==false]: " + rptName + "." + colName), (Object[])new Object[0]);
                        }
                        if (!showCol) continue;
                        String colArg = XMLTools.getAttribute((Element)column, (String)ATTR_arg, (String)"");
                        boolean colSort = XMLTools.getAttributeBoolean((Element)column, (String)ATTR_sortable, (boolean)true);
                        String titleStr = ReportFactory.getNodeText(column, "\\n");
                        String blankStr = XMLTools.getAttribute((Element)column, (String)ATTR_blankFill, null);
                        I18N.Text colTitle = null;
                        if (!StringTools.isBlank((String)titleStr)) {
                            String i18nKey3 = XMLTools.getAttribute((Element)column, (String)ATTR_i18n, null);
                            colTitle = ReportFactory.parseI18N(i18nPkgName, i18nKey3, titleStr);
                        }
                        ReportColumn rc = new ReportColumn(colName, colArg, colTitle);
                        rc.setSortable(rptTableSortable && colSort);
                        rc.setBlankFiller(blankStr);
                        colList.add(rc);
                    }
                    int columnCount = colList.size();
                    if (columnCount <= 0) continue;
                    int columnIndex = ListTools.size(rptCols);
                    if (rptCols == null) {
                        rptCols = colList.toArray(new ReportColumn[columnCount]);
                    } else {
                        int rci = rptCols.length;
                        ReportColumn[] rca = new ReportColumn[rci + columnCount];
                        System.arraycopy(rptCols, 0, rca, 0, rci);
                        for (ReportColumn rc : colList) {
                            rca[rci++] = rc;
                        }
                        rptCols = rca;
                    }
                    I18N.Text gt = null;
                    Element gte = XMLTools.getChildElement((Node)attrElem, (String)TAG_Title);
                    if (gte != null && !StringTools.isBlank((String)(ts = ReportFactory.getNodeText(gte, "\\n")))) {
                        String i18nk = XMLTools.getAttribute((Element)gte, (String)ATTR_i18n, null);
                        gt = ReportFactory.parseI18N(i18nPkgName, i18nk, ts);
                    }
                    ReportHeaderGroup rhg = new ReportHeaderGroup(columnIndex, columnCount, gt);
                    if (rptHdrG == null) {
                        rptHdrG = new ReportHeaderGroup[]{rhg};
                        continue;
                    }
                    rptHdrG = (ReportHeaderGroup[])ListTools.add((Object[])rptHdrG, (Object)rhg);
                    continue;
                }
                if (rptCols == null && attrName.equalsIgnoreCase(TAG_SimpleColumns)) {
                    String columns = ReportFactory.getNodeText(attrElem, null);
                    String[] cols = StringTools.parseStringArray((String)columns, (String)", \t\r\n");
                    Vector<ReportColumn> colList = new Vector<ReportColumn>();
                    for (int i = 0; i < cols.length; ++i) {
                        colName = cols[i].trim();
                        if (colName.equals("")) continue;
                        String colKey = colName;
                        int ka = colKey.indexOf(58);
                        String colArg = null;
                        if (ka >= 0) {
                            colArg = colKey.substring(ka + 1);
                            colKey = colKey.substring(0, ka);
                        }
                        ReportColumn rc = new ReportColumn(colKey, colArg, null);
                        rc.setSortable(rptTableSortable);
                        colList.add(rc);
                    }
                    rptCols = colList.toArray(new ReportColumn[colList.size()]);
                    continue;
                }
                if (rptOptMap == null && attrName.equalsIgnoreCase(TAG_Options)) {
                    rptOptType = XMLTools.getAttribute((Element)attrElem, (String)ATTR_type, (String)"");
                    rptOptType = StringTools.blankDefault((String)rptOptType, (String)OPTIONS_TYPE_list[0]).toLowerCase();
                    NodeList optionList = XMLTools.getChildElements((Node)attrElem, (String)TAG_Option);
                    if (ListTools.contains((Object[])OPTIONS_TYPE_list, (Object)rptOptType)) {
                        rptOptMap = new OrderedMap();
                        for (int z = 0; z < optionList.getLength(); ++z) {
                            Element option = (Element)optionList.item(z);
                            String optName = XMLTools.getAttribute((Element)option, (String)ATTR_name, (String)"");
                            String ifTrue2 = XMLTools.getAttribute((Element)option, (String)ATTR_ifTrue, null);
                            String ifFalse2 = XMLTools.getAttribute((Element)option, (String)ATTR_ifFalse, null);
                            if (StringTools.isBlank((String)optName)) {
                                Print.logError((String)("[" + xmlFile + "] Missing Option name"), (Object[])new Object[0]);
                                rfv.setHasParsingErrors();
                                continue;
                            }
                            if (!StringTools.isBlank((String)ifTrue2) && !rptDefProps.getBoolean(ifTrue2, true)) {
                                Print.logDebug((String)("Ignoring option [" + ifTrue2 + "==true]: " + rptName + "." + optName), (Object[])new Object[0]);
                                continue;
                            }
                            if (!StringTools.isBlank((String)ifFalse2) && rptDefProps.getBoolean(ifFalse2, true)) {
                                Print.logDebug((String)("Ignoring option [" + ifFalse2 + "==false]: " + rptName + "." + optName), (Object[])new Object[0]);
                                continue;
                            }
                            if (rptOptMap.containsKey((Object)optName)) {
                                Print.logError((String)("[" + xmlFile + "] Option already defined: " + optName), (Object[])new Object[0]);
                                rfv.setHasParsingErrors();
                                continue;
                            }
                            ReportOption rptOpt = new ReportOption(optName);
                            rptOptMap.put((Object)optName, (Object)rptOpt);
                            NodeList optChildList = option.getChildNodes();
                            for (int zz = 0; zz < optChildList.getLength(); ++zz) {
                                Node optChildNode = optChildList.item(zz);
                                if (!(optChildNode instanceof Element)) continue;
                                String optChildName = optChildNode.getNodeName();
                                Element optChildElem = (Element)optChildNode;
                                if (optChildName.equalsIgnoreCase(TAG_Description)) {
                                    String i18nKey4 = optChildElem.getAttribute(ATTR_i18n);
                                    String textDft = ReportFactory.getNodeText(optChildElem, "\\n");
                                    rptOpt.setDescription(ReportFactory.parseI18N(i18nPkgName, i18nKey4, textDft));
                                    continue;
                                }
                                if (optChildName.equalsIgnoreCase(TAG_Property)) {
                                    String propKey = optChildElem.getAttribute(ATTR_key);
                                    if (!StringTools.isBlank((String)propKey)) {
                                        String propVal = ReportFactory.getNodeText(optChildElem, "\\n");
                                        propVal = rptDefProps.insertKeyValues(propVal);
                                        rptOpt.setValue(propKey, propVal);
                                        continue;
                                    }
                                    Print.logError((String)("[" + xmlFile + "] Option Property 'key' is blank: " + optName), (Object[])new Object[0]);
                                    rfv.setHasParsingErrors();
                                    continue;
                                }
                                Print.logError((String)("[" + xmlFile + "] Unrecognized TAG: " + optChildName), (Object[])new Object[0]);
                                rfv.setHasParsingErrors();
                            }
                        }
                        continue;
                    }
                    if (optionList.getLength() <= 0) continue;
                    Print.logError((String)("[" + xmlFile + "] 'Option' tags ignored for type: " + rptOptType), (Object[])new Object[0]);
                    rfv.setHasParsingErrors();
                    continue;
                }
                if (rptRC == null && attrName.equalsIgnoreCase(TAG_Constraints)) {
                    rptRC = ReportFactory.parseReportConstraintsXML(rfv, attrElem, rptDefProps);
                    continue;
                }
                if (rptIconSel == null && attrName.equalsIgnoreCase(TAG_MapIconSelector)) {
                    Object[] rfName = StringTools.split((String)attrElem.getAttribute(ATTR_ruleFactoryName), (char)',');
                    RuleFactory ruleFact = Device.getRuleFactory((boolean)true);
                    if (ruleFact == null || !ListTools.isEmpty((Object[])rfName) && !ListTools.containsIgnoreCase((String[])rfName, (String)ruleFact.getName()) || ruleFact.checkSelectorSyntax(rptIconSel = ReportFactory.getNodeText(attrElem, " "))) continue;
                    Print.logError((String)("[" + xmlFile + "] Invalid MapIconSelector syntax: " + rptIconSel + " [" + ruleFact.getName() + "]"), (Object[])new Object[0]);
                    rfv.setHasParsingErrors();
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Property)) {
                    String propKey = attrElem.getAttribute(ATTR_key);
                    if (!StringTools.isBlank((String)propKey)) {
                        String propVal = ReportFactory.getNodeText(attrElem, "\\n");
                        propVal = rptDefProps.insertKeyValues(propVal);
                        rptProps.setString(propKey, propVal);
                        continue;
                    }
                    Print.logError((String)("[" + xmlFile + "] Report Property 'key' is blank: " + rptName), (Object[])new Object[0]);
                    rfv.setHasParsingErrors();
                    continue;
                }
                Print.logError((String)("[" + xmlFile + "] Unrecognized tag name: " + attrName), (Object[])new Object[0]);
                rfv.setHasParsingErrors();
            }
            try {
                ReportOptionsProvider rptOptProv;
                ReportFactory rf = new ReportFactory();
                rf.setReportName(rptName);
                rf.setReportType(rptType);
                rf.setReportClassName(rptClassName);
                Class rptClass = rf.getReportClass();
                if (!StringTools.isBlank((String)rptLayout)) {
                    Class<?> layoutExpect = null;
                    try {
                        layoutExpect = Class.forName(rptLayout);
                        Print.logDebug((String)("Found layout: " + StringTools.className(layoutExpect)), (Object[])new Object[0]);
                    }
                    catch (Throwable t) {
                        Print.logError((String)("[" + xmlFile + "] Report '" + rptName + "' [Specified layout not found]"), (Object[])new Object[0]);
                        rfv.setHasParsingWarnings();
                    }
                    Class<?> layoutActual = null;
                    try {
                        MethodAction ma;
                        ReportLayout rl;
                        if (layoutExpect != null && (rl = (ReportLayout)(ma = new MethodAction((Object)rptClass, "GetReportLayout")).invoke()) != null) {
                            layoutActual = rl.getClass();
                        }
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                    if (layoutActual != null && layoutExpect != null && !layoutActual.equals(layoutExpect)) {
                        Print.logError((String)("[" + xmlFile + "] Report '" + rptName + "' [Incorrect specified layout]"), (Object[])new Object[0]);
                        rfv.setHasParsingWarnings();
                    }
                }
                rf.setMenuDescription(rptMenu);
                rf.setReportTitle(rptTitle);
                rf.setReportSubtitle(rptSubt);
                rf.setReportColumns(rptCols);
                rf.setReportConstraints(rptRC);
                rf.setMapIconSelector(rptIconSel);
                rf.setProperties(rptProps);
                rf.setSysAdminOnly(rptSysAdminOnly);
                rf.setTableSortable(rptTableSortable);
                if (ListTools.size(rptHdrG) > 0 && (rptHdrG.length != 1 || rptHdrG[0].hasTitle())) {
                    rf.setReportHeaderGroups((ReportHeaderGroup[])rptHdrG);
                }
                if (rptOptMap != null) {
                    rf.setReportOptionMap(rptOptMap);
                } else if (ListTools.contains((Object[])OPTIONS_TYPE_geozone, (Object)rptOptType)) {
                    final String _rptName = rptName;
                    rptOptProv = new ReportOptionsProvider(){

                        @Override
                        public OrderedMap<String, ReportOption> getReportOptionMap(ReportFactory rptFact, RequestProperties reqState) {
                            Account account;
                            Account account2 = account = reqState != null ? reqState.getCurrentAccount() : null;
                            if (account == null) {
                                return null;
                            }
                            try {
                                String[] idList;
                                OrderedMap roMap = new OrderedMap();
                                for (String id : idList = Geozone.getGeozoneIDsForAccount((String)account.getAccountID())) {
                                    Geozone GZ = Geozone.getGeozone((Account)account, (String)id, (int)0, (boolean)false);
                                    if (GZ == null) continue;
                                    String desc = GZ.getDescription();
                                    ReportOption ro = new ReportOption(id);
                                    ro.setDescription("[" + id + "] " + desc);
                                    ro.setValue("accountID", account.getAccountID());
                                    ro.setValue("geozoneID", id);
                                    ro.setValue("sortID", String.valueOf(GZ.getSortID()));
                                    ro.setValue("zonePurposeID", GZ.getZonePurposeID());
                                    ro.setValue("reverseGeocode", GZ.getReverseGeocode() ? "1" : "0");
                                    ro.setValue("arrivalZone", GZ.getArrivalZone() ? "1" : "0");
                                    ro.setValue("departureZone", GZ.getDepartureZone() ? "1" : "0");
                                    ro.setValue("groupID", GZ.getGroupID());
                                    ro.setValue("description", desc);
                                    roMap.put((Object)id, (Object)ro);
                                }
                                return roMap;
                            }
                            catch (DBException dbe) {
                                Print.logException((String)(_rptName + ") Reading Account Geozones"), (Throwable)dbe);
                                return null;
                            }
                        }
                    };
                    rf.setReportOptionMap(rptOptProv);
                } else if (ListTools.contains((Object[])OPTIONS_TYPE_fleet, (Object)rptOptType)) {
                    final String _rptName = rptName;
                    rptOptProv = new ReportOptionsProvider(){

                        @Override
                        public OrderedMap<String, ReportOption> getReportOptionMap(ReportFactory rptFact, RequestProperties reqState) {
                            Account account;
                            Account account2 = account = reqState != null ? reqState.getCurrentAccount() : null;
                            if (account == null) {
                                return null;
                            }
                            try {
                                OrderedMap roMap = new OrderedMap();
                                if (reqState != null) {
                                    OrderedSet<String> idList = reqState.getDeviceGroupIDList(true);
                                    for (String id : idList) {
                                        DeviceGroup DG = DeviceGroup.getDeviceGroup((Account)account, (String)id);
                                        if (DG == null) continue;
                                        String desc = DG.getDescription();
                                        ReportOption ro = new ReportOption(id);
                                        ro.setDescription("[" + id + "] " + desc);
                                        ro.setValue("accountID", account.getAccountID());
                                        ro.setValue("groupID", id);
                                        ro.setValue("description", desc);
                                        roMap.put((Object)id, (Object)ro);
                                    }
                                }
                                return roMap;
                            }
                            catch (DBException dbe) {
                                Print.logException((String)(_rptName + ") Reading Account DeviceGroups"), (Throwable)dbe);
                                return null;
                            }
                        }
                    };
                    rf.setReportOptionMap(rptOptProv);
                } else if (ListTools.contains((Object[])OPTIONS_TYPE_statusCode, (Object)rptOptType)) {
                    String _rptName = rptName;
                    rptOptProv = new ReportOptionsProvider(){

                        @Override
                        public OrderedMap<String, ReportOption> getReportOptionMap(ReportFactory rptFact, RequestProperties reqState) {
                            Account account;
                            Account account2 = account = reqState != null ? reqState.getCurrentAccount() : null;
                            if (account == null) {
                                return null;
                            }
                            OrderedMap roMap = new OrderedMap();
                            if (reqState != null) {
                                OrderedMap scDescMap = reqState.getPrivateLabel().getStatusCodeDescriptionMap();
                                for (Integer sc : scDescMap.keySet()) {
                                    String id = "0x" + StringTools.toHexString((long)sc.intValue(), (int)16);
                                    String desc = (String)scDescMap.get(sc);
                                    ReportOption ro = new ReportOption(id);
                                    ro.setDescription("[" + id + "] " + desc);
                                    ro.setValue("accountID", account.getAccountID());
                                    ro.setValue("statusCode", id);
                                    ro.setValue("description", desc);
                                    roMap.put((Object)id, (Object)ro);
                                }
                            }
                            return roMap;
                        }
                    };
                    rf.setReportOptionMap(rptOptProv);
                } else if (ListTools.contains((Object[])OPTIONS_TYPE_custom, (Object)rptOptType)) {
                    try {
                        MethodAction rptOptProvMA = new MethodAction((Object)rptClass, "getReportOptionsProvider");
                        rptOptProv = (ReportOptionsProvider)rptOptProvMA.invoke();
                        if (rptOptProv != null) {
                            rf.setReportOptionMap(rptOptProv);
                        }
                    }
                    catch (NoSuchMethodException nsme) {
                    }
                    catch (Throwable th) {
                        Print.logInfo((String)("'getReportOptionsProvider' error: " + th), (Object[])new Object[0]);
                    }
                }
                rfv.addReportFactory(rf);
                ++count;
                continue;
            }
            catch (ReportException re) {
                if (!IGNORE_MISSING_REPORTS && !rptOptional) {
                    Print.logError((String)("[" + xmlFile + "] Report '" + rptName + "' [" + re.getMessage() + "]"), (Object[])new Object[0]);
                    rfv.setHasParsingErrors();
                    continue;
                }
                if (RTConfig.isDebugMode()) {
                    Print.logWarn((String)("[" + xmlFile + "] Optional Report '" + rptName + "' [" + re.getMessage() + "]"), (Object[])new Object[0]);
                    rfv.setHasParsingErrors();
                    continue;
                }
                Print.logDebug((String)("[" + xmlFile + "] Ignoring Optional Report: " + rptClassName), (Object[])new Object[0]);
            }
        }
        try {
            MethodAction reportJobAddTag = new MethodAction((Object)"org.opengts.extra.tables.ReportJob", "AddIntervalTag", new Class[]{String.class, I18N.Text.class, String.class, String.class});
            NodeList rptJobsList = XMLTools.getChildElements((Node)reportDef, (String)TAG_ReportJobs);
            for (int ty = 0; ty < rptJobsList.getLength(); ++ty) {
                Element rptJobs = (Element)rptJobsList.item(ty);
                NodeList iTagList = XMLTools.getChildElements((Node)rptJobs, (String)TAG_IntervalTag);
                for (int c = 0; c < iTagList.getLength(); ++c) {
                    Element iTag = (Element)iTagList.item(c);
                    String tagID = iTag.getAttribute(ATTR_id);
                    String frTime = iTag.getAttribute(ATTR_fromTime);
                    String toTime = iTag.getAttribute(ATTR_toTime);
                    String i18nKey = iTag.getAttribute(ATTR_i18n);
                    String descDft = ReportFactory.getNodeText(iTag, " ");
                    I18N.Text tagDesc = ReportFactory.parseI18N(i18nPkgName, i18nKey, descDft);
                    if (StringTools.isBlank((String)tagID)) {
                        Print.logError((String)("[" + xmlFile + "] ReportJob attribute 'id' is blank"), (Object[])new Object[0]);
                        rfv.setHasParsingErrors();
                        continue;
                    }
                    if (StringTools.isBlank((String)frTime) || StringTools.isBlank((String)toTime)) {
                        Print.logError((String)("[" + xmlFile + "] ReportJob tag-id '" + tagID + "' has blank 'fromTime'/'toTime'"), (Object[])new Object[0]);
                        continue;
                    }
                    Print.logDebug((String)("[" + xmlFile + "] Adding ReportJob id=" + tagID + ", from=" + frTime + ", to=" + toTime), (Object[])new Object[0]);
                    reportJobAddTag.invoke(new Object[]{tagID, tagDesc, frTime, toTime});
                }
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        NodeList inclList = XMLTools.getChildElements((Node)reportDef, (String)TAG_Include);
        for (int ic = 0; ic < inclList.getLength(); ++ic) {
            File file;
            Element include = (Element)inclList.item(ic);
            boolean optional = XMLTools.getAttributeBoolean((Element)include, (String)ATTR_optional, (boolean)false, (boolean)false);
            String dirStr = XMLTools.getAttribute((Element)include, (String)ATTR_dir, null, (boolean)false);
            File inclDir = !StringTools.isBlank((String)dirStr) ? new File(dirStr) : null;
            String inclFile = XMLTools.getAttribute((Element)include, (String)ATTR_file, null, (boolean)false);
            File parentDir = xmlFile.getParentFile();
            Vector<String> filesChecked = new Vector<String>();
            File foundInclFile = null;
            if (foundInclFile == null && parentDir != null && inclDir != null) {
                File dir = new File(parentDir, inclDir.toString());
                File file2 = new File(dir, inclFile);
                filesChecked.add(file2.toString());
                if (file2.isFile()) {
                    foundInclFile = file2;
                }
            }
            if (foundInclFile == null && parentDir != null) {
                file = new File(parentDir, inclFile);
                filesChecked.add(file.toString());
                if (file.isFile()) {
                    foundInclFile = file;
                }
            }
            if (foundInclFile == null && inclDir != null) {
                file = new File(inclDir, inclFile);
                filesChecked.add(file.toString());
                if (file.isFile()) {
                    foundInclFile = file;
                }
            }
            if (foundInclFile == null && parentDir != null) {
                file = new File(inclFile);
                filesChecked.add(file.toString());
                if (file.isFile()) {
                    foundInclFile = file;
                }
            }
            if (foundInclFile != null && foundInclFile.isFile()) {
                try {
                    String inclFilePath = foundInclFile.getCanonicalPath();
                    Print.logInfo((String)("Found Include: " + inclFilePath), (Object[])new Object[0]);
                }
                catch (Throwable th) {
                    Print.logError((String)("Error while including file: " + foundInclFile), (Object[])new Object[0]);
                    Print.logException((String)("Error while including file: " + foundInclFile), (Throwable)th);
                }
                continue;
            }
            if (optional) continue;
            Print.logWarn((String)("Include file not found: " + inclFile), (Object[])new Object[0]);
            rfv.setHasParsingWarnings();
        }
        if (!isReload) {
            Print.logDebug((String)("Loaded: " + xmlFile), (Object[])new Object[0]);
        }
        return count;
    }

    private static String reformatStyle(StringBuffer style) {
        String[] styleLines = StringTools.parseStringArray((String)style.toString(), (String)"\r\n");
        for (int i = 0; i < styleLines.length; ++i) {
            styleLines[i] = styleLines[i].trim();
        }
        return StringTools.join((String[])styleLines, (char)'\n');
    }

    private static ReportConstraints parseReportConstraintsXML(ReportFactoryVars rfv, Element dftConst, RTProperties rptDefProps) {
        File xmlFile = rfv.getXMLFile();
        ReportConstraints rc = new ReportConstraints();
        NodeList attrList = dftConst.getChildNodes();
        for (int c = 0; c < attrList.getLength(); ++c) {
            String limStr;
            Node attrNode = attrList.item(c);
            if (!(attrNode instanceof Element)) continue;
            String attrName = attrNode.getNodeName();
            Element attrElem = (Element)attrNode;
            if (attrName.equalsIgnoreCase(TAG_TimeStart)) {
                rc.setTimeStart(StringTools.parseLong((String)ReportFactory.getNodeText(attrElem, " "), (long)-1L));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_TimeEnd)) {
                rc.setTimeEnd(StringTools.parseLong((String)ReportFactory.getNodeText(attrElem, " "), (long)-1L));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_ValidGPSRequired)) {
                rc.setValidGPSRequired(StringTools.parseBoolean((String)ReportFactory.getNodeText(attrElem, " "), (boolean)false));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_OrderAscending)) {
                rc.setOrderAscending(StringTools.parseBoolean((String)ReportFactory.getNodeText(attrElem, " "), (boolean)true));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_OrderDescending)) {
                rc.setOrderAscending(!StringTools.parseBoolean((String)ReportFactory.getNodeText(attrElem, " "), (boolean)false));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_SelectionLimit)) {
                limStr = rptDefProps.insertKeyValues(ReportFactory.getNodeText(attrElem, " "));
                long limit = StringTools.parseLong((String)limStr, (long)-1L);
                String typeStr = attrElem.getAttribute(ATTR_type);
                if (typeStr == null) {
                    typeStr = "";
                }
                EventData.LimitType type = EventData.LimitType.FIRST;
                type = typeStr.equalsIgnoreCase("first") ? EventData.LimitType.FIRST : (typeStr.equalsIgnoreCase("last") ? EventData.LimitType.LAST : (limit > 0L ? EventData.LimitType.LAST : EventData.LimitType.FIRST));
                rc.setSelectionLimit(type, limit);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_ReportLimit)) {
                limStr = rptDefProps.insertKeyValues(ReportFactory.getNodeText(attrElem, " "));
                long limit = StringTools.parseLong((String)limStr, (long)-1L);
                rc.setReportLimit(limit);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_Where)) {
                String typeStr = attrElem.getAttribute(ATTR_type);
                rc.setWhere(ReportFactory.getNodeText(attrElem, " "));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_RuleSelector)) {
                Object[] rfName = StringTools.split((String)attrElem.getAttribute(ATTR_ruleFactoryName), (char)',');
                RuleFactory ruleFact = Device.getRuleFactory((boolean)true);
                if (ruleFact == null || !ListTools.isEmpty((Object[])rfName) && !ListTools.containsIgnoreCase((String[])rfName, (String)ruleFact.getName())) continue;
                String ruleSel = ReportFactory.getNodeText(attrElem, " ");
                if (!ruleFact.checkSelectorSyntax(ruleSel)) {
                    Print.logWarn((String)("[" + xmlFile + "] Invalid RuleSelector syntax: " + ruleSel), (Object[])new Object[0]);
                }
                rc.setRuleSelector(ruleSel);
                continue;
            }
            Print.logError((String)("[" + xmlFile + "] Unrecognized tag: " + attrName), (Object[])new Object[0]);
            rfv.setHasParsingErrors();
        }
        return rc;
    }

    protected static ReportType _getReportType(String type) {
        return ReportTypeMap != null && type != null ? ReportTypeMap.get(type) : null;
    }

    public static boolean hasReportType(String type) {
        return ReportFactory._getReportType(type) != null;
    }

    public static boolean getReportTypeIsGroup(String type) {
        ReportType rt = ReportFactory._getReportType(type);
        return rt != null ? rt.isGroup() : false;
    }

    public static String getReportTypeDescription(String type, Locale loc) {
        ReportType rt = ReportFactory._getReportType(type);
        return rt != null ? rt.getDescription(loc) : "";
    }

    public static void addReportType(String type, boolean isGroup, I18N.Text desc) {
        if (!StringTools.isBlank((String)type)) {
            if (ReportTypeMap == null) {
                ReportTypeMap = new HashMap();
            }
            ReportTypeMap.put(type, new ReportType(type, isGroup, desc));
        }
    }

    public static ReportFactory getReportFactory(String rptName, boolean isOptional) throws ReportException {
        ReportFactory rptFact = ReportFactory._getReportFactory(rptName);
        if (rptFact == null) {
            if (isOptional) {
                return null;
            }
            throw new ReportException("Report name not found: " + rptName);
        }
        return rptFact;
    }

    public static ReportFactory getReportFactory(String rptName) {
        return ReportFactory._getReportFactory(rptName);
    }

    protected static ReportFactory _getReportFactory(String rptName) {
        if (GlobalReportFactoryVars == null) {
            return null;
        }
        return GlobalReportFactoryVars.getReportFactory(rptName);
    }

    protected static I18N.Text parseI18N(String pkgName, String i18nKey, String dftStr) {
        if (StringTools.isBlank((String)i18nKey) && StringTools.isBlank((String)dftStr)) {
            return null;
        }
        if (StringTools.isBlank((String)i18nKey)) {
            // empty if block
        }
        I18N.Text text = I18N.parseText((String)pkgName, (String)i18nKey, (String)dftStr, (boolean)false);
        if (SAVE_I18N_STRINGS) {
            if (I18N_STRINGS == null) {
                I18N_STRINGS = new OrderedSet();
            }
            I18N_STRINGS.add(text);
        }
        return text;
    }

    private ReportFactory() {
    }

    private void setReportName(String rn) throws ReportException {
        if (rn == null || rn.equals("")) {
            throw new ReportException("Report name not specified");
        }
        this.reportName = rn;
    }

    public String getReportName() {
        return this.reportName != null ? this.reportName : "report";
    }

    private void setReportType(String rptType) throws ReportException {
        String[] rt = StringTools.split((String)rptType, (char)',');
        if (rt == null || rt.length <= 0) {
            throw new ReportException("Report type not specified");
        }
        for (int i = 0; i < rt.length; ++i) {
            if (ReportFactory.hasReportType(rt[i])) continue;
            throw new ReportException("Report type not defined: " + rt);
        }
        this.reportType = rt[0];
    }

    public String getReportType() {
        return this.reportType != null ? this.reportType : REPORT_TYPE_DEVICE_DETAIL;
    }

    public boolean getReportTypeIsGroup() {
        return ReportFactory.getReportTypeIsGroup(this.getReportType());
    }

    public void setSysAdminOnly(boolean sysAdmin) {
        this.isSysAdminOnly = sysAdmin;
    }

    public boolean getSysAdminOnly() {
        return this.isSysAdminOnly;
    }

    public boolean isSysAdminOnly() {
        return this.isSysAdminOnly;
    }

    public void setTableSortable(boolean sortable) {
        this.isTableSortable = sortable;
    }

    public boolean getTableSortable() {
        return this.isTableSortable;
    }

    public boolean isTableSortable() {
        return this.isTableSortable;
    }

    private void setReportClassName(String cn) throws ReportException {
        if (StringTools.isBlank((String)cn)) {
            throw new ReportException("Report class name not specified");
        }
        this.className = cn;
    }

    public String getReportClassName() {
        return this.className;
    }

    public Class getReportClass() throws ReportException {
        if (this.classObj == null) {
            String cn = this.getReportClassName();
            if (StringTools.isBlank((String)cn)) {
                throw new ReportException("Report class name not specified");
            }
            try {
                Class<?> rptClass = Class.forName(cn);
                if (!ReportData.class.isAssignableFrom(rptClass)) {
                    throw new ReportException(cn + " does not implement interface ReportData");
                }
                this.classObj = rptClass;
            }
            catch (ClassNotFoundException cnfe) {
                throw new ReportException("Class not found: " + cn);
            }
            catch (Throwable t) {
                throw new ReportException("Unable to load class: " + cn, t);
            }
        }
        return this.classObj;
    }

    public ReportData createReport(ReportEntry reportEntry, String reportOptionID, RequestProperties reqState, Device device) throws ReportException {
        String rptClassName = StringTools.className((Object)this.getReportClass());
        if (device == null) {
            return this._createReport(reportEntry, reportOptionID, reqState, null);
        }
        if (reqState != null) {
            Account account = reqState.getCurrentAccount();
            User user = reqState.getCurrentUser();
            return this._createReport(reportEntry, reportOptionID, reqState, new ReportDeviceList(account, user, device));
        }
        return this._createReport(reportEntry, reportOptionID, null, null);
    }

    public ReportData createReport(ReportEntry reportEntry, String reportOptionID, RequestProperties reqState, DeviceGroup group) throws ReportException {
        String rptClassName = StringTools.className((Object)this.getReportClass());
        if (group == null) {
            return this._createReport(reportEntry, reportOptionID, reqState, null);
        }
        if (reqState != null) {
            Account account = reqState.getCurrentAccount();
            User user = reqState.getCurrentUser();
            return this._createReport(reportEntry, reportOptionID, reqState, new ReportDeviceList(account, user, group));
        }
        return this._createReport(reportEntry, reportOptionID, null, null);
    }

    public ReportData createReport(ReportEntry reportEntry, String reportOptionID, RequestProperties reqState, ReportDeviceList deviceList) throws ReportException {
        return this._createReport(reportEntry, reportOptionID, reqState, deviceList);
    }

    protected ReportData _createReport(ReportEntry reportEntry, String reportOptionID, RequestProperties reqState, ReportDeviceList deviceList) throws ReportException {
        Object reportInstance;
        block9: {
            reportInstance = null;
            Class rptClass = this.getReportClass();
            if (reportEntry != null && reportEntry.getReportFactory() != this) {
                throw new ReportException("Invalid ReportEntry: " + this.getReportName());
            }
            try {
                if (reportEntry == null) {
                    Print.logWarn((String)"ReportEntry not specified ...", (Object[])new Object[0]);
                    throw new Throwable("No ReportEntry ... try again using ReportFactory");
                }
                Class[] argTypes = new Class[]{ReportEntry.class, RequestProperties.class, ReportDeviceList.class};
                MethodAction rc = new MethodAction((Object)rptClass, "<init>", argTypes);
                reportInstance = rc.invoke(new Object[]{reportEntry, reqState, deviceList});
            }
            catch (ReportException re) {
                throw re;
            }
            catch (Throwable reTh) {
                if (reqState == null) break block9;
                try {
                    Class[] argTypes = new Class[]{ReportFactory.class, RequestProperties.class, Account.class, User.class, ReportDeviceList.class};
                    MethodAction rc = new MethodAction((Object)rptClass, "<init>", argTypes);
                    Account account = reqState.getCurrentAccount();
                    User user = reqState.getCurrentUser();
                    reportInstance = rc.invoke(new Object[]{this, reqState, account, user, deviceList});
                    Print.logInfo((String)("Report not yet converted to new constructor: " + this.getReportName()), (Object[])new Object[0]);
                }
                catch (ReportException re) {
                    throw re;
                }
                catch (Throwable reTh2) {
                    throw new ReportException("Unable to create report: " + this.getReportClassName(), reTh);
                }
            }
        }
        if (!(reportInstance instanceof ReportData)) {
            throw new ReportException("Report class is not a subclass of ReportData");
        }
        Locale locale = reqState != null ? reqState.getLocale() : null;
        ReportData report = (ReportData)reportInstance;
        report.setReportName(this.getReportName());
        report.setReportTitle(this.getReportTitle(locale));
        report.setReportSubtitle(this.getReportSubtitle(locale));
        report.setReportHeaderGroups(this.getReportHeaderGroups());
        report.setReportColumns(this.getReportColumns());
        report.setReportConstraints(this.getReportConstraints());
        report.setMapIconSelector(this.getMapIconSelector());
        ReportOption rptOpt = this.getReportOption(reportOptionID, reqState);
        report.setReportOption(rptOpt);
        return report;
    }

    private void setMenuDescription(I18N.Text text) {
        this.menuDescription = text;
    }

    public I18N.Text getMenuDescription() {
        return this.menuDescription;
    }

    public String getMenuDescription(Locale loc, String dft) {
        return this.menuDescription != null ? this.menuDescription.toString(loc) : dft;
    }

    public String getMenuDescription(Locale loc) {
        return this.getMenuDescription(loc, "Menu Item");
    }

    private void setReportTitle(I18N.Text rt) {
        this.reportTitle = rt;
    }

    public I18N.Text getReportTitle() {
        return this.reportTitle;
    }

    public String getReportTitle(Locale loc, String dft) {
        return this.reportTitle != null ? this.reportTitle.toString(loc) : dft;
    }

    public String getReportTitle(Locale loc) {
        return this.getReportTitle(loc, "A Report");
    }

    private void setReportSubtitle(I18N.Text st) {
        this.reportSubtitle = st;
    }

    public I18N.Text getReportSubtitle() {
        return this.reportSubtitle;
    }

    public String getReportSubtitle(Locale loc, String dft) {
        return this.reportSubtitle != null ? this.reportSubtitle.toString(loc) : dft;
    }

    public String getReportSubtitle(Locale loc) {
        return this.getReportSubtitle(loc, "${deviceDesc} [${deviceId}]\n${dateRange}");
    }

    private void setReportHeaderGroups(ReportHeaderGroup[] rhg) {
        this.reportHeaderGroups = rhg;
    }

    public ReportHeaderGroup[] getReportHeaderGroups() {
        return this.reportHeaderGroups;
    }

    private void setReportColumns(ReportColumn[] rc) {
        this.reportColumns = rc;
    }

    public ReportColumn[] getReportColumns() {
        return this.reportColumns != null ? this.reportColumns : new ReportColumn[]{};
    }

    private void setReportConstraints(ReportConstraints rc) {
        this.dftConstraints = rc;
    }

    public boolean hasReportConstraints() {
        return this.dftConstraints != null;
    }

    public ReportConstraints getReportConstraints() {
        if (this.dftConstraints == null) {
            return null;
        }
        return (ReportConstraints)this.dftConstraints.clone();
    }

    public void setMapIconSelector(String iconSel) {
        this.mapIconSelector = iconSel != null && !iconSel.equals("") ? iconSel : null;
    }

    public String getMapIconSelector() {
        return this.mapIconSelector;
    }

    public void setProperties(RTProperties props) {
        this.reportProperties = props;
    }

    public RTProperties getProperties() {
        if (this.reportProperties == null) {
            this.reportProperties = new RTProperties();
        }
        return this.reportProperties;
    }

    public void setReportOptionMap(OrderedMap<String, ReportOption> rptOptMap) {
        this.reportOptions = rptOptMap;
        if (this.reportOptions != null) {
            this.reportOptionsProvider = null;
        }
    }

    public void setReportOptionMap(ReportOptionsProvider rptOpProvider) {
        this.reportOptionsProvider = rptOpProvider;
        if (this.reportOptionsProvider != null) {
            this.reportOptions = null;
        }
    }

    public OrderedMap<String, ReportOption> getReportOptionMap(RequestProperties reqState) {
        if (!ListTools.isEmpty(this.reportOptions)) {
            return this.reportOptions;
        }
        if (this.reportOptionsProvider != null) {
            OrderedMap<String, ReportOption> map = this.reportOptionsProvider.getReportOptionMap(this, reqState);
            return map;
        }
        return null;
    }

    public boolean hasReportOptions(RequestProperties reqState) {
        return !ListTools.isEmpty(this.getReportOptionMap(reqState));
    }

    public ReportOption getReportOption(String name, RequestProperties reqState) {
        if (name == null) {
            return null;
        }
        OrderedMap<String, ReportOption> rptOpt = this.getReportOptionMap(reqState);
        if (ListTools.isEmpty(rptOpt)) {
            return null;
        }
        return (ReportOption)rptOpt.get((Object)name);
    }

    public OrderedMap<String, String> getReportOptionDescriptionMap(RequestProperties reqState) {
        OrderedMap<String, ReportOption> rptOptMap = this.getReportOptionMap(reqState);
        if (ListTools.isEmpty(rptOptMap)) {
            return null;
        }
        if (reqState != null) {
            Locale locale = reqState.getLocale();
            Account account = reqState.getCurrentAccount();
            OrderedMap descMap = new OrderedMap();
            for (ReportOption rptOpt : rptOptMap.values()) {
                String desc;
                String key = rptOpt.getName();
                String val = desc = rptOpt.getDescription(locale, reqState);
                descMap.put((Object)key, (Object)val);
            }
            return descMap;
        }
        return null;
    }

    public boolean hasReportTextInput() {
        return false;
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit((String[])argv, (boolean)true);
        File reportXML = RTConfig.getFile((String[])ARG_XML, (File)new File("./reports.xml"));
        File output = RTConfig.getFile((String[])ARG_OUT, null);
        String rptName = RTConfig.getString((String[])ARG_REPORT, (String)"event.detail");
        String rptInfo = RTConfig.getString((String[])ARG_INFO, null);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, null);
        String deviceID = RTConfig.getString((String[])ARG_DEVICE, null);
        String format = RTConfig.getString((String[])ARG_FORMAT, (String)"html");
        if (rptInfo != null) {
            rptName = rptInfo;
        }
        if (reportXML == null) {
            Print.logError((String)"'reports.xml' file not specified", (Object[])new Object[0]);
            System.exit(1);
        }
        ReportFactoryVars rfv = new ReportFactoryVars(reportXML);
        try {
            ReportFactory._loadReportDefinitionXML(rfv);
        }
        catch (Throwable t) {
            Print.logException((String)"Unable to load ReportFactory XML", (Throwable)t);
            rfv.setHasParsingErrors();
            System.exit(1);
        }
        int rptCount = rfv.getCount();
        if (rptCount <= 0) {
            Print.logError((String)"No reports found", (Object[])new Object[0]);
            System.exit(1);
        }
        if (accountID == null || accountID.equals("")) {
            Print.logWarn((String)"Missing Account ...", (Object[])new Object[0]);
            System.exit(0);
        } else if (deviceID == null || deviceID.equals("")) {
            Print.logWarn((String)"Missing Device ...", (Object[])new Object[0]);
            System.exit(0);
        }
        Print.logInfo((String)("Attempting to load Account/Device: " + accountID + "/" + deviceID), (Object[])new Object[0]);
        Account acct = null;
        Device dev = null;
        try {
            acct = Account.getAccount((String)accountID);
            if (acct != null) {
                dev = Device.getDevice((Account)acct, (String)deviceID);
                if (dev == null) {
                    Print.logError((String)("Device not found: " + accountID + "/" + deviceID), (Object[])new Object[0]);
                    System.exit(1);
                }
            } else {
                Print.logError((String)("Account not found: " + accountID), (Object[])new Object[0]);
                System.exit(1);
            }
        }
        catch (Throwable t) {
            Print.logException((String)"Error getting Account/Device", (Throwable)t);
            System.exit(1);
        }
        PrintWriter out = null;
        if (output != null) {
            try {
                out = new PrintWriter(new FileOutputStream(output));
            }
            catch (IOException ioe) {
                Print.logError((String)("Unable to open output: " + output), (Object[])new Object[0]);
                out = null;
            }
        }
        try {
            PrintWriter pw;
            RequestProperties reqState = new RequestProperties();
            reqState.setCurrentAccount(acct);
            ReportFactory rf = ReportFactory.getReportFactory(rptName, false);
            ReportEntry re = new ReportEntry(rf, "");
            ReportData rpt = rf.createReport(re, null, reqState, dev);
            TimeZone tz = TimeZone.getTimeZone(acct.getTimeZone());
            ReportConstraints rc = rpt.getReportConstraints();
            rc.setTimeStart(-1L);
            rc.setTimeEnd(new DateTime(tz).getDayEnd(tz));
            Print.logInfo((String)("Generating report: " + rpt.getClass().getName()), (Object[])new Object[0]);
            PrintWriter printWriter = pw = out != null ? out : new PrintWriter(System.out);
            if (rptInfo == null) {
                OutputProvider op = new OutputProvider(pw);
                pw.print("<html>\n");
                pw.print("<head>\n");
                rpt.getReportLayout().writeReportStyle(format, rpt, op, 1);
                pw.print("</head>\n");
                pw.print("<body>\n");
                rpt.getReportLayout().writeReport(format, rpt, op, 1);
                pw.print("</body>\n");
                pw.print("</html>\n");
            } else {
                Print.logInfo((String)("ReoprtFactory constraints: " + rf.getReportConstraints()), (Object[])new Object[0]);
                Print.logInfo((String)("ReoprtData constraints   : " + rpt.getReportConstraints()), (Object[])new Object[0]);
            }
        }
        catch (ReportException re) {
            Print.logException((String)"Error generating report", (Throwable)re);
            System.exit(1);
        }
        catch (Throwable t) {
            Print.logException((String)"Error generating report", (Throwable)t);
            System.exit(1);
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            out = null;
        }
    }

    private static class ReportType {
        private String type = null;
        private boolean isGroup = false;
        private I18N.Text desc = null;

        public ReportType(String type, boolean isGroup, I18N.Text desc) {
            this.type = type != null ? type : "";
            this.isGroup = isGroup;
            this.desc = desc != null ? desc : new I18N.Text();
        }

        public String getType() {
            return this.type;
        }

        public boolean isGroup() {
            return this.isGroup;
        }

        public String getDescription(Locale loc) {
            return this.desc.toString(loc);
        }
    }

    public static class ReportFactoryVars {
        private File xmlFile = null;
        private Map<String, ReportFactory> rptFactoryMap = null;
        private boolean hasParsingErrors = false;
        private boolean hasParsingWarnings = false;
        private int count = 0;

        public ReportFactoryVars(File xmlFile) {
            this.xmlFile = xmlFile != null ? xmlFile : ReportFactory._getReportXMLFile();
            this.reset();
        }

        public void reset() {
            this.rptFactoryMap = null;
            this.hasParsingErrors = false;
            this.hasParsingWarnings = false;
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        public File getXMLFile() {
            return this.xmlFile;
        }

        public boolean isReload() {
            return this.rptFactoryMap != null;
        }

        public void addReportFactory(ReportFactory rf) throws ReportException {
            if (rf != null) {
                String name = rf.getReportName();
                if (StringTools.isBlank((String)name)) {
                    throw new ReportException("Report name not specified");
                }
                if (ReportFactory._getReportFactory(name) != null) {
                    throw new ReportException("Report name already exists: " + name);
                }
                if (this.rptFactoryMap == null) {
                    this.rptFactoryMap = new OrderedMap();
                }
                this.rptFactoryMap.put(name, rf);
                ++this.count;
            }
        }

        public ReportFactory getReportFactory(String rptName) {
            if (this.rptFactoryMap != null) {
                return this.rptFactoryMap.get(rptName);
            }
            return null;
        }

        public Collection<ReportFactory> getReportFactories() {
            return this.rptFactoryMap != null ? this.rptFactoryMap.values() : null;
        }

        public void setHasParsingErrors() {
            this.hasParsingErrors = true;
        }

        public boolean hasParsingErrors() {
            return this.hasParsingErrors;
        }

        public void setHasParsingWarnings() {
            this.hasParsingWarnings = true;
        }

        public boolean hasParsingWarnings() {
            return this.hasParsingWarnings;
        }
    }
}

