/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class ReportDeviceList
extends DBRecord<ReportDeviceList> {
    private Account account = null;
    private User user = null;
    private DeviceGroup devGroup = null;
    private boolean isGroup = false;
    private Map<String, DeviceHolder> devMap = null;

    public ReportDeviceList(Account acct, User user) {
        this.account = acct;
        this.user = user;
        this.devMap = null;
    }

    public ReportDeviceList(Account acct, User user, Device device) {
        this(acct, user);
        this.add(device);
    }

    public ReportDeviceList(Account acct, User user, String[] devID) {
        this(acct, user);
        this.add(devID);
    }

    public ReportDeviceList(Account acct, User user, DeviceGroup group) {
        this(acct, user);
        this.devGroup = group;
        this.isGroup = true;
        this.add(group);
    }

    public String getAccountID() {
        return this.account != null ? this.account.getAccountID() : "";
    }

    public Account getAccount() {
        return this.account;
    }

    public String getUserID() {
        return this.user != null ? this.user.getUserID() : "";
    }

    public User getUser() {
        return this.user;
    }

    public String getDeviceGroupID() {
        return this.devGroup != null ? this.devGroup.getGroupID() : "";
    }

    public DeviceGroup getDeviceGroup() {
        return this.devGroup;
    }

    public boolean isDeviceGroup() {
        return this.isGroup || this.size() > 1;
    }

    public Device getDevice(String devID) throws DBException {
        if (StringTools.isBlank((String)devID)) {
            return null;
        }
        DeviceHolder dh = this.getDeviceMap().get(devID);
        return dh != null ? dh.getDevice() : null;
    }

    public void clear() {
        if (this.devMap != null) {
            this.devMap.clear();
        }
    }

    protected Map<String, DeviceHolder> getDeviceMap() {
        if (this.devMap == null) {
            this.devMap = new HashMap<String, DeviceHolder>(10);
        }
        return this.devMap;
    }

    public boolean setDevice(User user, DeviceHolder dh) {
        this.clear();
        try {
            this._addDevice(user, dh);
            return true;
        }
        catch (DBException dbe) {
            return false;
        }
    }

    protected void _addDevice(User user, DeviceHolder dh) throws DBException {
        String devID = dh.getDeviceID();
        if (user == null || user.isAuthorizedDevice(devID)) {
            Map<String, DeviceHolder> dm = this.getDeviceMap();
            if (dm.containsKey(devID)) {
                if (dh.hasDevice()) {
                    DeviceHolder dmdh = dm.get(devID);
                    dmdh.setDevice(dh.getDevice());
                }
            } else {
                dm.put(devID, dh);
            }
        }
    }

    protected void _addDevice(User user, Device device) throws DBException {
        String devID = device.getDeviceID();
        if (user == null || user.isAuthorizedDevice(devID)) {
            Map<String, DeviceHolder> dm = this.getDeviceMap();
            if (dm.containsKey(devID)) {
                DeviceHolder dmdh = dm.get(devID);
                dmdh.setDevice(device);
            } else {
                DeviceHolder dh = new DeviceHolder(device);
                dm.put(devID, dh);
            }
        }
    }

    public boolean add(Device device) {
        if (device == null) {
            return false;
        }
        User user = this.getUser();
        try {
            this._addDevice(user, device);
            return true;
        }
        catch (DBException dbe) {
            return false;
        }
    }

    public boolean add(String[] devID) {
        if (ListTools.isEmpty((Object[])devID)) {
            return false;
        }
        Account acct = this.getAccount();
        User user = this.getUser();
        try {
            for (int i = 0; i < devID.length; ++i) {
                this._addDevice(user, new DeviceHolder(acct, devID[i]));
            }
            return true;
        }
        catch (DBException dbe) {
            return false;
        }
    }

    public boolean add(List<String> devIDList) {
        if (ListTools.isEmpty(devIDList)) {
            return false;
        }
        Account acct = this.getAccount();
        User user = this.getUser();
        try {
            for (String devID : devIDList) {
                this._addDevice(user, new DeviceHolder(acct, devID));
            }
            return true;
        }
        catch (DBException dbe) {
            return false;
        }
    }

    public boolean add(String devID) {
        if (StringTools.isBlank((String)devID)) {
            return false;
        }
        Account acct = this.getAccount();
        User user = this.getUser();
        try {
            this._addDevice(user, new DeviceHolder(acct, devID));
            return true;
        }
        catch (DBException dbe) {
            return false;
        }
    }

    public boolean add(DeviceGroup group) {
        if (group == null) {
            return false;
        }
        String acctID = this.getAccountID();
        if (!acctID.equals(group.getAccountID())) {
            return false;
        }
        Account acct = this.getAccount();
        User user = this.getUser();
        try {
            OrderedSet devIDSet = DeviceGroup.getDeviceIDsForGroup((String)acctID, (String)group.getGroupID(), null, (boolean)false);
            for (int i = 0; i < devIDSet.size(); ++i) {
                this._addDevice(user, new DeviceHolder(acct, (String)devIDSet.get(i)));
            }
            this.isGroup = true;
            return true;
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to add DeviceGroup", (Throwable)dbe);
            return false;
        }
    }

    public void addAllAuthorizedDevices() {
        try {
            User usr = this.getUser();
            Account acct = this.getAccount();
            OrderedSet list = User.getAuthorizedDeviceIDs((User)usr, (Account)acct, (boolean)false);
            this.add((List<String>)list);
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to add all User devices", (Throwable)dbe);
        }
    }

    public int size() {
        return this.getDeviceMap().size();
    }

    public Iterator<String> iterator() {
        return this.getDeviceMap().keySet().iterator();
    }

    public List<DeviceHolder> getDeviceHolderList(boolean sort) {
        Vector<DeviceHolder> dhList = new Vector<DeviceHolder>(this.getDeviceMap().values());
        if (sort) {
            Collections.sort(dhList, new DeviceHolderComparator());
        }
        return dhList;
    }

    public String getFirstDeviceID() {
        Iterator<String> i = this.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return "";
    }

    public Device getFirstDevice() {
        String devID = this.getFirstDeviceID();
        if (!devID.equals("")) {
            try {
                return this.getDevice(devID);
            }
            catch (DBException dbe) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ReportDeviceList:");
        sb.append(" Account=").append(this.getAccountID());
        sb.append(" User=").append(this.getUserID());
        sb.append(" Group=").append(this.getDeviceGroupID());
        sb.append(" Size=").append(this.size());
        return sb.toString();
    }

    private static class DeviceHolderComparator
    implements Comparator<DeviceHolder> {
        private boolean ascending = true;

        public DeviceHolderComparator() {
            this(true);
        }

        public DeviceHolderComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(DeviceHolder dh1, DeviceHolder dh2) {
            if (dh1 == dh2) {
                return 0;
            }
            if (dh1 == null) {
                return this.ascending ? -1 : 1;
            }
            if (dh2 == null) {
                return this.ascending ? 1 : -1;
            }
            String D1 = dh1.getDeviceDescription().toLowerCase();
            String D2 = dh2.getDeviceDescription().toLowerCase();
            return this.ascending ? D1.compareTo(D2) : D2.compareTo(D1);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof DeviceHolderComparator) {
                DeviceHolderComparator dhc = (DeviceHolderComparator)other;
                return this.ascending == dhc.ascending;
            }
            return false;
        }
    }

    public static class DeviceHolder {
        private Account account = null;
        private String deviceID = null;
        private String deviceDesc = null;
        private Device device = null;

        public DeviceHolder(Account acct, String devID) {
            this.account = acct;
            this.deviceID = devID;
            this.device = null;
        }

        public DeviceHolder(Device dev) {
            this(dev.getAccount(), dev.getDeviceID());
            this.device = dev;
        }

        public void setDevice(Device dev) {
            if (dev != null && this.account.getAccountID().equals(dev.getAccountID()) && this.deviceID.equals(dev.getDeviceID())) {
                this.device = dev;
            }
        }

        public String getDeviceID() {
            return this.deviceID;
        }

        public boolean hasDevice() {
            return this.device != null;
        }

        public String getDeviceDescription() {
            if (this.deviceDesc == null) {
                try {
                    Device device = this.getDevice();
                    this.deviceDesc = device != null ? device.getDescription() : "";
                }
                catch (DBException dbe) {
                    this.deviceDesc = "";
                }
            }
            return this.deviceDesc;
        }

        public Device getDevice() throws DBException {
            if (this.device == null && this.account != null && this.deviceID != null) {
                this.device = Device.getDevice((Account)this.account, (String)this.deviceID);
                if (this.device == null) {
                    this.account = null;
                    this.deviceID = null;
                }
            }
            return this.device;
        }
    }
}

