/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.DBDataRowAdapter;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportCallback;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportFactory;
import org.opengts.war.report.ReportHeaderGroup;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.ReportOption;
import org.opengts.war.tools.MapDimension;
import org.opengts.war.tools.OutputProvider;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;

public abstract class ReportData {
    private static final boolean REPORT_DATA_FIELDS_ENABLED = false;
    private static final String PROP_reportDataFieldEnabled = "reportDataFieldEnabled";
    private static final String PROP_gpsAgeColorRange = "gpsAgeColorRange";
    private static final String PROP_gpsAgeColorRange_array = "gpsAgeColorRange.array";
    private static final String PROP_creationAgeColorRange = "creationAgeColorRange";
    private static final String PROP_creationAgeColorRange_array = "creationAgeColorRange.array";
    private static final String PROP_checkinAgeColorRange = "checkinAgeColorRange";
    private static final String PROP_checkinAgeColorRange_array = "checkinAgeColorRange.array";
    private static final String PROP_loginAgeColorRange = "loginAgeColorRange";
    private static final String PROP_loginAgeColorRange_array = "loginAgeColorRange.array";
    public static final String FORMAT_MAP = "map";
    public static final String FORMAT_KML = "kml";
    public static final String FORMAT_PDF = "pdf";
    public static final String FORMAT_GRAPH = "graph";
    private static final String DFT_REPORT_NAME = "generic.report";
    private static final String DFT_REPORT_TITLE = "Generic Report";
    private static final String DFT_REPORT_SUBTITLE = "${deviceDesc} [${deviceId}]\n${dateRange}";
    private static final ReportColumn[] EMPTY_COLUMNS = new ReportColumn[0];
    private String reportName = "generic.report";
    private String reportTitle = "Generic Report";
    private String reportSubtitle = "${deviceDesc} [${deviceId}]\n${dateRange}";
    private ReportEntry rptEntry = null;
    private ReportFactory rptFactory = null;
    private Object rptJob = null;
    private PrivateLabel privLabel = null;
    private RequestProperties reqState = null;
    private Account account = null;
    private User user = null;
    private String preferredFormat = "";
    private ReportDeviceList deviceList = null;
    private int eventDataCount = 0;
    private int maxEventDataCount = 0;
    private int rptRecordCount = 0;
    private boolean rptIsPartial = false;
    private ReportConstraints rptConstraints = null;
    private ReportOption reportOption = null;
    private RTProperties reportProperties = null;
    private ReportHeaderGroup[] rptHdrGrps = null;
    private ReportColumn[] rptColumns = EMPTY_COLUMNS;
    private URIArg refreshURL = null;
    private URIArg autoReportURL = null;
    private URIArg graphURL = null;
    private URIArg mapURL = null;
    private URIArg kmlURL = null;
    private String iconSelector = null;
    private ReportCallback rptCallback = null;
    public static final ReportLayout.AgeColorRange[] GpsAgeColorRangeDefault = new ReportLayout.AgeColorRange[]{new ReportLayout.AgeColorRange(3600L, "#BB0000", "italic"), new ReportLayout.AgeColorRange(1200L, "#550000", null)};
    public static final ReportLayout.AgeColorRange[] CreationAgeColorRangeDefault = new ReportLayout.AgeColorRange[0];
    public static final ReportLayout.AgeColorRange[] CheckinAgeColorRangeDefault = new ReportLayout.AgeColorRange[]{new ReportLayout.AgeColorRange(DateTime.HourSeconds((long)24L), "#BB0000", null)};
    public static final ReportLayout.AgeColorRange[] LoginAgeColorRangeDefault = new ReportLayout.AgeColorRange[]{new ReportLayout.AgeColorRange(DateTime.DaySeconds((long)7L), "#AA9700", null), new ReportLayout.AgeColorRange(DateTime.DaySeconds((long)30L), "#DD0000", null)};

    public ReportData(ReportFactory rptFact, RequestProperties reqState, Account acct, User user, ReportDeviceList devList) throws ReportException {
        this.rptFactory = rptFact;
        this.reqState = reqState;
        this.privLabel = this.reqState.getPrivateLabel();
        this.account = acct;
        this.user = user;
        this.deviceList = devList;
    }

    public ReportData(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        this.rptEntry = rptEntry;
        this.rptFactory = this.rptEntry.getReportFactory();
        this.reqState = reqState;
        this.privLabel = this.reqState.getPrivateLabel();
        this.account = this.reqState.getCurrentAccount();
        this.user = this.reqState.getCurrentUser();
        this.deviceList = devList;
    }

    public boolean hasReportJob() {
        return this.rptJob != null;
    }

    public Object getReportJob() {
        return this.rptJob;
    }

    public void setReportJob(Object rj) {
        this.rptJob = rj;
    }

    public ReportEntry getReportEntry() {
        return this.rptEntry;
    }

    public ReportFactory getReportFactory() {
        return this.rptFactory;
    }

    public RTProperties getProperties() {
        if (this.reportProperties == null) {
            this.reportProperties = this.getReportFactory().getProperties();
            if (this.hasReportOption()) {
                this.reportProperties = new RTProperties(this.reportProperties);
                this.reportProperties.setProperties(this.getReportOption().getProperties());
            }
        }
        return this.reportProperties;
    }

    public void setReportName(String name) {
        this.reportName = name;
    }

    public String getReportName() {
        if (this.reportName != null && !this.reportName.equals("")) {
            return this.reportName;
        }
        return DFT_REPORT_NAME;
    }

    public String getReportType() {
        return this.getReportFactory().getReportType();
    }

    public void setReportTitle(String title) {
        this.reportTitle = title;
    }

    public String getReportTitle() {
        if (this.reportTitle != null && !this.reportTitle.equals("")) {
            return this.expandHeaderText(this.reportTitle);
        }
        return this.expandHeaderText(DFT_REPORT_NAME);
    }

    public void setReportSubtitle(String title) {
        this.reportSubtitle = title;
    }

    public String getReportSubtitle() {
        return this.expandHeaderText(this.reportSubtitle);
    }

    public String expandHeaderText(String text) {
        return ReportLayout.expandHeaderText(text, this);
    }

    public RequestProperties getRequestProperties() {
        return this.reqState;
    }

    public boolean isSoapRequest() {
        return this.getRequestProperties().isSoapRequest();
    }

    public TimeZone getTimeZone() {
        return this.getRequestProperties().getTimeZone();
    }

    public String getTimeZoneString() {
        return this.getRequestProperties().getTimeZoneString(null);
    }

    public PrivateLabel getPrivateLabel() {
        return this.privLabel;
    }

    public Locale getLocale() {
        return this.getRequestProperties().getLocale();
    }

    public void setMapIconSelector(String iconSel) {
        this.iconSelector = iconSel;
    }

    public String getMapIconSelector() {
        return this.iconSelector;
    }

    public Account getAccount() {
        return this.account;
    }

    public String getAccountID() {
        Account a = this.getAccount();
        return a != null ? a.getAccountID() : "";
    }

    public User getUser() {
        return this.user;
    }

    public String getUserID() {
        User u = this.getUser();
        return u != null ? u.getUserID() : "";
    }

    public String getPreferredFormat() {
        return StringTools.trim((String)this.preferredFormat);
    }

    public void setPreferredFormat(String format) {
        this.preferredFormat = StringTools.trim((String)format);
    }

    public boolean isSingleDeviceOnly() {
        return false;
    }

    protected void setReportDeviceList(ReportDeviceList devList) throws ReportException {
        this.deviceList = devList;
    }

    public ReportDeviceList getReportDeviceList() {
        if (this.deviceList == null) {
            this.deviceList = new ReportDeviceList(this.getAccount(), this.getUser());
        }
        return this.deviceList;
    }

    public int getDeviceCount() {
        if (this.deviceList == null) {
            return 0;
        }
        return this.deviceList.size();
    }

    public String getFirstDeviceID() {
        return this.getReportDeviceList().getFirstDeviceID();
    }

    public Device getDevice(String deviceID) throws DBException {
        ReportDeviceList devList = this.getReportDeviceList();
        return devList.getDevice(deviceID);
    }

    public void setReportHeaderGroups(ReportHeaderGroup[] rhg) {
        this.rptHdrGrps = rhg;
    }

    public ReportHeaderGroup[] getReportHeaderGroups() {
        return this.rptHdrGrps;
    }

    public ReportHeaderGroup getReportHeaderGroup(int col) {
        if (ListTools.isEmpty((Object[])this.rptHdrGrps)) {
            return null;
        }
        for (ReportHeaderGroup rhg : this.rptHdrGrps) {
            int C = rhg.getColIndex();
            if (col != C) continue;
            return rhg;
        }
        return null;
    }

    public void setReportColumns(ReportColumn[] columns) {
        this.rptColumns = columns != null ? columns : EMPTY_COLUMNS;
    }

    public ReportColumn[] getReportColumns() {
        return this.rptColumns;
    }

    public int getColumnCount() {
        return this.rptColumns.length;
    }

    public boolean hasReportColumn(String name) {
        if (!StringTools.isBlank((String)name)) {
            for (ReportColumn rc : this.rptColumns) {
                if (!rc.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasReportOption() {
        return this.reportOption != null;
    }

    public ReportOption getReportOption() {
        return this.reportOption;
    }

    public void setReportOption(ReportOption rptOpt) {
        this.reportOption = rptOpt;
        this.reportProperties = null;
    }

    public void setReportConstraints(ReportConstraints rc) {
        this.rptConstraints = rc;
    }

    public ReportConstraints getReportConstraints() {
        if (this.rptConstraints == null) {
            this.rptConstraints = new ReportConstraints();
        }
        return this.rptConstraints;
    }

    public boolean getReportDataFieldsEnabled() {
        return this.getProperties().getBoolean(PROP_reportDataFieldEnabled, false);
    }

    public ReportLayout.AgeColorRange[] getGpsAgeColorRangeArray() {
        RTProperties rtp = this.getProperties();
        ReportLayout.AgeColorRange[] gacra = rtp.getProperty((Object)PROP_gpsAgeColorRange_array, null);
        if (!(gacra instanceof ReportLayout.AgeColorRange[])) {
            String gacrl = rtp.getString(PROP_gpsAgeColorRange, null);
            gacra = ReportLayout.ParseAgeColorRange(gacrl, GpsAgeColorRangeDefault);
            if (gacra == null) {
                gacra = new ReportLayout.AgeColorRange[]{};
            }
            rtp.setProperty((Object)PROP_gpsAgeColorRange_array, (Object)gacra);
        }
        return gacra;
    }

    public ReportLayout.AgeColorRange getGpsAgeColorRange(long age) {
        ReportLayout.AgeColorRange[] acra = this.getGpsAgeColorRangeArray();
        return ReportLayout.GetAgeColorRange(age, acra);
    }

    public ReportLayout.AgeColorRange[] getCreationAgeColorRangeArray() {
        RTProperties rtp = this.getProperties();
        ReportLayout.AgeColorRange[] cacra = rtp.getProperty((Object)PROP_creationAgeColorRange_array, null);
        if (!(cacra instanceof ReportLayout.AgeColorRange[])) {
            String cacrl = rtp.getString(PROP_creationAgeColorRange, null);
            cacra = ReportLayout.ParseAgeColorRange(cacrl, CreationAgeColorRangeDefault);
            if (cacra == null) {
                cacra = new ReportLayout.AgeColorRange[]{};
            }
            rtp.setProperty((Object)PROP_creationAgeColorRange_array, (Object)cacra);
        }
        return cacra;
    }

    public ReportLayout.AgeColorRange getCreationAgeColorRange(long age) {
        ReportLayout.AgeColorRange[] acra = this.getCreationAgeColorRangeArray();
        return ReportLayout.GetAgeColorRange(age, acra);
    }

    public ReportLayout.AgeColorRange[] getCheckinAgeColorRangeArray() {
        RTProperties rtp = this.getProperties();
        ReportLayout.AgeColorRange[] cacra = rtp.getProperty((Object)PROP_checkinAgeColorRange_array, null);
        if (!(cacra instanceof ReportLayout.AgeColorRange[])) {
            String cacrl = rtp.getString(PROP_checkinAgeColorRange, null);
            cacra = ReportLayout.ParseAgeColorRange(cacrl, CheckinAgeColorRangeDefault);
            if (cacra == null) {
                cacra = new ReportLayout.AgeColorRange[]{};
            }
            rtp.setProperty((Object)PROP_checkinAgeColorRange_array, (Object)cacra);
        }
        return cacra;
    }

    public ReportLayout.AgeColorRange getCheckinAgeColorRange(long age) {
        ReportLayout.AgeColorRange[] acra = this.getCheckinAgeColorRangeArray();
        return ReportLayout.GetAgeColorRange(age, acra);
    }

    public ReportLayout.AgeColorRange[] getLoginAgeColorRangeArray() {
        RTProperties rtp = this.getProperties();
        ReportLayout.AgeColorRange[] cacra = rtp.getProperty((Object)PROP_loginAgeColorRange_array, null);
        if (!(cacra instanceof ReportLayout.AgeColorRange[])) {
            String cacrl = rtp.getString(PROP_loginAgeColorRange, null);
            cacra = ReportLayout.ParseAgeColorRange(cacrl, LoginAgeColorRangeDefault);
            if (cacra == null) {
                cacra = new ReportLayout.AgeColorRange[]{};
            }
            rtp.setProperty((Object)PROP_loginAgeColorRange_array, (Object)cacra);
        }
        return cacra;
    }

    public ReportLayout.AgeColorRange getLoginAgeColorRange(long age) {
        ReportLayout.AgeColorRange[] acra = this.getLoginAgeColorRangeArray();
        return ReportLayout.GetAgeColorRange(age, acra);
    }

    public String getRuleSelector() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getRuleSelector();
    }

    public String getWhereSelector() {
        ReportConstraints rc = this.getReportConstraints();
        String wh = rc.getWhere();
        if (this.hasReportOption()) {
            ReportOption ro = this.getReportOption();
            wh = StringTools.replaceKeys((String)wh, (StringTools.KeyValueMap)ro.getProperties());
        }
        return wh;
    }

    public EventData.LimitType getSelectionLimitType() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getSelectionLimitType();
    }

    public long getSelectionLimit() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getSelectionLimit();
    }

    public long getReportLimit() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getReportLimit();
    }

    public long getTimeStart() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getTimeStart();
    }

    public long getTimeEnd() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getTimeEnd();
    }

    public boolean getValidGPSRequired() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getValidGPSRequired();
    }

    public int[] getStatusCodes() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getStatusCodes();
    }

    public boolean getOrderAscending() {
        ReportConstraints rc = this.getReportConstraints();
        return rc.getOrderAscending();
    }

    public ReportCallback getReportCallback() {
        return this.rptCallback;
    }

    public void setReportCallback(ReportCallback rptCB) throws ReportException {
        this.rptCallback = rptCB;
        if (this.rptCallback != null) {
            this.rptCallback.setReport(this);
        }
    }

    public DBDataIterator getEventDataIterator() {
        Object[] ed = this.getEventData(null);
        return new ArrayDataIterator(ed);
    }

    protected EventData[] getEventData(DBRecordHandler<EventData> rcdHandler) {
        long rptLimit = this.getReportLimit();
        ReportDeviceList devList = this.getReportDeviceList();
        Vector edList = new Vector();
        this.maxEventDataCount = 0;
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            String devID = i.next();
            this.eventDataCount = 0;
            if (rptLimit >= 0L && (long)edList.size() >= rptLimit) break;
            try {
                Device device = devList.getDevice(devID);
                Object[] ed = this._getEventData(device, rcdHandler);
                if (rptLimit < 0L) {
                    ListTools.toList((Object[])ed, edList);
                } else {
                    int maxRcds = (int)rptLimit - edList.size();
                    if (ed.length <= maxRcds) {
                        ListTools.toList((Object[])ed, edList);
                    } else {
                        ListTools.toList((Object[])ed, (int)0, (int)maxRcds, edList);
                    }
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData for Device: " + devID), (Object[])new Object[0]);
            }
            if (this.eventDataCount <= this.maxEventDataCount) continue;
            this.maxEventDataCount = this.eventDataCount;
        }
        return edList.toArray(new EventData[edList.size()]);
    }

    protected EventData[] getEventData(Device deviceDB, DBRecordHandler<EventData> rcdHandler) {
        this.eventDataCount = 0;
        EventData[] ed = this._getEventData(deviceDB, rcdHandler);
        this.maxEventDataCount = this.eventDataCount;
        return ed;
    }

    protected boolean isEventDataMatch(EventData ev) {
        return true;
    }

    protected EventData[] _getEventData(final Device deviceDB, final DBRecordHandler<EventData> rcdHandler) {
        RuleFactory ruleFact;
        if (deviceDB == null) {
            return EventData.EMPTY_ARRAY;
        }
        String accountID = this.getAccountID();
        final String ruleSelector = this.getRuleSelector();
        if (!StringTools.isBlank((String)ruleSelector)) {
            ruleFact = Device.getRuleFactory();
            if (ruleFact == null) {
                Print.logWarn((String)"RuleSelector not supported", (Object[])new Object[0]);
            }
        } else {
            ruleFact = null;
        }
        final LastEventData lastEDR = new LastEventData();
        DBRecordHandler<EventData> evRcdHandler = new DBRecordHandler<EventData>(){

            public int handleDBRecord(EventData rcd) throws DBException {
                ReportData.this.eventDataCount++;
                EventData ev = rcd;
                ev.setDevice(deviceDB);
                EventData lastEv = lastEDR.getEvent();
                ev.setPreviousEventData(lastEv);
                lastEDR.setEvent(ev);
                if (ReportData.this.getReportDataFieldsEnabled() && lastEv != null) {
                    ev.calculateReportDistance(lastEv);
                }
                if (!ReportData.this.isEventDataMatch(ev)) {
                    return 1;
                }
                if (ruleFact != null && !ruleFact.isSelectorMatch(ruleSelector, ev)) {
                    return 1;
                }
                if (rcdHandler == null) {
                    return 2;
                }
                try {
                    return rcdHandler.handleDBRecord((DBRecord)rcd);
                }
                catch (DBException dbe) {
                    throw dbe;
                }
                catch (Throwable th) {
                    Print.logException((String)"RecordHandler callback exception", (Throwable)th);
                    return 0;
                }
            }
        };
        EventData[] ed = null;
        try {
            ed = EventData.getRangeEvents((String)accountID, (String)deviceDB.getDeviceID(), (long)this.getTimeStart(), (long)this.getTimeEnd(), (int[])this.getStatusCodes(), (boolean)this.getValidGPSRequired(), (EventData.LimitType)this.getSelectionLimitType(), (long)this.getSelectionLimit(), (boolean)this.getOrderAscending(), (String)this.getWhereSelector(), (DBRecordHandler)evRcdHandler);
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to obtain EventData records", (Throwable)dbe);
        }
        if (ed == null) {
            return EventData.EMPTY_ARRAY;
        }
        for (int i = 0; i < ed.length; ++i) {
            ed[i].setDevice(deviceDB);
        }
        return ed;
    }

    private long getEventDataCount() {
        return this.eventDataCount;
    }

    public long getMaximumEventDataCount() {
        return this.maxEventDataCount;
    }

    protected long countEventData(Device deviceDB) {
        long timeStart = this.getTimeStart();
        long timeEnd = this.getTimeEnd();
        return this._countEventData(deviceDB, timeStart, timeEnd);
    }

    protected long countEventData(Device deviceDB, long timeStart, long timeEnd) {
        return this._countEventData(deviceDB, timeStart, timeEnd);
    }

    protected long _countEventData(Device deviceDB, long timeStart, long timeEnd) {
        if (deviceDB == null) {
            return 0L;
        }
        String accountID = this.getAccountID();
        String ruleSelector = this.getRuleSelector();
        if (ruleSelector != null && !ruleSelector.equals("")) {
            Print.logWarn((String)"RuleSelector not supported when obtaining EventData record counts!", (Object[])new Object[0]);
        }
        long recordCount = 0L;
        try {
            recordCount = EventData.countRangeEvents((String)accountID, (String)deviceDB.getDeviceID(), (long)timeStart, (long)timeEnd, (int[])this.getStatusCodes(), (boolean)this.getValidGPSRequired(), (EventData.LimitType)this.getSelectionLimitType(), (long)this.getSelectionLimit(), (String)this.getWhereSelector());
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to obtain EventData record count", (Throwable)dbe);
        }
        return recordCount;
    }

    public void setReportRecordCount(int count, boolean isPartial) {
        this.rptRecordCount = count;
        this.rptIsPartial = isPartial;
    }

    public int getReportRecordCount() {
        return this.rptRecordCount;
    }

    public boolean getReportIsPartial() {
        return this.rptIsPartial;
    }

    public void setAutoReportURL(URIArg autoReportURL) {
        this.autoReportURL = autoReportURL;
    }

    public URIArg getAutoReportURL() {
        return this.autoReportURL;
    }

    public boolean getSupportsGraphDisplay() {
        return false;
    }

    public void setGraphURL(URIArg graphURL) {
        if (this.getSupportsGraphDisplay()) {
            this.graphURL = graphURL;
        }
    }

    public URIArg getGraphURL() {
        return this.getSupportsGraphDisplay() ? this.graphURL : null;
    }

    public String getGraphLinkDescription() {
        return null;
    }

    public MapDimension getGraphWindowSize() {
        return new MapDimension(730, 440);
    }

    public boolean getSupportsMapDisplay() {
        return false;
    }

    public void setMapURL(URIArg mapURL) {
        if (this.getSupportsMapDisplay()) {
            this.mapURL = mapURL;
        }
    }

    public URIArg getMapURL() {
        return this.getSupportsMapDisplay() ? this.mapURL : null;
    }

    public String getMapLinkDescription() {
        return null;
    }

    public MapDimension getMapWindowSize() {
        return new MapDimension(700, 500);
    }

    public boolean getSupportsKmlDisplay() {
        return false;
    }

    public void setKmlURL(URIArg kmlURL) {
        if (this.getSupportsKmlDisplay()) {
            this.kmlURL = kmlURL;
        }
    }

    public URIArg getKmlURL() {
        return this.getSupportsKmlDisplay() ? this.kmlURL : null;
    }

    public String getKmlLinkDescription() {
        return null;
    }

    public void setRefreshURL(URIArg refreshURL) {
        this.refreshURL = refreshURL;
    }

    public URIArg getRefreshURL() {
        return this.refreshURL;
    }

    public void postInitialize() {
    }

    public abstract ReportLayout getReportLayout();

    public DataRowTemplate getDataRowTemplate() {
        return this.getReportLayout().getDataRowTemplate();
    }

    public void writeReportStyle(String format, OutputProvider out) throws ReportException {
        String fmt = StringTools.blankDefault((String)format, (String)this.getPreferredFormat());
        this.getReportLayout().writeReportStyle(fmt, this, out, 0);
    }

    public int writeReport(String format, OutputProvider out) throws ReportException {
        String fmt = StringTools.blankDefault((String)format, (String)this.getPreferredFormat());
        return this.getReportLayout().writeReport(fmt, this, out, 0);
    }

    public int writeReport(String format, OutputProvider out, int indentLevel) throws ReportException {
        String fmt = StringTools.blankDefault((String)format, (String)this.getPreferredFormat());
        return this.getReportLayout().writeReport(fmt, this, out, indentLevel);
    }

    public abstract DBDataIterator getBodyDataIterator();

    public abstract DBDataIterator getTotalsDataIterator();

    protected class ListDataIterator
    implements DBDataIterator {
        private Iterator dataIter = null;
        private Object dataObj = null;
        private DBDataRow dataRow = null;

        public ListDataIterator(List data) {
            this.dataIter = data != null ? data.iterator() : null;
            this.dataRow = new DBDataRowAdapter(ReportData.this){

                @Override
                public Object getRowObject() {
                    return ListDataIterator.this.dataObj;
                }

                @Override
                public Object getDBValue(String name, int rowNdx, ReportColumn rptCol) {
                    Object obj = ListDataIterator.this.dataObj;
                    if (obj != null) {
                        DataRowTemplate rdp = ReportData.this.getDataRowTemplate();
                        return rdp.getFieldValue(name, rowNdx, ReportData.this, rptCol, obj);
                    }
                    return "";
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.dataIter != null && this.dataIter.hasNext();
        }

        @Override
        public DBDataRow next() {
            if (this.hasNext()) {
                this.dataObj = this.dataIter.next();
                return this.dataRow;
            }
            this.dataObj = null;
            return null;
        }
    }

    public class ArrayDataIterator
    implements DBDataIterator {
        private int recordIndex = -1;
        private Object[] data = null;
        private Object dataObj = null;
        private DBDataRow dataRow = null;

        public ArrayDataIterator(Object[] data) {
            this.data = data;
            this.recordIndex = -1;
            this.dataRow = new DBDataRowAdapter(ReportData.this){

                @Override
                public Object getRowObject() {
                    return ArrayDataIterator.this.dataObj;
                }

                @Override
                public Object getDBValue(String name, int rowNdx, ReportColumn rptCol) {
                    Object obj = ArrayDataIterator.this.dataObj;
                    if (obj != null) {
                        DataRowTemplate drt = ReportData.this.getDataRowTemplate();
                        return drt.getFieldValue(name, rowNdx, ReportData.this, rptCol, obj);
                    }
                    return "";
                }
            };
        }

        public Object[] getArray() {
            return this.data;
        }

        @Override
        public boolean hasNext() {
            return this.data != null && this.recordIndex + 1 < this.data.length;
        }

        @Override
        public DBDataRow next() {
            if (this.hasNext()) {
                ++this.recordIndex;
                this.dataObj = this.data[this.recordIndex];
                return this.dataRow;
            }
            this.dataObj = null;
            return null;
        }
    }

    private static class LastEventData {
        private EventData event = null;

        private LastEventData() {
        }

        public void setEvent(EventData ev) {
            this.event = ev;
        }

        public EventData getEvent() {
            return this.event;
        }
    }
}

