/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import org.opengts.db.tables.EventData;
import org.opengts.util.StringTools;

public class ReportConstraints
implements Cloneable {
    public static final int WHERE_SET = 0;
    public static final int WHERE_OR = 1;
    public static final int WHERE_AND = 2;
    private long timeStart = -1L;
    private long timeEnd = -1L;
    private boolean validGPS = false;
    private EventData.LimitType selLimitType = EventData.LimitType.FIRST;
    private long selLimitCount = -1L;
    private long rptLimitCount = -1L;
    private boolean orderAscending = true;
    private StringBuffer whSelect = new StringBuffer();
    private String ruleSelector = null;
    private int[] statusCodes = null;
    private String emailAddresses = null;

    public ReportConstraints() {
    }

    public ReportConstraints(long timeStart, long timeEnd) {
        this();
        this.setTimeRange(timeStart, timeStart);
    }

    public ReportConstraints(long timeStart, long timeEnd, boolean validGPS, EventData.LimitType selLimitType, long selLimit) {
        this();
        this.setTimeRange(timeStart, timeStart);
        this.setValidGPSRequired(validGPS);
        this.setSelectionLimit(selLimitType, selLimit);
        this.setReportLimit(selLimit);
    }

    public ReportConstraints(ReportConstraints rc) {
        this();
        if (rc != null) {
            this.setTimeRange(rc.getTimeStart(), rc.getTimeEnd());
            this.setValidGPSRequired(rc.getValidGPSRequired());
            this.setSelectionLimit(rc.getSelectionLimitType(), rc.getSelectionLimit());
            this.setReportLimit(rc.getReportLimit());
            this.setWhere(rc.getWhere());
            this.setRuleSelector(rc.getRuleSelector());
            this.setStatusCodes(rc.getStatusCodes());
            this.setOrderAscending(rc.getOrderAscending());
        }
    }

    public void setTimeStart(long ts) {
        this.timeStart = ts > 0L ? ts : -1L;
    }

    public long getTimeStart() {
        return this.timeStart;
    }

    public void setTimeEnd(long te) {
        this.timeEnd = te > 0L ? te : -1L;
    }

    public long getTimeEnd() {
        return this.timeEnd;
    }

    public void setTimeRange(long timeStart, long timeEnd) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
    }

    public boolean getValidGPSRequired() {
        return this.validGPS;
    }

    public void setValidGPSRequired(boolean reqGPS) {
        this.validGPS = reqGPS;
    }

    public boolean getOrderAscending() {
        return this.orderAscending;
    }

    public void setOrderAscending(boolean ascending) {
        this.orderAscending = ascending;
    }

    public EventData.LimitType getSelectionLimitType() {
        return this.selLimitType;
    }

    public long getSelectionLimit() {
        if (this.selLimitCount == 0L) {
            this.selLimitCount = 1L;
        }
        return this.selLimitCount;
    }

    public boolean hasSelectionLimit() {
        return this.getSelectionLimit() > 0L;
    }

    public void setSelectionLimit(long limit) {
        this.selLimitCount = limit < 0L ? -1L : (limit == 0L ? 1L : limit);
    }

    public void setSelectionLimit(EventData.LimitType limitType, long limit) {
        this.selLimitType = limitType;
        this.setSelectionLimit(limit);
    }

    public long getReportLimit() {
        if (this.rptLimitCount == 0L) {
            this.rptLimitCount = 1L;
        }
        return this.rptLimitCount;
    }

    public boolean hasReportLimit() {
        return this.getReportLimit() > 0L;
    }

    public void setReportLimit(long limit) {
        this.rptLimitCount = limit < 0L ? -1L : (limit == 0L ? 1L : limit);
    }

    public String getWhere() {
        return this.whSelect.toString();
    }

    public boolean hasWhere() {
        return this.whSelect.length() > 0;
    }

    public void setWhere(String dbsel) {
        this._appendWhere(dbsel, 0);
    }

    public void orWhere(String dbsel) {
        this._appendWhere(dbsel, 1);
    }

    public void andWhere(String dbsel) {
        this._appendWhere(dbsel, 1);
    }

    protected void _appendWhere(String dbsel, int op) {
        String sel = StringTools.trim((String)dbsel);
        if (op == 0) {
            this.whSelect.setLength(0);
            if (!sel.equals("")) {
                this.whSelect.append("(");
                this.whSelect.append(sel);
                this.whSelect.append(")");
            }
            return;
        }
        if (!sel.equals("")) {
            if (this.whSelect.length() > 0) {
                this.whSelect.insert(0, "(");
                if (op == 1) {
                    this.whSelect.append(" OR ");
                } else {
                    this.whSelect.append(" AND ");
                }
                this.whSelect.append("(");
                this.whSelect.append(sel);
                this.whSelect.append("))");
            } else {
                this.whSelect.append("(");
                this.whSelect.append(sel);
                this.whSelect.append(")");
            }
        }
    }

    public String getRuleSelector() {
        return this.ruleSelector != null ? this.ruleSelector : "";
    }

    public boolean hasRuleSelector() {
        return this.ruleSelector != null && !this.ruleSelector.equals("");
    }

    public void setRuleSelector(String ruleSel) {
        this.ruleSelector = ruleSel;
    }

    public int[] getStatusCodes() {
        return this.statusCodes;
    }

    public boolean hasStatusCodes() {
        return this.statusCodes != null && this.statusCodes.length > 0;
    }

    public void setStatusCodes(int[] sc) {
        this.statusCodes = sc != null && sc.length > 0 ? sc : null;
    }

    public boolean hasEmailAddresses() {
        return !StringTools.isBlank((String)this.emailAddresses);
    }

    public String getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String emailAddr) {
        this.emailAddresses = StringTools.trim((String)emailAddr);
    }

    public Object clone() {
        return new ReportConstraints(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ReportConstraints:");
        sb.append(" TimeStart=" + this.getTimeStart());
        sb.append(" TimeEnd=" + this.getTimeEnd());
        sb.append(" ValidGPSRequired=" + this.getValidGPSRequired());
        sb.append(" SelectionLimitType=" + this.getSelectionLimitType());
        sb.append(" SelectionLimit=" + this.getSelectionLimit());
        sb.append(" ReportLimit=" + this.getReportLimit());
        sb.append(" Where='" + this.getWhere() + "'");
        return sb.toString();
    }
}

