/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.util.Locale;
import org.opengts.util.I18N;

public class ReportColumn {
    private String colKey = "";
    private String colArg = "";
    private I18N.Text colTitle = null;
    private int colSpan = 1;
    private boolean sortable = true;
    private String blankFiller = "";

    public ReportColumn(String key, String arg, I18N.Text title) {
        this.colKey = key != null ? key : "";
        this.colArg = arg != null ? arg : "";
        this.colTitle = title != null && !title.toString().equals("") ? title : null;
    }

    public ReportColumn(String key, String arg, int colSpan, I18N.Text title) {
        this(key, arg, title);
        this.colSpan = colSpan;
    }

    public String getName() {
        return this.colKey;
    }

    public String getKey() {
        return this.colKey;
    }

    public String getArg() {
        return this.colArg;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public String getTitle(Locale loc, String dft) {
        return this.colTitle != null ? this.colTitle.toString(loc) : dft;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setBlankFiller(String filler) {
        this.blankFiller = filler != null ? filler : "";
    }

    public String getBlankFiller() {
        return this.blankFiller;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getKey()).append(":").append(this.getArg());
        String title = this.getTitle(null, "");
        if (title != null) {
            sb.append(" - ").append(title);
        }
        return sb.toString();
    }
}

