/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.util.List;
import java.util.Vector;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.presentation.HeaderColumnTemplate;
import org.opengts.war.tools.OutputProvider;

public class ReportCallback {
    private ReportData report = null;
    private ReportColumn[] rptCols = null;
    private String rptTitle = null;
    private String rptSubtitle = null;
    private String[] headerDesc = null;
    private List<Object[]> bodyRows = null;
    private List<Object[]> totalRows = null;

    public ReportCallback() {
    }

    public ReportCallback(ReportData report) throws ReportException {
        this();
        this.setReport(report);
    }

    public void setReport(ReportData report) throws ReportException {
        this.report = report;
        if (this.report == null) {
            throw new ReportException("Report is null");
        }
        this.rptCols = null;
        this.getReportColumns();
    }

    public ReportColumn[] getReportColumns() throws ReportException {
        if (this.rptCols != null) {
            return this.rptCols;
        }
        if (this.report == null) {
            throw new ReportException("Report is null");
        }
        this.rptCols = this.report.getReportColumns();
        if (ListTools.isEmpty((Object[])this.rptCols)) {
            throw new ReportException("No report columns defined");
        }
        return this.rptCols;
    }

    public void reportStart(OutputProvider out, int level) throws ReportException {
        if (this.report == null) {
            throw new ReportException("Report is null");
        }
        this.rptTitle = this.report.getReportTitle();
        this.rptSubtitle = this.report.getReportSubtitle();
    }

    public String getReportTitle() {
        return this.rptTitle;
    }

    public String getReportSubtitle() {
        return this.rptSubtitle;
    }

    public void reportHeader(OutputProvider out, int level, Object[] headerCol) throws ReportException {
        if (this.report == null) {
            throw new ReportException("Report is null");
        }
        if (ListTools.size((Object[])headerCol) != this.rptCols.length) {
            throw new ReportException("Invalid number of header columns");
        }
        this.headerDesc = new String[this.rptCols.length];
        for (int i = 0; i < this.rptCols.length; ++i) {
            if (headerCol[i] instanceof String) {
                this.headerDesc[i] = (String)headerCol[i];
                continue;
            }
            if (headerCol[i] instanceof HeaderColumnTemplate) {
                HeaderColumnTemplate hct = (HeaderColumnTemplate)headerCol[i];
                this.headerDesc[i] = hct.getTitle(this.report, this.rptCols[i]);
                continue;
            }
            Print.logWarn((String)("Unrecognized header column class: " + StringTools.className((Object)headerCol[i])), (Object[])new Object[0]);
            this.headerDesc[i] = "#" + i;
        }
    }

    public boolean hasHeaderColumnDescriptions() {
        return !ListTools.isEmpty((Object[])this.headerDesc);
    }

    public String[] getHeaderColumnDescriptions() {
        return this.headerDesc;
    }

    public int reportBody(OutputProvider out, int level, DBDataIterator data) throws ReportException {
        if (this.report == null) {
            throw new ReportException("Report is null");
        }
        this.bodyRows = new Vector<Object[]>();
        while (data.hasNext()) {
            DBDataRow dr = data.next();
            if (dr == null) continue;
            DataRowTemplate drt = dr.getDataRowTemplate();
            Object[] rowVal = new Object[this.rptCols.length];
            for (int i = 0; i < this.rptCols.length; ++i) {
                String colName = this.rptCols[i].getKey();
                int colSpan = this.rptCols[i].getColSpan();
                DataColumnTemplate dct = drt.getColumnTemplate(colName);
                if (dct != null) {
                    Object fldVal;
                    String fldName = colName;
                    rowVal[i] = fldVal = dr.getDBValue(fldName, this.bodyRows.size(), this.rptCols[i]);
                    continue;
                }
                rowVal[i] = "";
            }
            this.bodyRows.add(rowVal);
        }
        return this.bodyRows.size();
    }

    public boolean hasReportBodyRows() {
        return !ListTools.isEmpty(this.bodyRows);
    }

    public List<Object[]> getReportBodyRows() {
        return this.bodyRows;
    }

    public int reportTotals(OutputProvider out, int level, DBDataIterator data) throws ReportException {
        if (this.report == null) {
            throw new ReportException("Report is null");
        }
        this.totalRows = new Vector<Object[]>();
        while (data.hasNext()) {
            DBDataRow dr = data.next();
            if (dr == null) continue;
            DataRowTemplate drt = dr.getDataRowTemplate();
            Object[] rowVal = new Object[this.rptCols.length];
            for (int i = 0; i < this.rptCols.length; ++i) {
                String colName = this.rptCols[i].getKey();
                int colSpan = this.rptCols[i].getColSpan();
                DataColumnTemplate dct = drt.getColumnTemplate(colName);
                if (dct != null) {
                    Object fldVal;
                    String fldName = colName;
                    rowVal[i] = fldVal = dr.getDBValue(fldName, this.totalRows.size(), this.rptCols[i]);
                    continue;
                }
                rowVal[i] = "";
            }
            this.totalRows.add(rowVal);
        }
        return this.totalRows.size();
    }

    public boolean hasReportTotalRows() {
        return !ListTools.isEmpty(this.totalRows);
    }

    public List<Object[]> getReportTotalRows() {
        return this.totalRows;
    }

    public void reportEnd(OutputProvider out, int level) throws ReportException {
    }

    public String toString() {
        List<Object[]> totalRows;
        StringBuffer sb = new StringBuffer();
        sb.append("Report Title   : " + this.getReportTitle() + "\n");
        sb.append("Report Subtitle: " + this.getReportSubtitle() + "\n");
        sb.append("Report Headers : ");
        Object[] hdr = this.getHeaderColumnDescriptions();
        if (ListTools.isEmpty((Object[])hdr)) {
            sb.append("null\n");
        } else {
            for (int i = 0; i < hdr.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(StringTools.replace((String)StringTools.trim((String)hdr[i]), (String)"\n", (String)"\\n"));
            }
            sb.append("\n");
        }
        List<Object[]> bodyRows = this.getReportBodyRows();
        if (!ListTools.isEmpty(bodyRows)) {
            sb.append("Report Body    : \n");
            for (Object[] rowData : bodyRows) {
                for (int i = 0; i < rowData.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(StringTools.replace((String)StringTools.trim((Object)rowData[i]), (String)"\n", (String)"\\n"));
                }
                sb.append("\n");
            }
        }
        if (!ListTools.isEmpty(totalRows = this.getReportTotalRows())) {
            sb.append("Report Totals  : \n");
            for (Object[] rowData : totalRows) {
                for (int i = 0; i < rowData.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(StringTools.replace((String)StringTools.trim((Object)rowData[i]), (String)"\n", (String)"\\n"));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

