/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;

public abstract class DataRowTemplate {
    private HashMap<String, DataColumnTemplate> lookupTable = new HashMap();

    protected String _normalizeKey(String key) {
        int ka = key.indexOf(58);
        if (ka >= 0) {
            key = key.substring(0, ka);
        }
        return key.trim().toLowerCase();
    }

    protected boolean _addColumnTemplate(String key, DataColumnTemplate dc) {
        if (!StringTools.isBlank((String)key) && dc != null) {
            String k = this._normalizeKey(key);
            if (this.lookupTable.containsKey(k)) {
                Print.logStackTrace((String)("Report layout column key already defined: " + k));
                this.lookupTable.put(k, dc);
                return false;
            }
            this.lookupTable.put(k, dc);
            return true;
        }
        Print.logWarn((String)("Invalid column options: key=" + key), (Object[])new Object[0]);
        return true;
    }

    public boolean addColumnTemplate(DataColumnTemplate dc, String ... aliasKeys) {
        int err = 0;
        if (dc != null) {
            if (this._addColumnTemplate(dc.getKeyName(), dc)) {
                ++err;
            }
            if (!ListTools.isEmpty((Object[])aliasKeys)) {
                for (String key : aliasKeys) {
                    if (!this._addColumnTemplate(key, dc)) continue;
                    ++err;
                }
            }
        }
        return err == 0;
    }

    public DataColumnTemplate getColumnTemplate(String key) {
        if (key != null) {
            return this.lookupTable.get(this._normalizeKey(key));
        }
        return null;
    }

    public boolean hasColumn(String key) {
        if (key != null) {
            return this.lookupTable.containsKey(this._normalizeKey(key));
        }
        return false;
    }

    public Set<String> getColumnNames() {
        return new HashSet<String>(this.lookupTable.keySet());
    }

    public DBDataRow.RowType getRowType(Object obj) {
        return DBDataRow.RowType.DETAIL;
    }

    public Object getFieldValue(String key, int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
        DataColumnTemplate cdv = this.getColumnTemplate(key);
        if (cdv != null) {
            try {
                return cdv.getColumnValue(rowNdx, rd, rc, obj);
            }
            catch (Throwable th) {
                Print.logException((String)"Error getting report column value", (Throwable)th);
                return "!!!";
            }
        }
        if (obj instanceof DBRecord) {
            try {
                DBRecord dbr = (DBRecord)obj;
                DBField dbFld = dbr.getFactory(true).getField(key);
                if (dbFld != null) {
                    Object val = dbr.getFieldValue(key);
                    return StringTools.trim((String)dbFld.formatValue(val));
                }
                return "";
            }
            catch (DBException dbe) {
                return "";
            }
        }
        return "";
    }
}

