/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.war.report;

import org.opengts.util.ColorTools;
import org.opengts.util.PixelDimension;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class ColumnValue {
    public static final String LINK_TARGET_NONE = "";
    public static final String LINK_TARGET_BLANK = "_blank";
    public static final String LINK_TARGET_TOP = "_top";
    public static final String LINK_TARGET_DEFAULT = "";
    public static final String TEXT_DECORATION_UNDERLINE = "underline";
    public static final String TEXT_DECORATION_OVERLINE = "overline";
    public static final String TEXT_DECORATION_BLINK = "blink";
    public static final String FONT_WEIGHT_BOLD = "bold";
    public static final String FONT_STYLE_ITALIC = "italic";
    private String value = null;
    private String sortKey = null;
    private String cssClass = null;
    private String foreground = null;
    private String background = null;
    private String fontWeight = null;
    private String fontStyle = null;
    private String textDecoration = null;
    private String imageURL = null;
    private String linkURL = null;
    private String linkTarget = null;

    public ColumnValue() {
        this.clear();
    }

    public ColumnValue(ColumnValue other) {
        this();
        if (other != null) {
            this.value = other.value;
            this.sortKey = other.sortKey;
            this.cssClass = other.cssClass;
            this.foreground = other.foreground;
            this.background = other.background;
            this.fontWeight = other.fontWeight;
            this.fontStyle = other.fontStyle;
            this.textDecoration = other.textDecoration;
            this.imageURL = other.imageURL;
            this.linkURL = other.linkURL;
            this.linkTarget = other.linkTarget;
        }
    }

    public ColumnValue(String value) {
        this();
        this.setValue(value);
    }

    public ColumnValue(URIArg url) {
        this();
        this.setImageURL(url);
    }

    public ColumnValue(long value) {
        this(String.valueOf(value));
    }

    public boolean hasCssClass() {
        return !StringTools.isBlank((String)this.cssClass);
    }

    public ColumnValue setCssClass(String cssClass) {
        this.cssClass = StringTools.trim((String)cssClass);
        return this;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void clear() {
        this.value = null;
        this.cssClass = null;
        this.foreground = null;
        this.background = null;
        this.fontWeight = null;
        this.fontStyle = null;
        this.textDecoration = null;
        this.imageURL = null;
        this.linkURL = null;
        this.linkTarget = null;
    }

    public ColumnValue setValue(String val) {
        this.value = val;
        return this;
    }

    public String getValue() {
        return this.value != null ? this.value : "";
    }

    public String toString() {
        return this.getValue();
    }

    public ColumnValue setSortKey(String val) {
        this.sortKey = val;
        return this;
    }

    public ColumnValue setSortKey(long val) {
        return this.setSortKey(String.valueOf(val));
    }

    public ColumnValue setSortKey(int val) {
        return this.setSortKey(String.valueOf(val));
    }

    public boolean hasSortKey() {
        return this.sortKey != null;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public boolean hasStyle() {
        return this.hasForegroundColor() || this.hasBackgroundColor() || this.hasTextDecoration() || this.hasFontWeight() || this.hasFontStyle();
    }

    public String getStyleString() {
        if (!this.hasStyle()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.hasForegroundColor()) {
            sb.append("color:").append(this.getForegroundColor()).append(";");
        }
        if (this.hasBackgroundColor()) {
            sb.append("background-color:").append(this.getBackgroundColor()).append(";");
        }
        if (this.hasTextDecoration()) {
            sb.append("text-decoration:").append(this.getTextDecoration()).append(";");
        }
        if (this.hasFontStyle()) {
            sb.append("font-style:").append(this.getFontStyle()).append(";");
        }
        if (this.hasFontWeight()) {
            sb.append("font-weight:").append(this.getFontWeight()).append(";");
        }
        return sb.toString();
    }

    public ColumnValue setForegroundColor(ColorTools.RGB rgb) {
        if (rgb != null) {
            this.setForegroundColor(rgb.toString(true));
        } else {
            this.setForegroundColor((String)null);
        }
        return this;
    }

    public ColumnValue setForegroundColor(String color) {
        this.foreground = color;
        return this;
    }

    public boolean hasForegroundColor() {
        return !StringTools.isBlank((String)this.foreground);
    }

    public String getForegroundColor() {
        return this.hasForegroundColor() ? this.foreground : null;
    }

    public ColumnValue setBackgroundColor(String color) {
        this.background = color;
        return this;
    }

    public boolean hasBackgroundColor() {
        return this.background != null && !this.background.equals("");
    }

    public String getBackgroundColor() {
        return this.hasBackgroundColor() ? this.background : null;
    }

    public ColumnValue setTextDecoration(String decor) {
        this.textDecoration = decor;
        return this;
    }

    public ColumnValue setTextDecorationUnderline() {
        return this.setTextDecoration(TEXT_DECORATION_UNDERLINE);
    }

    public ColumnValue setTextDecorationOverline() {
        return this.setTextDecoration(TEXT_DECORATION_OVERLINE);
    }

    public ColumnValue setTextDecorationBlink() {
        return this.setTextDecoration(TEXT_DECORATION_BLINK);
    }

    public boolean hasTextDecoration() {
        return this.textDecoration != null && !this.textDecoration.equals("");
    }

    public String getTextDecoration() {
        return this.hasTextDecoration() ? this.textDecoration : null;
    }

    public ColumnValue setFontWeight(String fw) {
        this.fontWeight = fw;
        return this;
    }

    public ColumnValue setFontWeightBold() {
        return this.setFontWeight(FONT_WEIGHT_BOLD);
    }

    public boolean hasFontWeight() {
        return this.fontWeight != null && !this.fontWeight.equals("");
    }

    public String getFontWeight() {
        return this.hasFontWeight() ? this.fontWeight : null;
    }

    public ColumnValue setFontStyle(String fs) {
        this.fontStyle = fs;
        return this;
    }

    public ColumnValue setFontStyleItalic() {
        return this.setFontStyle(FONT_STYLE_ITALIC);
    }

    public boolean hasFontStyle() {
        return this.fontStyle != null && !this.fontStyle.equals("");
    }

    public String getFontStyle() {
        return this.hasFontStyle() ? this.fontStyle : null;
    }

    public ColumnValue setImageURL(String url) {
        return this.setImageURL(url, null);
    }

    public ColumnValue setImageURL(URIArg url) {
        return this.setImageURL(url != null ? url.toString() : null, null);
    }

    public ColumnValue setImageURL(String url, PixelDimension size) {
        this.imageURL = url;
        return this;
    }

    public boolean hasImageURL() {
        return !StringTools.isBlank((String)this.imageURL);
    }

    public String getImageURL() {
        return this.hasImageURL() ? this.imageURL : null;
    }

    public ColumnValue setLinkURL(String url) {
        return this.setLinkURL(url, null);
    }

    public ColumnValue setLinkURL(URIArg url) {
        return this.setLinkURL(url, null);
    }

    public ColumnValue setLinkURL(String url, String target) {
        this.linkURL = url;
        this.linkTarget = target;
        return this;
    }

    public ColumnValue setLinkURL(URIArg url, String target) {
        return this.setLinkURL(url != null ? url.toString() : null, target);
    }

    public boolean hasLinkURL() {
        return !StringTools.isBlank((String)this.linkURL);
    }

    public String getLinkURL() {
        return this.hasLinkURL() ? this.linkURL : null;
    }

    public boolean hasLinkTarget() {
        return this.linkTarget != null && !this.linkTarget.equals("");
    }

    public String getLinkTarget() {
        return this.hasLinkTarget() ? this.linkTarget : "";
    }
}

