/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.session;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opengts.db.SessionStatsFactory;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class SessionStatusReport
extends ReportData {
    private List<FieldData> rowData = null;
    private SessionStatsFactory statsFactory = null;

    public SessionStatusReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account must be specified");
        }
        this.statsFactory = Device.getSessionStatsFactory();
    }

    @Override
    public void postInitialize() {
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return SessionStatusReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                Device device = devList.getDevice(devID);
                if (device != null) {
                    long eventCount = this.countEventData(device);
                    long[] connCount = this.countConnections(device);
                    long[] byteCount = this.countDataBytes(device);
                    long connTotal = connCount[0] + connCount[1];
                    long bytesRead = byteCount[0];
                    long bytesWritten = byteCount[1];
                    long bytesOverhead = byteCount[2];
                    long bytesTotal = bytesRead + bytesWritten + bytesOverhead;
                    long bytesRounded = byteCount[3];
                    FieldData fd = new FieldData();
                    fd.setDevice(device);
                    fd.setString("deviceId", devID);
                    fd.setLong("eventsReceived", eventCount);
                    fd.setLong("tcpConnections", connCount[0]);
                    fd.setLong("udpConnections", connCount[1]);
                    fd.setLong("connections", connTotal);
                    fd.setLong("bytesRead", bytesRead);
                    fd.setLong("bytesWritten", bytesWritten);
                    fd.setLong("bytesOverhead", bytesOverhead);
                    fd.setLong("bytesTotal", bytesTotal);
                    fd.setLong("bytesRounded", bytesRounded);
                    this.rowData.add(fd);
                    continue;
                }
                Print.logError((String)("Returned DeviceList 'Device' is null: " + devID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData count for Device: " + devID), (Object[])new Object[0]);
            }
        }
        FieldData.sortByDeviceDescription(this.rowData);
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    private long[] countConnections(Device device) {
        try {
            long[] lArray;
            long[] connCounts;
            long timeStart = super.getTimeStart();
            long timeEnd = super.getTimeEnd();
            long[] lArray2 = connCounts = this.statsFactory != null ? this.statsFactory.getConnectionCounts(device, timeStart, timeEnd) : null;
            if (connCounts != null) {
                lArray = connCounts;
            } else {
                long[] lArray3 = new long[2];
                lArray3[0] = 0L;
                lArray = lArray3;
                lArray3[1] = 0L;
            }
            return lArray;
        }
        catch (DBException dbe) {
            Print.logException((String)"Counting Connections", (Throwable)dbe);
            return new long[]{0L, 0L};
        }
    }

    private long[] countDataBytes(Device device) {
        try {
            long[] lArray;
            long[] byteCounts;
            long timeStart = super.getTimeStart();
            long timeEnd = super.getTimeEnd();
            long[] lArray2 = byteCounts = this.statsFactory != null ? this.statsFactory.getByteCounts(device, timeStart, timeEnd) : null;
            if (byteCounts != null) {
                lArray = byteCounts;
            } else {
                long[] lArray3 = new long[4];
                lArray3[0] = 0L;
                lArray3[1] = 0L;
                lArray3[2] = 0L;
                lArray = lArray3;
                lArray3[3] = 0L;
            }
            return lArray;
        }
        catch (DBException dbe) {
            Print.logException((String)"Counting Data Bytes", (Throwable)dbe);
            return new long[]{0L, 0L, 0L, 0L};
        }
    }
}

