/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.Comparator;
import java.util.Vector;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Transport;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.extra.tables.UnassignedDevices;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class UnassignedDevicesReport
extends ReportData
implements DBRecordHandler<UnassignedDevices> {
    private static Comparator<FieldData> createDateTimeComparator = null;
    private I18N i18n = null;

    private static Comparator<FieldData> CreationDateTimeComparator() {
        if (createDateTimeComparator == null) {
            createDateTimeComparator = new Comparator<FieldData>(){

                private long getTimestamp(FieldData fd) {
                    if (fd == null) {
                        return 0L;
                    }
                    long ts = fd.getLong("createTimestamp");
                    return ts > 0L ? ts : fd.getLong("timestamp");
                }

                @Override
                public int compare(FieldData fd1, FieldData fd2) {
                    long ts1 = this.getTimestamp(fd1);
                    long ts2 = this.getTimestamp(fd2);
                    return ts2 == ts1 ? 0 : (ts2 < ts1 ? -1 : 1);
                }
            };
        }
        return createDateTimeComparator;
    }

    public UnassignedDevicesReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        this.i18n = reqState.getPrivateLabel().getI18N(UnassignedDevicesReport.class);
    }

    @Override
    public void postInitialize() {
    }

    protected EventData[] getEventData(Device device, DBRecordHandler rcdHandler) {
        return new EventData[0];
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return false;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return UnassignedDevicesReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        final Vector rowData = new Vector();
        DBRecordHandler<UnassignedDevices> rcdHandler = new DBRecordHandler<UnassignedDevices>(){

            public int handleDBRecord(UnassignedDevices rcd) throws DBException {
                UnassignedDevices ud = rcd;
                String mobileID = ud.getMobileID();
                String serverID = ud.getServerID();
                DCServerConfig dcs = DCServerFactory._getServerConfig((String)serverID);
                if (dcs != null) {
                    String[] pfx = dcs.getUniquePrefix();
                    try {
                        for (int i = 0; i < pfx.length; ++i) {
                            String uniqueID = pfx[i] + mobileID;
                            if (Transport.loadDeviceByUniqueID((String)uniqueID) == null) continue;
                            Print.logInfo((String)"MobileID is now defined: [%s] %s", (Object[])new Object[]{serverID, uniqueID});
                            return 1;
                        }
                    }
                    catch (DBException dbe) {
                        Print.logWarn((String)("Error check for UniqueID existence: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                    }
                }
                FieldData fd = new FieldData();
                fd.setValue("timestamp", ud.getTimestamp());
                fd.setValue("createTimestamp", ud.getCreationTime());
                fd.setValue("serverId", serverID);
                fd.setValue("uniqueId", mobileID);
                fd.setValue("ipAddress", ud.getIpAddressString());
                fd.setValue("isDuplex", ud.getIsDuplex());
                fd.setValue("latitude", ud.getLatitude());
                fd.setValue("longitude", ud.getLongitude());
                rowData.add(fd);
                return 1;
            }
        };
        try {
            UnassignedDevices.getRecordCallback((DBRecordHandler)rcdHandler);
        }
        catch (DBException dbe) {
            Print.logException((String)"Error", (Throwable)dbe);
        }
        ListTools.sort(rowData, UnassignedDevicesReport.CreationDateTimeComparator());
        return new ReportData.ListDataIterator(this, rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    public int handleDBRecord(UnassignedDevices rcd) throws DBException {
        UnassignedDevices ud = rcd;
        return 1;
    }
}

