/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class TripReport
extends ReportData
implements DBRecordHandler<EventData> {
    private static final String PROP_tripStartType = "tripStartType";
    private static final String PROP_minimumStoppedTime = "minimumStoppedTime";
    private static final String PROP_minimumSpeedKPH = "minimumSpeedKPH";
    private static final String PROP_stopOnIgnitionOff = "stopOnIgnitionOff";
    private static final String PROP_estimateFuelTotal = "estimateFuelTotal";
    private static final String PROP_kilometersPerLiter = "kilometersPerLiter";
    private static final String PROP_tripStartStopOnly = "tripStartStopOnly";
    private static final String PROP_speedingThresholdKPH = "speedingThresholdKPH";
    private static final String PROP_minimumSpeedingDuration = "minimumSpeedingDuration";
    private static final String PROP_tripStopLookAheadSeconds = "tripStopLookAheadSeconds";
    private static final String PROP_odometerDeltaBit = "odometerDeltaBit";
    private static final long TRIPSTOP_LOOKAHEAD_SEC = 0L;
    private static final String[] MOTION_DEFAULT = new String[]{"default"};
    private static final String[] MOTION_SPEED = new String[]{"speed", "motion"};
    private static final String[] MOTION_IGNITION = new String[]{"ignition"};
    private static final String[] MOTION_ENGINE = new String[]{"engine"};
    private static final String[] MOTION_STARTSTOP = new String[]{"start", "startstop"};
    private static final int TRIP_ON_SPEED = 0;
    private static final int TRIP_ON_IGNITION = 1;
    private static final int TRIP_ON_ENGINE = 2;
    private static final int TRIP_ON_START = 3;
    private static final double MIN_SPEED_KPH = 5.0;
    private static final int SPEED_TYPE_NONE = 0;
    private static final int SPEED_TYPE_THRESHOLD = 1;
    private static final int SPEED_TYPE_DEVICE = 2;
    private static final double SPEEDING_THRESHOLD = 0.0;
    private static final long MIN_SPEED_DURATION = 0L;
    private static final int ODOMETER_DELTA_BIT = -1;
    private static final long MIN_STOPPED_TIME_SEC = DateTime.MinuteSeconds((long)5L);
    private static final boolean STOP_ON_IGNITION_OFF = false;
    private static final boolean TRIP_START_STOP_ONLY = false;
    private static final boolean ESTIMATE_FUEL_TOTAL = false;
    private static final double KILOMETERS_PER_LITER = 8.502874148605441;
    private static final double ZERO_LITERS = 0.001;
    private boolean startStopSupported = false;
    private int[] ignitionCodes = null;
    private long ignitionOnTime = 0L;
    private long ignitionOffTime = 0L;
    private long motionStartTime = 0L;
    private long motionStopTime = 0L;
    private boolean idleIsMoving = false;
    private double idleMinSpeedKPH = 0.0;
    private long idleStartTime = 0L;
    private long idleDuraTotalSec = 0L;
    private int tripStartType = 0;
    private EventData tripStartEvent = null;
    private EventData firstEvent = null;
    private EventData previousEvent = null;
    private boolean approxStart = true;
    private long lookAheadSeconds = 0L;
    private Vector<EventData> lookAheadEvents = null;
    private int lookAheadNdx = -1;
    private boolean devEstFuelTotal = false;
    private double devFuelEconomy = 0.0;
    private boolean speedIsMoving = false;
    private long lastMovingTime = 0L;
    private long lastStoppedTime = 0L;
    private double minSpeedKPH = 5.0;
    private long minStoppedTimeSec = MIN_STOPPED_TIME_SEC;
    private boolean stopOnIgnitionOff = false;
    private boolean estimateFuelTotal = false;
    private double kilometersPerLiter = 8.502874148605441;
    private boolean tripStartStopOnly = false;
    private int speedingType = 1;
    private double speedingThreshold = 0.0;
    private long minSpeedingDuration = 0L;
    private EventData speedingStartEvent = null;
    private EventData speedingLastEvent = null;
    private long speedDuraTotalSec = 0L;
    private int odometerDeltaBit = -1;
    private double bitOdometerTripKM = 0.0;
    private double lastFuelLevel = 0.0;
    private double lastFuelRemain = 0.0;
    private List<FieldData> rowData = null;
    private I18N i18n = null;

    public TripReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        this.i18n = reqState.getPrivateLabel().getI18N(TripReport.class);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        if (this.getDeviceCount() <= 0) {
            throw new ReportException("No Devices specified");
        }
    }

    @Override
    public boolean isSingleDeviceOnly() {
        return true;
    }

    @Override
    public void postInitialize() {
        RTProperties tripRTP = this.getProperties();
        this.minSpeedKPH = tripRTP.getDouble(PROP_minimumSpeedKPH, 5.0);
        this.minStoppedTimeSec = tripRTP.getLong(PROP_minimumStoppedTime, MIN_STOPPED_TIME_SEC);
        this.stopOnIgnitionOff = tripRTP.getBoolean(PROP_stopOnIgnitionOff, false);
        this.estimateFuelTotal = tripRTP.getBoolean(PROP_estimateFuelTotal, false);
        this.kilometersPerLiter = tripRTP.getDouble(PROP_kilometersPerLiter, 8.502874148605441);
        this.tripStartStopOnly = tripRTP.getBoolean(PROP_tripStartStopOnly, false);
        this.minSpeedingDuration = tripRTP.getLong(PROP_minimumSpeedingDuration, 0L);
        this.odometerDeltaBit = tripRTP.getInt(PROP_odometerDeltaBit, -1);
        String speedingTypeStr = tripRTP.getString(PROP_speedingThresholdKPH, String.valueOf(0.0));
        if (speedingTypeStr.equalsIgnoreCase("device")) {
            this.speedingType = 2;
            this.speedingThreshold = 0.0;
        } else {
            double threshold = StringTools.parseDouble((String)speedingTypeStr, (double)0.0);
            if (threshold <= 0.0) {
                this.speedingType = 0;
                this.speedingThreshold = 0.0;
            } else {
                this.speedingType = 1;
                this.speedingThreshold = threshold;
            }
        }
        if (this.estimateFuelTotal) {
            Print.logInfo((String)("Estimating Fuel Usage: default = " + this.kilometersPerLiter + " km/L"), (Object[])new Object[0]);
        }
        if (this.tripStartStopOnly) {
            Print.logInfo((String)"Trip detail will be omitted (per 'tripStartStopOnly')", (Object[])new Object[0]);
        }
    }

    @Override
    protected EventData[] getEventData(Device device, DBRecordHandler<EventData> rcdHandler) {
        return super.getEventData(device, rcdHandler);
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return false;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return TripReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        String accountID = this.getAccountID();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                String las;
                Device device = devList.getDevice(devID);
                if (device == null) continue;
                this.firstEvent = null;
                this.previousEvent = null;
                this.tripStartType = 0;
                this.tripStartEvent = null;
                this.approxStart = true;
                this.bitOdometerTripKM = 0.0;
                this.speedIsMoving = false;
                this.lastMovingTime = 0L;
                this.lastStoppedTime = 0L;
                this.ignitionOnTime = 0L;
                this.ignitionOffTime = 0L;
                this.motionStartTime = 0L;
                this.motionStopTime = 0L;
                this.lastFuelLevel = 0.0;
                this.lastFuelRemain = 0.0;
                this.speedingStartEvent = null;
                this.speedingLastEvent = null;
                this.speedDuraTotalSec = 0L;
                this.idleIsMoving = false;
                this.idleStartTime = 0L;
                this.idleDuraTotalSec = 0L;
                this.devFuelEconomy = 0.0;
                this.devEstFuelTotal = false;
                if (this.estimateFuelTotal) {
                    double fuelEcon = device.getFuelEconomy();
                    if (fuelEcon > 0.0) {
                        this.devFuelEconomy = fuelEcon;
                        this.devEstFuelTotal = true;
                    } else if (this.kilometersPerLiter > 0.0) {
                        this.devFuelEconomy = this.kilometersPerLiter;
                        this.devEstFuelTotal = true;
                    }
                }
                this.startStopSupported = device.getStartStopSupported();
                if (!this.startStopSupported) {
                    // empty if block
                }
                this.ignitionCodes = device.getIgnitionStatusCodes();
                boolean hasIgnition = this.ignitionCodes != null;
                String tt = this.getProperties().getString(PROP_tripStartType, MOTION_SPEED[0]).toLowerCase();
                if (ListTools.contains((Object[])MOTION_DEFAULT, (Object)tt)) {
                    String devCode = device.getDeviceCode();
                    DCServerConfig dcs = DCServerFactory.getServerConfig((String)devCode);
                    if (dcs == null && StringTools.isBlank((String)devCode) && Account.IsDemoAccount((String)accountID) && (dcs = DCServerFactory.getServerConfig((String)"gtsdmtp")) == null) {
                        Print.logWarn((String)"Account 'demo' DCServerConfig not found: gtsdmtp", (Object[])new Object[0]);
                    }
                    this.tripStartType = dcs != null ? (dcs.getStartStopSupported(false) ? 3 : (hasIgnition ? 1 : 0)) : (hasIgnition ? 1 : 0);
                } else if (ListTools.contains((Object[])MOTION_STARTSTOP, (Object)tt)) {
                    this.tripStartType = 3;
                } else if (ListTools.contains((Object[])MOTION_IGNITION, (Object)tt)) {
                    this.tripStartType = 1;
                    if (!hasIgnition) {
                        this.ignitionCodes = new int[]{62467, 62465};
                        hasIgnition = true;
                    }
                } else {
                    this.tripStartType = ListTools.contains((Object[])MOTION_ENGINE, (Object)tt) ? 2 : 0;
                }
                this.lookAheadSeconds = this.tripStartType == 0 ? (StringTools.isBlank((String)(las = this.getProperties().getString(PROP_tripStopLookAheadSeconds, null))) ? 0L : (las.equalsIgnoreCase(PROP_minimumStoppedTime) ? this.minStoppedTimeSec + 1L : StringTools.parseLong((String)las, (long)0L))) : 0L;
                if (this.lookAheadSeconds > 0L) {
                    EventData ev;
                    int dbrh;
                    final Vector<EventData> evList = this.lookAheadEvents = new Vector();
                    final long lim = this.getSelectionLimit();
                    this.getEventData(device, new DBRecordHandler<EventData>(){

                        public int handleDBRecord(EventData ev) throws DBException {
                            evList.add(ev);
                            return lim <= 0L || (long)evList.size() < lim ? 1 : 0;
                        }
                    });
                    int evLen = ListTools.size(this.lookAheadEvents);
                    this.lookAheadNdx = 0;
                    while (this.lookAheadNdx < evLen && (dbrh = this.handleDBRecord(ev = this.lookAheadEvents.get(this.lookAheadNdx))) != 0) {
                        ++this.lookAheadNdx;
                    }
                } else {
                    this.getEventData(device, this);
                }
                if (!this.approxStart) continue;
                Print.logWarn((String)"Actual Trip 'Start' not found, clearing row data ...", (Object[])new Object[0]);
                this.rowData.clear();
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData for Device: " + devID), (Object[])new Object[0]);
            }
        }
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    private EventData getLookAheadEventData(int ofs) {
        if (this.lookAheadEvents == null) {
            return null;
        }
        int ndx = this.lookAheadNdx + ofs;
        if (ndx < 0) {
            return null;
        }
        if (ndx >= this.lookAheadEvents.size()) {
            return null;
        }
        return this.lookAheadEvents.get(ndx);
    }

    private boolean isInMotion(EventData ev) {
        if (this.startStopSupported) {
            return this.motionStartTime > 0L && this.motionStartTime > this.motionStopTime;
        }
        double evKPH = ev.getSpeedKPH();
        return evKPH > this.idleMinSpeedKPH;
    }

    public int handleDBRecord(EventData rcd) throws DBException {
        boolean tripStop;
        EventData ev = rcd;
        int statusCode = ev.getStatusCode();
        long timestamp = ev.getTimestamp();
        boolean tripStart = this.isTripStart(ev);
        boolean bl = tripStop = tripStart ? false : this.isTripStop(ev);
        if (this.firstEvent == null) {
            this.firstEvent = ev;
            if (!tripStop && !tripStart) {
                this.tripStartEvent = ev;
                this.approxStart = true;
            }
            if (this.devEstFuelTotal) {
                if (this.firstEvent.getOdometerKM() <= 0.0) {
                    Print.logWarn((String)("First trip event missing odometer: " + ev.getDeviceID()), (Object[])new Object[0]);
                    this.devEstFuelTotal = false;
                } else if (this.firstEvent.getFuelTotal() > 0.001) {
                    Print.logWarn((String)("First trip event already has fuel-total: " + ev.getDeviceID()), (Object[])new Object[0]);
                    this.devEstFuelTotal = false;
                }
            }
        }
        if (this.devEstFuelTotal) {
            if (ev.getFuelTotal() > 0.001) {
                Print.logDebug((String)"WARN: Skipping FuelTotal estimate: CurrentEvent already has a fuel-total", (Object[])new Object[0]);
            } else if (ev.getOdometerKM() <= 0.0) {
                Print.logDebug((String)"Skipping FuelTotal estimate: CurrentEvent does not have an odometer value", (Object[])new Object[0]);
            } else {
                double km = ev.getOdometerKM() - this.firstEvent.getOdometerKM();
                double liters = km * (1.0 / this.devFuelEconomy);
                ev.setFuelTotal(liters > 0.0 ? liters : 0.001);
                Print.logDebug((String)("Setting FuelTotal estimate: " + ev.getFuelTotal() + " Liters"), (Object[])new Object[0]);
            }
        }
        if (this.isIgnitionOn(ev)) {
            this.ignitionOnTime = timestamp;
            this.ignitionOffTime = 0L;
        } else if (this.isIgnitionOff(ev)) {
            this.ignitionOnTime = 0L;
            this.ignitionOffTime = timestamp;
        }
        if (statusCode == 61713) {
            this.motionStartTime = timestamp;
            this.motionStopTime = 0L;
        } else if (statusCode == 61715) {
            this.motionStartTime = 0L;
            this.motionStopTime = timestamp;
        }
        if (tripStart) {
            if (this.tripStartEvent != null) {
                if (this.approxStart) {
                    Print.logInfo((String)"Found Trip 'Start', clearing previous approximate start ...", (Object[])new Object[0]);
                    this.rowData.clear();
                } else {
                    this.rowData.add(new BlankRow());
                }
            }
            this.tripStartEvent = ev;
            this.approxStart = false;
            this.idleStartTime = 0L;
            this.idleDuraTotalSec = 0L;
            this.speedDuraTotalSec = 0L;
            this.bitOdometerTripKM = 0.0;
            this.lastFuelLevel = 0.0;
            this.lastFuelRemain = 0.0;
        }
        long idleElapse = -1L;
        boolean totalIdle = false;
        if (this.tripStartEvent != null) {
            if (!this.isInMotion(ev)) {
                if (tripStart) {
                    this.idleIsMoving = false;
                    this.idleStartTime = timestamp;
                    idleElapse = 0L;
                } else if (this.idleIsMoving) {
                    this.idleIsMoving = false;
                    this.idleStartTime = timestamp;
                    idleElapse = 0L;
                } else if (this.idleStartTime > 0L) {
                    idleElapse = timestamp - this.idleStartTime;
                }
            } else if (!this.idleIsMoving || tripStop) {
                if (this.idleStartTime > 0L) {
                    idleElapse = timestamp - this.idleStartTime;
                    totalIdle = true;
                }
                this.idleIsMoving = true;
                this.idleStartTime = 0L;
            }
        }
        if ((totalIdle || tripStop) && idleElapse > 0L) {
            this.idleDuraTotalSec += idleElapse;
        }
        if (this.odometerDeltaBit >= 0 && this.isOdometerBitOn(rcd) && this.isOdometerBitOn(this.previousEvent)) {
            double deltaKM = rcd.getOdometerKM() - this.previousEvent.getOdometerKM();
            this.bitOdometerTripKM += deltaKM;
        }
        long speedDurationSec = -1L;
        double speedThresholdKPH = 0.0;
        if (this.speedingType == 1) {
            speedThresholdKPH = this.speedingThreshold;
        } else if (this.speedingType == 2) {
            Device device = ev.getDevice();
            double d = speedThresholdKPH = device != null ? device.getSpeedLimitKPH() : 0.0;
        }
        if (speedThresholdKPH > 0.0) {
            long endSpeedTime;
            if (this.tripStartEvent == null) {
                if (this.speedingStartEvent != null) {
                    long beginSpeedTime = this.speedingStartEvent.getTimestamp();
                    endSpeedTime = this.speedingLastEvent.getTimestamp();
                    this.speedDuraTotalSec += Math.max(endSpeedTime - beginSpeedTime, this.minSpeedingDuration);
                    this.speedingStartEvent = null;
                    this.speedingLastEvent = null;
                }
            } else if (ev.getSpeedKPH() >= speedThresholdKPH) {
                this.speedingLastEvent = ev;
                if (this.speedingStartEvent == null) {
                    this.speedingStartEvent = ev;
                    speedDurationSec = this.minSpeedingDuration;
                } else {
                    long beginSpeedTime = this.speedingStartEvent.getTimestamp();
                    endSpeedTime = this.speedingLastEvent.getTimestamp();
                    speedDurationSec = Math.max(endSpeedTime - beginSpeedTime, this.minSpeedingDuration);
                }
            } else if (this.speedingStartEvent != null) {
                long beginSpeedTime = this.speedingStartEvent.getTimestamp();
                endSpeedTime = this.speedingLastEvent.getTimestamp();
                this.speedDuraTotalSec += Math.max(endSpeedTime - beginSpeedTime, this.minSpeedingDuration);
                this.speedingStartEvent = null;
                this.speedingLastEvent = null;
            }
        }
        if (this.tripStartEvent != null) {
            TripDetail td;
            double bitOdomKM = this.bitOdometerTripKM;
            double fuelLevel = ev.getFuelLevel(true);
            if (fuelLevel > 0.0) {
                if (this.tripStartEvent.getFuelLevel(false) <= 0.0) {
                    this.tripStartEvent.setFuelLevel(fuelLevel);
                }
                this.lastFuelLevel = fuelLevel;
            } else if (this.lastFuelLevel > 0.0) {
                ev.setFuelLevel(this.lastFuelLevel);
                fuelLevel = this.lastFuelLevel;
            }
            double fuelRemain = ev.getFuelRemain(true);
            if (fuelRemain > 0.0) {
                if (this.tripStartEvent.getFuelRemain(false) <= 0.0) {
                    this.tripStartEvent.setFuelRemain(fuelRemain);
                }
                this.lastFuelRemain = fuelRemain;
            } else if (this.lastFuelRemain > 0.0) {
                ev.setFuelRemain(this.lastFuelRemain);
                fuelRemain = this.lastFuelRemain;
            }
            if (!this.tripStartStopOnly) {
                td = new TripDetail(this.tripStartEvent, ev, speedDurationSec, bitOdomKM, idleElapse, this.i18n);
                this.rowData.add(td);
            } else if (tripStart) {
                td = new TripDetail(this.tripStartEvent, ev, speedDurationSec, bitOdomKM, idleElapse, this.i18n);
                this.rowData.add(td);
            } else if (tripStop) {
                td = new TripDetail(this.tripStartEvent, ev, speedDurationSec, bitOdomKM, idleElapse, this.i18n);
                this.rowData.add(td);
            }
            if (tripStop) {
                long totalDura = this.speedDuraTotalSec > 0L ? this.speedDuraTotalSec : -1L;
                TripTotal tt = new TripTotal(this.tripStartEvent, ev, totalDura, bitOdomKM, this.idleDuraTotalSec, this.i18n);
                this.rowData.add(tt);
                this.tripStartEvent = null;
                this.idleStartTime = 0L;
                this.idleDuraTotalSec = 0L;
                this.speedDuraTotalSec = 0L;
                this.bitOdometerTripKM = 0.0;
                this.lastFuelLevel = 0.0;
                this.lastFuelRemain = 0.0;
            }
        }
        this.previousEvent = ev;
        return (long)this.rowData.size() < this.getReportLimit() ? 1 : 0;
    }

    private boolean isIgnitionOn(EventData ev) {
        int sc = ev.getStatusCode();
        if (sc == 62465) {
            return true;
        }
        return this.ignitionCodes != null && sc == this.ignitionCodes[1];
    }

    private boolean isIgnitionOff(EventData ev) {
        int sc = ev.getStatusCode();
        if (sc == 62467) {
            return true;
        }
        return this.ignitionCodes != null && sc == this.ignitionCodes[0];
    }

    private boolean isTripStart(EventData ev) {
        if (this.tripStartType == 1) {
            int sc = ev.getStatusCode();
            if (sc == 62465) {
                return true;
            }
            if (this.ignitionCodes != null && sc == this.ignitionCodes[1]) {
                return true;
            }
        } else if (this.tripStartType == 2) {
            int sc = ev.getStatusCode();
            if (sc == 62476) {
                return true;
            }
        } else if (this.tripStartType == 3) {
            int sc = ev.getStatusCode();
            if (sc == 61713) {
                return true;
            }
        } else if (this.tripStartType == 0 && ev.getSpeedKPH() >= this.minSpeedKPH) {
            this.lastStoppedTime = 0L;
            if (!this.speedIsMoving) {
                this.speedIsMoving = true;
                this.lastMovingTime = ev.getTimestamp();
                return true;
            }
        }
        return false;
    }

    private boolean isTripStop(EventData ev) {
        if (this.tripStartType == 1) {
            int sc = ev.getStatusCode();
            if (sc == 62467) {
                return true;
            }
            if (this.ignitionCodes != null && sc == this.ignitionCodes[0]) {
                return true;
            }
        } else if (this.tripStartType == 2) {
            int sc = ev.getStatusCode();
            if (sc == 62477) {
                return true;
            }
        } else if (this.tripStartType == 3) {
            int sc = ev.getStatusCode();
            if (sc == 61715) {
                return true;
            }
            if (sc == 62467) {
                return true;
            }
            if (this.stopOnIgnitionOff && this.ignitionCodes != null && sc == this.ignitionCodes[0]) {
                return true;
            }
        } else if (this.tripStartType == 0 && this.speedIsMoving) {
            long deltaSec;
            EventData nextEV;
            int sc = ev.getStatusCode();
            if (this.stopOnIgnitionOff && this.ignitionCodes != null && sc == this.ignitionCodes[0]) {
                this.speedIsMoving = false;
                this.lastMovingTime = 0L;
                this.lastStoppedTime = 0L;
                return true;
            }
            if (ev.getSpeedKPH() < this.minSpeedKPH) {
                if (this.lastStoppedTime == 0L) {
                    this.lastStoppedTime = ev.getTimestamp();
                } else {
                    long stoppedDeltaSec = ev.getTimestamp() - this.lastStoppedTime;
                    if (stoppedDeltaSec >= this.minStoppedTimeSec) {
                        this.speedIsMoving = false;
                        this.lastMovingTime = 0L;
                        this.lastStoppedTime = 0L;
                        return true;
                    }
                }
            } else if (this.lookAheadSeconds > 0L && (nextEV = this.getLookAheadEventData(1)) != null && (deltaSec = nextEV.getTimestamp() - ev.getTimestamp()) >= this.lookAheadSeconds) {
                this.speedIsMoving = false;
                this.lastMovingTime = 0L;
                this.lastStoppedTime = 0L;
                return true;
            }
        }
        return false;
    }

    private boolean isOdometerBitOn(EventData ev) {
        if (ev != null && this.odometerDeltaBit >= 0) {
            return ev.getInputMaskBitState(this.odometerDeltaBit);
        }
        return false;
    }

    private static class TripTotal
    extends FieldData {
        public TripTotal(EventData startEv, EventData stopEv, long speedDuraSec, double bitOdomKM, long idleElapse, I18N i18n) {
            this.setRowType(DBDataRow.RowType.SUBTOTAL);
            this.setCssClass("rptBodyRowTotal");
            if (startEv != null && stopEv != null) {
                Device device = stopEv.getDevice();
                long driveElapse = stopEv.getTimestamp() - startEv.getTimestamp();
                double odomDelta = stopEv.getOdometerKM() - startEv.getOdometerKM();
                double fuelLevel = stopEv.getFuelLevel(true);
                double fuelRemain = stopEv.getFuelRemain(true);
                double fuelTotal = stopEv.getFuelTotal();
                double fuelTrip = 0.0;
                double fuelEcon = 0.0;
                String driverID = stopEv.getDriverID();
                Device.FuelEconomyType fuelEconType = Device.FuelEconomyType.UNKNOWN;
                if (fuelTotal > 0.0) {
                    fuelTrip = fuelTotal - startEv.getFuelTotal();
                    fuelEcon = fuelTrip > 0.0 ? odomDelta / fuelTrip : 0.0;
                    fuelEconType = Device.FuelEconomyType.FUEL_CONSUMED;
                } else if (fuelRemain > 0.0) {
                    fuelTrip = startEv.getFuelRemain(true) - fuelRemain;
                    fuelEcon = fuelTrip > 0.0 ? odomDelta / fuelTrip : 0.0;
                    fuelEconType = Device.FuelEconomyType.FUEL_REMAINING;
                } else if (device.getFuelCapacity() > 0.0) {
                    double flDelta = startEv.getFuelLevel(true) - fuelLevel;
                    fuelTrip = flDelta > 0.0 ? flDelta * device.getFuelCapacity() : 0.0;
                    fuelEcon = fuelTrip > 0.0 ? odomDelta / fuelTrip : 0.0;
                    fuelEconType = Device.FuelEconomyType.FUEL_LEVEL;
                } else if (device.getFuelEconomy() > 0.0) {
                    fuelEcon = odomDelta > 0.0 ? device.getFuelEconomy() : 0.0;
                    fuelTrip = odomDelta / fuelEcon;
                    fuelEconType = Device.FuelEconomyType.DEVICE_ECONOMY;
                }
                this.setValue("speedDuration", speedDuraSec);
                this.setValue("fuelLevel", fuelLevel);
                this.setValue("fuelRemain", fuelRemain);
                this.setValue("fuelTotal", fuelTotal);
                this.setValue("fuelTrip", fuelTrip > 0.0 ? fuelTrip : 1.0E-4);
                this.setValue("odomDelta", odomDelta);
                this.setValue("odomDeltaBit", bitOdomKM);
                this.setValue("fuelEconomy", fuelEcon);
                this.setValue("fuelEconomyType", fuelEconType);
                this.setValue("drivingElapse", driveElapse);
                this.setValue("idleElapse", idleElapse);
                this.setValue("address", i18n.getString("TripReport.tripTimeDistance", "Trip Time/Distance"));
                this.setValue("driverId", driverID);
            } else {
                this.setValue("address", "");
            }
        }
    }

    private static class TripDetail
    extends FieldData {
        public TripDetail(EventData startEv, EventData tripEv, long speedDuraSec, double bitOdomKM, long idleElapse, I18N i18n) {
            Account account = tripEv.getAccount();
            Device device = tripEv.getDevice();
            this.setAccount(account);
            this.setDevice(device);
            this.setValue("timestamp", tripEv.getTimestamp());
            this.setValue("statusCode", tripEv.getStatusCode());
            this.setValue("latitude", tripEv.getLatitude());
            this.setValue("longitude", tripEv.getLongitude());
            this.setValue("altitude", tripEv.getAltitude());
            this.setValue("speed", tripEv.getSpeedKPH());
            this.setValue("speedDuration", speedDuraSec);
            this.setValue("heading", tripEv.getHeading());
            this.setValue("odometer", tripEv.getOdometerKM());
            this.setValue("odomDeltaBit", bitOdomKM);
            this.setValue("address", tripEv.getAddress());
            this.setValue("driverId", tripEv.getDriverID());
            double odomDelta = tripEv.getOdometerKM() - startEv.getOdometerKM();
            long driveElapse = tripEv.getTimestamp() - startEv.getTimestamp();
            double fuelLevel = tripEv.getFuelLevel(true);
            double fuelRemain = tripEv.getFuelRemain(true);
            double fuelTotal = tripEv.getFuelTotal();
            double fuelTrip = 0.0;
            double fuelEcon = 0.0;
            Device.FuelEconomyType fuelEconType = Device.FuelEconomyType.UNKNOWN;
            if (fuelTotal > 0.0) {
                fuelTrip = fuelTotal - startEv.getFuelTotal();
                fuelEcon = fuelTrip > 0.0 ? odomDelta / fuelTrip : 0.0;
                fuelEconType = Device.FuelEconomyType.FUEL_CONSUMED;
            } else if (fuelRemain > 0.0) {
                fuelTrip = startEv.getFuelRemain(true) - fuelRemain;
                fuelEcon = fuelTrip > 0.0 ? odomDelta / fuelTrip : 0.0;
                fuelEconType = Device.FuelEconomyType.FUEL_REMAINING;
            } else if (device.getFuelCapacity() > 0.0) {
                double flDelta = startEv.getFuelLevel(true) - fuelLevel;
                fuelTrip = flDelta > 0.0 ? flDelta * device.getFuelCapacity() : 0.0;
                fuelEcon = fuelTrip > 0.0 ? odomDelta / fuelTrip : 0.0;
                fuelEconType = Device.FuelEconomyType.FUEL_LEVEL;
            } else if (device.getFuelEconomy() > 0.0) {
                fuelEcon = odomDelta > 0.0 ? device.getFuelEconomy() : 0.0;
                fuelTrip = odomDelta / fuelEcon;
                fuelEconType = Device.FuelEconomyType.DEVICE_ECONOMY;
            }
            this.setValue("fuelLevel", fuelLevel);
            this.setValue("fuelRemain", fuelRemain);
            this.setValue("fuelTotal", fuelTotal);
            this.setValue("fuelTrip", fuelTrip > 0.0 ? fuelTrip : 1.0E-4);
            this.setValue("odomDelta", odomDelta);
            this.setValue("fuelEconomy", fuelEcon);
            this.setValue("fuelEconomyType", fuelEconType);
            this.setValue("drivingElapse", driveElapse);
            this.setValue("idleElapse", idleElapse);
        }
    }

    private static class BlankRow
    extends FieldData {
        public BlankRow() {
            this.setCssClass("rptBodyRowTotal");
            this.setValue("address", "");
        }
    }
}

