/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.Iterator;
import java.util.Vector;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.util.ColorTools;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.ColumnValue;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class GeozoneReport
extends ReportData
implements DBRecordHandler<EventData> {
    private static final String PROP_geozoneType = "geozoneType";
    private static final String PROP_totalByGeozone = "totalByGeozone";
    private static final String PROP_estimateDepartTime = "estimateDepartTime";
    private static final String ZONETYPE_GEOZONE = "geozone";
    private static final String ZONETYPE_JOB = "job";
    private boolean totalsByGeozone = false;
    private int[] zoneCodes = null;
    private String zoneType = "geozone";
    private boolean isGeozoneType = true;
    private I18N i18n = null;
    private String unknownText = null;
    private EventData firstEvent = null;
    private long arriveTime = 0L;
    private EventData arriveEvent = null;
    private long lastDepartTime = 0L;
    private boolean estimateDepartTime = false;
    private GeozoneDetail lastGeozoneDetail = null;
    private Vector<FieldData> rowData = null;

    public GeozoneReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        this.i18n = reqState.getPrivateLabel().getI18N(GeozoneReport.class);
        this.unknownText = this.i18n.getString("GeozoneReport.unknownZone", "(unknown)");
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        if (this.getDeviceCount() <= 0) {
            throw new ReportException("No Devices specified");
        }
    }

    @Override
    public boolean isSingleDeviceOnly() {
        return true;
    }

    @Override
    public void postInitialize() {
        this.estimateDepartTime = this.getProperties().getBoolean(PROP_estimateDepartTime, false);
        this.totalsByGeozone = this.getProperties().getBoolean(PROP_totalByGeozone, false);
        this.zoneType = this.getProperties().getString(PROP_geozoneType, ZONETYPE_GEOZONE);
        this.isGeozoneType = !this.zoneType.equalsIgnoreCase(ZONETYPE_JOB);
        this.zoneCodes = this.isGeozoneType ? new int[]{61968, 62000} : new int[]{61973, 62005};
    }

    @Override
    protected EventData[] getEventData(Device device, DBRecordHandler<EventData> rcdHandler) {
        if (device == null) {
            return EventData.EMPTY_ARRAY;
        }
        ReportConstraints rc = this.getReportConstraints();
        rc.setStatusCodes(this.zoneCodes);
        rc.setValidGPSRequired(false);
        return super.getEventData(device, rcdHandler);
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return false;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return GeozoneReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.firstEvent = null;
        this.arriveTime = 0L;
        this.arriveEvent = null;
        this.lastDepartTime = 0L;
        this.lastGeozoneDetail = null;
        this.rowData = new Vector();
        String accountID = this.getAccountID();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                Device device = devList.getDevice(devID);
                this.getEventData(device, this);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData for Device: " + devID), (Object[])new Object[0]);
            }
        }
        if (this.arriveEvent != null) {
            GeozoneDetail gzd = new GeozoneDetail(this.arriveTime, this.arriveEvent, null, this.i18n);
            this.rowData.add(gzd);
            this.lastDepartTime = 0L;
            this.arriveEvent = null;
            this.arriveTime = 0L;
        }
        if (this.rowData.size() > 0 && this.firstEvent != null && this.firstEvent.getStatusCode() == this.zoneCodes[1]) {
            Print.logInfo((String)"First event was a departure, searching for prior arrival ...", (Object[])new Object[0]);
            try {
                EventData arrEv = this.firstEvent.getPreviousEventData(new int[]{this.zoneCodes[0]}, false);
                if (arrEv != null) {
                    Print.logInfo((String)"... Found prior arrival.", (Object[])new Object[0]);
                    GeozoneDetail gzd = (GeozoneDetail)this.rowData.get(0);
                    gzd.fixupArrivalEvent(arrEv);
                } else {
                    Print.logInfo((String)"... Prior arrival not found!", (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Error retreiving EventData record", (Throwable)dbe);
            }
        }
        if (this.totalsByGeozone) {
            ListTools.sort(this.rowData, null);
            String lastZoneTypeID = null;
            boolean stillInZone = false;
            long totalDwellElapsedSec = 0L;
            long totalDriveElapsedSec = 0L;
            long totalVisitCount = 0L;
            for (int i2 = 0; i2 < this.rowData.size(); ++i2) {
                GeozoneDetail gzd = (GeozoneDetail)this.rowData.get(i2);
                if (lastZoneTypeID == null) {
                    lastZoneTypeID = gzd.getZoneTypeID();
                    stillInZone = false;
                    totalDwellElapsedSec = 0L;
                    totalDriveElapsedSec = 0L;
                    totalVisitCount = 0L;
                } else if (!lastZoneTypeID.equals(gzd.getZoneTypeID())) {
                    GeozoneTotal gzt = new GeozoneTotal(lastZoneTypeID, totalVisitCount, stillInZone, totalDwellElapsedSec, totalDriveElapsedSec, this.i18n);
                    this.rowData.insertElementAt(gzt, i2++);
                    lastZoneTypeID = gzd.getZoneTypeID();
                    stillInZone = false;
                    totalDwellElapsedSec = 0L;
                    totalDriveElapsedSec = 0L;
                    totalVisitCount = 0L;
                }
                stillInZone |= gzd.stillInZone();
                ++totalVisitCount;
                long insideZoneSec = gzd.getZoneElapseSec();
                if (insideZoneSec < 0L) {
                    totalDwellElapsedSec = -1L;
                } else if (totalDwellElapsedSec >= 0L && insideZoneSec >= 0L) {
                    totalDwellElapsedSec += insideZoneSec;
                }
                long outsideZoneSec = gzd.getDriveElapseSec();
                if (outsideZoneSec < 0L) {
                    totalDriveElapsedSec = -1L;
                    continue;
                }
                if (totalDriveElapsedSec < 0L || outsideZoneSec < 0L) continue;
                totalDriveElapsedSec += outsideZoneSec;
            }
            if (lastZoneTypeID != null) {
                GeozoneTotal gzt = new GeozoneTotal(lastZoneTypeID, totalVisitCount, stillInZone, totalDwellElapsedSec, totalDriveElapsedSec, this.i18n);
                this.rowData.insertElementAt(gzt, this.rowData.size());
            }
        }
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    public int handleDBRecord(EventData rcd) throws DBException {
        EventData ev = rcd;
        if (ev == null) {
            throw new DBException("EventData record is null!!");
        }
        if (this.rowData == null) {
            throw new DBException("Report has not been properly initialized! (rowData)");
        }
        if (this.zoneCodes == null) {
            throw new DBException("Report has not been properly initialized! (zoneCodes)");
        }
        int code = ev.getStatusCode();
        if (this.firstEvent == null) {
            if (code == this.zoneCodes[1]) {
                this.arriveTime = this.getTimeStart();
            } else if (code == this.zoneCodes[0]) {
                this.lastDepartTime = 0L;
            }
            this.firstEvent = ev;
        }
        if (code == this.zoneCodes[0]) {
            this.arriveEvent = ev;
            this.arriveTime = ev.getTimestamp();
            if (this.lastGeozoneDetail != null) {
                long driveElapseSec = this.lastDepartTime > 0L && this.arriveTime > this.lastDepartTime ? this.arriveTime - this.lastDepartTime : -1L;
                this.lastGeozoneDetail.setDriveElapseSec(driveElapseSec);
                this.lastGeozoneDetail = null;
            }
        } else if (code == this.zoneCodes[1]) {
            this.lastGeozoneDetail = new GeozoneDetail(this.arriveTime, this.arriveEvent, ev, this.i18n);
            this.rowData.add(this.lastGeozoneDetail);
            this.lastDepartTime = ev.getTimestamp();
            this.arriveEvent = null;
            this.arriveTime = 0L;
        }
        return (long)this.rowData.size() < this.getReportLimit() ? 1 : 0;
    }

    protected long getReportEndTime() {
        long endTime;
        long nowTime = DateTime.getCurrentTimeSec();
        return nowTime < (endTime = this.getTimeEnd()) ? nowTime : endTime;
    }

    private static ColumnValue getColumnValue(Object val) {
        if (val == null) {
            return new ColumnValue("");
        }
        if (val instanceof ColumnValue) {
            return (ColumnValue)val;
        }
        return new ColumnValue(val.toString());
    }

    private static class GeozoneTotal
    extends FieldData {
        private boolean stillInZone = false;

        public GeozoneTotal(String zoneTypeID, long totalVisitCount, boolean stillInZone, long totalDwellElapsed, long totalDriveElapsed, I18N i18n) {
            this.stillInZone = stillInZone;
            this.setCssClass("rptBodyRowTotal");
            String totalText = stillInZone ? i18n.getString("GeozoneReport.stillInZone", "Still in Geozone") : i18n.getString("GeozoneReport.timeInZone", "Total Time in Geozone");
            this.setValue("geozoneId", zoneTypeID);
            this.setValue("address", totalText);
            this.setValue("elapseSec", totalDwellElapsed);
            this.setValue("insideElapse", totalDwellElapsed);
            this.setValue("drivingElapse", totalDriveElapsed);
            this.setValue("outsideElapse", totalDriveElapsed);
            this.setValue("count", totalVisitCount);
        }

        @Override
        public Object filterReturnedValue(String key, Object rtnVal) {
            if (key == null) {
                return rtnVal;
            }
            if (rtnVal == null) {
                return "";
            }
            if (key.equals("elapseSec") || key.equals("insideElapse")) {
                if (this.stillInZone) {
                    return GeozoneReport.getColumnValue(rtnVal).setForegroundColor(ColorTools.DARK_YELLOW);
                }
                return rtnVal;
            }
            return rtnVal;
        }
    }

    private class GeozoneDetail
    extends FieldData {
        private boolean arriveApprox = false;
        private long arriveTime = 0L;
        private double arriveOdomKM = 0.0;
        private double arriveFuelTot = 0.0;
        private boolean departApprox = false;
        private long departTime = 0L;
        private double departOdomKM = 0.0;
        private double departFuelTot = 0.0;
        private String geozoneID = null;
        private GeoPoint geozoneGPS = null;
        private String geozoneAddr = null;
        private String corridorID = null;
        private long zoneElapseSec = -1L;
        private long driveElapseSec = -1L;
        private double zoneFuelDelta = -1.0;
        private double zoneOdomDelta = -1.0;

        public GeozoneDetail(long arrTime, EventData arrEv, EventData depEv, I18N i18n) {
            EventData ev = arrEv != null ? arrEv : depEv;
            this.setAccount(ev.getAccount());
            this.setDevice(ev.getDevice());
            this.geozoneID = GeozoneReport.this.isGeozoneType ? ev.getGeozoneID() : ev.getJobNumber();
            this.geozoneGPS = ev.getGeoPoint();
            this.geozoneAddr = ev.getAddress();
            this.corridorID = null;
            this.arriveApprox = arrEv == null;
            this.arriveTime = arrEv != null ? arrEv.getTimestamp() : arrTime;
            this.arriveOdomKM = arrEv != null ? arrEv.getOdometerKM() : 0.0;
            this.arriveFuelTot = arrEv != null ? arrEv.getFuelTotal() : 0.0;
            this.departApprox = depEv == null;
            this.departTime = depEv != null ? depEv.getTimestamp() : GeozoneReport.this.getReportEndTime();
            this.departOdomKM = depEv != null ? depEv.getOdometerKM() : 0.0;
            this.departFuelTot = depEv != null ? depEv.getFuelTotal() : 0.0;
            this.zoneElapseSec = this.departTime > 0L && this.arriveTime > 0L ? this.departTime - this.arriveTime : -1L;
            this.zoneFuelDelta = this.departFuelTot > 0.0 && this.arriveFuelTot > 0.0 ? this.departFuelTot - this.arriveFuelTot : -1.0;
            this.zoneOdomDelta = this.departOdomKM > 0.0 && this.arriveOdomKM > 0.0 ? this.departOdomKM - this.arriveOdomKM : -1.0;
            this.setValue("geozoneId", this.geozoneID);
            this.setValue("geoPoint", this.geozoneGPS);
            this.setValue("address", this.geozoneAddr);
            this.setValue("corridorID", this.corridorID);
            this.setValue("enterGeozoneId", this.geozoneID);
            this.setValue("enterTimestamp", this.arriveTime);
            this.setValue("startFuel", this.arriveFuelTot);
            this.setValue("startOdometer", this.arriveOdomKM);
            this.setValue("exitGeozoneId", this.geozoneID);
            this.setValue("exitTimestamp", !this.departApprox || GeozoneReport.this.estimateDepartTime ? this.departTime : 0L);
            this.setValue("stopFuel", this.departFuelTot);
            this.setValue("stopOdometer", this.departOdomKM);
            this.setValue("elapseSec", this.zoneElapseSec);
            this.setValue("insideElapse", this.zoneElapseSec);
            this.setValue("fuelDelta", this.zoneFuelDelta);
            this.setValue("odomDelta", this.zoneOdomDelta);
            this.setValue("count", -1L);
        }

        public String getGeozoneID() {
            return this.geozoneID;
        }

        public String getZoneTypeID() {
            return this.geozoneID;
        }

        public void fixupArrivalEvent(EventData arrEv) {
            if (arrEv != null) {
                this.geozoneID = arrEv.getGeozoneID();
                this.geozoneGPS = arrEv.getGeoPoint();
                this.geozoneAddr = arrEv.getAddress();
                this.arriveTime = arrEv.getTimestamp();
                this.corridorID = null;
                this.zoneElapseSec = this.departTime > 0L && this.arriveTime > 0L ? this.departTime - this.arriveTime : -1L;
                this.setValue("geozoneId", this.geozoneID);
                this.setValue("enterGeozoneId", this.geozoneID);
                this.setValue("enterTimestamp", this.arriveTime);
                this.setValue("geoPoint", this.geozoneGPS);
                this.setValue("address", this.geozoneAddr);
                this.setValue("corridorID", this.corridorID);
                this.setValue("elapseSec", this.zoneElapseSec);
                this.setValue("insideElapse", this.zoneElapseSec);
            }
        }

        public void setDriveElapseSec(long elapseSec) {
            this.driveElapseSec = elapseSec;
            this.setValue("drivingElapse", this.driveElapseSec);
            this.setValue("outsideElapse", this.driveElapseSec);
        }

        public long getDriveElapseSec() {
            return this.driveElapseSec;
        }

        public long getZoneElapseSec() {
            return this.zoneElapseSec;
        }

        public String toString() {
            return this.getZoneTypeID();
        }

        public boolean stillInZone() {
            return this.departApprox;
        }

        @Override
        public Object filterReturnedValue(String key, Object rtnVal) {
            if (rtnVal == null) {
                return "";
            }
            if (key == null) {
                return rtnVal;
            }
            if (key.equals("geozoneId")) {
                if (StringTools.isBlank((String)rtnVal.toString())) {
                    return GeozoneReport.getColumnValue(rtnVal).setValue(GeozoneReport.this.unknownText);
                }
                return rtnVal;
            }
            if (key.equals("enterTimestamp") || key.equals("enterDateTime")) {
                if (this.arriveApprox) {
                    return GeozoneReport.getColumnValue(rtnVal).setForegroundColor(ColorTools.DARK_YELLOW);
                }
                return rtnVal;
            }
            if (key.equals("elapseSec") || key.equals("insideElapse")) {
                if (this.departApprox) {
                    return GeozoneReport.getColumnValue(rtnVal).setForegroundColor(ColorTools.DARK_YELLOW);
                }
                return rtnVal;
            }
            if (key.equals("exitTimestamp") || key.equals("exitDateTime")) {
                if (this.departApprox) {
                    return GeozoneReport.getColumnValue(rtnVal).setForegroundColor(ColorTools.DARK_YELLOW);
                }
                return rtnVal;
            }
            return rtnVal;
        }
    }
}

