/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.Iterator;
import java.util.Vector;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class GeozoneDepartReport
extends ReportData
implements DBRecordHandler<EventData> {
    private int[] zoneCodes = null;
    private I18N i18n = null;
    private String unknownText = null;
    private EventData firstEvent = null;
    private EventData departEvent = null;
    private EventData arriveEvent = null;
    private DrivingDetail lastDrivingDetail = null;
    private DrivingDetail fixupDrivingDetail = null;
    private Vector<FieldData> rowData = null;

    public GeozoneDepartReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        this.i18n = reqState.getPrivateLabel().getI18N(GeozoneDepartReport.class);
        this.unknownText = this.i18n.getString("GeozoneDepartReport.unknownZone", "(unknown)");
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        if (this.getDeviceCount() <= 0) {
            throw new ReportException("No Devices specified");
        }
    }

    @Override
    public boolean isSingleDeviceOnly() {
        return true;
    }

    @Override
    public void postInitialize() {
        this.zoneCodes = new int[]{62000, 61968};
    }

    @Override
    protected EventData[] getEventData(Device device, DBRecordHandler<EventData> rcdHandler) {
        if (device == null) {
            return EventData.EMPTY_ARRAY;
        }
        ReportConstraints rc = this.getReportConstraints();
        rc.setStatusCodes(this.zoneCodes);
        rc.setValidGPSRequired(false);
        return super.getEventData(device, rcdHandler);
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return false;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return GeozoneDepartReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.firstEvent = null;
        this.departEvent = null;
        this.arriveEvent = null;
        this.lastDrivingDetail = null;
        this.fixupDrivingDetail = null;
        this.rowData = new Vector();
        String accountID = this.getAccountID();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                Device device = devList.getDevice(devID);
                this.getEventData(device, this);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData for Device: " + devID), (Object[])new Object[0]);
            }
        }
        if (this.fixupDrivingDetail != null && this.fixupDrivingDetail.hasArriveEvent() && !this.fixupDrivingDetail.hasDepartEvent()) {
            Print.logInfo((String)"First event was an arrival, searching for prior departure ...", (Object[])new Object[0]);
            EventData arrEv = this.fixupDrivingDetail.getArriveEvent();
            try {
                EventData depEv = arrEv.getPreviousEventData(new int[]{this.zoneCodes[0]}, false);
                if (depEv != null) {
                    Print.logInfo((String)"... Found prior departure.", (Object[])new Object[0]);
                    this.fixupDrivingDetail.setDepartEvent(depEv);
                } else {
                    Print.logInfo((String)"... Prior departure not found!", (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logException((String)"Error retreiving EventData record", (Throwable)dbe);
            }
        }
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    public int handleDBRecord(EventData rcd) throws DBException {
        EventData ev = rcd;
        int code = ev.getStatusCode();
        if (this.firstEvent == null) {
            this.firstEvent = ev;
        }
        if (code == this.zoneCodes[0]) {
            this.departEvent = ev;
            this.lastDrivingDetail = new DrivingDetail(ev.getDevice());
            this.lastDrivingDetail.setDepartEvent(this.departEvent);
            this.rowData.add(this.lastDrivingDetail);
        } else if (code == this.zoneCodes[1]) {
            this.arriveEvent = ev;
            if (this.lastDrivingDetail != null) {
                this.lastDrivingDetail.setArriveEvent(this.arriveEvent);
            } else {
                Print.logWarn((String)"Found 'Arrive' without previous 'Depart'", (Object[])new Object[0]);
                if (this.rowData.size() == 0) {
                    this.fixupDrivingDetail = new DrivingDetail(ev.getDevice());
                    this.fixupDrivingDetail.setArriveEvent(this.arriveEvent);
                    this.rowData.add(this.fixupDrivingDetail);
                }
            }
            this.lastDrivingDetail = null;
        }
        return (long)this.rowData.size() < this.getReportLimit() ? 1 : 0;
    }

    protected long getReportEndTime() {
        long endTime;
        long nowTime = DateTime.getCurrentTimeSec();
        return nowTime < (endTime = this.getTimeEnd()) ? nowTime : endTime;
    }

    private class DrivingDetail
    extends FieldData {
        private EventData departEvent = null;
        private EventData arriveEvent = null;

        public DrivingDetail(Device device) {
            this.setAccount(device.getAccount());
            this.setDevice(device);
        }

        public boolean hasDepartEvent() {
            return this.departEvent != null;
        }

        public void setDepartEvent(EventData ev) {
            if (ev != null) {
                this.departEvent = ev;
                this.setValue("exitGeozoneId", this.departEvent.getGeozoneID());
                this.setValue("exitTimestamp", this.departEvent.getTimestamp());
                this.setValue("driverId", this.departEvent.getDriverID());
            } else {
                this.departEvent = null;
                this.setValue("exitGeozoneId", "?");
                this.setValue("exitTimestamp", 0L);
                this.setValue("driverId", "?");
            }
            this.setDrivingElapsedTime();
        }

        public EventData getDepartEvent() {
            return this.departEvent;
        }

        public boolean hasArriveEvent() {
            return this.arriveEvent != null;
        }

        public void setArriveEvent(EventData ev) {
            if (ev != null) {
                this.arriveEvent = ev;
                this.setValue("enterGeozoneId", this.arriveEvent.getGeozoneID());
                this.setValue("enterTimestamp", this.arriveEvent.getTimestamp());
            } else {
                this.arriveEvent = null;
                this.setValue("enterGeozoneId", "?");
                this.setValue("enterTimestamp", 0L);
            }
            this.setDrivingElapsedTime();
        }

        public EventData getArriveEvent() {
            return this.arriveEvent;
        }

        public void setDrivingElapsedTime() {
            if (this.departEvent != null && this.arriveEvent != null) {
                long drivingSec = this.arriveEvent.getTimestamp() - this.departEvent.getTimestamp();
                this.setValue("drivingElapse", drivingSec);
                this.setValue("outsideElapse", drivingSec);
                double drivingDistKM = this.arriveEvent.getOdometerKM() - this.departEvent.getOdometerKM();
                this.setValue("odomDelta", drivingDistKM);
            } else {
                this.setValue("drivingElapse", 0L);
                this.setValue("outsideElapse", 0L);
                this.setValue("odomDelta", 0.0);
            }
        }

        public String toString() {
            return "";
        }

        public Object filterReturnedValue(String key, String rtnVal) {
            if (key == null) {
                return rtnVal;
            }
            if (key.equals("geozoneId")) {
                return StringTools.isBlank((String)rtnVal) ? GeozoneDepartReport.this.unknownText : rtnVal;
            }
            if (key.equals("enterTimestamp") || key.equals("enterDateTime")) {
                return rtnVal;
            }
            if (key.equals("exitTimestamp") || key.equals("exitDateTime")) {
                return rtnVal;
            }
            return rtnVal;
        }
    }
}

