/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class FuelSummaryReport
extends ReportData {
    private static final String PROP_tripStartType = "tripStartType";
    private static final String PROP_minimumSpeedKPH = "minimumSpeedKPH";
    private static final String PROP_minimumStoppedTime = "minimumStoppedTime";
    private static final String PROP_stopOnIgnitionOff = "stopOnIgnitionOff";
    private static final String PROP_countNumberOfStops = "countNumberOfStops";
    private static final String[] MOTION_DEFAULT = new String[]{"default"};
    private static final String[] MOTION_SPEED = new String[]{"speed", "motion"};
    private static final String[] MOTION_IGNITION = new String[]{"ignition"};
    private static final String[] MOTION_ENGINE = new String[]{"engine"};
    private static final String[] MOTION_STARTSTOP = new String[]{"start", "startstop"};
    private static final int TRIP_ON_SPEED = 0;
    private static final int TRIP_ON_IGNITION = 1;
    private static final int TRIP_ON_ENGINE = 2;
    private static final int TRIP_ON_START = 3;
    private static final double MIN_SPEED_KPH = 5.0;
    private static final long MIN_STOPPED_TIME_SEC = DateTime.MinuteSeconds((long)5L);
    private static final boolean STOP_ON_IGNITION_OFF = false;
    private static final boolean COUNT_NUMBER_OF_STOPS = false;
    private List<FieldData> rowData = null;
    private List<FieldData> totData = null;
    private double minSpeedKPH = 5.0;
    private long minStoppedTimeSec = MIN_STOPPED_TIME_SEC;
    private boolean stopOnIgnitionOff = false;
    private boolean countNumberOfStops = false;
    private long lookAheadSeconds = 0L;
    private int deviceCount = 0;
    private boolean startStopSupported = false;
    private int[] ignitionCodes = null;
    private int tripStartType = 0;
    private boolean speedIsMoving = false;
    private long lastMovingTime = 0L;
    private long lastStoppedTime = 0L;
    private EventData tripStartEvent = null;
    private EventData tripStopEvent = null;
    private int tripStopCount = 0;
    private double totEngineHours = 0.0;
    private double totFuelTotal = 0.0;
    private double totFuelLevel = 0.0;
    private double totFuelRemain = 0.0;
    private double totFuelEconomy = 0.0;
    private double totIdleHours = 0.0;
    private double totFuelIdle = 0.0;
    private double totWorkHours = 0.0;
    private double totFuelWork = 0.0;
    private double totPTOHours = 0.0;
    private double totFuelPTO = 0.0;
    private double totOdometerKM = 0.0;
    private int totStopCount = 0;

    public FuelSummaryReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
    }

    @Override
    public void postInitialize() {
        RTProperties tripRTP = this.getProperties();
        this.tripStartType = 1;
        this.minSpeedKPH = tripRTP.getDouble(PROP_minimumSpeedKPH, 5.0);
        this.minStoppedTimeSec = tripRTP.getLong(PROP_minimumStoppedTime, MIN_STOPPED_TIME_SEC);
        this.stopOnIgnitionOff = tripRTP.getBoolean(PROP_stopOnIgnitionOff, false);
        this.countNumberOfStops = tripRTP.getBoolean(PROP_countNumberOfStops, false);
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return FuelSummaryReport.GetReportLayout();
    }

    private EventData getLookAheadEventData(int ofs) {
        return null;
    }

    private boolean isTripStart(EventData ev) {
        if (this.tripStartType == 1) {
            int sc = ev.getStatusCode();
            if (sc == 62465) {
                return true;
            }
            if (this.ignitionCodes != null && sc == this.ignitionCodes[1]) {
                return true;
            }
        } else if (this.tripStartType == 2) {
            int sc = ev.getStatusCode();
            if (sc == 62476) {
                return true;
            }
        } else if (this.tripStartType == 3) {
            int sc = ev.getStatusCode();
            if (sc == 61713) {
                return true;
            }
        } else if (this.tripStartType == 0 && ev.getSpeedKPH() >= this.minSpeedKPH) {
            this.lastStoppedTime = 0L;
            if (!this.speedIsMoving) {
                this.speedIsMoving = true;
                this.lastMovingTime = ev.getTimestamp();
                return true;
            }
        }
        return false;
    }

    private boolean isTripStop(EventData ev) {
        if (this.tripStartType == 1) {
            int sc = ev.getStatusCode();
            if (sc == 62467) {
                return true;
            }
            if (this.ignitionCodes != null && sc == this.ignitionCodes[0]) {
                return true;
            }
        } else if (this.tripStartType == 2) {
            int sc = ev.getStatusCode();
            if (sc == 62477) {
                return true;
            }
        } else if (this.tripStartType == 3) {
            int sc = ev.getStatusCode();
            if (sc == 61715) {
                return true;
            }
            if (sc == 62467) {
                return true;
            }
            if (this.stopOnIgnitionOff && this.ignitionCodes != null && sc == this.ignitionCodes[0]) {
                return true;
            }
        } else if (this.tripStartType == 0 && this.speedIsMoving) {
            long deltaSec;
            EventData nextEV;
            int sc = ev.getStatusCode();
            if (this.stopOnIgnitionOff && this.ignitionCodes != null && sc == this.ignitionCodes[0]) {
                this.speedIsMoving = false;
                this.lastMovingTime = 0L;
                this.lastStoppedTime = 0L;
                return true;
            }
            if (ev.getSpeedKPH() < this.minSpeedKPH) {
                if (this.lastStoppedTime == 0L) {
                    this.lastStoppedTime = ev.getTimestamp();
                } else {
                    long stoppedDeltaSec = ev.getTimestamp() - this.lastStoppedTime;
                    if (stoppedDeltaSec >= this.minStoppedTimeSec) {
                        this.speedIsMoving = false;
                        this.lastMovingTime = 0L;
                        this.lastStoppedTime = 0L;
                        return true;
                    }
                }
            } else if (this.lookAheadSeconds > 0L && (nextEV = this.getLookAheadEventData(1)) != null && (deltaSec = nextEV.getTimestamp() - ev.getTimestamp()) >= this.lookAheadSeconds) {
                this.speedIsMoving = false;
                this.lastMovingTime = 0L;
                this.lastStoppedTime = 0L;
                return true;
            }
        }
        return false;
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        this.deviceCount = 0;
        this.totEngineHours = 0.0;
        this.totFuelTotal = 0.0;
        this.totFuelLevel = 0.0;
        this.totFuelRemain = 0.0;
        this.totFuelEconomy = 0.0;
        this.totIdleHours = 0.0;
        this.totFuelIdle = 0.0;
        this.totWorkHours = 0.0;
        this.totFuelWork = 0.0;
        this.totPTOHours = 0.0;
        this.totFuelPTO = 0.0;
        this.totOdometerKM = 0.0;
        this.totStopCount = 0;
        long startTime = this.getTimeStart();
        long endTime = this.getTimeEnd();
        long selLimit = this.getSelectionLimit();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                Device device = devList.getDevice(devID);
                if (device == null) {
                    Print.logError((String)("Returned DeviceList 'Device' is null: " + devID), (Object[])new Object[0]);
                    continue;
                }
                String accountID = device.getAccountID();
                String deviceID = device.getDeviceID();
                this.startStopSupported = device.getStartStopSupported();
                if (!this.startStopSupported) {
                    // empty if block
                }
                this.ignitionCodes = device.getIgnitionStatusCodes();
                boolean hasIgnition = this.ignitionCodes != null;
                this.speedIsMoving = false;
                this.lastMovingTime = 0L;
                this.lastStoppedTime = 0L;
                this.tripStartType = 1;
                String tt = this.getProperties().getString(PROP_tripStartType, MOTION_IGNITION[0]).toLowerCase();
                if (ListTools.contains((Object[])MOTION_DEFAULT, (Object)tt)) {
                    String devCode = device.getDeviceCode();
                    DCServerConfig dcs = DCServerFactory.getServerConfig((String)devCode);
                    if (dcs == null && StringTools.isBlank((String)devCode) && Account.IsDemoAccount((String)accountID) && (dcs = DCServerFactory.getServerConfig((String)"gtsdmtp")) == null) {
                        Print.logWarn((String)"Account 'demo' DCServerConfig not found: gtsdmtp", (Object[])new Object[0]);
                    }
                    this.tripStartType = dcs != null ? (dcs.getStartStopSupported(false) ? 3 : (hasIgnition ? 1 : 0)) : (hasIgnition ? 1 : 0);
                } else if (ListTools.contains((Object[])MOTION_STARTSTOP, (Object)tt)) {
                    this.tripStartType = 3;
                } else if (ListTools.contains((Object[])MOTION_IGNITION, (Object)tt)) {
                    this.tripStartType = 1;
                    if (!hasIgnition) {
                        this.ignitionCodes = new int[]{62467, 62465};
                        hasIgnition = true;
                    }
                } else {
                    this.tripStartType = ListTools.contains((Object[])MOTION_ENGINE, (Object)tt) ? 2 : 0;
                }
                this.tripStartEvent = null;
                this.tripStopEvent = null;
                this.tripStopCount = 0;
                double strEngineHours = 0.0;
                double strFuelTotal = 0.0;
                double strFuelLevel = 0.0;
                double strFuelRemain = 0.0;
                double strIdleHours = 0.0;
                double strFuelIdle = 0.0;
                double strPTOHours = 0.0;
                double strFuelPTO = 0.0;
                double strOdometerKM = 0.0;
                try {
                    long limit = this.countNumberOfStops ? selLimit : 50L;
                    Object[] eda = EventData.getRangeEvents((String)accountID, (String)deviceID, (long)this.getTimeStart(), (long)this.getTimeEnd(), null, (boolean)false, (EventData.LimitType)EventData.LimitType.FIRST, (long)limit, (boolean)true, null, null);
                    if (!ListTools.isEmpty((Object[])eda)) {
                        for (Object ed : eda) {
                            boolean tripStop;
                            if (strEngineHours <= 0.0) {
                                strEngineHours = ed.getEngineHours();
                            }
                            if (strFuelTotal <= 0.0) {
                                strFuelTotal = ed.getFuelTotal();
                            }
                            if (strFuelLevel <= 0.0) {
                                strFuelLevel = ed.getFuelLevel(true);
                            }
                            if (strFuelRemain <= 0.0) {
                                strFuelRemain = ed.getFuelRemain(true);
                            }
                            if (strIdleHours <= 0.0) {
                                strIdleHours = ed.getIdleHours();
                            }
                            if (strFuelIdle <= 0.0) {
                                strFuelIdle = ed.getFuelIdle();
                            }
                            if (strPTOHours <= 0.0) {
                                strPTOHours = ed.getPtoHours();
                            }
                            if (strFuelPTO <= 0.0) {
                                strFuelPTO = ed.getFuelPTO();
                            }
                            if (strOdometerKM <= 0.0) {
                                strOdometerKM = ed.getOdometerKM();
                            }
                            if (!this.countNumberOfStops) continue;
                            boolean tripStart = this.isTripStart((EventData)ed);
                            if (tripStart) {
                                this.tripStartEvent = ed;
                            }
                            boolean bl = tripStop = tripStart ? false : this.isTripStop((EventData)ed);
                            if (!tripStop) continue;
                            this.tripStopEvent = ed;
                            ++this.tripStopCount;
                        }
                    }
                }
                catch (DBException dbe) {
                    Print.logException((String)"Unable to obtain EventData records", (Throwable)dbe);
                }
                double endEngineHours = 0.0;
                double endFuelTotal = 0.0;
                double endFuelLevel = 0.0;
                double endFuelRemain = 0.0;
                double endIdleHours = 0.0;
                double endFuelIdle = 0.0;
                double endPTOHours = 0.0;
                double endFuelPTO = 0.0;
                double endOdometerKM = 0.0;
                try {
                    long limit = 50L;
                    Object[] eda = EventData.getRangeEvents((String)accountID, (String)deviceID, (long)this.getTimeStart(), (long)this.getTimeEnd(), null, (boolean)false, (EventData.LimitType)EventData.LimitType.LAST, (long)limit, (boolean)false, null, null);
                    if (!ListTools.isEmpty((Object[])eda)) {
                        for (Object ed : eda) {
                            if (endEngineHours <= 0.0) {
                                endEngineHours = ed.getEngineHours();
                            }
                            if (endFuelTotal <= 0.0) {
                                endFuelTotal = ed.getFuelTotal();
                            }
                            if (endFuelLevel <= 0.0) {
                                endFuelLevel = ed.getFuelLevel(true);
                            }
                            if (endFuelRemain <= 0.0) {
                                endFuelRemain = ed.getFuelRemain(true);
                            }
                            if (endIdleHours <= 0.0) {
                                endIdleHours = ed.getIdleHours();
                            }
                            if (endFuelIdle <= 0.0) {
                                endFuelIdle = ed.getFuelIdle();
                            }
                            if (endPTOHours <= 0.0) {
                                endPTOHours = ed.getPtoHours();
                            }
                            if (endFuelPTO <= 0.0) {
                                endFuelPTO = ed.getFuelPTO();
                            }
                            if (!(endOdometerKM <= 0.0)) continue;
                            endOdometerKM = ed.getOdometerKM();
                        }
                    }
                }
                catch (DBException dbe) {
                    Print.logException((String)"Unable to obtain EventData records", (Throwable)dbe);
                }
                double useEngineHours = endEngineHours > strEngineHours ? endEngineHours - strEngineHours : 0.0;
                double useFuelTotal = endFuelTotal > strFuelTotal ? endFuelTotal - strFuelTotal : 0.0;
                double useFuelLevel = endFuelLevel < strFuelLevel ? endFuelLevel - strFuelLevel : 0.0;
                double useFuelRemain = endFuelRemain < strFuelRemain ? endFuelRemain - strFuelRemain : 0.0;
                double useFuelEconomy = 0.0;
                double useIdleHours = endIdleHours > strIdleHours ? endIdleHours - strIdleHours : 0.0;
                double useFuelIdle = endFuelIdle > strFuelIdle ? endFuelIdle - strFuelIdle : 0.0;
                double usePTOHours = endPTOHours > strPTOHours ? endPTOHours - strPTOHours : 0.0;
                double useFuelPTO = endFuelPTO > strFuelPTO ? endFuelPTO - strFuelPTO : 0.0;
                double useOdometerKM = endOdometerKM > strOdometerKM ? endOdometerKM - strOdometerKM : 0.0;
                double useWorkHours = useEngineHours - useIdleHours;
                double useFuelWork = useFuelTotal - useFuelIdle;
                int useNumStops = this.tripStopCount;
                double useAvgStopIdle = useNumStops > 0 ? useIdleHours / (double)useNumStops : 0.0;
                Device.FuelEconomyType fuelEconType = Device.FuelEconomyType.UNKNOWN;
                if (useFuelTotal > 0.0) {
                    useFuelEconomy = useOdometerKM / useFuelTotal;
                    fuelEconType = Device.FuelEconomyType.FUEL_CONSUMED;
                } else if (useFuelRemain < 0.0) {
                    double fuelDelta = -useFuelRemain;
                    useFuelEconomy = fuelDelta > 0.0 ? useOdometerKM / fuelDelta : 0.0;
                    fuelEconType = Device.FuelEconomyType.FUEL_REMAINING;
                } else if (useFuelLevel < 0.0 && device.getFuelCapacity() > 0.0) {
                    double fuelDelta = -useFuelLevel * device.getFuelCapacity();
                    useFuelEconomy = fuelDelta > 0.0 ? useOdometerKM / fuelDelta : 0.0;
                    fuelEconType = Device.FuelEconomyType.FUEL_LEVEL;
                } else {
                    useFuelEconomy = useOdometerKM > 0.0 ? device.getFuelEconomy() : 0.0;
                    fuelEconType = Device.FuelEconomyType.DEVICE_ECONOMY;
                }
                FieldData fd = new FieldData();
                fd.setDevice(device);
                fd.setDouble("engineHours", useEngineHours);
                fd.setDouble("fuelTotal", useFuelTotal);
                fd.setDouble("fuelLevel", useFuelLevel);
                fd.setDouble("fuelRemain", useFuelRemain);
                fd.setDouble("fuelEconomy", useFuelEconomy);
                fd.setValue("fuelEconomyType", fuelEconType);
                fd.setDouble("idleHours", useIdleHours);
                fd.setDouble("fuelIdle", useFuelIdle);
                fd.setDouble("workHours", useWorkHours);
                fd.setDouble("fuelWork", useFuelWork);
                fd.setDouble("ptoHours", usePTOHours);
                fd.setDouble("fuelPTO", useFuelPTO);
                fd.setDouble("odomDelta", useOdometerKM);
                fd.setInt("stopCount", useNumStops);
                fd.setDouble("avgIdleHours", useAvgStopIdle);
                this.rowData.add(fd);
                ++this.deviceCount;
                this.totEngineHours += useEngineHours;
                this.totFuelTotal += useFuelTotal;
                this.totFuelLevel += useFuelLevel;
                this.totFuelRemain += useFuelRemain;
                this.totFuelEconomy += useFuelEconomy;
                this.totIdleHours += useIdleHours;
                this.totFuelIdle += useFuelIdle;
                this.totWorkHours += useWorkHours;
                this.totFuelWork += useFuelWork;
                this.totPTOHours += usePTOHours;
                this.totFuelPTO += useFuelPTO;
                this.totOdometerKM += useOdometerKM;
                this.totStopCount += useNumStops;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error generating report for Device: " + devID), (Object[])new Object[0]);
            }
        }
        FieldData.sortByDeviceDescription(this.rowData);
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        if (this.deviceCount <= 0) {
            return null;
        }
        this.totData = new Vector<FieldData>();
        Object[] devTitles = this.getRequestProperties().getDeviceTitles();
        I18N i18n = this.getPrivateLabel().getI18N(FuelSummaryReport.class);
        FieldData fdTot = new FieldData();
        fdTot.setRowType(DBDataRow.RowType.TOTAL);
        fdTot.setString("deviceDesc", i18n.getString("FuelSummaryReport.total", "Total", devTitles));
        fdTot.setDouble("engineHours", this.totEngineHours);
        fdTot.setDouble("fuelTotal", this.totFuelTotal);
        fdTot.setDouble("idleHours", this.totIdleHours);
        fdTot.setDouble("fuelIdle", this.totFuelIdle);
        fdTot.setDouble("workHours", this.totWorkHours);
        fdTot.setDouble("fuelWork", this.totFuelWork);
        fdTot.setDouble("ptoHours", this.totPTOHours);
        fdTot.setDouble("fuelPTO", this.totFuelPTO);
        fdTot.setDouble("odomDelta", this.totOdometerKM);
        fdTot.setInt("stopCount", this.totStopCount);
        this.totData.add(fdTot);
        double avgEngineHours = this.totEngineHours / (double)this.deviceCount;
        double avgFuelTotal = this.totFuelTotal / (double)this.deviceCount;
        double avgFuelLevel = this.totFuelLevel / (double)this.deviceCount;
        double avgFuelRemain = this.totFuelRemain / (double)this.deviceCount;
        double avgFuelEconomy = this.totFuelEconomy / (double)this.deviceCount;
        double avgIdleHours = this.totIdleHours / (double)this.deviceCount;
        double avgFuelIdle = this.totFuelIdle / (double)this.deviceCount;
        double avgWorkHours = this.totWorkHours / (double)this.deviceCount;
        double avgFuelWork = this.totFuelWork / (double)this.deviceCount;
        double avgPTOHours = this.totPTOHours / (double)this.deviceCount;
        double avgFuelPTO = this.totFuelPTO / (double)this.deviceCount;
        double avgOdometerKM = this.totOdometerKM / (double)this.deviceCount;
        double avgStopCount = (double)this.totStopCount / (double)this.deviceCount;
        FieldData fdAvg = new FieldData();
        fdAvg.setRowType(DBDataRow.RowType.TOTAL);
        fdAvg.setString("deviceDesc", i18n.getString("FuelSummaryReport.average", "Average/{0}", devTitles));
        fdAvg.setDouble("engineHours", avgEngineHours);
        fdAvg.setDouble("fuelTotal", avgFuelTotal);
        fdAvg.setDouble("fuelLevel", avgFuelLevel);
        fdAvg.setDouble("fuelRemain", avgFuelRemain);
        fdAvg.setDouble("fuelEconomy", avgFuelEconomy);
        fdAvg.setDouble("idleHours", avgIdleHours);
        fdAvg.setDouble("fuelIdle", avgFuelIdle);
        fdAvg.setDouble("workHours", avgWorkHours);
        fdAvg.setDouble("fuelWork", avgFuelWork);
        fdAvg.setDouble("ptoHours", avgPTOHours);
        fdAvg.setDouble("fuelPTO", avgFuelPTO);
        fdAvg.setDouble("odomDelta", avgOdometerKM);
        fdAvg.setDouble("stopCount", avgStopCount);
        this.totData.add(fdAvg);
        return new ReportData.ListDataIterator(this, this.totData);
    }
}

