/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class DriverReport
extends ReportData
implements DBRecordHandler<Driver> {
    private static final String PROP_licenseWillExpireDays = "licenseWillExpireDays";
    private I18N i18n = null;
    private long licenseWillExpireDays = -1L;

    public DriverReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        this.i18n = reqState.getPrivateLabel().getI18N(DriverReport.class);
    }

    @Override
    public void postInitialize() {
        RTProperties rtp = this.getProperties();
        this.licenseWillExpireDays = rtp.getLong(PROP_licenseWillExpireDays, -1L);
    }

    protected EventData[] getEventData(Device device, DBRecordHandler rcdHandler) {
        return new EventData[0];
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return false;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return DriverReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        final Vector rowData = new Vector();
        TimeZone tz = null;
        final long currDay = DateTime.getCurrentDayNumber(tz);
        final long expOffs = this.licenseWillExpireDays;
        DBRecordHandler<Driver> rcdHandler = new DBRecordHandler<Driver>(){

            public int handleDBRecord(Driver rcd) throws DBException {
                Driver driver = rcd;
                long licExp = driver.getLicenseExpire();
                if (expOffs >= 0L) {
                    if (licExp <= 0L) {
                        return 1;
                    }
                    if (licExp > currDay + expOffs) {
                        Print.logInfo((String)("Current Day   : " + currDay), (Object[])new Object[0]);
                        Print.logInfo((String)("License Expire: " + licExp), (Object[])new Object[0]);
                        Print.logInfo((String)("Offset Days   : " + expOffs), (Object[])new Object[0]);
                        return 1;
                    }
                }
                FieldData fd = new FieldData();
                fd.setAccount(DriverReport.this.getAccount());
                fd.setDriver(driver);
                fd.setValue("driverDesc", driver.getDescription());
                fd.setValue("displayName", driver.getDisplayName());
                fd.setValue("driverNickname", driver.getDisplayName());
                fd.setValue("driverLicense", driver.getLicenseNumber());
                fd.setValue("driverLicenseType", driver.getLicenseType());
                fd.setValue("driverLicenseExp", driver.getLicenseExpire());
                fd.setValue("driverBadge", driver.getBadgeID());
                fd.setValue("address", driver.getAddress());
                fd.setValue("driverBirthdate", driver.getBirthdate());
                fd.setValue("driverDeviceID", driver.getDeviceID());
                fd.setValue("deviceId", driver.getDeviceID());
                fd.setValue("driverStatus", driver.getDriverStatus());
                rowData.add(fd);
                return 1;
            }
        };
        try {
            Driver.getRecordCallback((DBRecordHandler)rcdHandler);
        }
        catch (DBException dbe) {
            Print.logException((String)"Error", (Throwable)dbe);
        }
        return new ReportData.ListDataIterator(this, rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    public int handleDBRecord(Driver rcd) throws DBException {
        Driver drv = rcd;
        return 1;
    }
}

