/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.Iterator;
import java.util.Vector;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.EventDataProvider;
import org.opengts.db.StatusCodeProvider;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.StatusCode;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.util.ColorTools;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.ColumnValue;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.DBDataRow;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class DigitalIOReport
extends ReportData
implements DBRecordHandler<EventData> {
    private static final String PROP_digitalInputIndex = "digitalInputIndex";
    private static final String PROP_reportType = "reportType";
    private static final String REPORT_TYPE_detail = "detail";
    private static final String REPORT_TYPE_summary = "summary";
    private static final boolean FIXUP_FIRST_DIGITIAL_ON = false;
    private I18N i18n = null;
    private boolean isDetailReport = true;
    private Device device = null;
    private int statusDigital_ON = 62465;
    private int statusDigital_OFF = 62467;
    private String description = null;
    private EventData firstEvent = null;
    private EventData ioEvent_on = null;
    private EventData ioEvent_off = null;
    private Vector<FieldData> rowData = null;
    private Vector<FieldData> totalData = null;
    private boolean stillOn = false;
    private long totalElapsedSec_on = 0L;
    private double totalDistanceKM_on = 0.0;

    public DigitalIOReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        this.i18n = reqState.getPrivateLabel().getI18N(DigitalIOReport.class);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        this.isDetailReport = this.getProperties().getString(PROP_reportType, REPORT_TYPE_detail).equalsIgnoreCase(REPORT_TYPE_detail);
        if (this.getDeviceCount() <= 0) {
            throw new ReportException("No Devices specified");
        }
    }

    @Override
    public void postInitialize() {
    }

    @Override
    public boolean isSingleDeviceOnly() {
        return this.isDetailReport;
    }

    @Override
    protected EventData[] getEventData(Device device, DBRecordHandler<EventData> rcdHandler) {
        if (device == null) {
            return EventData.EMPTY_ARRAY;
        }
        ReportConstraints rc = this.getReportConstraints();
        rc.setStatusCodes(new int[]{this.statusDigital_ON, this.statusDigital_OFF});
        rc.setValidGPSRequired(false);
        return super.getEventData(device, rcdHandler);
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return true;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return DigitalIOReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = this.isDetailReport ? new Vector() : null;
        this.totalData = new Vector();
        String accountID = this.getAccountID();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                this.device = devList.getDevice(devID);
                String ioNdxStr = this.getProperties().getString(PROP_digitalInputIndex, "ignition");
                if (ioNdxStr.equalsIgnoreCase("ignition") || ioNdxStr.equalsIgnoreCase("ign")) {
                    int[] ignCodes = this.device.getIgnitionStatusCodes();
                    if (ignCodes != null) {
                        this.statusDigital_OFF = ignCodes[0];
                        this.statusDigital_ON = ignCodes[1];
                        this.description = this.i18n.getString("DigitalIOReport.ignition", "Ignition");
                    } else {
                        Print.logWarn((String)"Device does not support 'ignition' status codes", (Object[])new Object[0]);
                        this.statusDigital_OFF = 62467;
                        this.statusDigital_ON = 62465;
                        this.description = this.i18n.getString("DigitalIOReport.ignition", "Ignition");
                    }
                } else if (ioNdxStr.equalsIgnoreCase("engine") || ioNdxStr.equalsIgnoreCase("eng")) {
                    this.statusDigital_OFF = 62477;
                    this.statusDigital_ON = 62476;
                    this.description = this.i18n.getString("DigitalIOReport.engine", "Engine");
                } else {
                    int ioNdx = StringTools.parseInt((String)ioNdxStr, (int)-1);
                    int scOFF = StatusCodes.GetDigitalInputStatusCode((int)ioNdx, (boolean)false);
                    int scON = StatusCodes.GetDigitalInputStatusCode((int)ioNdx, (boolean)true);
                    if (scOFF != 0) {
                        this.statusDigital_OFF = scOFF;
                        this.statusDigital_ON = scON;
                        this.description = this.i18n.getString("DigitalIOReport.input", "Input #{0}", (Object)ioNdxStr);
                    } else {
                        Print.logWarn((String)("Invalid Digital Input Index: " + ioNdxStr), (Object[])new Object[0]);
                        this.statusDigital_OFF = 62467;
                        this.statusDigital_ON = 62465;
                        this.description = this.i18n.getString("DigitalIOReport.ignition", "Ignition");
                    }
                }
                this.firstEvent = null;
                this.ioEvent_on = null;
                this.ioEvent_off = null;
                this.stillOn = false;
                this.totalElapsedSec_on = 0L;
                this.totalDistanceKM_on = 0.0;
                this.getEventData(this.device, this);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData for Device: " + devID), (Object[])new Object[0]);
            }
            if (this.ioEvent_on != null) {
                this.createDigitalInputDetail(this.ioEvent_on, null);
                this.ioEvent_on = null;
                this.stillOn = true;
            }
            long elapsed = this.isDetailReport || this.totalElapsedSec_on > 0L ? this.totalElapsedSec_on : -1L;
            double distance = this.isDetailReport || this.totalDistanceKM_on > 0.0 ? this.totalDistanceKM_on : 0.0;
            DigitalInputTotal dit = new DigitalInputTotal(this.stillOn, elapsed, distance);
            this.totalData.add(dit);
        }
        if (this.isDetailReport) {
            return new ReportData.ListDataIterator(this, this.rowData);
        }
        return new ReportData.ListDataIterator(this, this.totalData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return this.isDetailReport ? new ReportData.ListDataIterator(this, this.totalData) : null;
    }

    public int handleDBRecord(EventData rcd) throws DBException {
        EventData ev = rcd;
        int code = ev.getStatusCode();
        if (this.firstEvent == null) {
            if (code == this.statusDigital_OFF || code == this.statusDigital_ON) {
                // empty if block
            }
            this.firstEvent = ev;
        }
        if (code == this.statusDigital_ON) {
            if (this.ioEvent_on == null) {
                this.ioEvent_on = ev;
            }
        } else if (code == this.statusDigital_OFF) {
            if (this.ioEvent_on != null) {
                this.createDigitalInputDetail(this.ioEvent_on, ev);
            } else if (ev == this.firstEvent) {
                this.createDigitalInputDetail(null, ev);
            }
            this.ioEvent_on = null;
        }
        if (this.isDetailReport) {
            return (long)this.rowData.size() < this.getReportLimit() ? 1 : 0;
        }
        return (long)this.totalData.size() < this.getReportLimit() ? 1 : 0;
    }

    protected long getReportStartTime() {
        long startTime = this.getTimeStart();
        return startTime;
    }

    protected long getReportEndTime() {
        long endTime;
        long nowTime = DateTime.getCurrentTimeSec();
        return nowTime < (endTime = this.getTimeEnd()) ? nowTime : endTime;
    }

    private static ColumnValue getColumnValue(Object val) {
        if (val == null) {
            return new ColumnValue("");
        }
        if (val instanceof ColumnValue) {
            return (ColumnValue)val;
        }
        return new ColumnValue(val.toString());
    }

    private void createDigitalInputDetail(EventData ioEv_on, EventData ioEv_off) {
        double ioDistanceKM_on;
        boolean ioApprox_on = ioEv_on == null;
        long ioTime_on = ioEv_on != null ? ioEv_on.getTimestamp() : this.getReportStartTime();
        GeoPoint ioLoc_on = ioEv_on != null ? ioEv_on.getGeoPoint() : null;
        String ioAddr_on = ioEv_on != null ? ioEv_on.getAddress() : "";
        double ioOdom_on = ioEv_on != null ? ioEv_on.getOdometerKM() : 0.0;
        boolean ioApprox_off = ioEv_off == null;
        long ioTime_off = ioEv_off != null ? ioEv_off.getTimestamp() : this.getReportEndTime();
        GeoPoint ioLoc_off = ioEv_off != null ? ioEv_off.getGeoPoint() : null;
        String ioAddr_off = ioEv_off != null ? ioEv_off.getAddress() : "";
        double ioOdom_off = ioEv_off != null ? ioEv_off.getOdometerKM() : 0.0;
        long ioElapsedSec_on = ioTime_off > 0L && ioTime_on > 0L ? ioTime_off - ioTime_on : -1L;
        double d = ioDistanceKM_on = ioOdom_off > 0.0 && ioOdom_on > 0.0 ? ioOdom_off - ioOdom_on : -1.0;
        if (this.isDetailReport) {
            DigitalInputDetail did = new DigitalInputDetail(ioApprox_on, ioTime_on, ioOdom_on, ioLoc_on, ioAddr_on, ioApprox_off, ioTime_off, ioOdom_off, ioLoc_off, ioAddr_off, ioElapsedSec_on, ioDistanceKM_on);
            this.rowData.add(did);
        }
        if (ioElapsedSec_on > 0L) {
            this.totalElapsedSec_on += ioElapsedSec_on;
        }
        if (ioDistanceKM_on > 0.0) {
            this.totalDistanceKM_on += ioDistanceKM_on;
        }
    }

    private class DigitalInputTotal
    extends FieldData {
        public DigitalInputTotal(boolean stillOn, long totalElapsed_on, double totalDistance_on) {
            String totalText = stillOn ? DigitalIOReport.this.i18n.getString("DigitialIOReport.stillOn", "Still 'On'") : DigitalIOReport.this.i18n.getString("DigitialIOReport.timeInZone", "Total Time 'On'");
            this.setRowType(DBDataRow.RowType.TOTAL);
            this.setAccount(DigitalIOReport.this.device.getAccount());
            this.setDevice(DigitalIOReport.this.device);
            this.setValue("elapseSec", totalElapsed_on);
            this.setValue("insideElapse", totalElapsed_on);
            this.setValue("distance", totalDistance_on);
            this.setValue("odomDelta", totalDistance_on);
        }
    }

    private class DigitalInputDetail
    extends FieldData
    implements EventDataProvider {
        private boolean ioApprox_on = false;
        private long ioTime_on = 0L;
        private double ioOdom_on = 0.0;
        private boolean ioApprox_off = false;
        private long ioTime_off = 0L;
        private double ioOdom_off = 0.0;
        private long ioElapsedSec_on = -1L;
        private double ioDistanceKM_on = 0.0;

        public DigitalInputDetail(boolean ioApprox_on, long ioTime_on, double ioOdom_on, GeoPoint ioLoc_on, String ioAddr_on, boolean ioApprox_off, long ioTime_off, double ioOdom_off, GeoPoint ioLoc_off, String ioAddr_off, long ioElapsedSec_on, double ioDistanceKM_on) {
            this.ioApprox_on = ioApprox_on;
            this.ioApprox_off = ioApprox_off;
            this.ioTime_on = ioTime_on;
            this.ioTime_off = ioTime_off;
            this.ioElapsedSec_on = ioElapsedSec_on;
            this.ioOdom_on = ioOdom_on;
            this.ioOdom_off = ioOdom_off;
            this.ioDistanceKM_on = ioDistanceKM_on;
            this.setAccount(DigitalIOReport.this.device.getAccount());
            this.setDevice(DigitalIOReport.this.device);
            this.setValue("enterTimestamp", this.ioTime_on);
            this.setValue("startTimestamp", this.ioTime_on);
            this.setValue("exitTimestamp", this.ioTime_off);
            this.setValue("stopTimestamp", this.ioTime_off);
            this.setValue("elapseSec", this.ioElapsedSec_on);
            this.setValue("insideElapse", this.ioElapsedSec_on);
            this.setValue("startOdometer", this.ioOdom_on);
            this.setValue("stopOdometer", this.ioOdom_off);
            this.setValue("distance", this.ioDistanceKM_on);
            this.setValue("odomDelta", this.ioDistanceKM_on);
            this.setValue("startGeoPoint", ioLoc_on);
            this.setValue("stopGeoPoint", ioLoc_off);
            this.setValue("startAddress", ioAddr_on);
            this.setValue("stopAddress", ioAddr_off);
            this.setValue("address", ioAddr_off);
        }

        @Override
        public String getAccountID() {
            return super.getAccountID();
        }

        @Override
        public String getDeviceID() {
            return super.getDeviceID();
        }

        @Override
        public String getDeviceDescription() {
            return super.getDeviceDescription();
        }

        @Override
        public String getDeviceVIN() {
            return super.getDeviceVIN();
        }

        public long getTimestamp() {
            return super.getLong("stopTimestamp", 0L);
        }

        public int getStatusCode() {
            return 62468;
        }

        public String getStatusCodeDescription(BasicPrivateLabel bpl) {
            Device dev = null;
            int code = this.getStatusCode();
            return StatusCode.getDescription(dev, (int)code, (BasicPrivateLabel)bpl, (String)"InputOff");
        }

        public StatusCodeProvider getStatusCodeProvider(BasicPrivateLabel bpl) {
            Device dev = null;
            int code = this.getStatusCode();
            return StatusCode.getStatusCodeProvider(dev, (int)code, (BasicPrivateLabel)bpl, null);
        }

        public int getPushpinIconIndex(String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, BasicPrivateLabel bpl) {
            return 2;
        }

        public boolean isValidGeoPoint() {
            return GeoPoint.isValid((double)this.getLatitude(), (double)this.getLongitude());
        }

        public double getLatitude() {
            GeoPoint gp = super.getGeoPoint("stopGeoPoint", null);
            return gp != null ? gp.getLatitude() : 0.0;
        }

        public double getLongitude() {
            GeoPoint gp = super.getGeoPoint("stopGeoPoint", null);
            return gp != null ? gp.getLongitude() : 0.0;
        }

        public GeoPoint getGeoPoint() {
            return new GeoPoint(this.getLatitude(), this.getLongitude());
        }

        public long getGpsAge() {
            return 0L;
        }

        public long getCreationAge() {
            return 0L;
        }

        public double getHorzAccuracy() {
            return -1.0;
        }

        public GeoPoint getBestGeoPoint() {
            return this.getGeoPoint();
        }

        public double getBestAccuracy() {
            return this.getHorzAccuracy();
        }

        public int getSatelliteCount() {
            return 0;
        }

        public double getBatteryLevel() {
            return 0.0;
        }

        public double getSpeedKPH() {
            return 0.0;
        }

        public double getHeading() {
            return 0.0;
        }

        public double getAltitude() {
            return 0.0;
        }

        public double getOdometerKM() {
            return 0.0;
        }

        public String getGeozoneID() {
            return "";
        }

        public String getAddress() {
            return super.getString("stopAddress", "");
        }

        public long getInputMask() {
            return 0L;
        }

        public void setEventIndex(int ndx) {
            super.setInt("eventIndex", ndx);
        }

        public int getEventIndex() {
            return super.getInt("eventIndex", -1);
        }

        public boolean getIsFirstEvent() {
            return this.getEventIndex() == 0;
        }

        public void setIsLastEvent(boolean isLast) {
            super.setBoolean("lastEvent", isLast);
        }

        public boolean getIsLastEvent() {
            return super.getBoolean("lastEvent", false);
        }

        public void fixupIoEvent_On(EventData ioEv_on) {
            if (ioEv_on != null) {
                this.ioTime_on = ioEv_on.getTimestamp();
                this.ioElapsedSec_on = this.ioTime_off > 0L && this.ioTime_on > 0L ? this.ioTime_off - this.ioTime_on : -1L;
                this.setValue("enterTimestamp", this.ioTime_on);
                this.setValue("elapseSec", this.ioElapsedSec_on);
                this.setValue("insideElapse", this.ioElapsedSec_on);
                this.ioOdom_on = ioEv_on.getOdometerKM();
                this.ioDistanceKM_on = this.ioOdom_off > 0.0 && this.ioOdom_on > 0.0 ? this.ioOdom_off - this.ioOdom_on : -1.0;
                this.setValue("startOdometer", this.ioOdom_on);
                this.setValue("distance", this.ioDistanceKM_on);
                this.setValue("odomDelta", this.ioDistanceKM_on);
            }
        }

        public String toString() {
            return DigitalIOReport.this.description;
        }

        public long getIoElapsedSec_On() {
            return this.ioElapsedSec_on > 0L ? this.ioElapsedSec_on : 0L;
        }

        public double getIoDistanceKM_On() {
            return this.ioDistanceKM_on > 0.0 ? this.ioDistanceKM_on : 0.0;
        }

        @Override
        public Object filterReturnedValue(String key, Object rtnVal) {
            if (rtnVal == null) {
                return "";
            }
            if (key == null) {
                return rtnVal;
            }
            if (key.equals("enterTimestamp") || key.equals("startTimestamp") || key.equals("enterDateTime") || key.equals("startOdometer")) {
                if (this.ioApprox_on) {
                    return DigitalIOReport.getColumnValue(rtnVal).setForegroundColor(ColorTools.DARK_YELLOW);
                }
                return rtnVal;
            }
            if (key.equals("exitTimestamp") || key.equals("stopTimestamp") || key.equals("exitDateTime") || key.equals("stopOdometer")) {
                if (this.ioApprox_off) {
                    return DigitalIOReport.getColumnValue(rtnVal).setForegroundColor(ColorTools.DARK_YELLOW);
                }
                return rtnVal;
            }
            return rtnVal;
        }
    }
}

