/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.util.AccumulatorLong;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class DeviceReport
extends ReportData {
    private static final String PROP_includeDeltaValues = "includeDeltaValues";
    private static final String PROP_countStatusCodes = "countStatusCodes";
    private List<FieldData> rowData = null;
    private boolean includeDeltaValues = false;
    private int[] countStatusCodes = null;

    public DeviceReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
    }

    @Override
    public void postInitialize() {
        RTProperties rtp = this.getProperties();
        this.includeDeltaValues = rtp.getBoolean(PROP_includeDeltaValues, false);
        this.countStatusCodes = rtp.getIntArray(PROP_countStatusCodes, null);
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return DeviceReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        Device dev;
        this.rowData = new Vector<FieldData>();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                Device device = devList.getDevice(devID);
                if (device != null) {
                    FieldData fd = new FieldData();
                    fd.setDevice(device);
                    this.rowData.add(fd);
                    continue;
                }
                Print.logError((String)("Returned DeviceList 'Device' is null: " + devID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData count for Device: " + devID), (Object[])new Object[0]);
            }
        }
        long startTime = this.getTimeStart();
        long endTime = this.getTimeEnd();
        if (this.includeDeltaValues) {
            for (FieldData fd : this.rowData) {
                double deltaHours;
                double stopFuel;
                double startFuel;
                double stopOdom;
                double startOdom;
                double stopHours;
                double startHours;
                block40: {
                    double fuel;
                    double odom;
                    double hours;
                    int e;
                    Object[] ed;
                    block39: {
                        dev = fd.getDevice();
                        startHours = 0.0;
                        stopHours = 0.0;
                        startOdom = 0.0;
                        stopOdom = 0.0;
                        startFuel = 0.0;
                        stopFuel = 0.0;
                        try {
                            ed = dev.getRangeEvents(startTime, -1L, false, EventData.LimitType.FIRST, 4L);
                            if (ListTools.isEmpty((Object[])ed)) break block39;
                            for (e = 0; e < ed.length; ++e) {
                                if (startHours <= 0.0 && (hours = ed[e].getEngineHours()) > 0.0) {
                                    startHours = hours;
                                }
                                if (startOdom <= 0.0 && (odom = ed[e].getOdometerKM()) > 0.0) {
                                    startOdom = odom;
                                }
                                if (startFuel <= 0.0 && (fuel = ed[e].getFuelTotal()) > 0.0) {
                                    startFuel = fuel;
                                }
                                if (!(startHours > 0.0 && startOdom > 0.0 && startFuel > 0.0)) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (DBException dbe) {
                            Print.logException((String)"Getting FIRST Device Event Records", (Throwable)dbe);
                        }
                    }
                    if (endTime <= 0L) {
                        stopHours = dev.getLastEngineHours();
                        stopOdom = dev.getLastOdometerKM();
                        stopFuel = dev.getLastFuelTotal();
                    } else {
                        try {
                            ed = dev.getRangeEvents(-1L, endTime, false, EventData.LimitType.LAST, 4L);
                            if (ListTools.isEmpty((Object[])ed)) break block40;
                            for (e = ed.length - 1; e > 0; --e) {
                                if (stopHours <= 0.0 && (hours = ed[e].getEngineHours()) > 0.0) {
                                    stopHours = hours;
                                }
                                if (stopOdom <= 0.0 && (odom = ed[e].getOdometerKM()) > 0.0) {
                                    stopOdom = odom;
                                }
                                if (stopFuel <= 0.0 && (fuel = ed[e].getFuelTotal()) > 0.0) {
                                    stopFuel = fuel;
                                }
                                if (!(stopHours > 0.0 && stopOdom > 0.0 && stopFuel > 0.0)) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (DBException dbe) {
                            Print.logException((String)"Getting FIRST Device Event Records", (Throwable)dbe);
                        }
                    }
                }
                if (startHours > 0.0) {
                    fd.setDouble("startEngineHours", startHours);
                }
                if (stopHours > 0.0) {
                    fd.setDouble("startEngineHours", stopHours);
                }
                if (startHours > 0.0 && stopHours > 0.0 && (deltaHours = stopHours - startHours) < 0.0) {
                    deltaHours = 0.0;
                }
                if (startOdom > 0.0) {
                    fd.setDouble("startOdometer", startOdom);
                }
                if (stopOdom > 0.0) {
                    fd.setDouble("stopOdometer", stopOdom);
                }
                if (startOdom > 0.0 && stopOdom > 0.0) {
                    double deltaOdom = stopOdom - startOdom;
                    if (deltaOdom < 0.0) {
                        deltaOdom = 0.0;
                    }
                    fd.setDouble("odomDelta", deltaOdom);
                    fd.setDouble("distance", deltaOdom);
                }
                double planDelta = dev.getPlanDistanceKM();
                fd.setDouble("plannedDistance", planDelta);
                if (startFuel > 0.0) {
                    fd.setDouble("startFuel", startFuel);
                }
                if (stopFuel > 0.0) {
                    fd.setDouble("stopFuel", stopFuel);
                }
                if (!(startFuel > 0.0) || !(stopFuel > 0.0)) continue;
                double deltaFuel = stopFuel - startFuel;
                fd.setDouble("fuelDelta", deltaFuel);
            }
        }
        if (!ListTools.isEmpty((int[])this.countStatusCodes)) {
            for (FieldData fd : this.rowData) {
                dev = fd.getDevice();
                HashMap<Integer, AccumulatorLong> countMap = null;
                try {
                    Object[] ed = dev.getRangeEvents(startTime, -1L, this.countStatusCodes, false, EventData.LimitType.FIRST, -1L);
                    if (!ListTools.isEmpty((Object[])ed)) {
                        countMap = new HashMap<Integer, AccumulatorLong>();
                        for (Object ev : ed) {
                            Integer sci = new Integer(ev.getStatusCode());
                            AccumulatorLong acc = (AccumulatorLong)countMap.get(sci);
                            if (acc != null) {
                                acc.increment();
                                continue;
                            }
                            countMap.put(sci, new AccumulatorLong(1L));
                        }
                    }
                }
                catch (DBException dbe) {
                    Print.logException((String)"Getting Event StatusCodes", (Throwable)dbe);
                }
                for (int sc : this.countStatusCodes) {
                    AccumulatorLong acc = countMap != null ? (AccumulatorLong)countMap.get(new Integer(sc)) : null;
                    long count = acc != null ? acc.get() : 0L;
                    String scKey = "statusCount_" + StringTools.toHexString((long)sc, (int)16);
                    fd.setLong(scKey, count);
                }
            }
        }
        FieldData.sortByDeviceDescription(this.rowData);
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

