/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.util.AccumulatorLong;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class DailySummaryReport
extends ReportData
implements DBRecordHandler<EventData> {
    private static final String PROP_digitalInputIndex = "digitalInputIndex";
    private static final String PROP_reportType = "reportType";
    private static final String REPORT_TYPE_detail = "detail";
    private static final String REPORT_TYPE_summary = "summary";
    private static final boolean FIXUP_FIRST_DIGITIAL_ON = false;
    private I18N i18n = null;
    private Device device = null;
    private String description = null;
    private EventData firstEvent = null;
    private EventData lastEvent = null;
    private Map<Integer, AccumulatorLong> codeCount = new OrderedMap();
    private Vector<FieldData> rowData = null;

    public DailySummaryReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        this.i18n = reqState.getPrivateLabel().getI18N(DailySummaryReport.class);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        if (this.getDeviceCount() <= 0) {
            throw new ReportException("No Devices specified");
        }
    }

    @Override
    public void postInitialize() {
    }

    @Override
    public boolean isSingleDeviceOnly() {
        return false;
    }

    @Override
    protected EventData[] getEventData(Device device, DBRecordHandler<EventData> rcdHandler) {
        if (device == null) {
            return EventData.EMPTY_ARRAY;
        }
        ReportConstraints rc = this.getReportConstraints();
        rc.setValidGPSRequired(false);
        return super.getEventData(device, rcdHandler);
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return false;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return DailySummaryReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector();
        String accountID = this.getAccountID();
        String devID = "";
        ReportDeviceList devList = this.getReportDeviceList();
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            devID = i.next();
            try {
                this.device = devList.getDevice(devID);
                this.firstEvent = null;
                this.lastEvent = null;
                this.codeCount.clear();
                this.getEventData(this.device, this);
                double odomDeltaKM = 0.0;
                double fuelDeltaL = 0.0;
                if (this.lastEvent != null) {
                    odomDeltaKM = this.lastEvent.getOdometerKM() - this.firstEvent.getOdometerKM();
                    fuelDeltaL = this.lastEvent.getFuelTotal() - this.firstEvent.getFuelTotal();
                }
                FieldData fd = new FieldData();
                fd.setAccount(this.getAccount());
                fd.setString("accountId", this.getAccountID());
                fd.setDevice(this.device);
                fd.setString("deviceId", devID);
                fd.setDouble("distance", odomDeltaKM);
                fd.setDouble("odomDelta", odomDeltaKM);
                fd.setDouble("fuelTotal", fuelDeltaL);
                fd.setDouble("fuelTrip", fuelDeltaL);
                for (Integer sc : this.codeCount.keySet()) {
                    int code = sc;
                    AccumulatorLong al = this.codeCount.get(sc);
                    String cKey = "statusCount_" + StringTools.toHexString((long)code, (int)16);
                    fd.setLong(cKey, al.get());
                }
                this.rowData.add(fd);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving EventData for Device: " + devID), (Object[])new Object[0]);
            }
        }
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    public int handleDBRecord(EventData rcd) throws DBException {
        Integer sci;
        AccumulatorLong acc;
        EventData ev = rcd;
        if (this.firstEvent == null) {
            this.firstEvent = ev;
        }
        if ((acc = this.codeCount.get(sci = new Integer(ev.getStatusCode()))) != null) {
            acc.increment();
        } else {
            this.codeCount.put(sci, new AccumulatorLong(1L));
        }
        this.lastEvent = ev;
        return (long)this.rowData.size() < this.getReportLimit() ? 1 : 0;
    }

    protected long getReportStartTime() {
        long startTime = this.getTimeStart();
        return startTime;
    }

    protected long getReportEndTime() {
        long endTime;
        long nowTime = DateTime.getCurrentTimeSec();
        return nowTime < (endTime = this.getTimeEnd()) ? nowTime : endTime;
    }
}

