/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.List;
import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.extra.tables.SystemAudit;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class AuditReport
extends ReportData {
    private List<FieldData> rowData = null;
    private I18N i18n = null;

    public AuditReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        this.i18n = reqState.getPrivateLabel().getI18N(AuditReport.class);
    }

    @Override
    public void postInitialize() {
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return AuditReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        Account currAcct = this.getAccount();
        String currAcctID = currAcct.getAccountID();
        DBRecordHandler<SystemAudit> rcdHandler = new DBRecordHandler<SystemAudit>(){

            public int handleDBRecord(SystemAudit rcd) throws DBException {
                SystemAudit sa = rcd;
                FieldData fd = new FieldData();
                fd.setValue("timestamp", sa.getAuditTime());
                fd.setValue("createTimestamp", sa.getCreationTime());
                fd.setValue("accountId", sa.getAccountID());
                fd.setValue("userId", sa.getUserID());
                fd.setValue("deviceId", sa.getDeviceID());
                fd.setValue("ipAddress", sa.getIpAddress());
                if (sa.getAuditCode() == 256) {
                    fd.setValue("loginDateTime", sa.getAuditTime());
                }
                AuditReport.this.rowData.add(fd);
                return 1;
            }
        };
        ReportConstraints rc = this.getReportConstraints();
        int auditCode = 256;
        long startTime = rc.getTimeStart();
        long endTime = rc.getTimeEnd();
        long limit = rc.getSelectionLimit();
        try {
            SystemAudit.getRecordCallback((DBRecordHandler)rcdHandler, (String)currAcctID, (int)auditCode, (long)startTime, (long)endTime, (long)limit);
        }
        catch (DBException dbe) {
            Print.logException((String)"Error", (Throwable)dbe);
        }
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

