/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.field;

import java.util.List;
import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class AccountReport
extends ReportData {
    private List<FieldData> rowData = null;
    private I18N i18n = null;

    public AccountReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        this.i18n = reqState.getPrivateLabel().getI18N(AccountReport.class);
    }

    @Override
    public void postInitialize() {
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return AccountReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        Account currAcct = this.getAccount();
        Vector<String> accountList = null;
        try {
            accountList = Account.getAuthorizedAccounts((Account)currAcct);
        }
        catch (DBException dbe) {
            Print.logError((String)"Error reading authorized Accounts", (Object[])new Object[0]);
            accountList = new Vector<String>();
            accountList.add(currAcct.getAccountID());
        }
        for (String accountID : accountList) {
            try {
                Account account = Account.getAccount((String)accountID);
                if (account != null) {
                    FieldData fd = new FieldData();
                    fd.setAccount(account);
                    this.rowData.add(fd);
                    continue;
                }
                Print.logError((String)("'Account' is null: " + accountID), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error retrieving Account: " + accountID), (Object[])new Object[0]);
            }
        }
        FieldData.sortByDeviceDescription(this.rowData);
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

