/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.event;

import java.awt.Color;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.db.tables.EventData;
import org.opengts.google.GoogleChartTemperature;
import org.opengts.util.ColorTools;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.event.EventDetailReport;
import org.opengts.war.tools.MapDimension;
import org.opengts.war.tools.RequestProperties;

public class EventThermoReport
extends EventDetailReport {
    private static final String PROP_TITLE_COLOR = "graph.titleColor";
    private static final String PROP_TITLE_FONT_SIZE = "graph.titleFontSize";
    private static final String PROP_X_TICK_COUNT = "graph.xTickCount";
    private static final String PROP_Y_TICK_COUNT = "graph.yTickCount";
    private static final String[] COL_THERMO = new String[]{"thermo1", "thermo2", "thermo3", "thermo4", "thermo6", "thermo7", "thermo8"};
    private static Color[] TEMP_COLOR = new Color[]{Color.red, Color.green, Color.blue, Color.cyan, Color.yellow, Color.gray, Color.black};

    private static double F2C(double F) {
        return (F - 32.0) * 5.0 / 9.0;
    }

    private static double C2F(double C) {
        return C * 9.0 / 5.0 + 32.0;
    }

    public EventThermoReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        ReportData.ArrayDataIterator adi;
        Object[] oa;
        DBDataIterator dbi = super.getBodyDataIterator();
        if (dbi instanceof ReportData.ArrayDataIterator && !ListTools.isEmpty((Object[])(oa = (adi = (ReportData.ArrayDataIterator)dbi).getArray()))) {
            int t;
            EventData ev;
            int i;
            int tempMask = 0;
            for (i = 0; i < oa.length; ++i) {
                ev = (EventData)oa[i];
                for (t = 0; t < 8; ++t) {
                    double C = ev.getThermoAverage(t);
                    if (!EventData.isValidTemperature((double)C)) continue;
                    tempMask |= 1 << t;
                }
            }
            for (i = 0; i < oa.length; ++i) {
                ev = (EventData)oa[i];
                for (t = 0; t < 8; ++t) {
                    if ((tempMask & 1 << t) != 0) continue;
                    ev.setThermoAverage(t, -9999.0);
                }
            }
        }
        return dbi;
    }

    @Override
    public boolean getSupportsGraphDisplay() {
        return true;
    }

    @Override
    public URIArg getGraphURL() {
        try {
            return this._getGraphURL();
        }
        catch (Throwable th) {
            Print.logException((String)"Error", (Throwable)th);
            return new URIArg("");
        }
    }

    private URIArg _getGraphURL() throws Exception {
        int d;
        TimeZone tz = this.getTimeZone();
        DateTime timeStart = new DateTime(this.getTimeStart(), tz);
        DateTime timeEnd = new DateTime(this.getTimeEnd(), tz);
        ReportLayout rl = this.getReportLayout();
        String dateFormat = "MM/dd";
        String timeFormat = rl.getTimeFormat(this.getPrivateLabel());
        MapDimension size = this.getGraphWindowSize();
        Locale locale = this.getPrivateLabel().getLocale();
        I18N i18n = I18N.getI18N(EventThermoReport.class, (Locale)locale);
        int tempUnits = this.getAccount().getTemperatureUnits();
        int thermoCount = 0;
        Vector[] dataSet = new Vector[COL_THERMO.length];
        boolean[] dataSetValid = new boolean[COL_THERMO.length];
        for (int i = 0; i < COL_THERMO.length; ++i) {
            if (this.hasReportColumn(COL_THERMO[i])) {
                dataSet[i] = new Vector();
                ++thermoCount;
            } else {
                dataSet[i] = null;
            }
            dataSetValid[i] = false;
        }
        double maxTempC = -9999.0;
        double minTempC = 9999.0;
        if (thermoCount > 0) {
            int evNdx = 0;
            DBDataIterator dbi = this.getBodyDataIterator();
            while (dbi.hasNext()) {
                Object ev = dbi.next().getRowObject();
                if (ev instanceof EventData) {
                    EventData ed = (EventData)ev;
                    ed.setEventIndex(evNdx++);
                    if (!dbi.hasNext()) {
                        ed.setIsLastEvent(true);
                    }
                    double lastTempC = -9999.0;
                    for (d = 0; d < dataSet.length; ++d) {
                        if (dataSet[d] == null) continue;
                        long ts = ed.getTimestamp();
                        double tempC = ed.getThermoAverage(d);
                        if (EventData.isValidTemperature((double)tempC)) {
                            if (tempC > maxTempC) {
                                maxTempC = tempC;
                            }
                            if (tempC < minTempC) {
                                minTempC = tempC;
                            }
                            dataSet[d].add(new GoogleChartTemperature.Data(ts, tempC));
                            if (tempC != 0.0) {
                                dataSetValid[d] = true;
                            }
                            lastTempC = tempC;
                            continue;
                        }
                        if (EventData.isValidTemperature((double)lastTempC)) {
                            dataSet[d].add(new GoogleChartTemperature.Data(ts, lastTempC));
                            continue;
                        }
                        dataSet[d].add(new GoogleChartTemperature.Data(ts, 0.0));
                    }
                    continue;
                }
                Print.logWarn((String)("Not an EventData: " + StringTools.className((Object)ev)), (Object[])new Object[0]);
            }
        }
        for (int d2 = 0; d2 < dataSet.length; ++d2) {
            if (dataSetValid[d2]) continue;
            dataSet[d2] = null;
        }
        if (!EventData.isValidTemperature((double)minTempC) || !EventData.isValidTemperature((double)maxTempC)) {
            minTempC = 0.0;
            maxTempC = 54.0;
        } else if (tempUnits == 1) {
            minTempC = Math.floor(minTempC / 10.0) * 10.0;
            maxTempC = Math.ceil(maxTempC / 10.0) * 10.0;
        } else {
            minTempC = EventThermoReport.F2C(Math.floor(EventThermoReport.C2F(minTempC) / 10.0) * 10.0);
            maxTempC = EventThermoReport.F2C(Math.ceil(EventThermoReport.C2F(maxTempC) / 10.0) * 10.0);
        }
        Color titleColor = ColorTools.parseColor((String)this.getProperties().getString(PROP_TITLE_COLOR, "black"), (Color)Color.black);
        int titleFontSize = this.getProperties().getInt(PROP_TITLE_FONT_SIZE, 16);
        int xTickCount = this.getProperties().getInt(PROP_X_TICK_COUNT, 10);
        int yTickCount = this.getProperties().getInt(PROP_Y_TICK_COUNT, 8);
        GoogleChartTemperature gct = new GoogleChartTemperature();
        gct.setSize(size.getWidth() - 30, size.getHeight() - 40);
        gct.setTitle(titleColor, titleFontSize, i18n.getString("EventThermoReport.temperature", "Temperature"));
        gct.setTemperatureRange(this.getAccount().getTemperatureUnits(), minTempC, maxTempC, xTickCount);
        gct.setDateRange(timeStart, timeEnd, yTickCount);
        gct.setDateFormat("MM/dd");
        gct.setTimeFormat(timeFormat);
        if (thermoCount > 0) {
            Color[] tempColor = TEMP_COLOR;
            for (d = 0; d < dataSet.length; ++d) {
                if (dataSet[d] == null) continue;
                Color color = tempColor[d % tempColor.length];
                String title = i18n.getString("EventThermoReport.temp", "Temp {0}", (Object)String.valueOf(d + 1));
                gct.addDataSet(color, title, dataSet[d].toArray(new GoogleChartTemperature.Data[dataSet[d].size()]));
            }
        } else {
            gct._addRandomSampleData(4, 15);
        }
        String url = gct.toString();
        return new URIArg(url);
    }
}

