/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.EntityManager;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.extra.tables.Entity;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class EntityReport
extends ReportData
implements DBRecordHandler<Entity> {
    private static String PROP_entityType = "entityType";
    private static String PROP_entityStatusCode = "entityMapStatusCode";
    private static String PROP_entityPushpinID = "entityMapPushpinID";
    private EntityManager.EntityType entityType = null;
    private long entityTypeCode = -1L;
    private int entityStatusCode = 61472;
    private String entityPushpinID = null;
    private List<FieldData> rowData = null;
    private Map<String, EventData> lastDeviceEvents = new HashMap<String, EventData>();

    public EntityReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account must be specified");
        }
    }

    @Override
    public void postInitialize() {
        String entType = this.getProperties().getString(PROP_entityType, "").trim();
        if (StringTools.isBlank((String)entType)) {
            this.entityType = null;
            this.entityTypeCode = -1L;
        } else {
            if (Character.isDigit(entType.charAt(0))) {
                long etc = StringTools.parseLong((String)entType, (long)-1L);
                this.entityType = EntityManager.getEntityTypeFromCode((long)etc, null);
            } else {
                this.entityType = EntityManager.getEntityTypeFromName((String)entType, null);
            }
            if (this.entityType == null) {
                Print.logWarn((String)("Unable to recognize EntityType: " + entType), (Object[])new Object[0]);
                this.entityTypeCode = -1L;
            } else {
                this.entityTypeCode = this.entityType.getIntValue();
            }
        }
        this.entityStatusCode = this.getProperties().getInt(PROP_entityStatusCode, 61472);
        this.entityPushpinID = this.getProperties().getString(PROP_entityPushpinID, "").trim();
    }

    public int getStatusCode() {
        return this.entityStatusCode;
    }

    public String getPushpinID() {
        return this.entityPushpinID;
    }

    @Override
    public boolean getSupportsMapDisplay() {
        return true;
    }

    @Override
    public boolean getSupportsKmlDisplay() {
        return false;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    @Override
    public ReportLayout getReportLayout() {
        return EntityReport.GetReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<FieldData>();
        String acctID = this.getAccountID();
        long limit = 0L;
        try {
            Entity.getEntitiesForAccount((String)acctID, (long)limit, (DBRecordHandler)this);
        }
        catch (DBException dbe) {
            Print.logException((String)"Getting Entities ...", (Throwable)dbe);
        }
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }

    private EventData getLastDeviceEvent(String devID, long endTime) {
        if (devID != null) {
            try {
                Device device;
                EventData event = this.lastDeviceEvents.get(devID);
                if (event == null && (device = Device.getDevice((Account)this.getAccount(), (String)devID)) != null && (event = device.getLastEvent(endTime, true)) != null) {
                    this.lastDeviceEvents.put(devID, event);
                }
                return event;
            }
            catch (Throwable th) {
                Print.logException((String)("Error retrieving last EventData for Device: " + devID), (Throwable)th);
            }
        }
        return null;
    }

    public int handleDBRecord(Entity rcd) throws DBException {
        Entity ent = rcd;
        boolean isAttached = ent.getIsAttached();
        String entDev = isAttached ? ent.getDeviceID() : "";
        EventData evt = isAttached ? this.getLastDeviceEvent(entDev, -1L) : null;
        long entTime = ent.getTimestamp();
        long entType = ent.getEntityType();
        if (this.entityTypeCode >= 0L && this.entityTypeCode != entType) {
            return 1;
        }
        EntityFieldData fd = new EntityFieldData(this);
        fd.setString("accountId", this.getAccountID());
        fd.setString("entityId", ent.getEntityID());
        fd.setLong("entityType", entType);
        fd.setDouble("odometer", ent.getOdometerKM());
        fd.setString("entityDesc", ent.getDescription());
        fd.setBoolean("attached", isAttached);
        fd.setString("deviceId", entDev);
        if (evt != null && evt.getTimestamp() >= entTime) {
            fd.setLong("timestamp", evt.getTimestamp());
            fd.setGeoPoint("geoPoint", evt.getGeoPoint());
            fd.setString("address", evt.getAddress());
        } else {
            fd.setLong("timestamp", entTime);
            fd.setGeoPoint("geoPoint", ent.getGeoPoint());
            fd.setString("address", ent.getAddress());
        }
        this.rowData.add(fd);
        return (long)this.rowData.size() < this.getReportLimit() ? 1 : 0;
    }

    private static class EntityFieldData
    extends FieldData.FieldEventDataProvider {
        private EntityReport entityReport = null;

        public EntityFieldData(EntityReport er) {
            this.entityReport = er;
        }

        @Override
        public int getStatusCode() {
            return this.entityReport.getStatusCode();
        }

        @Override
        public int getPushpinIconIndex(String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, BasicPrivateLabel bpl) {
            String pid = this.entityReport.getPushpinID();
            return EventData._getPushpinIconIndex((String)pid, iconKeys, (int)3);
        }
    }
}

