/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.antx;

import java.util.TimeZone;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.extra.war.report.antx.AntxChannel;
import org.opengts.extra.war.report.antx.AntxData;
import org.opengts.extra.war.report.antx.AntxField;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.StringTools;
import org.opengts.war.report.DataColumnTemplate;
import org.opengts.war.report.DataRowTemplate;
import org.opengts.war.report.ReportColumn;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportLayout;

public class AntxLayout
extends ReportLayout {
    public static final String DATA_INDEX = "index";
    public static final String DATA_DEVICE_ID = "deviceID";
    public static final String DATA_DEVICE_DESC = "deviceDesc";
    public static final String DATA_TIMESTAMP = "timestamp";
    public static final String DATA_DATETIME = "dateTime";
    public static final String DATA_DATE = "date";
    public static final String DATA_FIELD_ID = "fieldID";
    public static final String DATA_FIELD_DESC = "fieldDesc";
    public static final String DATA_CHANNEL_ID = "channelID";
    public static final String DATA_CHANNEL_DESC = "channelDesc";
    public static final String DATA_TYPE = "type";
    public static final String DATA_DATA_0 = "data0";
    public static final String DATA_DATA_1 = "data1";
    public static final String DATA_DATA_2 = "data2";
    public static final String DATA_DATA_3 = "data3";
    public static final String DATA_DATA_4 = "data4";
    public static final String DATA_FUEL_TOTAL = "totalFuel";
    public static final String DATA_FUEL_PTO = "ptoFuel";
    public static final String DATA_FUEL_IDLE = "idleFuel";
    public static final String DATA_FUEL_WORK = "workFuel";
    public static final String DATA_DISTANCE = "distance";
    public static final String DATA_SPEED = "speed";
    private static AntxLayout reportDef = null;

    public static ReportLayout getReportLayout() {
        if (reportDef == null) {
            reportDef = new AntxLayout();
        }
        return reportDef;
    }

    private AntxLayout() {
        this.setDataRowTemplate(new AntxDataRow());
    }

    protected static class AntxDataRow
    extends DataRowTemplate {
        public AntxDataRow() {
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_INDEX){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    if (rowNdx < 0) {
                        return "";
                    }
                    int ofs = 1;
                    if (arg != null && arg.length() > 0 && arg.charAt(0) == '0') {
                        ofs = 0;
                    }
                    return String.valueOf(rowNdx + ofs);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    return "#";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DEVICE_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    AntxData ad = (AntxData)obj;
                    String devID = ad.getString(AntxLayout.DATA_DEVICE_ID);
                    if (StringTools.isBlank((String)devID) && (dev = ad.getDevice()) != null) {
                        devID = dev.getDeviceID();
                    }
                    return devID;
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.deviceID", "Device-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DEVICE_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    Device dev;
                    String arg = rc.getArg();
                    AntxData ad = (AntxData)obj;
                    String desc = ad.getString(AntxLayout.DATA_DEVICE_DESC);
                    if (StringTools.isBlank((String)desc) && (dev = ad.getDevice()) != null) {
                        desc = dev.getDescription();
                    }
                    return desc;
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.deviceDescription", "Device\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_TIMESTAMP){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData fd = (AntxData)obj;
                    long ts = fd.getLong(AntxLayout.DATA_TIMESTAMP);
                    return String.valueOf(ts);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.timestamp", "Timestamp") + "\n(Epoch)";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DATETIME){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData fd = (AntxData)obj;
                    long ts = fd.getLong(AntxLayout.DATA_TIMESTAMP);
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        return dt.format(rl.getDateTimeFormat(rd.getPrivateLabel()), tz);
                    }
                    return "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.dateTime", "Date/Time") + "\n${timezone}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DATE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData fd = (AntxData)obj;
                    long ts = fd.getLong(AntxLayout.DATA_TIMESTAMP);
                    if (ts > 0L) {
                        ReportLayout rl = rd.getReportLayout();
                        TimeZone tz = rd.getTimeZone();
                        DateTime dt = new DateTime(ts);
                        return dt.format(rl.getDateFormat(rd.getPrivateLabel()), tz);
                    }
                    return "";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.date", "Date");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_FIELD_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData fd = (AntxData)obj;
                    String fid = fd.getString(AntxLayout.DATA_FIELD_ID);
                    return StringTools.trim((String)fid);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.fieldID", "Field-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_FIELD_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData fd = (AntxData)obj;
                    String desc = fd.getString(AntxLayout.DATA_FIELD_DESC);
                    if (StringTools.isBlank((String)desc)) {
                        int fid = fd.getInt(AntxLayout.DATA_FIELD_ID);
                        desc = AntxField.GetFieldDescription(fid);
                        if ("id".equalsIgnoreCase(arg) && !StringTools.isBlank((String)desc)) {
                            desc = desc + " (" + fid + ")";
                        }
                    }
                    return StringTools.trim((String)desc);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.fieldDesc", "Field\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_CHANNEL_ID){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData fd = (AntxData)obj;
                    String cid = fd.getString(AntxLayout.DATA_CHANNEL_ID);
                    return StringTools.trim((String)cid);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.channelID", "Channel-ID");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_CHANNEL_DESC){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData fd = (AntxData)obj;
                    String desc = fd.getString(AntxLayout.DATA_CHANNEL_DESC);
                    if (StringTools.isBlank((String)desc)) {
                        int chan = fd.getInt(AntxLayout.DATA_CHANNEL_ID);
                        desc = AntxChannel.GetChannelDescription(chan);
                        if ("id".equalsIgnoreCase(arg) && !StringTools.isBlank((String)desc)) {
                            desc = desc + " (" + chan + ")";
                        }
                    }
                    return StringTools.trim((String)desc);
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.channelDesc", "Channel\nDescription");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_TYPE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData fd = (AntxData)obj;
                    int type = fd.getInt(AntxLayout.DATA_TYPE);
                    switch (type) {
                        case 0: {
                            return "Value";
                        }
                        case 1: {
                            return "Min/Max";
                        }
                        case 2: {
                            return "Bin";
                        }
                    }
                    return "?";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.type", "Type");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DATA_0){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    Account acct = rd.getAccount();
                    AntxData fd = (AntxData)obj;
                    int type = fd.getInt(AntxLayout.DATA_TYPE);
                    int fld = fd.getInt(AntxLayout.DATA_FIELD_ID);
                    int chan = fd.getInt(AntxLayout.DATA_CHANNEL_ID);
                    String unit = AntxChannel.GetChannelUnitsDescription(acct, fld, chan);
                    double data = AntxChannel.GetAccountUnitsValue(acct, fld, chan, fd.getDouble(AntxLayout.DATA_DATA_0));
                    return StringTools.format((double)data, (String)AntxDataRow.this.getDataFormat(arg)) + (!StringTools.isBlank((String)unit) ? " " + unit : "");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.data0", "Data #0");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DATA_1){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    Account acct = rd.getAccount();
                    AntxData fd = (AntxData)obj;
                    int type = fd.getInt(AntxLayout.DATA_TYPE);
                    if (type == 0) {
                        return "--";
                    }
                    int fld = fd.getInt(AntxLayout.DATA_FIELD_ID);
                    int chan = fd.getInt(AntxLayout.DATA_CHANNEL_ID);
                    String unit = AntxChannel.GetChannelUnitsDescription(acct, fld, chan);
                    double data = AntxChannel.GetAccountUnitsValue(acct, fld, chan, fd.getDouble(AntxLayout.DATA_DATA_1));
                    return StringTools.format((double)data, (String)AntxDataRow.this.getDataFormat(arg)) + (!StringTools.isBlank((String)unit) ? " " + unit : "");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.data1", "Data #1");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DATA_2){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    Account acct = rd.getAccount();
                    AntxData fd = (AntxData)obj;
                    int type = fd.getInt(AntxLayout.DATA_TYPE);
                    if (type == 0 || type == 1) {
                        return "--";
                    }
                    int fld = fd.getInt(AntxLayout.DATA_FIELD_ID);
                    int chan = fd.getInt(AntxLayout.DATA_CHANNEL_ID);
                    String unit = AntxChannel.GetChannelUnitsDescription(acct, fld, chan);
                    double data = AntxChannel.GetAccountUnitsValue(acct, fld, chan, fd.getDouble(AntxLayout.DATA_DATA_2));
                    return StringTools.format((double)data, (String)AntxDataRow.this.getDataFormat(arg)) + (!StringTools.isBlank((String)unit) ? " " + unit : "");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.data2", "Data #2");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DATA_3){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    Account acct = rd.getAccount();
                    AntxData fd = (AntxData)obj;
                    int type = fd.getInt(AntxLayout.DATA_TYPE);
                    if (type == 0 || type == 1) {
                        return "--";
                    }
                    int fld = fd.getInt(AntxLayout.DATA_FIELD_ID);
                    int chan = fd.getInt(AntxLayout.DATA_CHANNEL_ID);
                    String unit = AntxChannel.GetChannelUnitsDescription(acct, fld, chan);
                    double data = AntxChannel.GetAccountUnitsValue(acct, fld, chan, fd.getDouble(AntxLayout.DATA_DATA_3));
                    return StringTools.format((double)data, (String)AntxDataRow.this.getDataFormat(arg)) + (!StringTools.isBlank((String)unit) ? " " + unit : "");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.data3", "Data #3");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DATA_4){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    Account acct = rd.getAccount();
                    AntxData fd = (AntxData)obj;
                    int type = fd.getInt(AntxLayout.DATA_TYPE);
                    if (type == 0 || type == 1) {
                        return "--";
                    }
                    int fld = fd.getInt(AntxLayout.DATA_FIELD_ID);
                    int chan = fd.getInt(AntxLayout.DATA_CHANNEL_ID);
                    String unit = AntxChannel.GetChannelUnitsDescription(acct, fld, chan);
                    double data = AntxChannel.GetAccountUnitsValue(acct, fld, chan, fd.getDouble(AntxLayout.DATA_DATA_4));
                    return StringTools.format((double)data, (String)AntxDataRow.this.getDataFormat(arg)) + (!StringTools.isBlank((String)unit) ? " " + unit : "");
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.data4", "Data #4");
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_SPEED){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData ad = (AntxData)obj;
                    if (ad.hasValue(AntxLayout.DATA_SPEED)) {
                        Account a = rd.getAccount();
                        double kph = Account.getSpeedUnits((Account)a).convertFromKPH(ad.getDouble(AntxLayout.DATA_SPEED));
                        return StringTools.format((double)kph, (String)AntxDataRow.this.getDataFormat(arg));
                    }
                    return "--";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.speed", "Speed") + "\n${speedUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_DISTANCE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData ad = (AntxData)obj;
                    if (ad.hasValue(AntxLayout.DATA_DISTANCE)) {
                        Account a = rd.getAccount();
                        double km = Account.getDistanceUnits((Account)a).convertFromKM(ad.getDouble(AntxLayout.DATA_DISTANCE));
                        return StringTools.format((double)km, (String)AntxDataRow.this.getDataFormat(arg));
                    }
                    return "--";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.distance", "Distance") + "\n${distanceUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_FUEL_TOTAL){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData ad = (AntxData)obj;
                    if (ad.hasValue(AntxLayout.DATA_FUEL_TOTAL)) {
                        Account a = rd.getAccount();
                        double liters = Account.getVolumeUnits((Account)a).convertFromLiters(ad.getDouble(AntxLayout.DATA_FUEL_TOTAL));
                        return StringTools.format((double)liters, (String)AntxDataRow.this.getDataFormat(arg));
                    }
                    return "--";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.totalFuel", "Total Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_FUEL_PTO){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData ad = (AntxData)obj;
                    if (ad.hasValue(AntxLayout.DATA_FUEL_PTO)) {
                        Account a = rd.getAccount();
                        double liters = Account.getVolumeUnits((Account)a).convertFromLiters(ad.getDouble(AntxLayout.DATA_FUEL_PTO));
                        return StringTools.format((double)liters, (String)AntxDataRow.this.getDataFormat(arg));
                    }
                    return "--";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.ptoFuel", "PTO Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_FUEL_IDLE){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData ad = (AntxData)obj;
                    if (ad.hasValue(AntxLayout.DATA_FUEL_IDLE)) {
                        Account a = rd.getAccount();
                        double liters = Account.getVolumeUnits((Account)a).convertFromLiters(ad.getDouble(AntxLayout.DATA_FUEL_IDLE));
                        return StringTools.format((double)liters, (String)AntxDataRow.this.getDataFormat(arg));
                    }
                    return "--";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.idleFuel", "Idle Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
            this.addColumnTemplate(new DataColumnTemplate(AntxLayout.DATA_FUEL_WORK){

                @Override
                public Object getColumnValue(int rowNdx, ReportData rd, ReportColumn rc, Object obj) {
                    String arg = rc.getArg();
                    AntxData ad = (AntxData)obj;
                    if (ad.hasValue(AntxLayout.DATA_FUEL_WORK)) {
                        Account a = rd.getAccount();
                        double liters = Account.getVolumeUnits((Account)a).convertFromLiters(ad.getDouble(AntxLayout.DATA_FUEL_WORK));
                        return StringTools.format((double)liters, (String)AntxDataRow.this.getDataFormat(arg));
                    }
                    return "--";
                }

                @Override
                public String getTitle(ReportData rd, ReportColumn rc) {
                    I18N i18n = rd.getPrivateLabel().getI18N(AntxLayout.class);
                    return i18n.getString("AntxLayout.workFuel", "Work Fuel") + "\n${volumeUnits}";
                }
            }, new String[0]);
        }

        public String getDataFormat(String arg) {
            String fmt = "#0";
            if (arg != null && arg.length() > 0) {
                switch (arg.charAt(0)) {
                    case '0': {
                        fmt = "#0";
                        break;
                    }
                    case '1': {
                        fmt = "#0.0";
                        break;
                    }
                    case '2': {
                        fmt = "#0.00";
                        break;
                    }
                    case '3': {
                        fmt = "#0.000";
                        break;
                    }
                    case '4': {
                        fmt = "#0.0000";
                    }
                }
            }
            return fmt;
        }
    }
}

