/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.antx;

import java.util.Map;
import org.opengts.util.ListTools;

public class AntxField {
    public static final int EVCODE_DEMAND_END_OF_DAY = 104;
    public static final int EVCODE_DEMAND_STANDARD = 105;
    public static final int EVCODE_STANDARD_REPORT = 474;
    public static final int EVCODE_END_OF_DAY = 475;
    public static final int EVCODE_COG_HEADING = 476;
    public static final int EVCODE_SOG_SPEED = 477;
    public static final int EVCODE_RPM = 478;
    public static final int EVCODE_POWER_ON = 480;
    public static final int EVCODE_ENGINE_START = 481;
    public static final int EVCODE_ENGINE_STOP = 482;
    public static final int EVCODE_POWER_OFF = 484;
    public static final int EVCODE_DECELERATION = 485;
    public static final int EVCODE_ACCELERATION = 486;
    public static final int EVCODE_OUTPUT_CTL_ON = 487;
    public static final int EVCODE_OUTPUT_CTL_OFF = 488;
    public static final int EVCODE_OFF_TO_IDLE = 501;
    public static final int EVCODE_OFF_TO_WORK = 502;
    public static final int EVCODE_IDLE_TO_OFF = 503;
    public static final int EVCODE_IDLE_TO_WORK = 504;
    public static final int EVCODE_WORK_TO_OFF = 505;
    public static final int EVCODE_WORK_TO_IDLE = 506;
    public static final int EVCODE_CONFIG_SET_OK = 901;
    public static final int EVCODE_CONFIG_SET_ERROR = 902;
    public static final int EVCODE_CONFIG_GET_OK = 903;
    public static final int EVCODE_CONFIG_GET_ERROR = 904;
    public static final int EVCODE_ACTION_CMD_OK = 905;
    public static final int EVCODE_ACTION_CMD_ERROR = 906;
    public static final int EVCODE_CONFIG_CHANGE = 910;
    public static final int EVCODE_GPS_ANT_UNAVAIL = 956;
    public static final int EVCODE_GPS_ANT_NORMAL = 957;
    public static final int EVCODE_GPS_ANT_OPEN = 958;
    public static final int EVCODE_GPS_ANT_SHORT = 959;
    public static final int EVCODE_DIAG_CODE_ACTIVE = 961;
    public static final int EVCODE_DIAG_CODE_NORMAL = 962;
    public static final int EVCODE_IDLE_EXCEPTION = 978;
    public static final int FIELD_VEHICLE_ID = 1;
    public static final int FIELD_ACK = 10;
    public static final int FIELD_PING = 15;
    public static final int FIELD_GPS_DATA = 20;
    public static final int FIELD_TEXT = 30;
    public static final int FIELD_DIGITAL_CHAN_DATA = 40;
    public static final int FIELD_DIGITAL_BIN_DATA = 41;
    public static final int FIELD_ANALOG_CHAN_DATA = 60;
    public static final int FIELD_ANALOG_BIN_COUNT_DATA = 61;
    public static final int FIELD_ANALOG_BIN_DURA_DATA = 62;
    public static final int FIELD_ANALOG_MIN_MAX_VALUE = 63;
    public static final int FIELD_ANALOG_DISTANCE = 64;
    public static final int FIELD_ANALOG_FUEL = 65;
    public static final int FIELD_J1939_DIAG = 80;
    public static final int FIELD_J1708_DIAG = 81;
    public static final int FIELD_OBD2_DIAG = 82;
    public static final int FIELD_IDLE_EXCEPTION = 86;
    public static final int FIELD_REQUEST_GET_CONFIG = 255;
    public static final int FIELD_REQUEST_SET_CONFIG = 258;
    public static final int FIELD_ACTION_COMMAND = 280;
    public static final Map FieldDescription = ListTools.toMap((String)"toString", (Object[])new AntxField[]{new AntxField(1, "VehicleID"), new AntxField(10, "ACL"), new AntxField(15, "Ping"), new AntxField(20, "GPS"), new AntxField(30, "Text"), new AntxField(40, "Digital"), new AntxField(41, "Digital[Dura]"), new AntxField(60, "Analog"), new AntxField(61, "Analog[Count]"), new AntxField(62, "Analog[Dura]"), new AntxField(63, "Analog[MinMax]"), new AntxField(64, "Analog[Dist]"), new AntxField(65, "Analog[Fuel]"), new AntxField(80, "J1939_Fault"), new AntxField(81, "J1708_Fault"), new AntxField(82, "OBDII_Fault"), new AntxField(86, "Idle"), new AntxField(255, "Get_Config"), new AntxField(258, "Set_Config"), new AntxField(280, "Command")});
    private int id = 0;
    private String desc = "";

    public static int getStatusCodeFromEventCode(int evCode) {
        switch (evCode) {
            case 104: {
                return 64000;
            }
            case 105: {
                return 61472;
            }
            case 474: {
                return 61472;
            }
            case 475: {
                return 64000;
            }
            case 476: {
                return 61472;
            }
            case 477: {
                return 61722;
            }
            case 478: {
                return 63778;
            }
            case 480: {
                return 61456;
            }
            case 481: {
                return 62465;
            }
            case 482: {
                return 62467;
            }
            case 484: {
                return 64787;
            }
            case 485: {
                return 63792;
            }
            case 486: {
                return 61472;
            }
            case 487: {
                return 62472;
            }
            case 488: {
                return 62474;
            }
            case 501: {
                return 62465;
            }
            case 502: {
                return 62465;
            }
            case 503: {
                return 62467;
            }
            case 504: {
                return 61472;
            }
            case 505: {
                return 62467;
            }
            case 506: {
                return 61472;
            }
            case 901: {
                return 63537;
            }
            case 902: {
                return 63538;
            }
            case 903: {
                return 63537;
            }
            case 904: {
                return 63538;
            }
            case 905: {
                return 63537;
            }
            case 906: {
                return 63538;
            }
            case 910: {
                return 64833;
            }
            case 956: {
                return 64802;
            }
            case 957: {
                return 61472;
            }
            case 958: {
                return 64802;
            }
            case 959: {
                return 64802;
            }
            case 961: {
                return 63761;
            }
            case 962: {
                return 61472;
            }
            case 978: {
                return 61718;
            }
        }
        if (evCode >= 1001 && evCode <= 1500) {
            int eventCodeOffset = evCode - 1001;
            return 63776;
        }
        if (evCode >= 1501 && evCode <= 2000) {
            int eventCodeOffset = evCode - 1501;
            return 61472;
        }
        if (evCode >= 2001 && evCode <= 2500) {
            int eventCodeOffset = evCode - 2001;
            return 63776;
        }
        if (evCode >= 2501 && evCode <= 3000) {
            int eventCodeOffset = evCode - 2501;
            return 63776;
        }
        if (evCode >= 3001 && evCode <= 3500) {
            int eventCodeOffset = evCode - 3001;
            return 63776;
        }
        if (evCode >= 3501 && evCode <= 4000) {
            int eventCodeOffset = evCode - 3501;
            return 63776;
        }
        if (evCode >= 4001 && evCode <= 4500) {
            int eventCodeOffset = evCode - 4001;
            return 63776;
        }
        if (evCode >= 4501 && evCode <= 5000) {
            int eventCodeOffset = evCode - 4501;
            return 63776;
        }
        if (evCode >= 5001 && evCode <= 5500) {
            int eventCodeOffset = evCode - 5001;
            return 61472;
        }
        if (evCode >= 6001 && evCode <= 6100) {
            int eventCodeOffset = evCode - 6001;
            return 61968;
        }
        if (evCode >= 6101 && evCode <= 6200) {
            int eventCodeOffset = evCode - 6101;
            return 62000;
        }
        return 61472;
    }

    public static AntxField GetAntxField(int fld) {
        return (AntxField)FieldDescription.get(String.valueOf(fld));
    }

    public static String GetFieldDescription(int fld) {
        AntxField af = AntxField.GetAntxField(fld);
        return af != null ? af.getDescription() : "?";
    }

    public AntxField(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return String.valueOf(this.getID());
    }
}

