/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.war.report.antx;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.extra.tables.Antx;
import org.opengts.extra.war.report.antx.AntxData;
import org.opengts.extra.war.report.antx.AntxLayout;
import org.opengts.util.DateTime;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.tools.RequestProperties;

public class AntxDayValueSummaryReport
extends ReportData {
    private List<AntxData> rowData = null;

    public AntxDayValueSummaryReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account must be specified");
        }
    }

    @Override
    public void postInitialize() {
    }

    @Override
    public ReportLayout getReportLayout() {
        return AntxLayout.getReportLayout();
    }

    @Override
    public DBDataIterator getBodyDataIterator() {
        this.rowData = new Vector<AntxData>();
        ReportConstraints rc = this.getReportConstraints();
        long startTime = rc.getTimeStart();
        long endTime = rc.getTimeEnd();
        long limit = rc.getSelectionLimit();
        final Account currAcct = this.getAccount();
        String currAcctID = currAcct.getAccountID();
        ReportDeviceList devList = this.getReportDeviceList();
        final HashMap summaryMap = new HashMap();
        DBRecordHandler<Antx> rcdHandler = new DBRecordHandler<Antx>(){

            public int handleDBRecord(Antx a) throws DBException {
                String devID = a.getDeviceID();
                int chan = a.getChannelID();
                int type = a.getType();
                long ts = a.getTimestamp();
                long day = DateTime.getDayNumberFromDate((DateTime)new DateTime(ts, currAcct.getTimeZone(null)));
                if (type != 0) {
                    return 1;
                }
                String summKey = devID + "|" + day;
                AntxData ad = (AntxData)summaryMap.get(summKey);
                if (ad == null) {
                    ad = new AntxData();
                    ad.setValue("deviceID", devID);
                    ad.setDevice(a.getDevice());
                    ad.setValue("type", type);
                    ad.setValue("timestamp", ts);
                    summaryMap.put(summKey, ad);
                    AntxDayValueSummaryReport.this.rowData.add(ad);
                }
                if (chan == 119) {
                    ad.setValue("totalFuel", a.getData0());
                } else if (chan == 150) {
                    ad.setValue("ptoFuel", a.getData0());
                } else if (chan == 87) {
                    ad.setValue("idleFuel", a.getData0());
                } else if (chan == 89) {
                    ad.setValue("workFuel", a.getData0());
                } else if (chan == 118) {
                    ad.setValue("distance", a.getData0());
                }
                return 1;
            }
        };
        Iterator<String> i = devList.iterator();
        while (i.hasNext()) {
            String deviceID = i.next();
            try {
                Antx.getRecordCallback((DBRecordHandler)rcdHandler, (String)currAcctID, (String)deviceID, (long)startTime, (long)endTime, (long)limit);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error", (Throwable)dbe);
            }
        }
        return new ReportData.ListDataIterator(this, this.rowData);
    }

    @Override
    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

